/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.DslAdaptersKt;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.res.Aapt2ProcessResourcesRunnable;
import com.android.build.gradle.internal.res.namespaced.Aapt2DaemonManagerService;
import com.android.build.gradle.internal.res.namespaced.Aapt2ServiceKey;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.tasks.ModuleMetadata;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadata;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;

public class GenerateSplitAbiRes
extends AndroidBuilderTask {
    private final WorkerExecutorFacade workers;
    private Supplier<String> applicationId;
    private String outputBaseName;
    private Supplier<String> versionName;
    private IntSupplier versionCode;
    private ImmutableSortedMap<String, ApkData> splits;
    private File outputDirectory;
    private boolean debuggable;
    private AaptOptions aaptOptions;
    private VariantType variantType;
    @VisibleForTesting
    Supplier<String> featureNameSupplier;
    private FileCollection applicationIdOverride;
    private FileCollection aapt2FromMaven;
    private Provider<File> androidJarProvider;

    @Inject
    public GenerateSplitAbiRes(WorkerExecutor workerExecutor) {
        this.workers = Workers.INSTANCE.getWorker(this.getPath(), workerExecutor);
    }

    @Input
    public String getApplicationId() {
        return this.applicationId.get();
    }

    @Input
    public int getVersionCode() {
        return this.versionCode.getAsInt();
    }

    @Input
    @Optional
    public String getVersionName() {
        return this.versionName.get();
    }

    @Input
    public String getOutputBaseName() {
        return this.outputBaseName;
    }

    @Input
    public Set<String> getSplits() {
        return this.splits.keySet();
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Input
    public boolean isDebuggable() {
        return this.debuggable;
    }

    @Nested
    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    @Input
    @Optional
    public String getFeatureName() {
        return this.featureNameSupplier != null ? this.featureNameSupplier.get() : null;
    }

    @InputFiles
    @Optional
    public FileCollection getApplicationIdOverride() {
        return this.applicationIdOverride;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getAapt2FromMaven() {
        return this.aapt2FromMaven;
    }

    @TaskAction
    protected void doFullTaskAction() throws IOException {
        ImmutableList.Builder buildOutputs = ImmutableList.builder();
        try (WorkerExecutorFacade workerExecutor = this.workers;){
            for (String split : this.splits.keySet()) {
                File resPackageFile = this.getOutputFileForSplit(split);
                File manifestFile = this.generateSplitManifest(split, (ApkData)this.splits.get((Object)split));
                AndroidBuilder builder = this.getBuilder();
                AaptPackageConfig aaptConfig = new AaptPackageConfig.Builder().setManifestFile(manifestFile).setOptions(DslAdaptersKt.convert(this.aaptOptions)).setDebuggable(this.debuggable).setResourceOutputApk(resPackageFile).setVariantType(this.variantType).setAndroidTarget((File)this.androidJarProvider.get()).build();
                Aapt2ServiceKey aapt2ServiceKey = Aapt2DaemonManagerService.registerAaptService(this.aapt2FromMaven, builder.getLogger());
                Aapt2ProcessResourcesRunnable.Params params = new Aapt2ProcessResourcesRunnable.Params(aapt2ServiceKey, aaptConfig);
                workerExecutor.submit(Aapt2ProcessResourcesRunnable.class, (Serializable)params);
                buildOutputs.add((Object)new BuildOutput(InternalArtifactType.ABI_PROCESSED_SPLIT_RES, (ApkData)this.splits.get((Object)split), resPackageFile));
            }
        }
        new BuildElements((Collection<BuildOutput>)buildOutputs.build()).save(this.outputDirectory);
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public Provider<File> getAndroidJar() {
        return this.androidJarProvider;
    }

    @VisibleForTesting
    File generateSplitManifest(String split, ApkData apkInfo) throws IOException {
        CharMatcher charMatcher = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.is((char)'_')).or(CharMatcher.is((char)'.')).negate();
        String featureName = this.getFeatureName();
        String encodedSplitName = (featureName != null ? featureName + "." : "") + "config." + charMatcher.replaceFrom((CharSequence)split, '_');
        File tmpDirectory = new File(this.outputDirectory, split);
        FileUtils.mkdirs((File)tmpDirectory);
        File tmpFile = new File(tmpDirectory, "AndroidManifest.xml");
        String versionNameToUse = apkInfo.getVersionName();
        if (versionNameToUse == null) {
            versionNameToUse = String.valueOf(apkInfo.getVersionCode());
        }
        String manifestAppId = this.applicationIdOverride != null && !this.applicationIdOverride.isEmpty() ? ModuleMetadata.load(this.applicationIdOverride.getSingleFile()).getApplicationId() : this.applicationId.get();
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(tmpFile)), "UTF-8");){
            fileWriter.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n      package=\"" + manifestAppId + "\"\n      android:versionCode=\"" + apkInfo.getVersionCode() + "\"\n      android:versionName=\"" + versionNameToUse + "\"\n");
            if (featureName != null) {
                fileWriter.append("      configForSplit=\"" + featureName + "\"\n");
            }
            fileWriter.append("      split=\"" + encodedSplitName + "\"\n      targetABI=\"" + split + "\">\n       <uses-sdk android:minSdkVersion=\"21\"/>\n</manifest> ");
            fileWriter.flush();
        }
        return tmpFile;
    }

    private File getOutputFileForSplit(String split) {
        return new File(this.outputDirectory, "resources-" + this.getOutputBaseName() + "-" + split + ".ap_");
    }

    public static class CreationAction
    extends VariantTaskCreationAction<GenerateSplitAbiRes> {
        private final FeatureSetMetadata.SupplierProvider provider;
        private File outputDirectory;

        public CreationAction(VariantScope scope) {
            this(scope, FeatureSetMetadata.getInstance());
        }

        @VisibleForTesting
        CreationAction(VariantScope scope, FeatureSetMetadata.SupplierProvider provider) {
            super(scope);
            this.provider = provider;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("generate", "SplitAbiRes");
        }

        @Override
        public Class<GenerateSplitAbiRes> getType() {
            return GenerateSplitAbiRes.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.outputDirectory = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.ABI_PROCESSED_SPLIT_RES, taskName, "out");
        }

        @Override
        public void configure(GenerateSplitAbiRes task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            GradleVariantConfiguration config2 = scope.getVariantConfiguration();
            VariantType variantType = config2.getType();
            if (variantType.isFeatureSplit()) {
                task.featureNameSupplier = this.provider.getFeatureNameSupplierForTask(scope, (Task)task);
            }
            task.versionCode = config2::getVersionCode;
            task.versionName = config2::getVersionName;
            task.variantType = variantType;
            task.outputDirectory = this.outputDirectory;
            task.splits = CreationAction.getAbiSplitData(scope);
            task.outputBaseName = config2.getBaseName();
            task.applicationId = config2::getApplicationId;
            task.debuggable = config2.getBuildType().isDebuggable();
            task.aaptOptions = scope.getGlobalScope().getExtension().getAaptOptions();
            task.aapt2FromMaven = Aapt2MavenUtils.getAapt2FromMaven(scope.getGlobalScope());
            task.androidJarProvider = scope.getGlobalScope().getSdkComponents().getAndroidJarProvider();
            if (variantType.isBaseModule() && variantType.isHybrid()) {
                task.applicationIdOverride = scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.METADATA_BASE_MODULE_DECLARATION);
            } else if (variantType.isFeatureSplit()) {
                task.applicationIdOverride = scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_APPLICATION_ID_DECLARATION);
            }
        }

        private static ImmutableSortedMap<String, ApkData> getAbiSplitData(VariantScope variantScope) {
            return (ImmutableSortedMap)variantScope.getOutputScope().getApkDatas().stream().filter(apk -> apk.isEnabled() && apk.getFilter(VariantOutput.FilterType.ABI) != null).collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), apk -> apk.getFilter(VariantOutput.FilterType.ABI).getIdentifier(), apk -> apk));
        }
    }
}

