/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.builder.aar.AarExtractor;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.inject.Inject;
import org.gradle.api.artifacts.transform.ArtifactTransform;

public class ExtractAarTransform
extends ArtifactTransform {
    @Inject
    public ExtractAarTransform() {
    }

    public List<File> transform(File input) {
        File outputDir = this.getOutputDirectory();
        FileUtils.mkdirs((File)outputDir);
        AarExtractor aarExtractor = new AarExtractor();
        aarExtractor.extract(input, outputDir);
        File classesJar = new File(new File(outputDir, "jars"), "classes.jar");
        if (!classesJar.exists()) {
            try {
                Files.createParentDirs((File)classesJar);
                try (FileOutputStream out = new FileOutputStream(classesJar);){
                    JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new BufferedOutputStream(out), new Manifest());
                    jarOutputStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot create missing classes.jar", e);
            }
        }
        return ImmutableList.of((Object)outputDir);
    }
}

