/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.configure.NdkAbiFile;
import com.android.build.gradle.internal.cxx.configure.NdkAbiFileKt;
import com.android.build.gradle.internal.cxx.configure.PlatformConfigurator;
import com.android.build.gradle.internal.ndk.AbiInfo;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.repository.Revision;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.logging.Logging;

public class DefaultNdkInfo
implements NdkInfo {
    private final File root;
    private final PlatformConfigurator platformConfigurator;
    private final List<AbiInfo> abiInfoList;
    private final Map<Abi, String> defaultToolchainVersions = Maps.newHashMap();

    public DefaultNdkInfo(File root) {
        this.root = root;
        this.platformConfigurator = new PlatformConfigurator(root);
        this.abiInfoList = new NdkAbiFile(NdkAbiFileKt.ndkMetaAbisFile(root)).getAbiInfoList();
    }

    private File getRootDirectory() {
        return this.root;
    }

    @Override
    public String findLatestPlatformVersion(String targetPlatformString) {
        int targetVersion;
        AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)targetPlatformString);
        if (androidVersion == null) {
            Logging.getLogger(this.getClass()).warn("Unable to parse NDK platform version.  Try to find the latest instead.");
            targetVersion = Integer.MAX_VALUE;
        } else {
            targetVersion = androidVersion.getFeatureLevel();
        }
        targetVersion = this.findTargetPlatformVersionOrLower(targetVersion);
        if (targetVersion == 0) {
            return null;
        }
        return "android-" + targetVersion;
    }

    @Override
    public int findSuitablePlatformVersion(String abiName, AndroidVersion androidVersion) {
        return this.platformConfigurator.findSuitablePlatformVersion(abiName, androidVersion);
    }

    private int findTargetPlatformVersionOrLower(int targetVersion) {
        File platformDir = new File(this.root, "/platforms");
        if (new File(platformDir, "android-" + targetVersion).exists()) {
            return targetVersion;
        }
        File[] platformSubDirs2 = platformDir.listFiles(File::isDirectory);
        int highestVersion = 0;
        assert (platformSubDirs2 != null);
        for (File platform : platformSubDirs2) {
            if (!platform.getName().startsWith("android-")) continue;
            try {
                int version = Integer.parseInt(platform.getName().substring("android-".length()));
                if (version <= highestVersion || version >= targetVersion) continue;
                highestVersion = version;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return highestVersion;
    }

    private static String getToolchainPrefix(Abi abi) {
        return abi.getGccToolchainPrefix();
    }

    private File getToolchainPath(Abi abi) {
        String version = this.getDefaultToolchainVersion(abi = this.getToolchainAbi(abi));
        version = version.isEmpty() ? "" : "-" + version;
        File prebuiltFolder = new File(this.getRootDirectory(), "toolchains/" + DefaultNdkInfo.getToolchainPrefix(abi) + version + "/prebuilt");
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        String hostOs = osName.contains("windows") ? "windows" : (osName.contains("mac") ? "darwin" : "linux");
        File[] toolchainPaths = prebuiltFolder.listFiles(File::isDirectory);
        if (toolchainPaths == null) {
            throw new InvalidUserDataException("Unable to find toolchain: " + prebuiltFolder);
        }
        if (toolchainPaths.length == 1) {
            return toolchainPaths[0];
        }
        File toolchainPath = new File(prebuiltFolder, hostOs + "-x86_64");
        if (toolchainPath.isDirectory()) {
            return toolchainPath;
        }
        String osString = osName.equals("windows") ? hostOs : hostOs + "-x86";
        toolchainPath = new File(prebuiltFolder, osString);
        if (toolchainPath.isDirectory()) {
            return toolchainPath;
        }
        throw new InvalidUserDataException("Unable to find toolchain prebuilt folder in: " + prebuiltFolder);
    }

    protected Abi getToolchainAbi(Abi abi) {
        return abi;
    }

    @Override
    public File getStripExecutable(Abi abi) {
        abi = this.getToolchainAbi(abi);
        return FileUtils.join((File)this.getToolchainPath(abi), (String[])new String[]{"bin", abi.getGccExecutablePrefix() + "-strip"});
    }

    private String getDefaultToolchainVersion(Abi abi) {
        String defaultVersion = this.defaultToolchainVersions.get((Object)(abi = this.getToolchainAbi(abi)));
        if (defaultVersion != null) {
            return defaultVersion;
        }
        String toolchainPrefix = DefaultNdkInfo.getToolchainPrefix(abi);
        File toolchains = new File(this.getRootDirectory(), "toolchains");
        File[] toolchainsForAbi = toolchains.listFiles((dir, filename) -> filename.startsWith(toolchainPrefix));
        if (toolchainsForAbi == null || toolchainsForAbi.length == 0) {
            throw new RuntimeException("No toolchains found in the NDK toolchains folder for ABI with prefix: " + toolchainPrefix);
        }
        Revision bestRevision = null;
        String bestVersionString = "";
        for (File toolchainFolder : toolchainsForAbi) {
            String folderName = toolchainFolder.getName();
            Revision revision = new Revision(0);
            String versionString = "";
            if (folderName.length() > toolchainPrefix.length() + 1) {
                try {
                    versionString = folderName.substring(toolchainPrefix.length() + 1);
                    revision = Revision.parseRevision((String)versionString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (bestRevision != null && revision.compareTo(bestRevision) <= 0) continue;
            bestRevision = revision;
            bestVersionString = versionString;
        }
        this.defaultToolchainVersions.put(abi, bestVersionString);
        return bestVersionString;
    }

    @Override
    public Collection<Abi> getDefault32BitsAbis() {
        return this.abiInfoList.stream().filter(abiInfo -> abiInfo.isDefault() && !abiInfo.isDeprecated()).map(AbiInfo::getAbi).filter(abi -> !abi.supports64Bits()).collect(Collectors.toList());
    }

    @Override
    public Collection<Abi> getDefaultAbis() {
        return this.abiInfoList.stream().filter(abiInfo -> abiInfo.isDefault() && !abiInfo.isDeprecated()).map(AbiInfo::getAbi).collect(Collectors.toList());
    }

    @Override
    public Collection<Abi> getSupported32BitsAbis() {
        return this.abiInfoList.stream().map(AbiInfo::getAbi).filter(abi -> !abi.supports64Bits()).collect(Collectors.toList());
    }

    @Override
    public Collection<Abi> getSupportedAbis() {
        return this.abiInfoList.stream().map(AbiInfo::getAbi).collect(Collectors.toList());
    }
}

