/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.profile.ProfileAgent;
import com.android.build.gradle.internal.profile.RecordingBuildListener;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.ProcessProfileWriterFactory;
import com.android.builder.profile.ProfileRecordWriter;
import com.android.utils.ILogger;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import java.io.File;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import org.gradle.BuildAdapter;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.initialization.BuildCompletionListener;

public final class ProfilerInitializer {
    private static final String PROFILE_DIRECTORY = "android-profile";
    private static final DateTimeFormatter PROFILE_FILE_NAME = DateTimeFormatter.ofPattern("'profile-'YYYY-MM-dd-HH-mm-ss-SSS'.rawproto'", Locale.US);
    private static final Object lock = new Object();
    private static volatile RecordingBuildListener recordingBuildListener;

    private ProfilerInitializer() {
    }

    public static RecordingBuildListener getListener() {
        return recordingBuildListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordingBuildListener init(Project project, ProjectOptions projectOptions) {
        Object object = lock;
        synchronized (object) {
            if (recordingBuildListener != null) {
                return recordingBuildListener;
            }
            ProcessProfileWriterFactory.initialize((File)project.getRootProject().getProjectDir(), (String)project.getGradle().getGradleVersion(), (ILogger)new LoggerWrapper(project.getLogger()), (boolean)projectOptions.get(BooleanOption.ENABLE_PROFILE_JSON));
            recordingBuildListener = new RecordingBuildListener((ProfileRecordWriter)ProcessProfileWriter.get());
            project.getGradle().addListener((Object)recordingBuildListener);
        }
        project.getGradle().addListener((Object)new ProfileShutdownListener(project.getGradle(), projectOptions.get(StringOption.PROFILE_OUTPUT_DIR), projectOptions.get(BooleanOption.ENABLE_PROFILE_JSON)));
        return recordingBuildListener;
    }

    private static final class ProfileShutdownListener
    extends BuildAdapter
    implements BuildCompletionListener {
        private final Gradle gradle;
        private String profileDirProperty;
        private Path profileDir = null;
        private boolean enableProfileJson;

        ProfileShutdownListener(Gradle gradle, String profileDirProperty, boolean enableProfileJson) {
            this.gradle = gradle;
            this.profileDirProperty = profileDirProperty;
            this.enableProfileJson = enableProfileJson;
        }

        public void projectsEvaluated(Gradle gradle) {
            gradle.allprojects(this::collectProjectInfo);
            if (this.profileDirProperty != null) {
                this.profileDir = gradle.getRootProject().file((Object)this.profileDirProperty).toPath();
            } else if (this.enableProfileJson) {
                this.profileDir = gradle.getRootProject().getBuildDir().toPath().resolve(ProfilerInitializer.PROFILE_DIRECTORY);
            }
        }

        private void collectProjectInfo(Project project) {
            GradleBuildProject.Builder analyticsProject = ProcessProfileWriter.getProject((String)project.getPath());
            project.getPlugins().all(plugin -> analyticsProject.addPlugin(AnalyticsUtil.toProto(plugin)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed() {
            Object object = lock;
            synchronized (object) {
                ProfileAgent.INSTANCE.unregister();
                if (recordingBuildListener != null) {
                    this.gradle.removeListener((Object)Objects.requireNonNull(recordingBuildListener));
                    recordingBuildListener = null;
                    Path profileFile = this.profileDir == null ? null : this.profileDir.resolve(PROFILE_FILE_NAME.format(LocalDateTime.now()));
                    ProcessProfileWriterFactory.shutdownAndMaybeWrite(profileFile);
                }
            }
        }
    }
}

