/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.VariantOutput;
import com.android.build.gradle.internal.scope.ApkData;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class OutputScope
implements Serializable {
    private final ImmutableList<ApkData> sortedApkDatas;

    private OutputScope(ImmutableList<ApkData> sortedApkDatas) {
        this.sortedApkDatas = sortedApkDatas;
    }

    public List<ApkData> getApkDatas() {
        return this.sortedApkDatas.stream().filter(ApkData::isEnabled).collect(Collectors.toList());
    }

    public ApkData getMainSplit() {
        Optional<ApkData> splitsByType = this.sortedApkDatas.stream().filter(apkInfo -> apkInfo.getType() == VariantOutput.OutputType.MAIN).findFirst();
        if (splitsByType.isPresent()) {
            return splitsByType.get();
        }
        Optional<ApkData> universal = this.getApkDatas().stream().filter(split -> "universal".equals(split.getFilterName())).findFirst();
        if (universal.isPresent()) {
            return universal.get();
        }
        Optional<ApkData> firstFullSplit = this.getApkDatas().stream().filter(split -> split.getType() == VariantOutput.OutputType.FULL_SPLIT).findFirst();
        if (firstFullSplit.isPresent()) {
            return firstFullSplit.get();
        }
        throw new RuntimeException(String.format("Cannot determine main APK output from %1$s", Joiner.on((String)":").join(this.sortedApkDatas)));
    }

    public List<ApkData> getSplitsByType(VariantOutput.OutputType outputType) {
        return this.sortedApkDatas.stream().filter(split -> split.getType() == outputType).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OutputScope that = (OutputScope)o;
        return Objects.equals(this.sortedApkDatas, that.sortedApkDatas);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sortedApkDatas);
    }

    public static class Builder {
        private final List<ApkData> apkDatas = new ArrayList<ApkData>();

        public void addSplit(ApkData apkData) {
            this.apkDatas.add(apkData);
        }

        public void addMainSplit(ApkData apkData) {
            if (this.hasMainSplits()) {
                throw new RuntimeException("Cannot add " + apkData + " in a scope that already has " + this.apkDatas.stream().filter(output2 -> output2.getType() == VariantOutput.OutputType.MAIN).map(ApkData::toString).collect(Collectors.joining(",")));
            }
            this.addSplit(apkData);
        }

        private boolean hasMainSplits() {
            return this.apkDatas.stream().anyMatch(s -> s.getType() == VariantOutput.OutputType.MAIN);
        }

        public OutputScope build() {
            return new OutputScope(ImmutableList.sortedCopyOf(this.apkDatas));
        }
    }
}

