/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.internal.tasks.IncrementalFileMergerTaskUtils$WhenMappings;
import com.android.builder.files.FileCacheByPath;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.RelativeFiles;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.builder.merge.LazyIncrementalFileMergerInput;
import com.android.builder.merge.LazyIncrementalFileMergerInputs;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.CachedSupplier;
import com.android.tools.build.apkzlib.utils.IOExceptionRunnable;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u001a0\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u001a8\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0006\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a8\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u001at\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\b\u0000\u0012\u00020\u00190\u00182\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u0018\u001a&\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a8\u0006!"}, d2={"computeFilesFromDir", "Lcom/google/common/collect/ImmutableSet;", "Lcom/android/builder/files/RelativeFile;", "dir", "Ljava/io/File;", "computeFilesFromJar", "jar", "computeUpdatesFromDir", "Lcom/google/common/collect/ImmutableMap;", "Lcom/android/ide/common/resources/FileStatus;", "changedInputs", "", "computeUpdatesFromJar", "zipCache", "Lcom/android/builder/files/FileCacheByPath;", "toIncrementalInput", "Lcom/android/builder/merge/IncrementalFileMergerInput;", "input", "cacheUpdates", "", "Ljava/lang/Runnable;", "toInputs", "Lcom/google/common/collect/ImmutableList;", "inputMap", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "full", "", "contentType", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "contentMap", "Lcom/android/build/api/transform/QualifiedContent;", "toNonIncrementalInput", "gradle"})
@JvmName(name="IncrementalFileMergerTaskUtils")
public final class IncrementalFileMergerTaskUtils {
    @NotNull
    public static final IncrementalFileMergerInput toIncrementalInput(@NotNull File input, @NotNull Map<File, ? extends FileStatus> changedInputs, @NotNull FileCacheByPath zipCache, @NotNull List<Runnable> cacheUpdates) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(changedInputs, (String)"changedInputs");
        Intrinsics.checkParameterIsNotNull((Object)zipCache, (String)"zipCache");
        Intrinsics.checkParameterIsNotNull(cacheUpdates, (String)"cacheUpdates");
        String string = input.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"input.name");
        if (StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
            Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(input, zipCache){
                final /* synthetic */ File $input;
                final /* synthetic */ FileCacheByPath $zipCache;

                public final void run() {
                    if (this.$input.isFile()) {
                        this.$zipCache.add(this.$input);
                    } else {
                        this.$zipCache.remove(this.$input);
                    }
                }
                {
                    this.$input = file;
                    this.$zipCache = fileCacheByPath;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)runnable, (String)"IOExceptionRunnable.asRu\u2026)\n            }\n        }");
            cacheUpdates.add(runnable);
            return (IncrementalFileMergerInput)new LazyIncrementalFileMergerInput(input.getAbsolutePath(), new CachedSupplier(new Supplier<T>(input, changedInputs, zipCache){
                final /* synthetic */ File $input;
                final /* synthetic */ Map $changedInputs;
                final /* synthetic */ FileCacheByPath $zipCache;

                @NotNull
                public final ImmutableMap<RelativeFile, FileStatus> get() {
                    return IncrementalFileMergerTaskUtils.access$computeUpdatesFromJar(this.$input, this.$changedInputs, this.$zipCache);
                }
                {
                    this.$input = file;
                    this.$changedInputs = map;
                    this.$zipCache = fileCacheByPath;
                }
            }), new CachedSupplier(new Supplier<T>(input){
                final /* synthetic */ File $input;

                @NotNull
                public final ImmutableSet<RelativeFile> get() {
                    return IncrementalFileMergerTaskUtils.access$computeFilesFromJar(this.$input);
                }
                {
                    this.$input = file;
                }
            }));
        }
        Preconditions.checkState((!input.isFile() ? 1 : 0) != 0, (String)("Non-directory inputs must have .jar extension: " + input), (Object[])new Object[0]);
        return (IncrementalFileMergerInput)new LazyIncrementalFileMergerInput(input.getAbsolutePath(), new CachedSupplier(new Supplier<T>(input, changedInputs){
            final /* synthetic */ File $input;
            final /* synthetic */ Map $changedInputs;

            @NotNull
            public final ImmutableMap<RelativeFile, FileStatus> get() {
                return IncrementalFileMergerTaskUtils.access$computeUpdatesFromDir(this.$input, this.$changedInputs);
            }
            {
                this.$input = file;
                this.$changedInputs = map;
            }
        }), new CachedSupplier(new Supplier<T>(input){
            final /* synthetic */ File $input;

            @NotNull
            public final ImmutableSet<RelativeFile> get() {
                return IncrementalFileMergerTaskUtils.access$computeFilesFromDir(this.$input);
            }
            {
                this.$input = file;
            }
        }));
    }

    @Nullable
    public static final IncrementalFileMergerInput toNonIncrementalInput(@NotNull File input, @NotNull FileCacheByPath zipCache, @NotNull List<Runnable> cacheUpdates) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)zipCache, (String)"zipCache");
        Intrinsics.checkParameterIsNotNull(cacheUpdates, (String)"cacheUpdates");
        if (!input.isFile() && !input.isDirectory()) {
            return null;
        }
        if (input.isFile()) {
            Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(zipCache, input){
                final /* synthetic */ FileCacheByPath $zipCache;
                final /* synthetic */ File $input;

                public final void run() {
                    this.$zipCache.add(this.$input);
                }
                {
                    this.$zipCache = fileCacheByPath;
                    this.$input = file;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)runnable, (String)"IOExceptionRunnable.asRu\u2026 {  zipCache.add(input) }");
            cacheUpdates.add(runnable);
        }
        return (IncrementalFileMergerInput)LazyIncrementalFileMergerInputs.fromNew((String)input.getAbsolutePath(), (Set)((Set)ImmutableSet.of((Object)input)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final ImmutableMap<RelativeFile, FileStatus> computeUpdatesFromJar(File jar, Map<File, ? extends FileStatus> changedInputs, FileCacheByPath zipCache) {
        Map<File, ? extends FileStatus> map = changedInputs;
        Map<File, ? extends FileStatus> map2 = map;
        if (map2.containsKey(jar)) {
            FileStatus fileStatus = changedInputs.get(jar);
            try {
                FileStatus fileStatus2 = fileStatus;
                if (fileStatus2 == null) throw (Throwable)((Object)new AssertionError((Object)("Unexpected FileStatus: " + fileStatus)));
                switch (IncrementalFileMergerTaskUtils$WhenMappings.$EnumSwitchMapping$0[fileStatus2.ordinal()]) {
                    case 1: {
                        ImmutableMap immutableMap = IncrementalRelativeFileSets.fromZip((File)jar, (FileStatus)FileStatus.NEW);
                        ImmutableMap immutableMap2 = immutableMap;
                        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"IncrementalRelativeFileS\u2026mZip(jar, FileStatus.NEW)");
                        return immutableMap2;
                    }
                    case 2: {
                        File file = zipCache.get(jar);
                        if (file == null) {
                            throw (Throwable)new RuntimeException("File '" + jar + "' was deleted, but previous version not found in cache");
                        }
                        File cached = file;
                        ImmutableMap immutableMap = IncrementalRelativeFileSets.fromZip((File)cached, (FileStatus)FileStatus.REMOVED);
                        ImmutableMap immutableMap2 = immutableMap;
                        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"IncrementalRelativeFileS\u2026ched, FileStatus.REMOVED)");
                        return immutableMap2;
                    }
                    case 3: {
                        ImmutableMap immutableMap = IncrementalRelativeFileSets.fromZip((File)jar, (FileCacheByPath)zipCache, (Set)new HashSet());
                        ImmutableMap immutableMap2 = immutableMap;
                        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"IncrementalRelativeFileS\u2026jar, zipCache, HashSet())");
                        return immutableMap2;
                    }
                    default: {
                        throw (Throwable)((Object)new AssertionError((Object)("Unexpected FileStatus: " + fileStatus)));
                    }
                }
            }
            catch (IOException e) {
                throw (Throwable)new UncheckedIOException(e);
            }
        }
        ImmutableMap immutableMap = ImmutableMap.of();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"ImmutableMap.of()");
        return immutableMap;
    }

    private static final ImmutableSet<RelativeFile> computeFilesFromJar(File jar) {
        if (!jar.isFile()) {
            ImmutableSet immutableSet = ImmutableSet.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"ImmutableSet.of()");
            return immutableSet;
        }
        try {
            ImmutableSet immutableSet = RelativeFiles.fromZip((File)jar);
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"RelativeFiles.fromZip(jar)");
            return immutableSet;
        }
        catch (IOException e) {
            throw (Throwable)new UncheckedIOException(e);
        }
    }

    private static final ImmutableMap<RelativeFile, FileStatus> computeUpdatesFromDir(File dir, Map<File, ? extends FileStatus> changedInputs) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map<File, ? extends FileStatus> map = changedInputs;
        Iterator<Map.Entry<File, ? extends FileStatus>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            RelativeFile rf;
            Map.Entry<File, ? extends FileStatus> entry;
            Map.Entry<File, ? extends FileStatus> entry2 = entry = iterator.next();
            File file = entry2.getKey();
            entry2 = entry;
            FileStatus status = entry2.getValue();
            if (!FileUtils.isFileInDirectory((File)file, (File)dir) || new File((rf = new RelativeFile(dir, file)).getBase(), rf.getRelativePath()).isDirectory()) continue;
            builder.put((Object)rf, (Object)status);
        }
        ImmutableMap immutableMap = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"builder.build()");
        return immutableMap;
    }

    private static final ImmutableSet<RelativeFile> computeFilesFromDir(File dir) {
        if (!dir.isDirectory()) {
            ImmutableSet immutableSet = ImmutableSet.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"ImmutableSet.of()");
            return immutableSet;
        }
        ImmutableSet immutableSet = RelativeFiles.fromDirectory((File)dir);
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"RelativeFiles.fromDirectory(dir)");
        return immutableSet;
    }

    @NotNull
    public static final ImmutableList<IncrementalFileMergerInput> toInputs(@NotNull Map<File, ? super QualifiedContent.Scope> inputMap, @Nullable Map<File, ? extends FileStatus> changedInputs, @NotNull FileCacheByPath zipCache, @NotNull List<Runnable> cacheUpdates, boolean full, @NotNull QualifiedContent.ContentType contentType, @Nullable Map<IncrementalFileMergerInput, QualifiedContent> contentMap) {
        Intrinsics.checkParameterIsNotNull(inputMap, (String)"inputMap");
        Intrinsics.checkParameterIsNotNull((Object)zipCache, (String)"zipCache");
        Intrinsics.checkParameterIsNotNull(cacheUpdates, (String)"cacheUpdates");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        if (full) {
            Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(zipCache){
                final /* synthetic */ FileCacheByPath $zipCache;

                public final void run() {
                    this.$zipCache.clear();
                }
                {
                    this.$zipCache = fileCacheByPath;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)runnable, (String)"IOExceptionRunnable.asRu\u2026able { zipCache.clear() }");
            cacheUpdates.add(runnable);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        Iterator<Map.Entry<File, ? super QualifiedContent.Scope>> iterator = inputMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map<IncrementalFileMergerInput, QualifiedContent> map;
            IncrementalFileMergerInput incrementalFileMergerInput;
            IncrementalFileMergerInput fileMergerInput;
            IncrementalFileMergerInput incrementalFileMergerInput2;
            Map.Entry<File, ? super QualifiedContent.Scope> entry;
            Map.Entry<File, ? super QualifiedContent.Scope> entry2 = entry = iterator.next();
            File input = entry2.getKey();
            entry2 = entry;
            QualifiedContent.Scope scope = entry2.getValue();
            QualifiedContent qualifiedContent2 = new QualifiedContent(input, contentType, scope){
                final /* synthetic */ File $input;
                final /* synthetic */ QualifiedContent.ContentType $contentType;
                final /* synthetic */ Object $scope;

                @NotNull
                public String getName() {
                    return "file-merger-qualified-content";
                }

                @NotNull
                public File getFile() {
                    return this.$input;
                }

                @NotNull
                public Set<QualifiedContent.ContentType> getContentTypes() {
                    return SetsKt.mutableSetOf((Object[])new QualifiedContent.ContentType[]{this.$contentType});
                }

                @NotNull
                public Set<Object> getScopes() {
                    return SetsKt.mutableSetOf((Object[])new Object[]{this.$scope});
                }
                {
                    this.$input = $captured_local_variable$0;
                    this.$contentType = $captured_local_variable$1;
                    this.$scope = $captured_local_variable$2;
                }
            };
            if (full) {
                incrementalFileMergerInput2 = IncrementalFileMergerTaskUtils.toNonIncrementalInput(input, zipCache, cacheUpdates);
            } else {
                if (changedInputs == null) {
                    throw (Throwable)new RuntimeException("changedInputs must be specified for incremental merging.");
                }
                incrementalFileMergerInput2 = fileMergerInput = IncrementalFileMergerTaskUtils.toIncrementalInput(input, changedInputs, zipCache, cacheUpdates);
            }
            if (fileMergerInput == null) continue;
            IncrementalFileMergerInput it = incrementalFileMergerInput;
            boolean bl = false;
            builder.add((Object)it);
            if (contentMap == null) continue;
            Map<IncrementalFileMergerInput, QualifiedContent> contentMap2 = map;
            boolean bl2 = false;
            Map<IncrementalFileMergerInput, QualifiedContent> map2 = contentMap2;
            IncrementalFileMergerInput incrementalFileMergerInput3 = it;
            QualifiedContent qualifiedContent3 = qualifiedContent2;
            map2.put(incrementalFileMergerInput3, qualifiedContent3);
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return immutableList;
    }

    public static final /* synthetic */ ImmutableMap access$computeUpdatesFromJar(File jar, Map changedInputs, FileCacheByPath zipCache) {
        return IncrementalFileMergerTaskUtils.computeUpdatesFromJar(jar, changedInputs, zipCache);
    }

    public static final /* synthetic */ ImmutableSet access$computeFilesFromJar(File jar) {
        return IncrementalFileMergerTaskUtils.computeFilesFromJar(jar);
    }

    public static final /* synthetic */ ImmutableMap access$computeUpdatesFromDir(File dir, Map changedInputs) {
        return IncrementalFileMergerTaskUtils.computeUpdatesFromDir(dir, changedInputs);
    }

    public static final /* synthetic */ ImmutableSet access$computeFilesFromDir(File dir) {
        return IncrementalFileMergerTaskUtils.computeFilesFromDir(dir);
    }
}

