/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.android.utils.PathUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;

public class JacocoTaskDelegate {
    private static final Pattern CLASS_PATTERN = Pattern.compile(".*\\.class$");
    private static final Pattern KOTLIN_MODULE_PATTERN = Pattern.compile("^META-INF/.*\\.kotlin_module$");
    private final FileCollection jacocoAntTaskConfiguration;
    private final File output;
    private final BuildableArtifact inputClasses;

    public JacocoTaskDelegate(FileCollection jacocoAntTaskConfiguration, File output2, BuildableArtifact inputClasses) {
        this.jacocoAntTaskConfiguration = jacocoAntTaskConfiguration;
        this.output = output2;
        this.inputClasses = inputClasses;
    }

    public void run(WorkerExecutorFacade executor, IncrementalTaskInputs inputs) throws IOException {
        for (File file : this.inputClasses.getFiles()) {
            if (!file.exists()) continue;
            Preconditions.checkState((boolean)file.isDirectory(), (String)"Jacoco instrumentation supports only directory inputs: %s", (Object)file.toString());
        }
        if (inputs.isIncremental()) {
            this.processIncrementally(executor, inputs);
        } else {
            for (File file : this.inputClasses.getFiles()) {
                Map<Action, List<File>> nonIncToProcess = JacocoTaskDelegate.getFilesForInstrumentationNonIncrementally(file, this.output);
                WorkerItemParameter parameter = new WorkerItemParameter(nonIncToProcess, file, this.output);
                executor.submit(JacocoWorkerAction.class, new WorkerExecutorFacade.Configuration((Serializable)parameter, WorkerExecutorFacade.IsolationMode.CLASSLOADER, (Iterable)this.jacocoAntTaskConfiguration.getFiles()));
            }
        }
    }

    private void processIncrementally(WorkerExecutorFacade executor, IncrementalTaskInputs inputs) throws IOException {
        SetMultimap basePathToRemove = Multimaps.newSetMultimap(new HashMap(), HashSet::new);
        SetMultimap basePathToProcess = Multimaps.newSetMultimap(new HashMap(), HashSet::new);
        HashSet<Path> baseDirs = new HashSet<Path>(this.inputClasses.getFiles().size());
        for (File file : this.inputClasses.getFiles()) {
            baseDirs.add(file.toPath());
        }
        inputs.outOfDate(arg_0 -> JacocoTaskDelegate.lambda$processIncrementally$0(baseDirs, (Multimap)basePathToProcess, (Multimap)basePathToRemove, arg_0));
        inputs.removed(arg_0 -> JacocoTaskDelegate.lambda$processIncrementally$1(baseDirs, (Multimap)basePathToRemove, arg_0));
        for (Path basePath : basePathToRemove.keys()) {
            for (Path toRemove : basePathToRemove.get((Object)basePath)) {
                Action action = JacocoTaskDelegate.calculateAction(toRemove.toFile(), basePath.toFile());
                if (action == Action.IGNORE) continue;
                Path outputPath = JacocoTaskDelegate.getOutputPath(basePath, toRemove, this.output.toPath());
                PathUtils.deleteRecursivelyIfExists((Path)outputPath);
            }
        }
        for (Path basePath : basePathToProcess.keys()) {
            EnumMap<Action, List<File>> toProcess = new EnumMap<Action, List<File>>(Action.class);
            for (Path changed : basePathToProcess.get((Object)basePath)) {
                Action action = JacocoTaskDelegate.calculateAction(changed.toFile(), basePath.toFile());
                if (action == Action.IGNORE) continue;
                List byAction = toProcess.getOrDefault((Object)action, new ArrayList());
                byAction.add(changed.toFile());
                toProcess.put(action, byAction);
            }
            executor.submit(JacocoWorkerAction.class, new WorkerExecutorFacade.Configuration((Serializable)new WorkerItemParameter(toProcess, basePath.toFile(), this.output), WorkerExecutorFacade.IsolationMode.CLASSLOADER, (Iterable)this.jacocoAntTaskConfiguration.getFiles()));
        }
    }

    private static Path findBase(Set<Path> baseDirs, Path file) {
        for (Path baseDir : baseDirs) {
            if (!file.startsWith(baseDir)) continue;
            return baseDir;
        }
        throw new RuntimeException(String.format("Unable to find base directory for %s. List of base dirs: %s", file, baseDirs.stream().map(Path::toString).collect(Collectors.joining(","))));
    }

    private static Path getOutputPath(Path baseDir, Path inputFile, Path outputBaseDir) {
        Path relativePath = baseDir.relativize(inputFile);
        return outputBaseDir.resolve(relativePath);
    }

    private static Map<Action, List<File>> getFilesForInstrumentationNonIncrementally(File inputDir, File outputDir) throws IOException {
        HashMap toProcess = Maps.newHashMap();
        FileUtils.cleanOutputDir((File)outputDir);
        FluentIterable files2 = FileUtils.getAllFiles((File)inputDir);
        block4: for (File inputFile : files2) {
            Action fileAction = JacocoTaskDelegate.calculateAction(inputFile, inputDir);
            switch (fileAction) {
                case COPY: 
                case INSTRUMENT: {
                    List actionFiles = toProcess.getOrDefault((Object)fileAction, new ArrayList());
                    actionFiles.add(inputFile);
                    toProcess.put(fileAction, actionFiles);
                    continue block4;
                }
                case IGNORE: {
                    continue block4;
                }
            }
            throw new AssertionError((Object)("Unsupported Action: " + (Object)((Object)fileAction)));
        }
        return toProcess;
    }

    private static Action calculateAction(File inputFile, File inputDir) {
        String inputRelativePath = FileUtils.toSystemIndependentPath((String)FileUtils.relativePossiblyNonExistingPath((File)inputFile, (File)inputDir));
        for (Pattern pattern : Action.COPY.getPatterns()) {
            if (!pattern.matcher(inputRelativePath).matches()) continue;
            return Action.COPY;
        }
        for (Pattern pattern : Action.INSTRUMENT.getPatterns()) {
            if (!pattern.matcher(inputRelativePath).matches()) continue;
            return Action.INSTRUMENT;
        }
        return Action.IGNORE;
    }

    private static /* synthetic */ void lambda$processIncrementally$1(Set baseDirs, Multimap basePathToRemove, InputFileDetails info2) {
        Path file = info2.getFile().toPath();
        Path baseDir = JacocoTaskDelegate.findBase(baseDirs, file);
        basePathToRemove.put((Object)baseDir, (Object)file);
    }

    private static /* synthetic */ void lambda$processIncrementally$0(Set baseDirs, Multimap basePathToProcess, Multimap basePathToRemove, InputFileDetails info2) {
        Path file = info2.getFile().toPath();
        Path baseDir = JacocoTaskDelegate.findBase(baseDirs, file);
        if (info2.isAdded()) {
            basePathToProcess.put((Object)baseDir, (Object)file);
        } else if (info2.isModified()) {
            basePathToRemove.put((Object)baseDir, (Object)file);
            basePathToProcess.put((Object)baseDir, (Object)file);
        } else if (info2.isRemoved()) {
            basePathToRemove.put((Object)baseDir, (Object)file);
        }
    }

    static /* synthetic */ Pattern access$000() {
        return KOTLIN_MODULE_PATTERN;
    }

    static /* synthetic */ Pattern access$100() {
        return CLASS_PATTERN;
    }

    private static class JacocoWorkerAction
    implements Runnable {
        private Map<Action, List<File>> inputs;
        private File inputDir;
        private File outputDir;

        @Inject
        public JacocoWorkerAction(WorkerItemParameter workerItemParameter) {
            this.inputs = workerItemParameter.nonIncToProcess;
            this.inputDir = workerItemParameter.root;
            this.outputDir = workerItemParameter.output;
        }

        @Override
        public void run() {
            Instrumenter instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator());
            for (File toInstrument : this.inputs.getOrDefault((Object)Action.INSTRUMENT, (List<File>)ImmutableList.of())) {
                try {
                    InputStream inputStream = Files.asByteSource((File)toInstrument).openBufferedStream();
                    Throwable throwable = null;
                    try {
                        byte[] instrumented = instrumenter.instrument(inputStream, toInstrument.toString());
                        File outputFile = new File(this.outputDir, FileUtils.relativePath((File)toInstrument, (File)this.inputDir));
                        Files.createParentDirs((File)outputFile);
                        Files.write((byte[])instrumented, (File)outputFile);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to instrument file with Jacoco: " + toInstrument, e);
                }
            }
            for (File toCopy : this.inputs.getOrDefault((Object)Action.COPY, (List<File>)ImmutableList.of())) {
                File outputFile = new File(this.outputDir, FileUtils.relativePath((File)toCopy, (File)this.inputDir));
                try {
                    Files.createParentDirs((File)outputFile);
                    Files.copy((File)toCopy, (File)outputFile);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to copy file: " + toCopy, e);
                }
            }
        }
    }

    private static enum Action {
        COPY(JacocoTaskDelegate.access$000()),
        IGNORE(new Pattern[0]),
        INSTRUMENT(JacocoTaskDelegate.access$100());

        private final ImmutableList<Pattern> patterns;

        private Action(Pattern ... patterns) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (Pattern pattern : patterns) {
                Preconditions.checkNotNull((Object)pattern);
                builder.add((Object)pattern);
            }
            this.patterns = builder.build();
        }

        ImmutableList<Pattern> getPatterns() {
            return this.patterns;
        }
    }

    public static class WorkerItemParameter
    implements Serializable {
        final Map<Action, List<File>> nonIncToProcess;
        final File root;
        final File output;

        public WorkerItemParameter(Map<Action, List<File>> nonIncToProcess, File root, File output2) {
            this.nonIncToProcess = nonIncToProcess;
            this.root = root;
            this.output = output2;
        }
    }
}

