/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.builder.packaging.PackagingUtils;
import com.android.builder.utils.ZipEntryUtils;
import com.android.ide.common.internal.WaitableExecutor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ExtractJarsTransform
extends Transform {
    @VisibleForTesting
    static Logger LOGGER = Logging.getLogger(ExtractJarsTransform.class);
    private final Set<QualifiedContent.ContentType> contentTypes;
    private final Set<QualifiedContent.Scope> scopes;

    public ExtractJarsTransform(Set<QualifiedContent.ContentType> contentTypes, Set<QualifiedContent.Scope> scopes) {
        this.contentTypes = contentTypes;
        this.scopes = scopes;
    }

    public String getName() {
        return "extractJars";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.contentTypes;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return this.scopes;
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws IOException, TransformException, InterruptedException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        boolean isIncremental = transformInvocation.isIncremental();
        Preconditions.checkNotNull((Object)outputProvider, (Object)("Missing output object for transform " + this.getName()));
        boolean extractCode = this.contentTypes.contains(QualifiedContent.DefaultContentType.CLASSES);
        if (!isIncremental) {
            outputProvider.deleteAll();
        }
        try {
            WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
            for (TransformInput input : transformInvocation.getInputs()) {
                for (DirectoryInput dirInput : input.getDirectoryInputs()) {
                    File dirOutput = outputProvider.getContentLocation(dirInput.getFile().toString(), dirInput.getContentTypes(), dirInput.getScopes(), Format.DIRECTORY);
                    if (dirOutput.isDirectory()) {
                        com.android.utils.FileUtils.deleteDirectoryContents((File)dirOutput);
                    }
                    if (!dirInput.getFile().exists()) continue;
                    FileUtils.copyDirectory((File)dirInput.getFile(), (File)dirOutput);
                }
                for (JarInput jarInput : input.getJarInputs()) {
                    File jarFile = jarInput.getFile();
                    File outJarFolder = outputProvider.getContentLocation(jarInput.getFile().toString(), jarInput.getContentTypes(), jarInput.getScopes(), Format.DIRECTORY);
                    com.android.utils.FileUtils.mkdirs((File)outJarFolder);
                    if (!isIncremental) {
                        executor.execute(() -> {
                            ExtractJarsTransform.extractJar(outJarFolder, jarFile, extractCode);
                            return null;
                        });
                        continue;
                    }
                    switch (jarInput.getStatus()) {
                        case CHANGED: {
                            executor.execute(() -> {
                                com.android.utils.FileUtils.cleanOutputDir((File)outJarFolder);
                                ExtractJarsTransform.extractJar(outJarFolder, jarFile, extractCode);
                                return null;
                            });
                            break;
                        }
                        case ADDED: {
                            executor.execute(() -> {
                                ExtractJarsTransform.extractJar(outJarFolder, jarFile, extractCode);
                                return null;
                            });
                            break;
                        }
                        case REMOVED: {
                            executor.execute(() -> {
                                com.android.utils.FileUtils.cleanOutputDir((File)outJarFolder);
                                return null;
                            });
                            break;
                        }
                    }
                }
            }
            executor.waitForTasksWithQuickFail(true);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransformException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void extractJar(File outJarFolder, File jarFile, boolean extractCode) throws IOException {
        com.android.utils.FileUtils.mkdirs((File)outJarFolder);
        HashSet<String> lowerCaseNames = new HashSet<String>();
        boolean foundCaseInsensitiveIssue = false;
        try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(jarFile));
             ZipInputStream zis = new ZipInputStream(fis);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                try {
                    File outputFile;
                    String name = entry.getName();
                    if (entry.isDirectory()) continue;
                    boolean bl = foundCaseInsensitiveIssue = foundCaseInsensitiveIssue || !lowerCaseNames.add(name.toLowerCase(Locale.US));
                    Action action = ExtractJarsTransform.getAction(name, extractCode);
                    if (action != Action.COPY || !ZipEntryUtils.isValidZipEntryPath((File)(outputFile = new File(outJarFolder, name.replace('/', File.separatorChar))), (File)outJarFolder)) continue;
                    com.android.utils.FileUtils.mkdirs((File)outputFile.getParentFile());
                    BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
                    Throwable throwable = null;
                    try {
                        ByteStreams.copy((InputStream)zis, (OutputStream)outputStream);
                        ((OutputStream)outputStream).flush();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (outputStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((OutputStream)outputStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((OutputStream)outputStream).close();
                    }
                }
                finally {
                    zis.closeEntry();
                }
            }
        }
        if (foundCaseInsensitiveIssue) {
            LOGGER.error("Jar '{}' contains multiple entries which will map to the same file on case insensitive file systems.\nThis can be caused by obfuscation with useMixedCaseClassNames.\nThis build will be incorrect on case insensitive file systems.", (Object)jarFile.getAbsolutePath());
        }
    }

    public static Action getAction(String archivePath, boolean extractCode) {
        if ("META-INF/MANIFEST.MF".equals(archivePath)) {
            return Action.IGNORE;
        }
        String[] segments = archivePath.split("/");
        if (segments.length == 0) {
            return Action.IGNORE;
        }
        return PackagingUtils.checkFileForApkPackaging((String)archivePath, (boolean)extractCode) ? Action.COPY : Action.IGNORE;
    }

    static enum Action {
        COPY,
        IGNORE;

    }
}

