/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.stripping.SymbolStripExecutableFinder;
import com.android.build.gradle.internal.cxx.stripping.SymbolStripExecutableFinderKt;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.transforms.StripDebugSymbolTransform$WhenMappings;
import com.android.build.gradle.internal.transforms.StripDebugSymbolTransformKt;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import java.io.File;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\bH\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\u0010\u0010\u001a\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001c0\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u000bH\u0016J\b\u0010\u001e\u001a\u00020\u000bH\u0016J\"\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0016R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006)"}, d2={"Lcom/android/build/gradle/internal/transforms/StripDebugSymbolTransform;", "Lcom/android/build/api/transform/Transform;", "project", "Lorg/gradle/api/Project;", "ndkHandler", "Ljava/util/function/Supplier;", "Lcom/android/build/gradle/internal/ndk/NdkHandler;", "excludePattern", "", "", "isLibrary", "", "includeFeaturesInScopes", "(Lorg/gradle/api/Project;Ljava/util/function/Supplier;Ljava/util/Set;ZZ)V", "excludeMatchers", "", "Ljava/nio/file/PathMatcher;", "stripToolFinder", "Lcom/android/build/gradle/internal/cxx/stripping/SymbolStripExecutableFinder;", "getStripToolFinder", "()Lcom/android/build/gradle/internal/cxx/stripping/SymbolStripExecutableFinder;", "stripToolFinder$delegate", "Lkotlin/Lazy;", "getInputTypes", "Lcom/android/build/gradle/internal/pipeline/ExtendedContentType;", "getName", "getScopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "isCacheable", "isIncremental", "stripFile", "", "input", "Ljava/io/File;", "output", "abi", "Lcom/android/build/gradle/internal/core/Abi;", "transform", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "gradle"})
public final class StripDebugSymbolTransform
extends Transform {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy stripToolFinder$delegate;
    private final List<PathMatcher> excludeMatchers;
    private final Project project;
    private final boolean isLibrary;
    private final boolean includeFeaturesInScopes;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(StripDebugSymbolTransform.class), "stripToolFinder", "getStripToolFinder()Lcom/android/build/gradle/internal/cxx/stripping/SymbolStripExecutableFinder;"))};
    }

    private final SymbolStripExecutableFinder getStripToolFinder() {
        Lazy lazy = this.stripToolFinder$delegate;
        StripDebugSymbolTransform stripDebugSymbolTransform = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (SymbolStripExecutableFinder)lazy.getValue();
    }

    @NotNull
    public String getName() {
        return "stripDebugSymbol";
    }

    @NotNull
    public Set<ExtendedContentType> getInputTypes() {
        return SetsKt.setOf((Object)((Object)ExtendedContentType.NATIVE_LIBS));
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        Set<QualifiedContent.ScopeType> set;
        if (this.isLibrary) {
            Set<QualifiedContent.ScopeType> set2 = TransformManager.PROJECT_ONLY;
            set = set2;
            Intrinsics.checkExpressionValueIsNotNull(set2, (String)"TransformManager.PROJECT_ONLY");
        } else if (this.includeFeaturesInScopes) {
            Set<QualifiedContent.ScopeType> set3 = TransformManager.SCOPE_FULL_WITH_FEATURES;
            set = set3;
            Intrinsics.checkExpressionValueIsNotNull(set3, (String)"TransformManager.SCOPE_FULL_WITH_FEATURES");
        } else {
            Set<QualifiedContent.ScopeType> set4 = TransformManager.SCOPE_FULL_PROJECT;
            set = set4;
            Intrinsics.checkExpressionValueIsNotNull(set4, (String)"TransformManager.SCOPE_FULL_PROJECT");
        }
        return set;
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean isCacheable() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void transform(@NotNull TransformInvocation transformInvocation) {
        Intrinsics.checkParameterIsNotNull((Object)transformInvocation, (String)"transformInvocation");
        v0 = transformInvocation.getOutputProvider();
        if (v0 == null) {
            throw (Throwable)new AssertionError((Object)("Missing output object for transform " + this.getName()));
        }
        outputProvider = v0;
        isIncremental = transformInvocation.isIncremental();
        if (!isIncremental) {
            outputProvider.deleteAll();
        }
        var5_4 = transformInvocation.getInputs().iterator();
        while (var5_4.hasNext()) {
            v1 = transformInput = (TransformInput)var5_4.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"transformInput");
            var7_7 = v1.getDirectoryInputs().iterator();
            while (var7_7.hasNext()) {
                block19: {
                    v2 = directoryInput = (DirectoryInput)var7_7.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"directoryInput");
                    folder = v2.getFile();
                    output = outputProvider.getContentLocation(folder.toString(), this.getInputTypes(), directoryInput.getScopes(), Format.DIRECTORY);
                    if (!isIncremental) break block19;
                    for (Map.Entry<K, V> fileStatus : directoryInput.getChangedFiles().entrySet()) {
                        v3 = input = (File)fileStatus.getKey();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"input");
                        if (v3.isDirectory()) continue;
                        v4 = input.getParentFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"input.parentFile");
                        abiName = v4.getName();
                        abi = Abi.getByName(abiName);
                        path = FileUtils.relativePossiblyNonExistingPath((File)input, (File)folder);
                        strippedLib = new File(output, path);
                        v5 = (Status)fileStatus.getValue();
                        if (v5 == null) continue;
                        switch (StripDebugSymbolTransform$WhenMappings.$EnumSwitchMapping$0[v5.ordinal()]) {
                            case 1: 
                            case 2: {
                                $receiver$iv = this.excludeMatchers;
                                if (!($receiver$iv instanceof Collection) || !((Collection)$receiver$iv).isEmpty()) ** GOTO lbl38
                                v6 = false;
                                ** GOTO lbl45
lbl38:
                                // 2 sources

                                for (T element$iv : $receiver$iv) {
                                    it = (PathMatcher)element$iv;
                                    $i$a$-any-StripDebugSymbolTransform$transform$1 = false;
                                    if (!it.matches(Paths.get(path, new String[0]))) continue;
                                    v6 = true;
                                    ** GOTO lbl45
                                }
                                v6 = false;
lbl45:
                                // 3 sources

                                if (v6) {
                                    FileUtils.mkdirs((File)strippedLib.getParentFile());
                                    FileUtils.copyFile((File)input, (File)strippedLib);
                                    break;
                                }
                                this.stripFile(input, strippedLib, abi);
                                break;
                            }
                            case 3: {
                                FileUtils.deletePath((File)new File(output, path));
                            }
                        }
                    }
                    continue;
                }
                var11_11 = FileUtils.getAllFiles((File)folder).iterator();
                while (var11_11.hasNext()) {
                    block18: {
                        v7 = input = (File)var11_11.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"input");
                        if (v7.isDirectory()) continue;
                        v8 = input.getParentFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"input.parentFile");
                        abiName = v8.getName();
                        abi = Abi.getByName(abiName);
                        path = FileUtils.relativePath((File)input, (File)folder);
                        strippedLib = new File(output, path);
                        $receiver$iv = this.excludeMatchers;
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            v9 = false;
                        } else {
                            for (T element$iv : $receiver$iv) {
                                it = (PathMatcher)element$iv;
                                $i$a$-any-StripDebugSymbolTransform$transform$2 = false;
                                if (!it.matches(Paths.get(path, new String[0]))) continue;
                                v9 = true;
                                break block18;
                            }
                            v9 = false;
                        }
                    }
                    if (v9) {
                        FileUtils.mkdirs((File)strippedLib.getParentFile());
                        FileUtils.copyFile((File)input, (File)strippedLib);
                        continue;
                    }
                    this.stripFile(input, strippedLib, abi);
                }
            }
            var7_7 = transformInput.getJarInputs().iterator();
            while (var7_7.hasNext()) {
                v10 = jarInput = (JarInput)var7_7.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"jarInput");
                outFile = outputProvider.getContentLocation(v10.getFile().toString(), this.getInputTypes(), jarInput.getScopes(), Format.JAR);
                if (!isIncremental || jarInput.getStatus() == Status.ADDED || jarInput.getStatus() == Status.CHANGED) {
                    v11 = outFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"outFile");
                    FileUtils.mkdirs((File)v11.getParentFile());
                    FileUtils.copyFile((File)jarInput.getFile(), (File)outFile);
                    continue;
                }
                if (jarInput.getStatus() != Status.REMOVED) continue;
                FileUtils.deleteIfExists((File)outFile);
            }
        }
    }

    private final void stripFile(File input, File output2, Abi abi) {
        FileUtils.mkdirs((File)output2.getParentFile());
        LoggerWrapper logger = new LoggerWrapper(this.project.getLogger());
        File exe2 = this.getStripToolFinder().stripToolExecutableFile(input, abi, (Function1<? super String, ? extends File>)new Function1(logger){
            final /* synthetic */ LoggerWrapper $logger;

            @Nullable
            public final Void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$logger.warning(it + " Packaging it as is.", new Object[0]);
                return null;
            }
            {
                this.$logger = loggerWrapper;
                super(1);
            }
        });
        if (exe2 == null) {
            FileUtils.copyFile((File)input, (File)output2);
            return;
        }
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(exe2);
        builder.addArgs("--strip-unneeded");
        builder.addArgs("-o");
        builder.addArgs(output2.toString());
        builder.addArgs(input.toString());
        ProcessResult processResult = new GradleProcessExecutor(this.project).execute(builder.createProcess(), (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)logger));
        Intrinsics.checkExpressionValueIsNotNull((Object)processResult, (String)"GradleProcessExecutor(pr\u2026ler(logger)\n            )");
        ProcessResult result = processResult;
        if (result.getExitValue() != 0) {
            logger.warning("Unable to strip library " + input.getAbsolutePath() + " due to error " + result.getExitValue() + " returned from " + exe2 + ", packaging it as is.", new Object[0]);
            FileUtils.copyFile((File)input, (File)output2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public StripDebugSymbolTransform(@NotNull Project project, @NotNull Supplier<NdkHandler> ndkHandler, @NotNull Set<String> excludePattern, boolean isLibrary, boolean includeFeaturesInScopes) {
        Collection<PathMatcher> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(ndkHandler, (String)"ndkHandler");
        Intrinsics.checkParameterIsNotNull(excludePattern, (String)"excludePattern");
        this.project = project;
        this.isLibrary = isLibrary;
        this.includeFeaturesInScopes = includeFeaturesInScopes;
        this.stripToolFinder$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SymbolStripExecutableFinder>(ndkHandler){
            final /* synthetic */ Supplier $ndkHandler;

            @NotNull
            public final SymbolStripExecutableFinder invoke() {
                T t = this.$ndkHandler.get();
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"ndkHandler.get()");
                return SymbolStripExecutableFinderKt.createSymbolStripExecutableFinder((NdkHandler)t);
            }
            {
                this.$ndkHandler = supplier;
                super(0);
            }
        }));
        Iterable iterable = excludePattern;
        StripDebugSymbolTransform stripDebugSymbolTransform = this;
        void var7_8 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            PathMatcher pathMatcher = StripDebugSymbolTransformKt.access$compileGlob((String)it);
            collection.add(pathMatcher);
        }
        collection = (List)destination$iv$iv;
        stripDebugSymbolTransform.excludeMatchers = collection;
    }
}

