/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.configure.CmakeAndroidGradleBuildExtensionsKt;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationAbiConfiguration;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationVariantConfiguration;
import com.android.build.gradle.internal.cxx.configure.LoggingEnvironmentKt;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.builder.core.AndroidBuilder;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class CmakeExternalNativeJsonGenerator
extends ExternalNativeJsonGenerator {
    private static final Pattern cmakeFileFinder = Pattern.compile("^(.*CMake (Error|Warning).* at\\s+)([^:]+)(:.*)$", 32);
    final File cmakeInstallFolder;

    CmakeExternalNativeJsonGenerator(JsonGenerationVariantConfiguration config2, Set<String> configurationFailures, AndroidBuilder androidBuilder, File cmakeInstallFolder, GradleBuildVariant.Builder stats) {
        super(config2, configurationFailures, androidBuilder, stats);
        this.cmakeInstallFolder = cmakeInstallFolder;
        this.stats.setNativeBuildSystemType(GradleNativeAndroidModule.NativeBuildSystemType.CMAKE);
        File cmakelists = this.getMakefile();
        if (cmakelists.isDirectory()) {
            LoggingEnvironmentKt.error("Gradle project cmake.path %s is a folder. It must be CMakeLists.txt", cmakelists);
        } else if (cmakelists.isFile()) {
            String filename = cmakelists.getName();
            if (!filename.equals("CMakeLists.txt")) {
                LoggingEnvironmentKt.error("Gradle project cmake.path specifies %s but it must be CMakeLists.txt", filename);
            }
        } else {
            LoggingEnvironmentKt.error("Gradle project cmake.path is %s but that file doesn't exist", cmakelists);
        }
    }

    abstract List<String> getCacheArguments(JsonGenerationAbiConfiguration var1);

    public abstract String executeProcessAndGetOutput(JsonGenerationAbiConfiguration var1) throws ProcessException, IOException;

    @Override
    public String executeProcess(JsonGenerationAbiConfiguration abiConfig) throws ProcessException, IOException {
        String output2 = this.executeProcessAndGetOutput(abiConfig);
        return CmakeExternalNativeJsonGenerator.correctMakefilePaths(output2, this.getMakefile().getParentFile());
    }

    @Override
    void processBuildOutput(String buildOutput, JsonGenerationAbiConfiguration abiConfig) {
        if (this.config.enableCmakeCompilerSettingsCache) {
            CmakeAndroidGradleBuildExtensionsKt.writeCompilerSettingsToCache(this.config.compilerSettingsCacheFolder, abiConfig);
        }
    }

    @Override
    ProcessInfoBuilder getProcessBuilder(JsonGenerationAbiConfiguration abiConfig) {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.getCmakeExecutable());
        builder.addArgs(this.getProcessBuilderArgs(abiConfig));
        return builder;
    }

    @VisibleForTesting
    List<String> getProcessBuilderArgs(JsonGenerationAbiConfiguration abiConfig) {
        ArrayList processBuilderArgs = Lists.newArrayList();
        File cmakeListsFolder = this.getMakefile().getParentFile();
        processBuilderArgs.add(String.format("-H%s", cmakeListsFolder));
        processBuilderArgs.add(String.format("-B%s", abiConfig.getExternalNativeBuildFolder()));
        processBuilderArgs.addAll(this.getCacheArguments(abiConfig));
        processBuilderArgs.addAll(this.getBuildArguments());
        if (this.config.enableCmakeCompilerSettingsCache) {
            return CmakeAndroidGradleBuildExtensionsKt.wrapCmakeListsForCompilerSettingsCaching(this.config.compilerSettingsCacheFolder, abiConfig, cmakeListsFolder, processBuilderArgs).getArgs();
        }
        return processBuilderArgs;
    }

    protected List<String> getCommonCacheArguments(JsonGenerationAbiConfiguration abiConfig) {
        ArrayList cacheArguments = Lists.newArrayList();
        cacheArguments.add(String.format("-DANDROID_ABI=%s", abiConfig.getAbiName()));
        cacheArguments.add(String.format("-DANDROID_PLATFORM=android-%s", abiConfig.getAbiPlatformVersion()));
        cacheArguments.add(String.format("-DCMAKE_LIBRARY_OUTPUT_DIRECTORY=%s", new File(this.getObjFolder(), abiConfig.getAbiName())));
        cacheArguments.add(String.format("-DCMAKE_BUILD_TYPE=%s", this.isDebuggable() ? "Debug" : "Release"));
        cacheArguments.add(String.format("-DANDROID_NDK=%s", this.getNdkFolder()));
        if (!this.getcFlags().isEmpty()) {
            cacheArguments.add(String.format("-DCMAKE_C_FLAGS=%s", Joiner.on((String)" ").join(this.getcFlags())));
        }
        if (!this.getCppFlags().isEmpty()) {
            cacheArguments.add(String.format("-DCMAKE_CXX_FLAGS=%s", Joiner.on((String)" ").join(this.getCppFlags())));
        }
        return cacheArguments;
    }

    public File getCompileCommandsJson(String abi) {
        return ExternalNativeBuildTaskUtils.getCompileCommandsJson(this.getJsonFolder(), abi);
    }

    @Override
    public NativeBuildSystem getNativeBuildSystem() {
        return NativeBuildSystem.CMAKE;
    }

    @Override
    Map<Abi, File> getStlSharedObjectFiles() {
        String stl = null;
        File ndkBasePath = null;
        for (String argument : this.getBuildArguments()) {
            switch (argument = argument.replace(" ", "")) {
                case "-DANDROID_STL=stlport_shared": {
                    stl = "stlport";
                    ndkBasePath = FileUtils.join((File)this.getNdkFolder(), (String[])new String[]{"sources", "cxx-stl", "stlport"});
                    break;
                }
                case "-DANDROID_STL=gnustl_shared": {
                    stl = "gnustl";
                    ndkBasePath = FileUtils.join((File)this.getNdkFolder(), (String[])new String[]{"sources", "cxx-stl", "gnu-libstdc++", "4.9"});
                    break;
                }
                case "-DANDROID_STL=c++_shared": {
                    stl = "c++";
                    ndkBasePath = FileUtils.join((File)this.getNdkFolder(), (String[])new String[]{"sources", "cxx-stl", "llvm-libc++"});
                }
            }
        }
        HashMap result = Maps.newHashMap();
        if (stl == null) {
            return result;
        }
        for (Abi abi : this.getAbis()) {
            File file = FileUtils.join((File)ndkBasePath, (String[])new String[]{"libs", abi.getName(), String.format("lib%s_shared.so", stl)});
            Preconditions.checkState((boolean)file.isFile(), (String)"Expected NDK STL shared object file at %s", (Object)file.toString());
            result.put(abi, file);
        }
        return result;
    }

    @VisibleForTesting
    static String correctMakefilePaths(String input, File makeFileDirectory) {
        Matcher cmakeFinderMatcher = cmakeFileFinder.matcher(input);
        if (cmakeFinderMatcher.matches()) {
            ArrayList<String> corrected = new ArrayList<String>();
            for (String entry : input.split(System.lineSeparator())) {
                cmakeFinderMatcher = cmakeFileFinder.matcher(entry);
                if (cmakeFinderMatcher.matches()) {
                    String fileName = cmakeFinderMatcher.group(3);
                    File makeFile = new File(fileName);
                    if (makeFile.isAbsolute()) {
                        corrected.add(entry);
                        continue;
                    }
                    makeFile = new File(makeFileDirectory, fileName);
                    if (!makeFile.exists()) {
                        corrected.add(entry);
                        continue;
                    }
                    corrected.add(cmakeFinderMatcher.group(1) + makeFile.getAbsolutePath() + cmakeFinderMatcher.group(4));
                    continue;
                }
                corrected.add(entry);
            }
            return Joiner.on((String)System.lineSeparator()).join(corrected);
        }
        return input;
    }

    protected File getToolChainFile() {
        String toolchainFileName = "android.toolchain.cmake";
        File ndkCmakeFolder = new File(new File(this.getNdkFolder(), "build"), "cmake");
        File toolchainFile = new File(ndkCmakeFolder, toolchainFileName);
        if (!toolchainFile.exists()) {
            toolchainFile = new File(this.cmakeInstallFolder, toolchainFileName);
        }
        return toolchainFile;
    }

    protected File getCmakeBinFolder() {
        return new File(this.cmakeInstallFolder, "bin");
    }

    protected File getCmakeExecutable() {
        if (CmakeExternalNativeJsonGenerator.isWindows()) {
            return new File(this.getCmakeBinFolder(), "cmake.exe");
        }
        return new File(this.getCmakeBinFolder(), "cmake");
    }
}

