/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.ApplicationTaskManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactImpl;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.CodeShrinker;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.test.TestApplicationTestData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantFactory;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.CheckTestedAppObfuscation;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessTestManifest;
import com.android.builder.profile.Recorder;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceProvider;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collection;
import java.util.Objects;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class TestApplicationTaskManager
extends ApplicationTaskManager {
    public TestApplicationTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, VariantFactory variantFactory, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project, projectOptions, dataBindingBuilder, extension, variantFactory, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(VariantScope variantScope) {
        super.createTasksForVariantScope(variantScope);
        Configuration testedApksConfig = this.project.getConfigurations().getByName(TestVariantFactory.getTestedApksConfigurationName(variantScope.getFullVariantName()));
        BuildableArtifact testingApk = variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK);
        FileCollection testedApks = testedApksConfig.getIncoming().artifactView(config2 -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.APK.getType()));
        }).getFiles();
        FileCollection testedManifestMetadata = this.getTestedManifestMetadata(variantScope.getVariantData());
        TestApplicationTestData testData = new TestApplicationTestData(variantScope.getVariantConfiguration(), variantScope.getVariantData()::getApplicationId, testingApk, new BuildableArtifactImpl(testedApks));
        this.configureTestData(testData);
        TaskProvider<DeviceProviderInstrumentTestTask> instrumentTestTask = this.taskFactory.register(new DeviceProviderInstrumentTestTask.CreationAction(variantScope, (DeviceProvider)new ConnectedDeviceProvider(() -> (File)this.globalScope.getSdkComponents().getAdbExecutableProvider().get(), this.extension.getAdbOptions().getTimeOutInMs(), (ILogger)new LoggerWrapper(this.getLogger())), testData, testedManifestMetadata){

            @Override
            public String getName() {
                return super.getName() + "AndroidTest";
            }
        });
        Task connectedAndroidTest = this.taskFactory.findByName("connectedAndroidTest");
        if (connectedAndroidTest != null) {
            connectedAndroidTest.dependsOn(new Object[]{instrumentTestTask.getName()});
        }
    }

    @Override
    protected void postJavacCreation(VariantScope scope) {
    }

    @Override
    public void createLintTasks(VariantScope scope) {
    }

    @Override
    public void createGlobalLintTask() {
    }

    @Override
    public void configureGlobalLintTask(Collection<VariantScope> variants) {
    }

    @Override
    protected CodeShrinker maybeCreateJavaCodeShrinkerTransform(VariantScope variantScope) {
        if (variantScope.getCodeShrinker() != null) {
            return this.doCreateJavaCodeShrinkerTransform(variantScope, Objects.requireNonNull(variantScope.getCodeShrinker()), variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.APK_MAPPING));
        }
        TaskProvider<CheckTestedAppObfuscation> checkObfuscation = this.taskFactory.register(new CheckTestedAppObfuscation.CreationAction(variantScope));
        Preconditions.checkNotNull(variantScope.getTaskContainer().getJavacTask());
        TaskFactoryUtils.dependsOn(variantScope.getTaskContainer().getJavacTask(), checkObfuscation);
        return null;
    }

    private FileCollection getTestedManifestMetadata(BaseVariantData variantData) {
        return variantData.getVariantDependency().getCompileClasspath().getIncoming().artifactView(config2 -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.MANIFEST_METADATA.getType()));
        }).getFiles();
    }

    @Override
    protected TaskProvider<? extends ManifestProcessorTask> createMergeManifestTask(VariantScope variantScope) {
        Provider directoryProperty = this.project.provider(() -> (Directory)this.project.getLayout().getBuildDirectory().dir(this.getTestedManifestMetadata(variantScope.getVariantData()).getSingleFile().getAbsolutePath()).get());
        return this.taskFactory.register(new ProcessTestManifest.CreationAction(variantScope, (Provider<Directory>)directoryProperty));
    }

    @Override
    protected void createVariantPreBuildTask(VariantScope scope) {
        this.createDefaultPreBuildTask(scope);
    }
}

