/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorKt;
import com.android.build.gradle.internal.ndk.DefaultNdkInfo;
import com.android.build.gradle.internal.ndk.NdkPlatform;
import com.android.build.gradle.internal.ndk.NdkR14Info;
import com.android.builder.sdk.InstallFailedException;
import com.android.builder.sdk.LicenceNotAcceptedException;
import com.android.builder.sdk.SdkLibData;
import com.android.builder.sdk.SdkLoader;
import com.android.repository.Revision;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.gradle.api.logging.Logging;

public class NdkHandler {
    private final File projectDir;
    private final String compileSdkVersion;
    private NdkPlatform ndkPlatform;
    private final String ndkVersionFromDsl;
    private final boolean enableSideBySideNdk;

    public NdkHandler(boolean enableSideBySideNdk, String ndkVersionFromDsl, String compileSdkVersion, File projectDir) {
        this.enableSideBySideNdk = enableSideBySideNdk;
        this.ndkVersionFromDsl = ndkVersionFromDsl;
        this.projectDir = projectDir;
        this.compileSdkVersion = compileSdkVersion;
        this.ndkPlatform = null;
    }

    public NdkPlatform getNdkPlatform() {
        Revision revision2;
        DefaultNdkInfo ndkInfo2;
        if (this.ndkPlatform != null) {
            return this.ndkPlatform;
        }
        File ndkDirectory2 = this.enableSideBySideNdk ? NdkLocatorKt.findNdkPath(this.ndkVersionFromDsl, this.projectDir) : NdkHandler.findNdkDirectory(this.projectDir);
        if (ndkDirectory2 == null || !ndkDirectory2.exists()) {
            ndkInfo2 = null;
            revision2 = null;
        } else {
            revision2 = NdkHandler.findRevision(ndkDirectory2);
            ndkInfo2 = revision2 == null ? new DefaultNdkInfo(ndkDirectory2) : new NdkR14Info(ndkDirectory2);
        }
        this.ndkPlatform = new NdkPlatform(ndkDirectory2, ndkInfo2, revision2, this.compileSdkVersion);
        return this.ndkPlatform;
    }

    private void invalidateNdk() {
        this.ndkPlatform = null;
    }

    private static Properties readProperties(File file) {
        Properties properties = new Properties();
        try (FileInputStream fis2 = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader((InputStream)fis2, Charsets.UTF_8);){
            properties.load(reader);
        }
        catch (FileNotFoundException fis2) {
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to read %1$s.", file), e);
        }
        return properties;
    }

    @VisibleForTesting
    public static Revision findRevision(File ndkDirectory2) {
        if (ndkDirectory2 == null) {
            return null;
        }
        File sourceProperties = new File(ndkDirectory2, "source.properties");
        if (!sourceProperties.exists()) {
            return null;
        }
        Properties properties = NdkHandler.readProperties(sourceProperties);
        String version = properties.getProperty("Pkg.Revision");
        if (version != null) {
            return Revision.parseRevision((String)version);
        }
        return null;
    }

    private static File findNdkDirectory(File projectDir) {
        File ndkDir;
        File localProperties = new File(projectDir, "local.properties");
        Properties properties = new Properties();
        if (localProperties.isFile()) {
            properties = NdkHandler.readProperties(localProperties);
        }
        if ((ndkDir = NdkHandler.findNdkDirectory(properties, projectDir)) == null) {
            return null;
        }
        return NdkHandler.checkNdkDir(ndkDir) ? ndkDir : null;
    }

    private static boolean checkNdkDir(File ndkDir) {
        if (!new File(ndkDir, "platforms").isDirectory()) {
            NdkHandler.invalidNdkWarning("NDK is missing a \"platforms\" directory.", ndkDir);
            return false;
        }
        if (!new File(ndkDir, "toolchains").isDirectory()) {
            NdkHandler.invalidNdkWarning("NDK is missing a \"toolchains\" directory.", ndkDir);
            return false;
        }
        return true;
    }

    private static void invalidNdkWarning(String message, File ndkDir) {
        Logging.getLogger(NdkHandler.class).warn("{}\nIf you are using NDK, verify the ndkPlatform.dir is set to a valid NDK directory.  It is currently set to {}.\nIf you are not using NDK, unset the NDK variable from ANDROID_NDK_HOME or local.properties to remove this warning.\n", (Object)message, (Object)ndkDir.getAbsolutePath());
    }

    private static File findNdkDirectory(Properties properties, File projectDir) {
        File ndkBundle;
        String ndkDirProp = properties.getProperty("ndk.dir");
        if (ndkDirProp != null) {
            return new File(ndkDirProp);
        }
        String ndkEnvVar = System.getenv("ANDROID_NDK_HOME");
        if (ndkEnvVar != null) {
            return new File(ndkEnvVar);
        }
        Pair<File, Boolean> sdkLocation = SdkHandler.findSdkLocation(properties, projectDir);
        File sdkFolder = (File)sdkLocation.getFirst();
        if (sdkFolder != null && (ndkBundle = new File(sdkFolder, "ndk-bundle")).isDirectory()) {
            return ndkBundle;
        }
        return null;
    }

    public void installFromSdk(SdkLoader sdkLoader, SdkLibData sdkLibData) {
        try {
            if (this.enableSideBySideNdk) {
                sdkLoader.installSdkTool(sdkLibData, "ndk");
            } else {
                sdkLoader.installSdkTool(sdkLibData, "ndk-bundle");
            }
        }
        catch (InstallFailedException | LicenceNotAcceptedException e) {
            throw new RuntimeException(e);
        }
        this.invalidateNdk();
    }
}

