/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.profile.ProfileMBeanImpl;
import com.android.build.gradle.internal.profile.RecordingBuildListener;
import com.android.ide.common.workers.ProfileMBean;
import com.android.ide.common.workers.ProfileMBeans;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/profile/ProfileAgent;", "", "()V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "mbs", "Ljavax/management/MBeanServer;", "register", "", "projectName", "", "buildListener", "Lcom/android/build/gradle/internal/profile/RecordingBuildListener;", "unregister", "gradle"})
public final class ProfileAgent {
    private static final MBeanServer mbs;
    private static final Logger logger;
    public static final ProfileAgent INSTANCE;

    public final synchronized void register(@NotNull String projectName, @NotNull RecordingBuildListener buildListener) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)buildListener, (String)"buildListener");
        try {
            ObjectName objectNameForProject = ProfileMBeans.INSTANCE.composeObjectName(projectName);
            Set<ObjectInstance> mbeans = mbs.queryMBeans(objectNameForProject, null);
            if (mbeans.isEmpty()) {
                ProfileMBeanImpl bean = new ProfileMBeanImpl(buildListener);
                StandardMBean mbean = new StandardMBean(bean, ProfileMBean.class, false);
                mbs.registerMBean(mbean, objectNameForProject);
            }
        }
        catch (Throwable t) {
            logger.warning("Profiling not available : " + t);
        }
    }

    public final synchronized void unregister() {
        Iterator<ObjectInstance> iterator = mbs.queryMBeans(new ObjectName("domain:type=Gradle.agp,name=profiling,*"), null).iterator();
        while (iterator.hasNext()) {
            ObjectInstance queryMBean;
            ObjectInstance objectInstance = queryMBean = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectInstance, (String)"queryMBean");
            mbs.unregisterMBean(objectInstance.getObjectName());
        }
    }

    private ProfileAgent() {
    }

    static {
        ProfileAgent profileAgent;
        INSTANCE = profileAgent = new ProfileAgent();
        mbs = ManagementFactory.getPlatformMBeanServer();
        logger = Logger.getLogger(Reflection.getOrCreateKotlinClass(ProfileAgent.class).getQualifiedName());
    }
}

