/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.ResourceDirectoryParser;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.workers.WorkerExecutorFacade;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0003\u0016\u0017\u0018B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0007R \u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\n8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/res/ParseLibraryResourcesTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "<set-?>", "Lcom/android/build/api/artifact/BuildableArtifact;", "inputResourcesDir", "getInputResourcesDir", "()Lcom/android/build/api/artifact/BuildableArtifact;", "Ljava/io/File;", "librarySymbolsFile", "getLibrarySymbolsFile", "()Ljava/io/File;", "Lorg/gradle/api/file/FileCollection;", "platformAttrRTxt", "getPlatformAttrRTxt", "()Lorg/gradle/api/file/FileCollection;", "workers", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "parseResources", "", "CreateAction", "ParseResourcesParams", "ParseResourcesRunnable", "gradle"})
public class ParseLibraryResourcesTask
extends AndroidVariantTask {
    private final WorkerExecutorFacade workers;
    @NotNull
    private FileCollection platformAttrRTxt;
    @NotNull
    private BuildableArtifact inputResourcesDir;
    @NotNull
    private File librarySymbolsFile;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public final FileCollection getPlatformAttrRTxt() {
        FileCollection fileCollection = this.platformAttrRTxt;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"platformAttrRTxt");
        }
        return fileCollection;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final BuildableArtifact getInputResourcesDir() {
        BuildableArtifact buildableArtifact = this.inputResourcesDir;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputResourcesDir");
        }
        return buildableArtifact;
    }

    @OutputFile
    @NotNull
    public final File getLibrarySymbolsFile() {
        File file = this.librarySymbolsFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"librarySymbolsFile");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void parseResources() {
        Closeable closeable = (Closeable)this.workers;
        Throwable throwable = null;
        try {
            WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
            boolean bl = false;
            BuildableArtifact buildableArtifact = this.inputResourcesDir;
            if (buildableArtifact == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"inputResourcesDir");
            }
            File file = BuildableArtifactUtil.singleFile(buildableArtifact);
            FileCollection fileCollection = this.platformAttrRTxt;
            if (fileCollection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"platformAttrRTxt");
            }
            File file2 = fileCollection.getSingleFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"platformAttrRTxt.singleFile");
            File file3 = this.librarySymbolsFile;
            if (file3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"librarySymbolsFile");
            }
            it.submit(ParseResourcesRunnable.class, (Serializable)new ParseResourcesParams(file, file2, file3));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Inject
    public ParseLibraryResourcesTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String string = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        String string2 = this.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        this.workers = Workers.preferWorkers$default(Workers.INSTANCE, string, string2, workerExecutor, null, 8, null);
    }

    public static final /* synthetic */ FileCollection access$getPlatformAttrRTxt$p(ParseLibraryResourcesTask $this) {
        FileCollection fileCollection = $this.platformAttrRTxt;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"platformAttrRTxt");
        }
        return fileCollection;
    }

    public static final /* synthetic */ BuildableArtifact access$getInputResourcesDir$p(ParseLibraryResourcesTask $this) {
        BuildableArtifact buildableArtifact = $this.inputResourcesDir;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputResourcesDir");
        }
        return buildableArtifact;
    }

    public static final /* synthetic */ File access$getLibrarySymbolsFile$p(ParseLibraryResourcesTask $this) {
        File file = $this.librarySymbolsFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"librarySymbolsFile");
        }
        return file;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/res/ParseLibraryResourcesTask$ParseResourcesParams;", "Ljava/io/Serializable;", "inputResDir", "Ljava/io/File;", "platformAttrsRTxt", "librarySymbolsFile", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;)V", "getInputResDir", "()Ljava/io/File;", "getLibrarySymbolsFile", "getPlatformAttrsRTxt", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "gradle"})
    public static final class ParseResourcesParams
    implements Serializable {
        @NotNull
        private final File inputResDir;
        @NotNull
        private final File platformAttrsRTxt;
        @NotNull
        private final File librarySymbolsFile;

        @NotNull
        public final File getInputResDir() {
            return this.inputResDir;
        }

        @NotNull
        public final File getPlatformAttrsRTxt() {
            return this.platformAttrsRTxt;
        }

        @NotNull
        public final File getLibrarySymbolsFile() {
            return this.librarySymbolsFile;
        }

        public ParseResourcesParams(@NotNull File inputResDir, @NotNull File platformAttrsRTxt, @NotNull File librarySymbolsFile) {
            Intrinsics.checkParameterIsNotNull((Object)inputResDir, (String)"inputResDir");
            Intrinsics.checkParameterIsNotNull((Object)platformAttrsRTxt, (String)"platformAttrsRTxt");
            Intrinsics.checkParameterIsNotNull((Object)librarySymbolsFile, (String)"librarySymbolsFile");
            this.inputResDir = inputResDir;
            this.platformAttrsRTxt = platformAttrsRTxt;
            this.librarySymbolsFile = librarySymbolsFile;
        }

        @NotNull
        public final File component1() {
            return this.inputResDir;
        }

        @NotNull
        public final File component2() {
            return this.platformAttrsRTxt;
        }

        @NotNull
        public final File component3() {
            return this.librarySymbolsFile;
        }

        @NotNull
        public final ParseResourcesParams copy(@NotNull File inputResDir, @NotNull File platformAttrsRTxt, @NotNull File librarySymbolsFile) {
            Intrinsics.checkParameterIsNotNull((Object)inputResDir, (String)"inputResDir");
            Intrinsics.checkParameterIsNotNull((Object)platformAttrsRTxt, (String)"platformAttrsRTxt");
            Intrinsics.checkParameterIsNotNull((Object)librarySymbolsFile, (String)"librarySymbolsFile");
            return new ParseResourcesParams(inputResDir, platformAttrsRTxt, librarySymbolsFile);
        }

        @NotNull
        public static /* synthetic */ ParseResourcesParams copy$default(ParseResourcesParams parseResourcesParams, File file, File file2, File file3, int n, Object object) {
            if ((n & 1) != 0) {
                file = parseResourcesParams.inputResDir;
            }
            if ((n & 2) != 0) {
                file2 = parseResourcesParams.platformAttrsRTxt;
            }
            if ((n & 4) != 0) {
                file3 = parseResourcesParams.librarySymbolsFile;
            }
            return parseResourcesParams.copy(file, file2, file3);
        }

        @NotNull
        public String toString() {
            return "ParseResourcesParams(inputResDir=" + this.inputResDir + ", platformAttrsRTxt=" + this.platformAttrsRTxt + ", librarySymbolsFile=" + this.librarySymbolsFile + ")";
        }

        public int hashCode() {
            File file = this.inputResDir;
            File file2 = this.platformAttrsRTxt;
            File file3 = this.librarySymbolsFile;
            return ((file != null ? ((Object)file).hashCode() : 0) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ParseResourcesParams)) break block3;
                    ParseResourcesParams parseResourcesParams = (ParseResourcesParams)object;
                    if (!Intrinsics.areEqual((Object)this.inputResDir, (Object)parseResourcesParams.inputResDir) || !Intrinsics.areEqual((Object)this.platformAttrsRTxt, (Object)parseResourcesParams.platformAttrsRTxt) || !Intrinsics.areEqual((Object)this.librarySymbolsFile, (Object)parseResourcesParams.librarySymbolsFile)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006H\u0002J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/res/ParseLibraryResourcesTask$ParseResourcesRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/res/ParseLibraryResourcesTask$ParseResourcesParams;", "(Lcom/android/build/gradle/internal/res/ParseLibraryResourcesTask$ParseResourcesParams;)V", "getAndroidAttrSymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "kotlin.jvm.PlatformType", "run", "", "gradle"})
    public static final class ParseResourcesRunnable
    implements Runnable {
        private final ParseResourcesParams params;

        @Override
        public void run() {
            SymbolTable symbolTable = ResourceDirectoryParser.parseResourceSourceSetDirectory((File)this.params.getInputResDir(), (IdProvider)IdProvider.Companion.constant(), (SymbolTable)this.getAndroidAttrSymbols(), (String)"local");
            SymbolIo.writeRDef((SymbolTable)symbolTable, (Path)this.params.getLibrarySymbolsFile().toPath());
        }

        private final SymbolTable getAndroidAttrSymbols() {
            return this.params.getPlatformAttrsRTxt().exists() ? SymbolIo.readFromAapt((File)this.params.getPlatformAttrsRTxt(), (String)"android") : SymbolTable.Companion.builder().tablePackage("android").build();
        }

        @Inject
        public ParseResourcesRunnable(@NotNull ParseResourcesParams params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\tH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/res/ParseLibraryResourcesTask$CreateAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/res/ParseLibraryResourcesTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "librarySymbolsFile", "Ljava/io/File;", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "preConfigure", "taskName", "gradle"})
    public static final class CreateAction
    extends VariantTaskCreationAction<ParseLibraryResourcesTask> {
        private File librarySymbolsFile;

        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("parse", "LibraryResources");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName\u2026rse\", \"LibraryResources\")");
            return string;
        }

        @Override
        @NotNull
        public Class<ParseLibraryResourcesTask> getType() {
            return ParseLibraryResourcesTask.class;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            super.preConfigure(taskName);
            this.librarySymbolsFile = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.LOCAL_ONLY_SYMBOL_LIST, taskName, "R-def.txt");
        }

        @Override
        public void configure(@NotNull ParseLibraryResourcesTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            FileCollection fileCollection = globalScope.getPlatformAttrs();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"variantScope.globalScope.platformAttrs");
            task.platformAttrRTxt = fileCollection;
            task.inputResourcesDir = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.PACKAGED_RES);
            File file = this.librarySymbolsFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"librarySymbolsFile");
            }
            task.librarySymbolsFile = file;
        }

        public CreateAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
        }
    }
}

