/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.coverage.JacocoConfigurations;
import com.android.build.gradle.internal.scope.AnchorOutputType;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.JacocoTaskDelegate;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.builder.dexing.DexerTool;
import com.android.ide.common.workers.WorkerExecutorFacade;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public class JacocoTask
extends AndroidVariantTask {
    private final WorkerExecutorFacade workers;
    private FileCollection jacocoAntTaskConfiguration;
    private BuildableArtifact inputClasses;
    private File output;
    private JacocoTaskDelegate delegate;

    @Inject
    public JacocoTask(WorkerExecutor workers) {
        this.workers = Workers.INSTANCE.preferWorkers(this.getProject().getName(), this.getPath(), workers);
    }

    @InputFiles
    public FileCollection getJacocoAntTaskConfiguration() {
        return this.jacocoAntTaskConfiguration;
    }

    @InputFiles
    public BuildableArtifact getInputClasses() {
        return this.inputClasses;
    }

    @OutputDirectory
    public File getOutput() {
        return this.output;
    }

    public static String getJacocoVersion(VariantScope scope) {
        if (scope.getDexer() == DexerTool.DX) {
            return "0.7.4.201502262128";
        }
        return scope.getGlobalScope().getExtension().getJacoco().getVersion();
    }

    @TaskAction
    public void run(IncrementalTaskInputs inputs) throws IOException {
        try {
            this.delegate.run(this.workers, inputs);
        }
        finally {
            this.workers.close();
        }
    }

    public static class CreationAction
    extends VariantTaskCreationAction<JacocoTask> {
        private File output;

        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("jacoco");
        }

        @Override
        public Class<JacocoTask> getType() {
            return JacocoTask.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.output = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.JACOCO_INSTRUMENTED_CLASSES, taskName, "out");
        }

        @Override
        public void configure(JacocoTask task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.inputClasses = scope.getArtifacts().getFinalArtifactFiles(AnchorOutputType.ALL_CLASSES);
            task.jacocoAntTaskConfiguration = (FileCollection)JacocoConfigurations.getJacocoAntTaskConfiguration(scope.getGlobalScope().getProject(), JacocoTask.getJacocoVersion(scope));
            task.output = this.output;
            task.delegate = new JacocoTaskDelegate(task.jacocoAntTaskConfiguration, task.output, task.inputClasses);
        }
    }
}

