/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.cxx.configure.AbiConfigurator;
import com.android.build.gradle.internal.cxx.configure.CmakeLocatorKt;
import com.android.build.gradle.internal.cxx.configure.GradleLocalPropertiesKt;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationAbiConfiguration;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationAbiConfigurationKt;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationInvalidationState;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationVariantConfiguration;
import com.android.build.gradle.internal.cxx.configure.NativeBuildSystemVariantConfig;
import com.android.build.gradle.internal.cxx.configure.NativeBuildSystemVariantConfigurationKt;
import com.android.build.gradle.internal.cxx.configure.NdkSymlinkerKt;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.GradleSyncLoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.model.CoreExternalNativeBuild;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.build.gradle.internal.ndk.NdkPlatform;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.CmakeExternalNativeJsonGeneratorFactory;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.build.gradle.tasks.NdkBuildExternalNativeJsonGenerator;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.ApiVersion;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;

public abstract class ExternalNativeJsonGenerator {
    final JsonGenerationVariantConfiguration config;
    final Set<String> configurationFailures;
    protected final AndroidBuilder androidBuilder;
    protected final GradleBuildVariant.Builder stats;

    ExternalNativeJsonGenerator(JsonGenerationVariantConfiguration config2, Set<String> configurationFailures, AndroidBuilder androidBuilder, GradleBuildVariant.Builder stats) {
        this.config = config2;
        this.configurationFailures = configurationFailures;
        this.androidBuilder = androidBuilder;
        this.stats = stats;
        if (!this.getNdkFolder().isDirectory()) {
            LoggingEnvironmentKt.error("NDK not configured (%s).\nDownload the NDK from http://developer.android.com/tools/sdk/ndk/.Then add ndk.dir=path/to/ndk in local.properties.\n(On Windows, make sure you escape backslashes, e.g. C:\\\\ndk rather than C:\\ndk)", this.getNdkFolder());
        }
    }

    protected static boolean isWindows() {
        return SdkConstants.CURRENT_PLATFORM == 2;
    }

    private List<File> getDependentBuildFiles(File json) throws IOException {
        ArrayList result = Lists.newArrayList();
        if (!json.exists()) {
            return result;
        }
        NativeBuildConfigValueMini config2 = AndroidBuildGradleJsons.getNativeBuildMiniConfig(json, this.stats);
        return config2.buildFiles;
    }

    public void build() throws IOException, ProcessException {
        this.buildAndPropagateException(false);
    }

    public void build(boolean forceJsonGeneration) {
        try {
            LoggingEnvironmentKt.info("building json with force flag %s", forceJsonGeneration);
            this.buildAndPropagateException(forceJsonGeneration);
        }
        catch (IOException | GradleException e) {
            LoggingEnvironmentKt.error("exception while building Json $%s", e.getMessage());
        }
        catch (ProcessException e) {
            LoggingEnvironmentKt.error("executing external native build for %s %s", this.getNativeBuildSystem().getTag(), this.config.makefile);
        }
    }

    public List<Callable<Void>> parallelBuild(boolean forceJsonGeneration) {
        ArrayList<Callable<Void>> buildSteps = new ArrayList<Callable<Void>>(this.config.abiConfigurations.size());
        for (JsonGenerationAbiConfiguration configuration : this.config.abiConfigurations) {
            buildSteps.add(() -> this.buildForOneConfigurationConvertExceptions(forceJsonGeneration, configuration));
        }
        return buildSteps;
    }

    private Void buildForOneConfigurationConvertExceptions(boolean forceJsonGeneration, JsonGenerationAbiConfiguration configuration) {
        try (GradleSyncLoggingEnvironment ignore = new GradleSyncLoggingEnvironment(this.getVariantName(), configuration.getAbiName(), this.configurationFailures, this.androidBuilder.getIssueReporter(), this.androidBuilder.getLogger());){
            try {
                this.buildForOneConfiguration(forceJsonGeneration, configuration);
            }
            catch (IOException | GradleException e) {
                LoggingEnvironmentKt.error("exception while building Json %s", e.getMessage());
            }
            catch (ProcessException e) {
                LoggingEnvironmentKt.error("executing external native build for %s %s", this.getNativeBuildSystem().getTag(), this.config.makefile);
            }
            Void void_ = null;
            return void_;
        }
    }

    private static String getPreviousBuildCommand(File commandFile) throws IOException {
        if (!commandFile.exists()) {
            return "";
        }
        return new String(Files.readAllBytes(commandFile.toPath()), Charsets.UTF_8);
    }

    private void buildAndPropagateException(boolean forceJsonGeneration) throws IOException, ProcessException {
        Throwable firstException = null;
        for (JsonGenerationAbiConfiguration configuration : this.config.abiConfigurations) {
            try {
                this.buildForOneConfiguration(forceJsonGeneration, configuration);
            }
            catch (ProcessException | IOException | GradleException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            if (firstException instanceof GradleException) {
                throw (GradleException)firstException;
            }
            if (firstException instanceof IOException) {
                throw (IOException)firstException;
            }
            throw (ProcessException)firstException;
        }
    }

    public void buildForOneAbiName(boolean forceJsonGeneration, String abiName) {
        int built = 0;
        for (JsonGenerationAbiConfiguration configuration : this.config.abiConfigurations) {
            if (!configuration.getAbi().getTag().equals(abiName)) continue;
            ++built;
            this.buildForOneConfigurationConvertExceptions(forceJsonGeneration, configuration);
        }
        assert (built == 1);
    }

    private void checkForConfigurationErrors() {
        if (!this.configurationFailures.isEmpty()) {
            throw new GradleException(Joiner.on((String)"\r\n").join(this.configurationFailures));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildForOneConfiguration(boolean forceJsonGeneration, JsonGenerationAbiConfiguration configuration) throws GradleException, IOException, ProcessException {
        this.checkForConfigurationErrors();
        GradleBuildVariant.NativeBuildConfigInfo.Builder variantStats = GradleBuildVariant.NativeBuildConfigInfo.newBuilder();
        variantStats.setAbi(AnalyticsUtil.getAbi(configuration.getAbiName()));
        variantStats.setDebuggable(this.config.debuggable);
        long startTime = System.currentTimeMillis();
        variantStats.setGenerationStartMs(startTime);
        try {
            LoggingEnvironmentKt.info("Start JSON generation. Platform version: %s min SDK version: %s", configuration.getAbiPlatformVersion(), configuration.getAbiName(), configuration.getAbiPlatformVersion());
            ProcessInfoBuilder processBuilder = this.getProcessBuilder(configuration);
            String currentBuildCommand = processBuilder.toString();
            JsonGenerationInvalidationState invalidationState = new JsonGenerationInvalidationState(forceJsonGeneration, configuration.getJsonFile(), configuration.getBuildCommandFile(), currentBuildCommand, ExternalNativeJsonGenerator.getPreviousBuildCommand(configuration.getBuildCommandFile()), this.getDependentBuildFiles(configuration.getJsonFile()));
            if (invalidationState.getRebuild()) {
                LoggingEnvironmentKt.info("rebuilding JSON %s due to:", configuration.getJsonFile());
                for (String reason : invalidationState.getRebuildReasons()) {
                    LoggingEnvironmentKt.info(reason, new Object[0]);
                }
                if (this.config.jsonFolder.exists()) {
                    if (invalidationState.getSoftRegeneration()) {
                        LoggingEnvironmentKt.info("keeping json folder '%s' but regenerating project", configuration.getExternalNativeBuildFolder());
                    } else {
                        LoggingEnvironmentKt.info("removing stale contents from '%s'", configuration.getExternalNativeBuildFolder());
                        FileUtils.deletePath((File)configuration.getExternalNativeBuildFolder());
                    }
                }
                if (configuration.getExternalNativeBuildFolder().mkdirs()) {
                    LoggingEnvironmentKt.info("created folder '%s'", configuration.getExternalNativeBuildFolder());
                }
                LoggingEnvironmentKt.info("executing %s %s", this.getNativeBuildSystem().getTag(), processBuilder);
                String buildOutput = this.executeProcess(configuration);
                LoggingEnvironmentKt.info("done executing %s", this.getNativeBuildSystem().getTag());
                LoggingEnvironmentKt.info("write build output %s", configuration.getBuildOutputFile().getAbsolutePath());
                Files.write(configuration.getBuildOutputFile().toPath(), buildOutput.getBytes(Charsets.UTF_8), new OpenOption[0]);
                this.processBuildOutput(buildOutput, configuration);
                if (!configuration.getJsonFile().exists()) {
                    throw new GradleException(String.format("Expected json generation to create '%s' but it didn't", configuration.getJsonFile()));
                }
                GradleBuildVariant.Builder builder = this.stats;
                synchronized (builder) {
                    ExternalNativeJsonGenerator.removeUnexpectedSoFiles(configuration.getObjFolder(), AndroidBuildGradleJsons.getNativeBuildMiniConfig(configuration.getJsonFile(), this.stats));
                }
                LoggingEnvironmentKt.info("write command file %s", configuration.getBuildCommandFile().getAbsolutePath());
                Files.write(configuration.getBuildCommandFile().toPath(), currentBuildCommand.getBytes(Charsets.UTF_8), new OpenOption[0]);
                variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.SUCCESS_BUILT);
            } else {
                LoggingEnvironmentKt.info("JSON '%s' was up-to-date", configuration.getJsonFile());
                variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.SUCCESS_UP_TO_DATE);
            }
            LoggingEnvironmentKt.info("JSON generation completed without problems", new Object[0]);
        }
        catch (ProcessException | IOException | GradleException e) {
            variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.FAILED);
            LoggingEnvironmentKt.info("JSON generation completed with problem. Exception: " + e.toString(), new Object[0]);
            throw e;
        }
        finally {
            variantStats.setGenerationDurationMs(System.currentTimeMillis() - startTime);
            GradleBuildVariant.Builder builder = this.stats;
            synchronized (builder) {
                this.stats.addNativeBuildConfig(variantStats);
            }
        }
    }

    private static void removeUnexpectedSoFiles(File expectedOutputFolder, NativeBuildConfigValueMini config2) throws IOException {
        if (!expectedOutputFolder.isDirectory()) {
            return;
        }
        ArrayList expectedSoFiles = Lists.newArrayList();
        for (NativeLibraryValueMini library : config2.libraries.values()) {
            assert (library.output != null);
            expectedSoFiles.add(library.output.toPath());
        }
        try (Stream<Path> paths = Files.walk(expectedOutputFolder.toPath(), new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".so")).filter(path -> !expectedSoFiles.contains(path)).forEach(path -> {
                if (path.toFile().delete()) {
                    LoggingEnvironmentKt.info("deleted unexpected build output %s in incremental regenerate", path);
                }
            });
        }
    }

    abstract void processBuildOutput(String var1, JsonGenerationAbiConfiguration var2) throws IOException;

    abstract ProcessInfoBuilder getProcessBuilder(JsonGenerationAbiConfiguration var1);

    abstract String executeProcess(JsonGenerationAbiConfiguration var1) throws ProcessException, IOException;

    public abstract NativeBuildSystem getNativeBuildSystem();

    abstract Map<Abi, File> getStlSharedObjectFiles();

    public String getVariantName() {
        return this.config.variantName;
    }

    public static ExternalNativeJsonGenerator create(File rootBuildGradlePath, String projectPath2, File projectDir2, File buildDir2, File externalNativeBuildDir, NativeBuildSystem buildSystem, File makefile, AndroidBuilder androidBuilder, VariantScope scope) {
        HashSet<String> configurationFailures = new HashSet<String>();
        try (GradleSyncLoggingEnvironment ignore = new GradleSyncLoggingEnvironment(scope.getFullVariantName(), "native", configurationFailures, androidBuilder.getIssueReporter(), androidBuilder.getLogger());){
            ExternalNativeJsonGenerator externalNativeJsonGenerator = ExternalNativeJsonGenerator.createImpl(configurationFailures, rootBuildGradlePath, projectPath2, projectDir2, buildDir2, externalNativeBuildDir, buildSystem, makefile, androidBuilder, scope);
            return externalNativeJsonGenerator;
        }
    }

    public static ExternalNativeJsonGenerator createImpl(Set<String> configurationFailures, File rootBuildGradlePath, String projectPath2, File projectDir2, File buildDir2, File externalNativeBuildDir, NativeBuildSystem buildSystem, File makefile, AndroidBuilder androidBuilder, VariantScope scope) {
        GlobalScope globalScope = scope.getGlobalScope();
        Preconditions.checkNotNull((Object)globalScope.getSdkComponents().getSdkFolder(), (Object)"No Android SDK folder found");
        NdkHandler ndkHandler = globalScope.getSdkComponents().getNdkHandlerSupplier().get();
        if (!ndkHandler.getNdkPlatform().isConfigured()) {
            globalScope.getSdkComponents().installNdk(ndkHandler);
            if (!ndkHandler.getNdkPlatform().isConfigured()) {
                throw new InvalidUserDataException("NDK not configured. Download it with SDK manager.");
            }
        }
        NdkPlatform ndkPlatform = ndkHandler.getNdkPlatform();
        Revision ndkRevision = ndkPlatform.getRevision();
        File ndkFolder = ndkPlatform.getNdkDirectory();
        NdkInfo ndkInfo2 = ndkPlatform.getNdkInfo();
        BaseVariantData variantData = scope.getVariantData();
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        GradleBuildVariant.Builder stats = ProcessProfileWriter.getOrCreateVariant((String)projectPath2, (String)scope.getFullVariantName());
        File intermediates = FileUtils.join((File)globalScope.getIntermediatesDir(), (String[])new String[]{buildSystem.getTag(), variantData.getVariantConfiguration().getDirName()});
        File soFolder = new File(intermediates, "lib");
        File externalNativeBuildFolder = ExternalNativeJsonGenerator.findExternalNativeBuildFolder(projectDir2, buildSystem, variantData.getName(), buildDir2, externalNativeBuildDir);
        File objFolder = new File(intermediates, "obj");
        ApiVersion minSdkVersion = variantData.getVariantConfiguration().getMergedFlavor().getMinSdkVersion();
        NativeBuildSystemVariantConfig nativeBuildVariantConfig = NativeBuildSystemVariantConfigurationKt.createNativeBuildSystemVariantConfig(buildSystem, variantData.getVariantConfiguration());
        Splits splits = globalScope.getExtension().getSplits();
        if (globalScope.getExtension().getGeneratePureSplits() && splits.getAbi().isUniversalApk()) {
            LoggingEnvironmentKt.warn("ABI based configuration splits and universal APK cannot be both set, universal APK will not be build.", new Object[0]);
        }
        ProjectOptions projectOptions = globalScope.getProjectOptions();
        AbiConfigurator abiConfigurator = new AbiConfigurator(ndkPlatform.getSupportedAbis(), ndkPlatform.getDefaultAbis(), nativeBuildVariantConfig.externalNativeBuildAbiFilters, nativeBuildVariantConfig.ndkAbiFilters, splits.getAbiFilters(), projectOptions.get(BooleanOption.BUILD_ONLY_TARGET_ABI), projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI));
        Collection<Abi> validAbis = abiConfigurator.getValidAbis();
        List<File> expectedJsons = ExternalNativeBuildTaskUtils.getOutputJsons(externalNativeBuildFolder, abiConfigurator.getAllAbis());
        if (buildSystem == NativeBuildSystem.NDK_BUILD) {
            objFolder = new File(objFolder, "local");
        }
        ArrayList abiConfigurations = Lists.newArrayList();
        for (Abi abi : validAbis) {
            AndroidVersion version = minSdkVersion == null ? null : new AndroidVersion(minSdkVersion.getApiLevel(), minSdkVersion.getCodename());
            abiConfigurations.add(JsonGenerationAbiConfigurationKt.createJsonGenerationAbiConfiguration(abi, variantData.getName(), externalNativeBuildFolder.getParentFile().getParentFile(), objFolder, buildSystem, ndkInfo2.findSuitablePlatformVersion(abi.getTag(), version)));
        }
        File defaultProjectCacheFolder = new File(rootBuildGradlePath, ".cxx");
        Properties localProperties2 = GradleLocalPropertiesKt.gradleLocalProperties(rootBuildGradlePath);
        String userSpecifiedCxxCacheFolder = localProperties2.getProperty("cxx.cache.dir");
        File cacheFolder = userSpecifiedCxxCacheFolder != null ? new File(userSpecifiedCxxCacheFolder) : defaultProjectCacheFolder;
        JsonGenerationVariantConfiguration config2 = new JsonGenerationVariantConfiguration(rootBuildGradlePath, nativeBuildVariantConfig, variantData.getName(), makefile, globalScope.getSdkComponents().getSdkFolder(), NdkSymlinkerKt.trySymlinkNdk(ndkFolder, externalNativeBuildFolder, globalScope.getSdkComponents().getNdkSymlinkDirInLocalProp()), soFolder, objFolder, externalNativeBuildFolder, ((CoreBuildType)variantConfig.getBuildType()).isDebuggable(), abiConfigurations, ndkRevision, expectedJsons, cacheFolder, globalScope.getProjectOptions().get(BooleanOption.ENABLE_NATIVE_COMPILER_SETTINGS_CACHE));
        switch (buildSystem) {
            case NDK_BUILD: {
                return new NdkBuildExternalNativeJsonGenerator(config2, configurationFailures, androidBuilder, projectDir2, stats);
            }
            case CMAKE: {
                return ExternalNativeJsonGenerator.createCmakeExternalNativeJsonGenerator(config2, configurationFailures, globalScope, androidBuilder, stats);
            }
        }
        throw new IllegalArgumentException("Unknown ExternalNativeJsonGenerator type");
    }

    private static ExternalNativeJsonGenerator createCmakeExternalNativeJsonGenerator(JsonGenerationVariantConfiguration config2, Set<String> configurationFailures, GlobalScope globalScope, AndroidBuilder androidBuilder, GradleBuildVariant.Builder stats) {
        Revision cmakeVersion2;
        CoreExternalNativeBuild externalNativeBuild = globalScope.getExtension().getExternalNativeBuild();
        File cmakeFolder = globalScope.getProjectOptions().get(BooleanOption.ENABLE_SIDE_BY_SIDE_CMAKE) ? CmakeLocatorKt.findCmakePath(externalNativeBuild.getCmake().getVersion(), globalScope.getSdkComponents().getCMakeExecutable(), globalScope.getSdkComponents().getSdkFolder(), version -> globalScope.getSdkComponents().installCmake((String)version), androidBuilder.getLogger()) : ExternalNativeBuildTaskUtils.findCmakeExecutableFolder(Objects.requireNonNull(externalNativeBuild.getCmake().getVersion()), globalScope.getSdkComponents().getCMakeExecutable(), globalScope.getSdkComponents().getSdkFolder(), version -> globalScope.getSdkComponents().installCmake((String)version));
        try {
            cmakeVersion2 = CmakeUtils.getVersion(new File(cmakeFolder, "bin"));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get the CMake version located at: " + new File(cmakeFolder, "bin").getAbsolutePath());
        }
        return CmakeExternalNativeJsonGeneratorFactory.createCmakeStrategy(config2, configurationFailures, cmakeVersion2, androidBuilder, Objects.requireNonNull(cmakeFolder), stats);
    }

    private static File findExternalNativeBuildFolder(File projectDir2, NativeBuildSystem buildSystem, String variantName, File buildDir2, File externalNativeBuildDir) {
        if (externalNativeBuildDir == null) {
            return FileUtils.join((File)projectDir2, (String[])new String[]{".cxx", buildSystem.getTag(), variantName});
        }
        File externalNativeBuildPath = FileUtils.join((File)externalNativeBuildDir, (String[])new String[]{buildSystem.getTag(), variantName});
        if (FileUtils.isFileInDirectory((File)externalNativeBuildPath, (File)buildDir2)) {
            File invalidPath = externalNativeBuildPath;
            externalNativeBuildPath = FileUtils.join((File)projectDir2, (String[])new String[]{".cxx", buildSystem.getTag(), variantName});
            LoggingEnvironmentKt.error("The build staging directory you specified ('%s') is a subdirectory of your project's temporary build directory ('%s').Files in this directory do not persist through clean builds.\nEither use the default build staging directory ('%s'),or specify a path outside the temporary build directory.", invalidPath.getAbsolutePath(), buildDir2.getAbsolutePath(), externalNativeBuildPath.getAbsolutePath());
        }
        return externalNativeBuildPath;
    }

    public void forEachNativeBuildConfiguration(Consumer<JsonReader> callback) throws IOException {
        try (GradleSyncLoggingEnvironment ignore = new GradleSyncLoggingEnvironment(this.getVariantName(), "native", this.configurationFailures, this.androidBuilder.getIssueReporter(), this.androidBuilder.getLogger());){
            List<File> files2 = this.getNativeBuildConfigurationsJsons();
            LoggingEnvironmentKt.info("streaming %s JSON files", files2.size());
            for (File file : this.getNativeBuildConfigurationsJsons()) {
                if (file.exists()) {
                    LoggingEnvironmentKt.info("string JSON file %s", file.getAbsolutePath());
                    try {
                        JsonReader reader = new JsonReader((Reader)new FileReader(file));
                        Throwable throwable = null;
                        try {
                            callback.accept(reader);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            reader.close();
                            continue;
                        }
                    }
                    catch (Throwable e) {
                        LoggingEnvironmentKt.info("Error parsing: %s", String.join((CharSequence)"\r\n", Files.readAllLines(file.toPath())));
                        throw e;
                    }
                }
                LoggingEnvironmentKt.info("streaming fallback JSON for %s", file.getAbsolutePath());
                NativeBuildConfigValueMini fallback = new NativeBuildConfigValueMini();
                fallback.buildFiles = Lists.newArrayList((Object[])new File[]{this.config.makefile});
                JsonReader reader = new JsonReader((Reader)new StringReader(new Gson().toJson((Object)fallback)));
                Throwable throwable = null;
                try {
                    callback.accept(reader);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
    }

    public JsonGenerationVariantConfiguration getConfig() {
        return this.config;
    }

    @InputFile
    public File getMakefile() {
        return this.config.makefile;
    }

    @Input
    public File getObjFolder() {
        return this.config.objFolder;
    }

    public File getJsonFolder() {
        return this.config.jsonFolder;
    }

    @Input
    public File getNdkFolder() {
        return this.config.ndkFolder;
    }

    @Input
    public boolean isDebuggable() {
        return this.config.debuggable;
    }

    @Optional
    @Input
    public List<String> getBuildArguments() {
        return this.config.buildSystem.arguments;
    }

    @Optional
    @Input
    public List<String> getcFlags() {
        return this.config.buildSystem.cFlags;
    }

    @Optional
    @Input
    public List<String> getCppFlags() {
        return this.config.buildSystem.cppFlags;
    }

    @OutputFiles
    public List<File> getNativeBuildConfigurationsJsons() {
        return this.config.generatedJsonFiles;
    }

    @Input
    public File getSoFolder() {
        return this.config.soFolder;
    }

    @Input
    public File getSdkFolder() {
        return this.config.sdkFolder;
    }

    @Input
    public Collection<Abi> getAbis() {
        ArrayList result = Lists.newArrayList();
        for (JsonGenerationAbiConfiguration configuration : this.config.abiConfigurations) {
            result.add(configuration.getAbi());
        }
        return result;
    }
}

