/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.cxx.configure.GradleLocalPropertiesKt;
import com.android.build.gradle.internal.cxx.configure.Location;
import com.android.build.gradle.internal.cxx.configure.LocationType;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorKt;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorRecord;
import com.android.build.gradle.internal.cxx.configure.SdkSourceProperties;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.repository.Revision;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001ab\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000b2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000bH\u0002\u001a`\u0010\u000f\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u00052\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000b2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000bH\u0007\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0005H\u0007\u001a\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0007\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a8\u0006\u0019"}, d2={"findNdkPath", "Lcom/android/build/gradle/internal/cxx/configure/NdkLocatorRecord;", "ndkVersionFromDsl", "", "projectDir", "Ljava/io/File;", "findNdkPathImpl", "ndkDirProperty", "androidNdkHomeEnvironmentVariable", "sdkFolder", "getNdkVersionedFolderNames", "Lkotlin/Function1;", "", "getNdkSourceProperties", "Lcom/android/build/gradle/internal/cxx/configure/SdkSourceProperties;", "findNdkPathWithRecord", "getNdkVersionInfo", "ndkRoot", "getNdkVersionedFolders", "ndkVersionRoot", "isAcceptableNdkVersion", "", "sourcePropertiesRevision", "Lcom/android/repository/Revision;", "revisionFromDsl", "gradle"})
public final class NdkLocatorKt {
    /*
     * WARNING - void declaration
     */
    private static final File findNdkPathImpl(String ndkDirProperty, String androidNdkHomeEnvironmentVariable, File sdkFolder2, String ndkVersionFromDsl, Function1<? super File, ? extends List<String>> getNdkVersionedFolderNames, Function1<? super File, SdkSourceProperties> getNdkSourceProperties) {
        Iterable $receiver$iv;
        Object foundNdkRoot;
        SdkSourceProperties version;
        kotlin.Pair ndkDirLocation;
        kotlin.Pair $location_$_$;
        void $receiver$iv$iv;
        void $receiver$iv2;
        Object location;
        Object element$iv2;
        Object object;
        Location location2;
        Collection collection;
        StringBuilder stringBuilder = new StringBuilder().append("android.ndkVersion from module build.gradle is ");
        String string = ndkVersionFromDsl;
        if (string == null) {
            string = "not set";
        }
        LoggingEnvironmentKt.info(stringBuilder.append(string).toString(), new Object[0]);
        StringBuilder stringBuilder2 = new StringBuilder().append("ndk.dir in local.properties is ");
        String string2 = ndkDirProperty;
        if (string2 == null) {
            string2 = "not set";
        }
        LoggingEnvironmentKt.info(stringBuilder2.append(string2).toString(), new Object[0]);
        StringBuilder stringBuilder3 = new StringBuilder().append("ANDROID_NDK_HOME environment variable is ");
        String string3 = androidNdkHomeEnvironmentVariable;
        if (string3 == null) {
            string3 = "not set";
        }
        LoggingEnvironmentKt.info(stringBuilder3.append((Object)string3).toString(), new Object[0]);
        StringBuilder stringBuilder4 = new StringBuilder().append("sdkFolder is ");
        Object object2 = sdkFolder2;
        if (object2 == null) {
            object2 = "not set";
        }
        LoggingEnvironmentKt.info(stringBuilder4.append(object2).toString(), new Object[0]);
        findNdkPathImpl.1 considerAndReject$ = findNdkPathImpl.1.INSTANCE;
        List foundLocations = new ArrayList();
        if (ndkDirProperty != null) {
            collection = foundLocations;
            location2 = new Location(LocationType.NDK_DIR_LOCATION, new File(ndkDirProperty));
            collection.add(location2);
        }
        if (androidNdkHomeEnvironmentVariable != null) {
            collection = foundLocations;
            location2 = new Location(LocationType.ANDROID_NDK_HOME_LOCATION, new File(androidNdkHomeEnvironmentVariable));
            collection.add(location2);
        }
        if (sdkFolder2 != null) {
            collection = foundLocations;
            location2 = new Location(LocationType.NDK_BUNDLE_FOLDER_LOCATION, new File(sdkFolder2, "ndk-bundle"));
            collection.add(location2);
        }
        Revision ndkVersionFromDslRevision = null;
        if (ndkVersionFromDsl != null) {
            try {
                ndkVersionFromDslRevision = Revision.parseRevision((String)ndkVersionFromDsl);
            }
            catch (NumberFormatException e) {
                LoggingEnvironmentKt.error("Requested NDK version '" + ndkVersionFromDsl + "' could not be parsed", new Object[0]);
            }
        }
        if (sdkFolder2 != null) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv3;
            File versionRoot = new File(sdkFolder2, "ndk");
            object = foundLocations;
            Iterable iterable = (Iterable)getNdkVersionedFolderNames.invoke((Object)versionRoot);
            void var12_13 = $receiver$iv3;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void version2;
                String string4 = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Location location3 = new Location(LocationType.NDK_VERSIONED_FOLDER_LOCATION, new File(versionRoot, (String)version2));
                collection2.add(location3);
            }
            $receiver$iv3 = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)object, (Iterable)$receiver$iv3);
        }
        Iterable $receiver$iv4 = foundLocations;
        for (Object element$iv2 : $receiver$iv4) {
            location = (Location)element$iv2;
            boolean bl = false;
            LoggingEnvironmentKt.info("Considering " + ((Location)location).getNdkRoot() + ' ' + ((Location)location).getType().getTag(), new Object[0]);
        }
        object = foundLocations;
        element$iv2 = $receiver$iv2;
        Object destination$iv$iv = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator<Object> $i$f$forEach = $receiver$iv$iv$iv.iterator();
        while ($i$f$forEach.hasNext()) {
            kotlin.Pair pair;
            kotlin.Pair pair2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = $i$f$forEach.next();
            Location location4 = (Location)element$iv$iv;
            boolean bl = false;
            SdkSourceProperties versionInfo = (SdkSourceProperties)getNdkSourceProperties.invoke((Object)location4.getNdkRoot());
            if (versionInfo == null) {
                findNdkPathImpl.1.INSTANCE.invoke(location4, "that location didn't exist");
                pair2 = null;
            } else if (versionInfo.getValue(SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION) == null) {
                findNdkPathImpl.1.INSTANCE.invoke(location4, "that location had source.properties " + "with no " + SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION.getKey());
                pair2 = null;
            } else {
                kotlin.Pair pair3;
                String revision2;
                if (versionInfo.getValue(SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION) == null) {
                    Intrinsics.throwNpe();
                }
                try {
                    Revision.parseRevision((String)revision2);
                    pair3 = new kotlin.Pair((Object)location4, (Object)versionInfo);
                }
                catch (NumberFormatException e) {
                    findNdkPathImpl.1.INSTANCE.invoke(location4, "that location had " + "source.properties with invalid " + SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION.getKey() + '=' + revision2);
                    pair3 = null;
                }
                pair2 = pair3;
            }
            if (pair2 == null) continue;
            kotlin.Pair it$iv$iv = pair = pair2;
            destination$iv$iv.add(it$iv$iv);
        }
        List versionedLocations2 = CollectionsKt.asReversed((List)CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{findNdkPathImpl.versionedLocations.2.INSTANCE, findNdkPathImpl.versionedLocations.3.INSTANCE})));
        kotlin.Pair highest = (kotlin.Pair)CollectionsKt.firstOrNull((List)versionedLocations2);
        if (highest == null) {
            if (ndkVersionFromDslRevision == null) {
                LoggingEnvironmentKt.warn("Compatible side by side NDK version was not found.", new Object[0]);
            } else {
                LoggingEnvironmentKt.warn("Compatible side by side NDK version was not found for android.ndkVersion " + '\'' + ndkVersionFromDslRevision + '\'', new Object[0]);
            }
            return null;
        }
        if (ndkVersionFromDslRevision != null) {
            Location location5;
            Iterable $receiver$iv$iv3;
            Iterable $receiver$iv5;
            if (ndkDirProperty != null) {
                Iterator iterator;
                block41: {
                    destination$iv$iv = versionedLocations2;
                    $receiver$iv$iv$iv = destination$iv$iv;
                    for (Iterator iterator2 : $receiver$iv$iv$iv) {
                        $location_$_$ = (kotlin.Pair)iterator2;
                        boolean bl = false;
                        Location location6 = (Location)$location_$_$.component1();
                        if (!(location6.getType() == LocationType.NDK_DIR_LOCATION)) continue;
                        iterator = iterator2;
                        break block41;
                    }
                    iterator = null;
                }
                ndkDirLocation = (kotlin.Pair)iterator;
                if (ndkDirLocation == null) {
                    LoggingEnvironmentKt.error("Location specified by ndk.dir (" + ndkDirProperty + ") did not contain a " + "valid NDK and so couldn't satisfy the requested NDK version " + ndkVersionFromDsl, new Object[0]);
                } else {
                    $i$f$forEach = ndkDirLocation;
                    destination$iv$iv = (Location)$i$f$forEach.component1();
                    version = (SdkSourceProperties)$i$f$forEach.component2();
                    if (NdkLocatorKt.isAcceptableNdkVersion(version.getRevision(), ndkVersionFromDslRevision)) {
                        LoggingEnvironmentKt.info("Choosing " + ((Location)location).getNdkRoot() + " from ndk.dir which had the requested " + "version " + ndkVersionFromDsl, new Object[0]);
                    } else {
                        LoggingEnvironmentKt.error("Requested NDK version " + ndkVersionFromDsl + " did not match the version " + version.getRevision() + " requested by ndk.dir at " + ((Location)location).getNdkRoot(), new Object[0]);
                    }
                    return ((Location)location).getNdkRoot();
                }
            }
            location = versionedLocations2;
            version = $receiver$iv5;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv3) {
                kotlin.Pair $$_$_sourceProperties = (kotlin.Pair)element$iv$iv;
                boolean bl = false;
                SdkSourceProperties sourceProperties = (SdkSourceProperties)$$_$_sourceProperties.component2();
                if (!NdkLocatorKt.isAcceptableNdkVersion(sourceProperties.getRevision(), ndkVersionFromDslRevision)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List matchingLocations = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
            if (matchingLocations.isEmpty()) {
                LoggingEnvironmentKt.error("No version of NDK matched the requested version " + ndkVersionFromDsl, new Object[0]);
                Iterable $receiver$iv6 = $receiver$iv$iv3 = ($receiver$iv5 = (Iterable)versionedLocations2);
                for (Object element$iv3 : $receiver$iv6) {
                    kotlin.Pair $location_version = (kotlin.Pair)element$iv3;
                    boolean bl = false;
                    location5 = (Location)$location_version.component1();
                    SdkSourceProperties version3 = (SdkSourceProperties)$location_version.component2();
                    findNdkPathImpl.1.INSTANCE.invoke(location5, "that NDK had version " + version3.getRevision() + " which didn't " + "match the requested version " + ndkVersionFromDsl);
                }
                return ((Location)highest.getFirst()).getNdkRoot();
            }
            foundNdkRoot = ((Location)((kotlin.Pair)CollectionsKt.first((List)matchingLocations)).getFirst()).getNdkRoot();
            if (matchingLocations.size() > 1) {
                LoggingEnvironmentKt.info("Found " + matchingLocations.size() + " NDK folders that matched requested " + "version " + ndkVersionFromDslRevision + ':', new Object[0]);
                $receiver$iv = matchingLocations;
                int index$iv = 0;
                for (Object item$iv : $receiver$iv) {
                    void $location_$_$2;
                    int $location_version;
                    if (($location_version = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int bl = $location_version;
                    location5 = (kotlin.Pair)item$iv;
                    int index = bl;
                    boolean bl2 = false;
                    Location location7 = (Location)$location_$_$2.component1();
                    LoggingEnvironmentKt.info(" (" + (index + 1) + ") " + location7.getNdkRoot() + ' ' + location7.getType().getTag(), new Object[0]);
                }
                LoggingEnvironmentKt.info("  choosing " + foundNdkRoot, new Object[0]);
            } else {
                LoggingEnvironmentKt.info("Found requested NDK version " + ndkVersionFromDslRevision + " at " + foundNdkRoot, new Object[0]);
            }
            return foundNdkRoot;
        }
        if (ndkDirProperty != null) {
            Iterator iterator;
            block42: {
                foundNdkRoot = versionedLocations2;
                $receiver$iv = foundNdkRoot;
                for (Iterator iterator2 : $receiver$iv) {
                    $location_$_$ = (kotlin.Pair)iterator2;
                    boolean bl = false;
                    Location location8 = (Location)$location_$_$.component1();
                    if (!(location8.getType() == LocationType.NDK_DIR_LOCATION)) continue;
                    iterator = iterator2;
                    break block42;
                }
                iterator = null;
            }
            ndkDirLocation = (kotlin.Pair)iterator;
            if (ndkDirLocation == null) {
                LoggingEnvironmentKt.error("Location specified by ndk.dir (" + ndkDirProperty + ") did not contain a " + "valid NDK and and couldn't be used", new Object[0]);
                LoggingEnvironmentKt.info("Using " + ((Location)highest.getFirst()).getNdkRoot() + " which is " + "version " + ((SdkSourceProperties)highest.getSecond()).getRevision() + " as fallback but build will fail", new Object[0]);
                return ((Location)highest.getFirst()).getNdkRoot();
            }
            kotlin.Pair pair = ndkDirLocation;
            foundNdkRoot = (Location)pair.component1();
            version = (SdkSourceProperties)pair.component2();
            LoggingEnvironmentKt.info("Found requested ndk.dir (" + ((Location)location).getNdkRoot() + ") which has version " + version.getRevision(), new Object[0]);
            return ((Location)location).getNdkRoot();
        }
        LoggingEnvironmentKt.info("No user requested version, choosing " + ((Location)highest.getFirst()).getNdkRoot() + " which is " + "version " + ((SdkSourceProperties)highest.getSecond()).getRevision(), new Object[0]);
        return ((Location)highest.getFirst()).getNdkRoot();
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    @NotNull
    public static final NdkLocatorRecord findNdkPathWithRecord(@Nullable String ndkVersionFromDsl, @Nullable String ndkDirProperty, @Nullable String androidNdkHomeEnvironmentVariable, @Nullable File sdkFolder, @NotNull Function1<? super File, ? extends List<String>> getNdkVersionedFolderNames, @NotNull Function1<? super File, SdkSourceProperties> getNdkSourceProperties) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final boolean isAcceptableNdkVersion(Revision sourcePropertiesRevision, Revision revisionFromDsl) {
        boolean bl;
        int[] parts = revisionFromDsl.toIntArray(true);
        switch (parts.length) {
            case 3: 
            case 4: {
                bl = Intrinsics.areEqual((Object)sourcePropertiesRevision, (Object)revisionFromDsl);
                break;
            }
            case 2: {
                if (revisionFromDsl.getMajor() == sourcePropertiesRevision.getMajor() && revisionFromDsl.getMinor() == sourcePropertiesRevision.getMinor()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                if (revisionFromDsl.getMajor() == sourcePropertiesRevision.getMajor()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("Unexpected");
            }
        }
        return bl;
    }

    @VisibleForTesting
    @Nullable
    public static final SdkSourceProperties getNdkVersionInfo(@NotNull File ndkRoot) {
        SdkSourceProperties sdkSourceProperties;
        Intrinsics.checkParameterIsNotNull((Object)ndkRoot, (String)"ndkRoot");
        try {
            sdkSourceProperties = SdkSourceProperties.Companion.fromInstallFolder(ndkRoot);
        }
        catch (FileNotFoundException e) {
            sdkSourceProperties = null;
        }
        return sdkSourceProperties;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final List<String> getNdkVersionedFolders(@NotNull File ndkVersionRoot) {
        void var3_3;
        void $receiver$iv$iv;
        String[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)ndkVersionRoot, (String)"ndkVersionRoot");
        if (!ndkVersionRoot.isDirectory()) {
            return CollectionsKt.emptyList();
        }
        String[] stringArray = ndkVersionRoot.list();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"ndkVersionRoot.list()");
        String[] stringArray2 = $receiver$iv = stringArray;
        Collection destination$iv$iv = new ArrayList();
        void var4_4 = $receiver$iv$iv;
        int n = ((void)var4_4).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var4_4[i];
            boolean bl = false;
            if (!new File(ndkVersionRoot, (String)it).isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final NdkLocatorRecord findNdkPath(@Nullable String ndkVersionFromDsl, @NotNull File projectDir) {
        Intrinsics.checkParameterIsNotNull((Object)projectDir, (String)"projectDir");
        Properties properties = GradleLocalPropertiesKt.gradleLocalProperties(projectDir);
        Pair<File, Boolean> pair = SdkHandler.findSdkLocation(properties, projectDir);
        Intrinsics.checkExpressionValueIsNotNull(pair, (String)"SdkHandler.findSdkLocation(properties, projectDir)");
        Pair<File, Boolean> sdkLocation = pair;
        File sdkPath = (File)sdkLocation.getFirst();
        return NdkLocatorKt.findNdkPathWithRecord(ndkVersionFromDsl, properties.getProperty("ndk.dir"), System.getenv("ANDROID_NDK_HOME"), sdkPath, (Function1<? super File, ? extends List<String>>)((Function1)findNdkPath.1.INSTANCE), (Function1<? super File, SdkSourceProperties>)((Function1)findNdkPath.2.INSTANCE));
    }
}

