/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.api.TestedComponentIdentifier;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.component.Artifact;
import org.gradle.api.file.FileCollection;

public class ArtifactCollectionWithExtraArtifact
implements ArtifactCollection {
    private final ArtifactCollection parentArtifacts;
    private final FileCollection extraArtifact;
    private final ExtraArtifactType extraArtifactType;
    private final String projectPath;
    private final String variantName;
    private final FileCollection combinedCollection;
    private Set<ResolvedArtifactResult> artifactResults = null;

    public static ArtifactCollectionWithExtraArtifact makeExtraCollectionForTest(ArtifactCollection parentArtifacts, FileCollection extraArtifact, String projectPath2, String variantName2) {
        return new ArtifactCollectionWithExtraArtifact(parentArtifacts, extraArtifact, ExtraArtifactType.TEST, projectPath2, variantName2);
    }

    public static ArtifactCollectionWithExtraArtifact makeExtraCollection(ArtifactCollection parentArtifacts, FileCollection extraArtifact, String projectPath2) {
        return new ArtifactCollectionWithExtraArtifact(parentArtifacts, extraArtifact, ExtraArtifactType.OTHER, projectPath2, null);
    }

    private ArtifactCollectionWithExtraArtifact(ArtifactCollection parentArtifacts, FileCollection extraArtifact, ExtraArtifactType extraArtifactType, String projectPath2, String variantName2) {
        Preconditions.checkState((variantName2 != null || extraArtifactType != ExtraArtifactType.TEST ? 1 : 0) != 0, (Object)"variant name should not be null for test extra type");
        this.parentArtifacts = parentArtifacts;
        this.extraArtifact = extraArtifact;
        this.extraArtifactType = extraArtifactType;
        this.projectPath = projectPath2;
        this.variantName = variantName2;
        this.combinedCollection = parentArtifacts.getArtifactFiles().plus(extraArtifact);
    }

    public FileCollection getArtifactFiles() {
        return this.combinedCollection;
    }

    public Set<ResolvedArtifactResult> getArtifacts() {
        if (this.artifactResults == null) {
            this.artifactResults = Sets.newLinkedHashSet();
            this.artifactResults.addAll(this.computeExtraArtifactResults());
            this.artifactResults.addAll(this.parentArtifacts.getArtifacts());
        }
        return this.artifactResults;
    }

    public Collection<Throwable> getFailures() {
        return this.parentArtifacts.getFailures();
    }

    public Iterator<ResolvedArtifactResult> iterator() {
        return this.getArtifacts().iterator();
    }

    public void forEach(Consumer<? super ResolvedArtifactResult> action) {
        this.getArtifacts().forEach(action);
    }

    public Spliterator<ResolvedArtifactResult> spliterator() {
        return this.getArtifacts().spliterator();
    }

    public ArtifactCollection getParentArtifacts() {
        return this.parentArtifacts;
    }

    private List<ResolvedArtifactResult> computeExtraArtifactResults() {
        Set testedFiles = this.extraArtifact.getFiles();
        ArrayList list = Lists.newArrayListWithCapacity((int)testedFiles.size());
        ExtraComponentArtifactIdentifier artifactId = new ExtraComponentArtifactIdentifier(this.extraArtifactType == ExtraArtifactType.TEST ? new TestedComponentIdentifierImpl(this.projectPath, this.variantName) : new ExtraComponentIdentifierImpl(this.projectPath));
        for (File file : testedFiles) {
            list.add(new ExtraResolvedArtifactResult(file, artifactId));
        }
        return list;
    }

    public static final class ExtraComponentIdentifierImpl
    implements ExtraComponentIdentifier {
        private final String projectPath;

        public ExtraComponentIdentifierImpl(String projectPath2) {
            this.projectPath = projectPath2;
        }

        public String getDisplayName() {
            return "__extra_artifact__:" + this.projectPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtraComponentIdentifierImpl that = (ExtraComponentIdentifierImpl)o;
            return Objects.equals(this.projectPath, that.projectPath);
        }

        public int hashCode() {
            return Objects.hash(this.projectPath);
        }
    }

    public static final class TestedComponentIdentifierImpl
    implements TestedComponentIdentifier,
    ExtraComponentIdentifier {
        private final String projectPath;
        private final String variantName;

        public TestedComponentIdentifierImpl(String projectPath2, String variantName2) {
            this.projectPath = projectPath2;
            this.variantName = variantName2;
        }

        @Override
        public String getVariantName() {
            return this.variantName;
        }

        public String getDisplayName() {
            return "__tested_artifact__:" + this.projectPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestedComponentIdentifierImpl that = (TestedComponentIdentifierImpl)o;
            return Objects.equals(this.projectPath, that.projectPath) && Objects.equals(this.variantName, that.variantName);
        }

        public int hashCode() {
            return Objects.hash(this.projectPath, this.variantName);
        }
    }

    private static final class ExtraComponentArtifactIdentifier
    implements ComponentArtifactIdentifier {
        private final ComponentIdentifier id;

        public ExtraComponentArtifactIdentifier(ComponentIdentifier id) {
            this.id = id;
        }

        public ComponentIdentifier getComponentIdentifier() {
            return this.id;
        }

        public String getDisplayName() {
            return this.id.getDisplayName();
        }
    }

    private static final class ExtraResolvedArtifactResult
    implements ResolvedArtifactResult {
        private final File artifactFile;
        private final ExtraComponentArtifactIdentifier artifactId;

        private ExtraResolvedArtifactResult(File artifactFile, ExtraComponentArtifactIdentifier artifactId) {
            this.artifactFile = artifactFile;
            this.artifactId = artifactId;
        }

        public File getFile() {
            return this.artifactFile;
        }

        public ResolvedVariantResult getVariant() {
            throw new UnsupportedOperationException("Call to ExtraResolvedArtifactResult.getVariant is not allowed");
        }

        public ComponentArtifactIdentifier getId() {
            return this.artifactId;
        }

        public Class<? extends Artifact> getType() {
            throw new UnsupportedOperationException("Call to ExtraResolvedArtifactResult.getType is not allowed");
        }
    }

    private static enum ExtraArtifactType {
        TEST,
        OTHER;

    }

    public static interface ExtraComponentIdentifier
    extends ComponentIdentifier {
    }
}

