/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.gradle.internal.scope.BootClasspathBuilder;
import com.android.builder.core.LibraryRequest;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.OptionalLibrary;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006H\u0002JF\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\u0013\u001a\u00020\u0014J\u0084\u0001\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00060\u001a2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00060\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/scope/BootClasspathBuilder;", "", "()V", "classpathCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Ljava/io/File;", "calculateKey", "targetApiLevel", "addAllOptionalLibraries", "", "libraryRequests", "Lcom/android/builder/core/LibraryRequest;", "computeAdditionalAndRequestedOptionalLibraries", "additionalLibraries", "Lcom/android/sdklib/OptionalLibrary;", "optionalLibraries", "libraryRequestsArg", "issueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "computeClasspath", "Lorg/gradle/api/file/FileCollection;", "project", "Lorg/gradle/api/Project;", "targetBootClasspath", "Lorg/gradle/api/provider/Provider;", "targetAndroidVersion", "Lcom/android/sdklib/AndroidVersion;", "annotationsJar", "gradle"})
public final class BootClasspathBuilder {
    private static final ConcurrentHashMap<Integer, List<File>> classpathCache;
    public static final BootClasspathBuilder INSTANCE;

    @NotNull
    public final FileCollection computeClasspath(@NotNull Project project, @NotNull EvalIssueReporter issueReporter, @NotNull Provider<List<File>> targetBootClasspath, @NotNull Provider<AndroidVersion> targetAndroidVersion, @NotNull Provider<List<OptionalLibrary>> additionalLibraries, @NotNull Provider<List<OptionalLibrary>> optionalLibraries, @NotNull Provider<File> annotationsJar, boolean addAllOptionalLibraries, @NotNull List<? extends LibraryRequest> libraryRequests) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        Intrinsics.checkParameterIsNotNull(targetBootClasspath, (String)"targetBootClasspath");
        Intrinsics.checkParameterIsNotNull(targetAndroidVersion, (String)"targetAndroidVersion");
        Intrinsics.checkParameterIsNotNull(additionalLibraries, (String)"additionalLibraries");
        Intrinsics.checkParameterIsNotNull(optionalLibraries, (String)"optionalLibraries");
        Intrinsics.checkParameterIsNotNull(annotationsJar, (String)"annotationsJar");
        Intrinsics.checkParameterIsNotNull(libraryRequests, (String)"libraryRequests");
        ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{targetBootClasspath.map(new Transformer<S, T>(targetAndroidVersion, addAllOptionalLibraries, libraryRequests, additionalLibraries, optionalLibraries, issueReporter, annotationsJar){
            final /* synthetic */ Provider $targetAndroidVersion;
            final /* synthetic */ boolean $addAllOptionalLibraries;
            final /* synthetic */ List $libraryRequests;
            final /* synthetic */ Provider $additionalLibraries;
            final /* synthetic */ Provider $optionalLibraries;
            final /* synthetic */ EvalIssueReporter $issueReporter;
            final /* synthetic */ Provider $annotationsJar;

            /*
             * WARNING - void declaration
             */
            public final List<File> transform(List<? extends File> bootClasspath) {
                void $receiver$iv;
                Object object = this.$targetAndroidVersion.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"targetAndroidVersion.get()");
                int apiLevel = ((AndroidVersion)object).getApiLevel();
                int key = BootClasspathBuilder.access$calculateKey(BootClasspathBuilder.INSTANCE, apiLevel, this.$addAllOptionalLibraries, this.$libraryRequests);
                ConcurrentMap concurrentMap = BootClasspathBuilder.access$getClasspathCache$p(BootClasspathBuilder.INSTANCE);
                Integer key$iv = key;
                Object object2 = $receiver$iv.get(key$iv);
                if (object2 == null) {
                    ImmutableList immutableList;
                    boolean bl = false;
                    ImmutableList.Builder files2 = ImmutableList.builder();
                    files2.addAll((Iterable)bootClasspath);
                    Object object3 = this.$additionalLibraries.get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"additionalLibraries.get()");
                    List list = (List)object3;
                    Object object4 = this.$optionalLibraries.get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"optionalLibraries.get()");
                    files2.addAll((Iterable)BootClasspathBuilder.INSTANCE.computeAdditionalAndRequestedOptionalLibraries(list, (List)object4, this.$addAllOptionalLibraries, this.$libraryRequests, this.$issueReporter));
                    if (apiLevel <= 15) {
                        files2.add(this.$annotationsJar.get());
                    }
                    ImmutableList default$iv = immutableList = files2.build();
                    object2 = $receiver$iv.putIfAbsent(key$iv, default$iv);
                    if (object2 == null) {
                        object2 = default$iv;
                    }
                }
                return (List)object2;
            }
            {
                this.$targetAndroidVersion = provider;
                this.$addAllOptionalLibraries = bl;
                this.$libraryRequests = list;
                this.$additionalLibraries = provider2;
                this.$optionalLibraries = provider3;
                this.$issueReporter = evalIssueReporter;
                this.$annotationsJar = provider4;
            }
        })});
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"project.files(\n         \u2026         }\n            })");
        return (FileCollection)configurableFileCollection;
    }

    private final int calculateKey(int targetApiLevel, boolean addAllOptionalLibraries, List<? extends LibraryRequest> libraryRequests) {
        return Objects.hash(AndroidTargetHash.getPlatformHashString((AndroidVersion)new AndroidVersion(targetApiLevel)), addAllOptionalLibraries, libraryRequests);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> computeAdditionalAndRequestedOptionalLibraries(@NotNull List<? extends OptionalLibrary> additionalLibraries, @NotNull List<? extends OptionalLibrary> optionalLibraries, boolean addAllOptionalLibraries, @NotNull List<? extends LibraryRequest> libraryRequestsArg, @NotNull EvalIssueReporter issueReporter) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(additionalLibraries, (String)"additionalLibraries");
        Intrinsics.checkParameterIsNotNull(optionalLibraries, (String)"optionalLibraries");
        Intrinsics.checkParameterIsNotNull(libraryRequestsArg, (String)"libraryRequestsArg");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        Iterable iterable = $receiver$iv = (Iterable)libraryRequestsArg;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            LibraryRequest libraryRequest = (LibraryRequest)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        Set libraryRequests = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        ImmutableList.Builder files2 = ImmutableList.builder();
        additionalLibraries.stream().map(new Function<T, R>(libraryRequests){
            final /* synthetic */ Set $libraryRequests;

            /*
             * WARNING - void declaration
             */
            public final File apply(OptionalLibrary lib) {
                void var2_2;
                OptionalLibrary optionalLibrary = lib;
                Intrinsics.checkExpressionValueIsNotNull((Object)optionalLibrary, (String)"lib");
                File jar = optionalLibrary.getJar();
                Verify.verify((jar != null ? 1 : 0) != 0, (String)"Jar missing from additional library %s.", (Object)lib.getName());
                if (this.$libraryRequests.contains(lib.getName())) {
                    this.$libraryRequests.remove(lib.getName());
                }
                return var2_2;
            }
            {
                this.$libraryRequests = set;
            }
        }).filter(computeAdditionalAndRequestedOptionalLibraries.2.INSTANCE).forEach((Consumer)new Consumer<File>(files2){
            final /* synthetic */ ImmutableList.Builder $files;

            public final void accept(File it) {
                this.$files.add((Object)it);
            }
            {
                this.$files = builder;
            }
        });
        optionalLibraries.stream().map(new Function<T, R>(libraryRequests, addAllOptionalLibraries){
            final /* synthetic */ Set $libraryRequests;
            final /* synthetic */ boolean $addAllOptionalLibraries;

            /*
             * WARNING - void declaration
             */
            public final File apply(OptionalLibrary lib) {
                File file;
                OptionalLibrary optionalLibrary = lib;
                Intrinsics.checkExpressionValueIsNotNull((Object)optionalLibrary, (String)"lib");
                boolean libraryRequested = this.$libraryRequests.contains(optionalLibrary.getName());
                if (this.$addAllOptionalLibraries || libraryRequested) {
                    void var3_3;
                    File jar = lib.getJar();
                    Verify.verify((jar != null ? 1 : 0) != 0, (String)"Jar missing from optional library %s.", (Object)lib.getName());
                    if (libraryRequested) {
                        this.$libraryRequests.remove(lib.getName());
                    }
                    file = var3_3;
                } else {
                    file = null;
                }
                return file;
            }
            {
                this.$libraryRequests = set;
                this.$addAllOptionalLibraries = bl;
            }
        }).filter(computeAdditionalAndRequestedOptionalLibraries.5.INSTANCE).forEach((Consumer)new Consumer<File>(files2){
            final /* synthetic */ ImmutableList.Builder $files;

            public final void accept(File it) {
                this.$files.add((Object)it);
            }
            {
                this.$files = builder;
            }
        });
        for (String library : libraryRequests) {
            issueReporter.reportError(EvalIssueReporter.Type.OPTIONAL_LIB_NOT_FOUND, new EvalIssueException("Unable to find optional library: " + library, library, null, 4, null));
        }
        ImmutableList immutableList = files2.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"files.build()");
        return (List)immutableList;
    }

    private BootClasspathBuilder() {
    }

    static {
        BootClasspathBuilder bootClasspathBuilder;
        INSTANCE = bootClasspathBuilder = new BootClasspathBuilder();
        classpathCache = new ConcurrentHashMap();
    }

    public static final /* synthetic */ int access$calculateKey(BootClasspathBuilder $this, int targetApiLevel, boolean addAllOptionalLibraries, List libraryRequests) {
        return $this.calculateKey(targetApiLevel, addAllOptionalLibraries, libraryRequests);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getClasspathCache$p(BootClasspathBuilder $this) {
        BootClasspathBuilder bootClasspathBuilder = $this;
        return classpathCache;
    }
}

