/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.ide.LibraryImpl;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.utils.FileUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public final class AndroidLibraryImpl
extends LibraryImpl
implements AndroidLibrary,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String variant;
    private final File bundle;
    private final File folder;
    private final File resStaticLibrary;
    private final List<AndroidLibrary> androidLibraries;
    private final Collection<JavaLibrary> javaLibraries;
    private final Collection<File> localJars;
    private final int hashcode;

    public AndroidLibraryImpl(MavenCoordinates coordinates, String buildId, String projectPath2, File bundle, File extractedFolder, File resStaticLibrary, String variant, boolean isProvided, boolean isSkipped, List<AndroidLibrary> androidLibraries, Collection<JavaLibrary> javaLibraries, Collection<File> localJavaLibraries) {
        super(buildId, projectPath2, null, coordinates, isSkipped, isProvided);
        this.resStaticLibrary = resStaticLibrary;
        this.androidLibraries = ImmutableList.copyOf(androidLibraries);
        this.javaLibraries = ImmutableList.copyOf(javaLibraries);
        this.localJars = ImmutableList.copyOf(localJavaLibraries);
        this.variant = variant;
        this.bundle = bundle;
        this.folder = extractedFolder;
        this.hashcode = this.computeHashCode();
    }

    public String getProjectVariant() {
        return this.variant;
    }

    public File getBundle() {
        return this.bundle;
    }

    public File getFolder() {
        return this.folder;
    }

    public List<? extends AndroidLibrary> getLibraryDependencies() {
        return this.androidLibraries;
    }

    public Collection<? extends JavaLibrary> getJavaDependencies() {
        return this.javaLibraries;
    }

    public Collection<File> getLocalJars() {
        return this.localJars;
    }

    public File getManifest() {
        return new File(this.folder, "AndroidManifest.xml");
    }

    public File getJarFile() {
        return FileUtils.join((File)this.folder, (String[])new String[]{"jars", "classes.jar"});
    }

    public File getCompileJarFile() {
        File apiJarFile = FileUtils.join((File)this.folder, (String[])new String[]{"api.jar"});
        return apiJarFile.exists() ? apiJarFile : this.getJarFile();
    }

    public File getResFolder() {
        return new File(this.folder, "res");
    }

    public File getResStaticLibrary() {
        return this.resStaticLibrary;
    }

    public File getAssetsFolder() {
        return new File(this.folder, "assets");
    }

    public File getJniFolder() {
        return new File(this.folder, "jni");
    }

    public File getAidlFolder() {
        return new File(this.folder, "aidl");
    }

    public File getRenderscriptFolder() {
        return new File(this.folder, "rs");
    }

    public File getProguardRules() {
        return new File(this.folder, "proguard.txt");
    }

    public File getLintJar() {
        return new File(this.getJarFile().getParentFile(), "lint.jar");
    }

    public File getExternalAnnotations() {
        return new File(this.folder, "annotations.zip");
    }

    public File getPublicResources() {
        return new File(this.folder, "public.txt");
    }

    @Deprecated
    public boolean isOptional() {
        return this.isProvided();
    }

    public File getSymbolFile() {
        return new File(this.folder, "R.txt");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidLibraryImpl that = (AndroidLibraryImpl)o;
        if (this.hashcode != that.hashcode || !super.equals(o)) {
            return false;
        }
        return Objects.equal((Object)this.variant, (Object)that.variant) && Objects.equal((Object)this.bundle, (Object)that.bundle) && Objects.equal((Object)this.folder, (Object)that.folder) && Objects.equal((Object)this.resStaticLibrary, (Object)that.resStaticLibrary) && Objects.equal(this.androidLibraries, that.androidLibraries) && Objects.equal(this.javaLibraries, that.javaLibraries) && Objects.equal(this.localJars, that.localJars);
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    private int computeHashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.variant, this.bundle, this.folder, this.resStaticLibrary, this.androidLibraries, this.javaLibraries, this.localJars});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("project", (Object)this.getProject()).add("variant", (Object)this.variant).add("bundle", (Object)this.bundle).add("folder", (Object)this.folder).add("resStaticLibrary", (Object)this.resStaticLibrary).add("androidLibraries", this.androidLibraries).add("javaLibraries", this.javaLibraries).add("localJars", this.localJars).add("super", (Object)super.toString()).toString();
    }
}

