/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorKt;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorRecord;
import com.android.build.gradle.internal.ndk.DefaultNdkInfo;
import com.android.build.gradle.internal.ndk.NdkHandlerKt;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.build.gradle.internal.ndk.NdkInstallStatus;
import com.android.build.gradle.internal.ndk.NdkPlatform;
import com.android.build.gradle.internal.ndk.NdkR14Info;
import com.android.builder.sdk.InstallFailedException;
import com.android.builder.sdk.LicenceNotAcceptedException;
import com.android.builder.sdk.SdkLibData;
import com.android.builder.sdk.SdkLoader;
import com.android.repository.Revision;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0002!\"B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u0019H\u0002J\u000e\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\bR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkHandler;", "", "enableSideBySideNdk", "", "ndkVersionFromDsl", "", "compileSdkVersion", "projectDir", "Ljava/io/File;", "(ZLjava/lang/String;Ljava/lang/String;Ljava/io/File;)V", "ndkInstallStatus", "Lcom/android/build/gradle/internal/ndk/NdkInstallStatus;", "ndkPlatform", "getNdkPlatform", "()Lcom/android/build/gradle/internal/ndk/NdkInstallStatus;", "sideBySideLocatorRecord", "Lcom/android/build/gradle/internal/cxx/configure/NdkLocatorRecord;", "findNdk", "getNdkInfo", "Lcom/android/build/gradle/internal/ndk/NdkInfo;", "ndkDirectory", "revision", "Lcom/android/repository/Revision;", "getNdkStatus", "installFromSdk", "", "sdkLoader", "Lcom/android/builder/sdk/SdkLoader;", "sdkLibData", "Lcom/android/builder/sdk/SdkLibData;", "invalidateNdk", "writeNdkLocatorRecord", "file", "Companion", "FindRevisionResult", "gradle"})
public final class NdkHandler {
    private NdkInstallStatus ndkInstallStatus;
    private NdkLocatorRecord sideBySideLocatorRecord;
    private final boolean enableSideBySideNdk;
    private final String ndkVersionFromDsl;
    private final String compileSdkVersion;
    private final File projectDir;
    public static final Companion Companion = new Companion(null);

    private final File findNdk() {
        File file;
        if (this.enableSideBySideNdk) {
            NdkLocatorRecord record;
            this.sideBySideLocatorRecord = record = NdkLocatorKt.findNdkPath(this.ndkVersionFromDsl, this.projectDir);
            file = record.getNdkFolder();
        } else {
            file = NdkHandler.Companion.findNdkDirectory(this.projectDir);
        }
        return file;
    }

    private final NdkInfo getNdkInfo(File ndkDirectory, Revision revision) {
        return revision.getMajor() < 14 ? (NdkInfo)new DefaultNdkInfo(ndkDirectory) : (NdkInfo)new NdkR14Info(ndkDirectory);
    }

    private final NdkInstallStatus getNdkStatus() {
        File ndkDirectory = this.findNdk();
        if (ndkDirectory == null || !ndkDirectory.exists()) {
            return NdkInstallStatus.NotInstalled.INSTANCE;
        }
        FindRevisionResult findRevisionResult = Companion.findRevision(ndkDirectory);
        FindRevisionResult findRevisionResult2 = findRevisionResult;
        if (!(findRevisionResult2 instanceof FindRevisionResult.Found)) {
            if (findRevisionResult2 instanceof FindRevisionResult.Error) {
                return new NdkInstallStatus.Invalid(((FindRevisionResult.Error)findRevisionResult).getMessage());
            }
            throw new NoWhenBranchMatchedException();
        }
        Revision revision = ((FindRevisionResult.Found)findRevisionResult).getRevision();
        NdkInfo ndkInfo = this.getNdkInfo(ndkDirectory, revision);
        return new NdkInstallStatus.Valid(new NdkPlatform(ndkDirectory, ndkInfo, revision, this.compileSdkVersion));
    }

    @NotNull
    public final NdkInstallStatus getNdkPlatform() {
        if (this.ndkInstallStatus == null) {
            this.ndkInstallStatus = this.getNdkStatus();
        }
        NdkInstallStatus ndkInstallStatus = this.ndkInstallStatus;
        if (ndkInstallStatus == null) {
            Intrinsics.throwNpe();
        }
        return ndkInstallStatus;
    }

    private final void invalidateNdk() {
        this.ndkInstallStatus = null;
    }

    public final void installFromSdk(@NotNull SdkLoader sdkLoader, @NotNull SdkLibData sdkLibData) {
        Intrinsics.checkParameterIsNotNull((Object)sdkLoader, (String)"sdkLoader");
        Intrinsics.checkParameterIsNotNull((Object)sdkLibData, (String)"sdkLibData");
        try {
            if (this.enableSideBySideNdk) {
                sdkLoader.installSdkTool(sdkLibData, "ndk");
            } else {
                sdkLoader.installSdkTool(sdkLibData, "ndk-bundle");
            }
        }
        catch (LicenceNotAcceptedException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (InstallFailedException e) {
            throw (Throwable)new RuntimeException(e);
        }
        this.invalidateNdk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeNdkLocatorRecord(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (this.sideBySideLocatorRecord != null) {
            file.getParentFile().mkdirs();
            Closeable closeable = new FileWriter(file);
            boolean bl = false;
            Throwable throwable = null;
            try {
                FileWriter writer = (FileWriter)closeable;
                boolean bl2 = false;
                NdkHandlerKt.getGSON().toJson((Object)this.sideBySideLocatorRecord, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    public NdkHandler(boolean enableSideBySideNdk, @Nullable String ndkVersionFromDsl, @NotNull String compileSdkVersion, @NotNull File projectDir) {
        Intrinsics.checkParameterIsNotNull((Object)compileSdkVersion, (String)"compileSdkVersion");
        Intrinsics.checkParameterIsNotNull((Object)projectDir, (String)"projectDir");
        this.enableSideBySideNdk = enableSideBySideNdk;
        this.ndkVersionFromDsl = ndkVersionFromDsl;
        this.compileSdkVersion = compileSdkVersion;
        this.projectDir = projectDir;
    }

    @VisibleForTesting
    @JvmStatic
    @NotNull
    public static final FindRevisionResult findRevision(@NotNull File ndkDirectory) {
        return Companion.findRevision(ndkDirectory);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkHandler$FindRevisionResult;", "", "()V", "getOrThrow", "Lcom/android/repository/Revision;", "Error", "Found", "Lcom/android/build/gradle/internal/ndk/NdkHandler$FindRevisionResult$Found;", "Lcom/android/build/gradle/internal/ndk/NdkHandler$FindRevisionResult$Error;", "gradle"})
    public static abstract class FindRevisionResult {
        @NotNull
        public final Revision getOrThrow() {
            FindRevisionResult findRevisionResult = this;
            if (findRevisionResult instanceof Found) {
                return ((Found)this).getRevision();
            }
            if (findRevisionResult instanceof Error) {
                throw (Throwable)new RuntimeException(((Error)this).getMessage());
            }
            throw new NoWhenBranchMatchedException();
        }

        private FindRevisionResult() {
        }

        public /* synthetic */ FindRevisionResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkHandler$FindRevisionResult$Found;", "Lcom/android/build/gradle/internal/ndk/NdkHandler$FindRevisionResult;", "revision", "Lcom/android/repository/Revision;", "(Lcom/android/repository/Revision;)V", "getRevision", "()Lcom/android/repository/Revision;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "gradle"})
        public static final class Found
        extends FindRevisionResult {
            @NotNull
            private final Revision revision;

            @NotNull
            public final Revision getRevision() {
                return this.revision;
            }

            public Found(@NotNull Revision revision) {
                Intrinsics.checkParameterIsNotNull((Object)revision, (String)"revision");
                super(null);
                this.revision = revision;
            }

            @NotNull
            public final Revision component1() {
                return this.revision;
            }

            @NotNull
            public final Found copy(@NotNull Revision revision) {
                Intrinsics.checkParameterIsNotNull((Object)revision, (String)"revision");
                return new Found(revision);
            }

            @NotNull
            public static /* synthetic */ Found copy$default(Found found, Revision revision, int n, Object object) {
                if ((n & 1) != 0) {
                    revision = found.revision;
                }
                return found.copy(revision);
            }

            @NotNull
            public String toString() {
                return "Found(revision=" + this.revision + ")";
            }

            public int hashCode() {
                Revision revision = this.revision;
                return revision != null ? revision.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Found)) break block3;
                        Found found = (Found)object;
                        if (!Intrinsics.areEqual((Object)this.revision, (Object)found.revision)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkHandler$FindRevisionResult$Error;", "Lcom/android/build/gradle/internal/ndk/NdkHandler$FindRevisionResult;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle"})
        public static final class Error
        extends FindRevisionResult {
            @NotNull
            private final String message;

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            public Error(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final Error copy(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                return new Error(message);
            }

            @NotNull
            public static /* synthetic */ Error copy$default(Error error2, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = error2.message;
                }
                return error2.copy(string);
            }

            @NotNull
            public String toString() {
                return "Error(message=" + this.message + ")";
            }

            public int hashCode() {
                String string = this.message;
                return string != null ? string.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Error)) break block3;
                        Error error2 = (Error)object;
                        if (!Intrinsics.areEqual((Object)this.message, (Object)error2.message)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0006H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkHandler$Companion;", "", "()V", "checkNdkDir", "", "ndkDir", "Ljava/io/File;", "findNdkDirectory", "projectDir", "properties", "Ljava/util/Properties;", "findRevision", "Lcom/android/build/gradle/internal/ndk/NdkHandler$FindRevisionResult;", "ndkDirectory", "invalidNdkWarning", "", "message", "", "readProperties", "file", "gradle"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Properties readProperties(File file) {
            Properties properties = new Properties();
            try {
                Closeable closeable = new FileInputStream(file);
                boolean bl = false;
                Throwable throwable = null;
                try {
                    FileInputStream fis = (FileInputStream)closeable;
                    boolean bl2 = false;
                    Closeable closeable2 = new InputStreamReader((InputStream)fis, Charsets.UTF_8);
                    boolean bl3 = false;
                    Throwable throwable2 = null;
                    try {
                        InputStreamReader reader = (InputStreamReader)closeable2;
                        boolean bl4 = false;
                        properties.load(reader);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Unable to read %1$s.";
                Object[] objectArray = new Object[]{file};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                String string3 = string2;
                Throwable throwable = e;
                String string4 = string3;
                throw (Throwable)new RuntimeException(string4, throwable);
            }
            return properties;
        }

        @VisibleForTesting
        @JvmStatic
        @NotNull
        public final FindRevisionResult findRevision(@NotNull File ndkDirectory) {
            FindRevisionResult findRevisionResult;
            Intrinsics.checkParameterIsNotNull((Object)ndkDirectory, (String)"ndkDirectory");
            File sourceProperties = new File(ndkDirectory, "source.properties");
            if (!sourceProperties.exists()) {
                File releaseTxt = FilesKt.resolve((File)ndkDirectory, (String)"RELEASE.TXT");
                return releaseTxt.exists() ? (FindRevisionResult)new FindRevisionResult.Error("NDK at " + ndkDirectory + " is not supported (pre-r11)") : (FindRevisionResult)new FindRevisionResult.Error(sourceProperties + " does not exist");
            }
            Properties properties = this.readProperties(sourceProperties);
            String version = properties.getProperty("Pkg.Revision");
            if (version != null) {
                Revision revision = Revision.parseRevision((String)version);
                Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"Revision.parseRevision(version)");
                findRevisionResult = new FindRevisionResult.Found(revision);
            } else {
                findRevisionResult = new FindRevisionResult.Error("Could not parse Pkg.Revision from " + sourceProperties);
            }
            return findRevisionResult;
        }

        private final File findNdkDirectory(File projectDir) {
            File localProperties = new File(projectDir, "local.properties");
            Properties properties = new Properties();
            if (localProperties.isFile()) {
                properties = this.readProperties(localProperties);
            }
            File file = this.findNdkDirectory(properties, projectDir);
            if (file == null) {
                return null;
            }
            File ndkDir = file;
            return this.checkNdkDir(ndkDir) ? ndkDir : null;
        }

        private final boolean checkNdkDir(File ndkDir) {
            if (!new File(ndkDir, "platforms").isDirectory()) {
                this.invalidNdkWarning("NDK is missing a \"platforms\" directory.", ndkDir);
                return false;
            }
            if (!new File(ndkDir, "toolchains").isDirectory()) {
                this.invalidNdkWarning("NDK is missing a \"toolchains\" directory.", ndkDir);
                return false;
            }
            return true;
        }

        private final void invalidNdkWarning(String message, File ndkDir) {
            Logging.getLogger(NdkHandler.class).warn("{}\nIf you are using NDK, verify the ndk.dir is set to a valid NDK directory.  It is currently set to {}.\nIf you are not using NDK, unset the NDK variable from ANDROID_NDK_HOME or local.properties to remove this warning.\n", (Object)message, (Object)ndkDir.getAbsolutePath());
        }

        private final File findNdkDirectory(Properties properties, File projectDir) {
            File ndkBundle;
            String ndkDirProp = properties.getProperty("ndk.dir");
            if (ndkDirProp != null) {
                return new File(ndkDirProp);
            }
            String ndkEnvVar = System.getenv("ANDROID_NDK_HOME");
            if (ndkEnvVar != null) {
                return new File(ndkEnvVar);
            }
            Pair<File, Boolean> pair = SdkHandler.findSdkLocation(properties, projectDir);
            Intrinsics.checkExpressionValueIsNotNull(pair, (String)"SdkHandler.findSdkLocation(properties, projectDir)");
            Pair<File, Boolean> sdkLocation = pair;
            File sdkFolder2 = (File)sdkLocation.getFirst();
            if (sdkFolder2 != null && (ndkBundle = new File(sdkFolder2, "ndk-bundle")).isDirectory()) {
                return ndkBundle;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

