/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.ide.common.resources.FileStatus;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

public abstract class IncrementalTask
extends AndroidVariantTask {
    private File incrementalFolder;

    public void setIncrementalFolder(File incrementalFolder) {
        this.incrementalFolder = incrementalFolder;
    }

    @OutputDirectory
    @Optional
    public File getIncrementalFolder() {
        return this.incrementalFolder;
    }

    @Internal
    protected boolean isIncremental() {
        return false;
    }

    protected abstract void doFullTaskAction() throws Exception;

    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws Exception {
    }

    @TaskAction
    void taskAction(IncrementalTaskInputs inputs) {
        super.recordTaskAction(inputs);
    }

    @Override
    protected void recordedTaskAction(IncrementalTaskInputs inputs) throws Exception {
        if (!this.isIncremental() || !inputs.isIncremental()) {
            this.getProject().getLogger().info("Unable do incremental execution: full task run");
            this.doFullTaskAction();
            return;
        }
        this.doIncrementalTaskAction(this.getChangedInputs(inputs));
    }

    private Map<File, FileStatus> getChangedInputs(IncrementalTaskInputs inputs) {
        HashMap changedInputs = Maps.newHashMap();
        inputs.outOfDate(change -> {
            FileStatus status = change.isAdded() ? FileStatus.NEW : FileStatus.CHANGED;
            changedInputs.put(change.getFile(), status);
        });
        inputs.removed(change -> {
            FileStatus status = changedInputs.get(change.getFile()) == FileStatus.NEW ? FileStatus.CHANGED : FileStatus.REMOVED;
            changedInputs.put(change.getFile(), status);
        });
        return changedInputs;
    }
}

