/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import java.io.File;
import java.util.List;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;

public class UninstallTask
extends AndroidVariantTask {
    private BaseVariantData variant;
    private int mTimeOutInMs = 0;
    private Provider<File> adbExecutableProvider;

    public UninstallTask() {
        this.getOutputs().upToDateWhen(task -> {
            this.getLogger().debug("Uninstall task is always run.");
            return false;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void uninstall() throws DeviceException {
        Logger logger = this.getLogger();
        String applicationId = this.variant.getApplicationId();
        logger.info("Uninstalling app: {}", (Object)applicationId);
        LoggerWrapper iLogger = new LoggerWrapper(this.getLogger());
        ConnectedDeviceProvider deviceProvider = new ConnectedDeviceProvider((File)this.adbExecutableProvider.get(), this.getTimeOutInMs(), (ILogger)iLogger);
        deviceProvider.init();
        try {
            List devices = deviceProvider.getDevices();
            for (DeviceConnector device : devices) {
                device.uninstallPackage(applicationId, this.getTimeOutInMs(), (ILogger)iLogger);
                logger.lifecycle("Uninstalling {} (from {}:{}) from device '{}' ({}).", new Object[]{applicationId, this.getProject().getName(), this.variant.getVariantConfiguration().getFullName(), device.getName(), device.getSerialNumber()});
            }
            int n = devices.size();
            logger.quiet("Uninstalled {} from {} device{}.", new Object[]{applicationId, n, n == 1 ? "" : "s"});
        }
        finally {
            deviceProvider.terminate();
        }
    }

    @InputFile
    public File getAdbExe() {
        return (File)this.adbExecutableProvider.get();
    }

    public BaseVariantData getVariant() {
        return this.variant;
    }

    public void setVariant(BaseVariantData variant) {
        this.variant = variant;
    }

    @Input
    public int getTimeOutInMs() {
        return this.mTimeOutInMs;
    }

    public void setTimeOutInMs(int timeoutInMs) {
        this.mTimeOutInMs = timeoutInMs;
    }

    public static class CreationAction
    extends VariantTaskCreationAction<UninstallTask> {
        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return StringHelper.appendCapitalized((String)"uninstall", (String)this.getVariantScope().getVariantConfiguration().getFullName());
        }

        @Override
        public Class<UninstallTask> getType() {
            return UninstallTask.class;
        }

        @Override
        public void configure(UninstallTask task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.setVariant(scope.getVariantData());
            task.setDescription("Uninstalls the " + scope.getVariantData().getDescription() + ".");
            task.setGroup("Install");
            task.setTimeOutInMs(scope.getGlobalScope().getExtension().getAdbOptions().getTimeOutInMs());
            task.adbExecutableProvider = scope.getGlobalScope().getSdkComponents().getAdbExecutableProvider();
        }

        @Override
        public void handleProvider(TaskProvider<? extends UninstallTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setUninstallTask(taskProvider);
        }
    }
}

