/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.services.CxxProcessServiceKt;
import com.android.build.gradle.tasks.CmakeExternalNativeJsonGenerator;
import com.android.ide.common.process.ProcessException;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.IOException;
import java.util.List;

class CmakeAndroidNinjaExternalNativeJsonGenerator
extends CmakeExternalNativeJsonGenerator {
    CmakeAndroidNinjaExternalNativeJsonGenerator(CxxVariantModel variant, List<CxxAbiModel> abis, GradleBuildVariant.Builder stats) {
        super(variant, abis, stats);
    }

    @Override
    List<String> getCacheArguments(CxxAbiModel abi) {
        List<String> cacheArguments = this.getCommonCacheArguments(abi);
        cacheArguments.add(String.format("-DCMAKE_TOOLCHAIN_FILE=%s", abi.getVariant().getModule().getCmakeToolchainFile().getAbsolutePath()));
        cacheArguments.add(String.format("-DCMAKE_MAKE_PROGRAM=%s", this.cmake.getNinjaExe().getAbsolutePath()));
        cacheArguments.add("-GAndroid Gradle - Ninja");
        return cacheArguments;
    }

    @Override
    public String executeProcessAndGetOutput(CxxAbiModel abi) throws ProcessException, IOException {
        String logPrefix = this.variant.getVariantName() + "|" + abi.getAbi().getTag() + " :";
        return CxxProcessServiceKt.createProcessOutputJunction(abi.getVariant().getModule(), abi.getCxxBuildFolder(), "android_gradle_generate_cmake_ninja_json_" + abi.getAbi().getTag(), this.getProcessBuilder(abi), logPrefix).logStderrToInfo().logStdoutToInfo().executeAndReturnStdoutString();
    }
}

