/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.external.cmake.server.BuildFiles;
import com.android.build.gradle.external.cmake.server.CmakeInputsResult;
import com.android.build.gradle.external.cmake.server.CodeModel;
import com.android.build.gradle.external.cmake.server.ComputeResult;
import com.android.build.gradle.external.cmake.server.Configuration;
import com.android.build.gradle.external.cmake.server.ConfigureCommandResult;
import com.android.build.gradle.external.cmake.server.FileGroup;
import com.android.build.gradle.external.cmake.server.HandshakeRequest;
import com.android.build.gradle.external.cmake.server.HandshakeResult;
import com.android.build.gradle.external.cmake.server.IncludePath;
import com.android.build.gradle.external.cmake.server.Project;
import com.android.build.gradle.external.cmake.server.ProtocolVersion;
import com.android.build.gradle.external.cmake.server.Server;
import com.android.build.gradle.external.cmake.server.ServerFactory;
import com.android.build.gradle.external.cmake.server.ServerUtils;
import com.android.build.gradle.external.cmake.server.Target;
import com.android.build.gradle.external.cmake.server.receiver.InteractiveMessage;
import com.android.build.gradle.external.cmake.server.receiver.ServerReceiver;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.cxx.configure.CmakeAndroidGradleBuildExtensionsKt;
import com.android.build.gradle.internal.cxx.configure.CmakeExecutionConfiguration;
import com.android.build.gradle.internal.cxx.configure.CmakeSourceFileNamingKt;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.CompilationDatabaseIndexingVisitorKt;
import com.android.build.gradle.internal.cxx.json.CompilationDatabaseToolchain;
import com.android.build.gradle.internal.cxx.json.CompilationDatabaseToolchainVisitorKt;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.NativeHeaderFileValue;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValue;
import com.android.build.gradle.internal.cxx.json.NativeSourceFileValue;
import com.android.build.gradle.internal.cxx.json.NativeToolchainValue;
import com.android.build.gradle.internal.cxx.json.StringTable;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.tasks.CmakeExternalNativeJsonGenerator;
import com.android.ide.common.process.ProcessException;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.UnsignedInts;
import com.google.gson.stream.JsonReader;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

class CmakeServerExternalNativeJsonGenerator
extends CmakeExternalNativeJsonGenerator {
    private static final String CMAKE_SERVER_LOG_PREFIX = "CMAKE SERVER: ";

    public CmakeServerExternalNativeJsonGenerator(CxxVariantModel variant, List<CxxAbiModel> abis, GradleBuildVariant.Builder stats) {
        super(variant, abis, stats);
    }

    private static String getOnlyToolchainName(Map<String, NativeToolchainValue> toolchains) {
        if (toolchains.size() != 1) {
            throw new RuntimeException(String.format("Invalid number %d of toolchains. Only one toolchain should be present.", toolchains.size()));
        }
        return toolchains.keySet().iterator().next();
    }

    private static String getCmakeInfoString(Server cmakeServer) throws IOException {
        return String.format("Cmake path: %s, version: %s", cmakeServer.getCmakePath(), CmakeUtils.getVersion(new File(cmakeServer.getCmakePath())).toString());
    }

    @Override
    List<String> getCacheArguments(CxxAbiModel abi) {
        List<String> cacheArguments = this.getCommonCacheArguments(abi);
        cacheArguments.add("-DCMAKE_SYSTEM_NAME=Android");
        cacheArguments.add(String.format("-DCMAKE_ANDROID_ARCH_ABI=%s", abi.getAbi().getTag()));
        cacheArguments.add(String.format("-DCMAKE_SYSTEM_VERSION=%s", abi.getAbiPlatformVersion()));
        cacheArguments.add("-DCMAKE_EXPORT_COMPILE_COMMANDS=ON");
        cacheArguments.add(String.format("-DCMAKE_ANDROID_NDK=%s", this.getNdkFolder()));
        cacheArguments.add(String.format("-DCMAKE_TOOLCHAIN_FILE=%s", this.getToolchainFile(abi).getAbsolutePath()));
        cacheArguments.add("-G Ninja");
        if (this.cmake.getNinjaExe().isFile()) {
            cacheArguments.add(String.format("-DCMAKE_MAKE_PROGRAM=%s", this.cmake.getNinjaExe()));
        }
        return cacheArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeProcessAndGetOutput(CxxAbiModel abi) throws ProcessException, IOException {
        Throwable throwable = null;
        try (PrintWriter serverLogWriter = CmakeServerExternalNativeJsonGenerator.getCmakeServerLogWriter(abi.getCxxBuildFolder());){
            String string;
            LoggerWrapper logger = LoggerWrapper.getLogger(CmakeServerExternalNativeJsonGenerator.class);
            ServerReceiver serverReceiver = new ServerReceiver().setMessageReceiver(message -> CmakeServerExternalNativeJsonGenerator.receiveInteractiveMessage(serverLogWriter, logger, message, this.getMakefile().getParentFile())).setDiagnosticReceiver(message -> CmakeServerExternalNativeJsonGenerator.receiveDiagnosticMessage(serverLogWriter, logger, message));
            File cmakeBinFolder = this.cmake.getCmakeExe().getParentFile();
            Server cmakeServer = ServerFactory.create(cmakeBinFolder, serverReceiver);
            if (cmakeServer == null) {
                throw new RuntimeException("Unable to create a Cmake server located at: " + cmakeBinFolder.getAbsolutePath());
            }
            if (!cmakeServer.connect()) {
                throw new RuntimeException("Unable to connect to Cmake server located at: " + cmakeBinFolder.getAbsolutePath());
            }
            try {
                List<String> cacheArgumentsList = this.getCacheArguments(abi);
                cacheArgumentsList.addAll(this.getBuildArguments());
                File cmakeListsFolder = this.variant.getModule().getMakeFile().getParentFile();
                if (this.variant.getModule().isNativeCompilerSettingsCacheEnabled()) {
                    CmakeExecutionConfiguration executableConfiguration = CmakeAndroidGradleBuildExtensionsKt.wrapCmakeListsForCompilerSettingsCaching(abi, cacheArgumentsList);
                    cacheArgumentsList = executableConfiguration.getArgs();
                    cmakeListsFolder = executableConfiguration.getCmakeListsFolder();
                }
                this.doHandshake(cmakeListsFolder, abi.getCxxBuildFolder(), cmakeServer);
                String[] argsArray = cacheArgumentsList.toArray(new String[0]);
                ConfigureCommandResult configureCommandResult = cmakeServer.configure(argsArray);
                if (!ServerUtils.isConfigureResultValid(configureCommandResult.configureResult)) {
                    throw new ProcessException(String.format("Error configuring CMake server (%s).\r\n%s", cmakeServer.getCmakePath(), configureCommandResult.interactiveMessages));
                }
                ComputeResult computeResult = CmakeServerExternalNativeJsonGenerator.doCompute(cmakeServer);
                if (!ServerUtils.isComputedResultValid(computeResult)) {
                    throw new ProcessException("Error computing CMake server result.\r\n" + configureCommandResult.interactiveMessages);
                }
                this.generateAndroidGradleBuild(abi, cmakeServer);
                string = configureCommandResult.interactiveMessages;
            }
            catch (Throwable throwable2) {
                try {
                    cmakeServer.disconnect();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            cmakeServer.disconnect();
            return string;
        }
    }

    private static PrintWriter getCmakeServerLogWriter(File outputFolder) throws IOException {
        return new PrintWriter(CmakeServerExternalNativeJsonGenerator.getCmakeServerLog(outputFolder).getAbsoluteFile(), "UTF-8");
    }

    private static File getCmakeServerLog(File outputFolder) {
        return new File(outputFolder, "cmake_server_log.txt");
    }

    static void receiveInteractiveMessage(PrintWriter writer, ILogger logger, InteractiveMessage message, File makeFileDirectory) {
        writer.println(CMAKE_SERVER_LOG_PREFIX + message.message);
        CmakeServerExternalNativeJsonGenerator.logInteractiveMessage(logger, message, makeFileDirectory);
    }

    @VisibleForTesting
    static void logInteractiveMessage(ILogger logger, InteractiveMessage message, File makeFileDirectory) {
        String CMAKE_ERROR_PREFIX = "CMake Error";
        String CMAKE_WARNING_PREFIX = "CMake Warning";
        if (message.type != null && message.type.equals("error")) {
            logger.error(null, CmakeServerExternalNativeJsonGenerator.correctMakefilePaths(message.errorMessage, makeFileDirectory), new Object[0]);
            return;
        }
        String correctedMessage = CmakeServerExternalNativeJsonGenerator.correctMakefilePaths(message.message, makeFileDirectory);
        if (message.title != null && message.title.equals("Error") || message.message.startsWith("CMake Error")) {
            logger.error(null, correctedMessage, new Object[0]);
            return;
        }
        if (message.title != null && message.title.equals("Warning") || message.message.startsWith("CMake Warning")) {
            logger.warning(correctedMessage, new Object[0]);
            return;
        }
        logger.info(correctedMessage, new Object[0]);
    }

    static void receiveDiagnosticMessage(PrintWriter writer, ILogger logger, String message) {
        writer.println(CMAKE_SERVER_LOG_PREFIX + message);
        logger.info(message, new Object[0]);
    }

    private void doHandshake(File sourceDirectory, File buildDirectory, Server cmakeServer) throws IOException {
        List<ProtocolVersion> supportedProtocolVersions = cmakeServer.getSupportedVersion();
        if (supportedProtocolVersions == null || supportedProtocolVersions.isEmpty()) {
            throw new RuntimeException(String.format("Gradle does not support the Cmake server version. %s", CmakeServerExternalNativeJsonGenerator.getCmakeInfoString(cmakeServer)));
        }
        HandshakeResult handshakeResult = cmakeServer.handshake(this.getHandshakeRequest(sourceDirectory, buildDirectory, supportedProtocolVersions.get(0)));
        if (!ServerUtils.isHandshakeResultValid(handshakeResult)) {
            throw new RuntimeException(String.format("Invalid handshake result from Cmake server: \n%s\n%s", CmakeUtils.getObjectToString(handshakeResult), CmakeServerExternalNativeJsonGenerator.getCmakeInfoString(cmakeServer)));
        }
    }

    private HandshakeRequest getHandshakeRequest(File sourceDirectory, File buildDirectory, ProtocolVersion cmakeServerProtocolVersion) {
        if (!sourceDirectory.isDirectory()) {
            LoggingEnvironmentKt.errorln("Not a directory: %s", sourceDirectory);
        }
        HandshakeRequest handshakeRequest = new HandshakeRequest();
        handshakeRequest.cookie = "gradle-cmake-cookie";
        handshakeRequest.generator = CmakeServerExternalNativeJsonGenerator.getGenerator(this.getBuildArguments());
        handshakeRequest.protocolVersion = cmakeServerProtocolVersion;
        handshakeRequest.buildDirectory = CmakeServerExternalNativeJsonGenerator.normalizeFilePath(buildDirectory);
        handshakeRequest.sourceDirectory = CmakeServerExternalNativeJsonGenerator.normalizeFilePath(sourceDirectory);
        return handshakeRequest;
    }

    private static ComputeResult doCompute(Server cmakeServer) throws IOException {
        return cmakeServer.compute();
    }

    private static String getGenerator(List<String> buildArguments) {
        String generatorArgument = "-G ";
        for (String argument : buildArguments) {
            if (!argument.startsWith(generatorArgument)) continue;
            int startIndex = argument.indexOf(generatorArgument) + generatorArgument.length();
            return argument.substring(startIndex);
        }
        return "Ninja";
    }

    private void generateAndroidGradleBuild(CxxAbiModel config2, Server cmakeServer) throws IOException {
        NativeBuildConfigValue nativeBuildConfigValue = this.getNativeBuildConfigValue(config2, cmakeServer);
        AndroidBuildGradleJsons.writeNativeBuildConfigValueToJsonFile(config2.getJsonFile(), nativeBuildConfigValue);
    }

    @VisibleForTesting
    protected NativeBuildConfigValue getNativeBuildConfigValue(CxxAbiModel abi, Server cmakeServer) throws IOException {
        NativeBuildConfigValue nativeBuildConfigValue = CmakeServerExternalNativeJsonGenerator.createDefaultNativeBuildConfigValue();
        assert (nativeBuildConfigValue.stringTable != null);
        StringTable strings = new StringTable(nativeBuildConfigValue.stringTable);
        assert (nativeBuildConfigValue.buildFiles != null);
        nativeBuildConfigValue.buildFiles.addAll(this.getBuildFiles(abi, cmakeServer));
        assert (nativeBuildConfigValue.cleanCommands != null);
        nativeBuildConfigValue.cleanCommands.add(CmakeUtils.getCleanCommand(this.cmake.getCmakeExe(), abi.getCxxBuildFolder()));
        assert (nativeBuildConfigValue.buildTargetsCommand != null);
        nativeBuildConfigValue.buildTargetsCommand = CmakeUtils.getBuildTargetsCommand(this.cmake.getCmakeExe(), abi.getCxxBuildFolder());
        CodeModel codeModel = cmakeServer.codemodel();
        if (!ServerUtils.isCodeModelValid(codeModel)) {
            throw new RuntimeException(String.format("Invalid code model received from Cmake server: \n%s\n%s", CmakeUtils.getObjectToString(codeModel), CmakeServerExternalNativeJsonGenerator.getCmakeInfoString(cmakeServer)));
        }
        assert (nativeBuildConfigValue.cFileExtensions != null);
        nativeBuildConfigValue.cFileExtensions.addAll(CmakeUtils.getCExtensionSet(codeModel));
        assert (nativeBuildConfigValue.cppFileExtensions != null);
        nativeBuildConfigValue.cppFileExtensions.addAll(CmakeUtils.getCppExtensionSet(codeModel));
        nativeBuildConfigValue.toolchains = CmakeServerExternalNativeJsonGenerator.getNativeToolchains(abi, cmakeServer, nativeBuildConfigValue.cppFileExtensions, nativeBuildConfigValue.cFileExtensions);
        String toolchainHashString = CmakeServerExternalNativeJsonGenerator.getOnlyToolchainName(nativeBuildConfigValue.toolchains);
        for (Configuration config2 : codeModel.configurations) {
            for (Project project : config2.projects) {
                for (Target target : project.targets) {
                    if (!CmakeServerExternalNativeJsonGenerator.canAddTargetToNativeLibrary(target)) continue;
                    NativeLibraryValue nativeLibraryValue = this.getNativeLibraryValue(abi, abi.getCxxBuildFolder(), target, strings);
                    nativeLibraryValue.toolchain = toolchainHashString;
                    String libraryName = target.name + "-" + config2.name + "-" + abi.getAbi().getTag();
                    assert (nativeBuildConfigValue.libraries != null);
                    nativeBuildConfigValue.libraries.put(libraryName, nativeLibraryValue);
                }
            }
        }
        return nativeBuildConfigValue;
    }

    @VisibleForTesting
    protected NativeLibraryValue getNativeLibraryValue(CxxAbiModel abi, File workingDirectory, Target target, StringTable strings) throws FileNotFoundException {
        return CmakeServerExternalNativeJsonGenerator.getNativeLibraryValue(this.cmake.getCmakeExe(), abi.getCxxBuildFolder(), this.isDebuggable(), new JsonReader((Reader)new FileReader(abi.getCompileCommandsJsonFile())), abi.getAbi().getTag(), workingDirectory, target, strings);
    }

    @VisibleForTesting
    static NativeLibraryValue getNativeLibraryValue(File cmakeExecutable, File outputFolder, boolean isDebuggable, JsonReader compileCommandsJson, String abi, File workingDirectory, Target target, StringTable strings) {
        NativeLibraryValue nativeLibraryValue = new NativeLibraryValue();
        nativeLibraryValue.abi = abi;
        nativeLibraryValue.buildCommand = CmakeUtils.getBuildCommand(cmakeExecutable, outputFolder, target.name);
        nativeLibraryValue.artifactName = target.name;
        String string = nativeLibraryValue.buildType = isDebuggable ? "debug" : "release";
        if (target.artifacts.length > 0) {
            nativeLibraryValue.output = new File(target.artifacts[0]);
        }
        nativeLibraryValue.files = new ArrayList<NativeSourceFileValue>();
        nativeLibraryValue.headers = new ArrayList<NativeHeaderFileValue>();
        Map<Object, Object> compilationDatabaseFlags = Maps.newHashMap();
        int workingDirectoryOrdinal = strings.intern(CmakeServerExternalNativeJsonGenerator.normalizeFilePath(workingDirectory));
        for (FileGroup fileGroup : target.fileGroups) {
            for (String source : fileGroup.sources) {
                File sourceFile;
                Path normalizedSourceFilePath;
                Path sourceFilePath = Paths.get(source, new String[0]);
                if (!sourceFilePath.isAbsolute()) {
                    sourceFilePath = Paths.get(target.sourceDirectory, source);
                }
                if (!(normalizedSourceFilePath = sourceFilePath.normalize()).toString().isEmpty()) {
                    sourceFilePath = normalizedSourceFilePath;
                }
                if (CmakeSourceFileNamingKt.hasCmakeHeaderFileExtensions(sourceFile = sourceFilePath.toFile())) {
                    nativeLibraryValue.headers.add(new NativeHeaderFileValue(sourceFile, workingDirectoryOrdinal));
                    continue;
                }
                NativeSourceFileValue nativeSourceFileValue = new NativeSourceFileValue();
                nativeSourceFileValue.workingDirectoryOrdinal = workingDirectoryOrdinal;
                nativeSourceFileValue.src = sourceFile;
                if (compilationDatabaseFlags.isEmpty()) {
                    compilationDatabaseFlags = CompilationDatabaseIndexingVisitorKt.indexCompilationDatabase(compileCommandsJson, strings);
                }
                if (compilationDatabaseFlags.containsKey(sourceFilePath.toString())) {
                    nativeSourceFileValue.flagsOrdinal = (Integer)compilationDatabaseFlags.get(sourceFilePath.toString());
                } else {
                    String compileFlags = CmakeServerExternalNativeJsonGenerator.compileFlagsFromFileGroup(fileGroup);
                    if (!Strings.isNullOrEmpty((String)compileFlags)) {
                        nativeSourceFileValue.flagsOrdinal = strings.intern(compileFlags);
                    }
                }
                nativeLibraryValue.files.add(nativeSourceFileValue);
            }
        }
        return nativeLibraryValue;
    }

    private static String compileFlagsFromFileGroup(FileGroup fileGroup) {
        StringBuilder flags = new StringBuilder();
        flags.append(fileGroup.compileFlags);
        if (fileGroup.defines != null) {
            for (String define : fileGroup.defines) {
                flags.append(" -D").append(define);
            }
        }
        if (fileGroup.includePath != null) {
            for (IncludePath includePath : fileGroup.includePath) {
                if (includePath == null || includePath.path == null) continue;
                if (includePath.isSystem != null && includePath.isSystem.booleanValue()) {
                    flags.append(" -system ");
                } else {
                    flags.append(" -I ");
                }
                flags.append(includePath.path);
            }
        }
        return flags.toString();
    }

    private static boolean canAddTargetToNativeLibrary(Target target) {
        return target.artifacts != null && target.fileGroups != null;
    }

    private List<File> getBuildFiles(CxxAbiModel config2, Server cmakeServer) throws IOException {
        CmakeInputsResult cmakeInputsResult = cmakeServer.cmakeInputs();
        if (!ServerUtils.isCmakeInputsResultValid(cmakeInputsResult)) {
            throw new RuntimeException(String.format("Invalid cmakeInputs result received from Cmake server: \n%s\n%s", CmakeUtils.getObjectToString(cmakeInputsResult), CmakeServerExternalNativeJsonGenerator.getCmakeInfoString(cmakeServer)));
        }
        if (cmakeInputsResult.buildFiles == null) {
            ArrayList buildFiles = Lists.newArrayList();
            buildFiles.add(this.getMakefile());
            return buildFiles;
        }
        HashSet buildSources = Sets.newHashSet();
        for (BuildFiles buildFile : cmakeInputsResult.buildFiles) {
            if (buildFile.isTemporary || buildFile.isCMake || buildFile.sources == null) continue;
            Collections.addAll(buildSources, buildFile.sources);
        }
        File sourceDirectory = null;
        if (cmakeInputsResult.sourceDirectory != null) {
            sourceDirectory = new File(cmakeInputsResult.sourceDirectory);
        }
        ArrayList buildFiles = Lists.newArrayList();
        for (String source : buildSources) {
            File sourceFile = new File(source);
            if (!sourceFile.isAbsolute() && sourceDirectory != null) {
                sourceFile = new File(sourceDirectory, source).getCanonicalFile();
            }
            if (!sourceFile.exists()) {
                LoggerWrapper logger = LoggerWrapper.getLogger(CmakeServerExternalNativeJsonGenerator.class);
                logger.error(null, "Build file " + sourceFile + " provided by CMake does not exists. This might lead to incorrect Android Studio behavior.", new Object[0]);
                continue;
            }
            if (sourceFile.getPath().startsWith(config2.getGradleBuildOutputFolder().getPath())) continue;
            buildFiles.add(sourceFile);
        }
        return buildFiles;
    }

    private static NativeBuildConfigValue createDefaultNativeBuildConfigValue() {
        NativeBuildConfigValue nativeBuildConfigValue = new NativeBuildConfigValue();
        nativeBuildConfigValue.buildFiles = new ArrayList<File>();
        nativeBuildConfigValue.cleanCommands = new ArrayList<String>();
        nativeBuildConfigValue.libraries = new HashMap<String, NativeLibraryValue>();
        nativeBuildConfigValue.toolchains = new HashMap<String, NativeToolchainValue>();
        nativeBuildConfigValue.cFileExtensions = new ArrayList<String>();
        nativeBuildConfigValue.cppFileExtensions = new ArrayList<String>();
        nativeBuildConfigValue.stringTable = Maps.newHashMap();
        return nativeBuildConfigValue;
    }

    private static Map<String, NativeToolchainValue> getNativeToolchains(CxxAbiModel abi, Server cmakeServer, Collection<String> cppExtensionSet, Collection<String> cExtensionSet) {
        NativeToolchainValue toolchainValue = new NativeToolchainValue();
        File cCompilerExecutable = null;
        File cppCompilerExecutable = null;
        File compilationDatabase = abi.getCompileCommandsJsonFile();
        if (compilationDatabase.exists()) {
            CompilationDatabaseToolchain toolchain = CompilationDatabaseToolchainVisitorKt.populateCompilationDatabaseToolchains(compilationDatabase, cppExtensionSet, cExtensionSet);
            cppCompilerExecutable = toolchain.getCppCompilerExecutable();
            cCompilerExecutable = toolchain.getCCompilerExecutable();
        } else {
            if (!cmakeServer.getCCompilerExecutable().isEmpty()) {
                cCompilerExecutable = new File(cmakeServer.getCCompilerExecutable());
            }
            if (!cmakeServer.getCppCompilerExecutable().isEmpty()) {
                cppCompilerExecutable = new File(cmakeServer.getCppCompilerExecutable());
            }
        }
        if (cCompilerExecutable != null) {
            toolchainValue.cCompilerExecutable = cCompilerExecutable;
        }
        if (cppCompilerExecutable != null) {
            toolchainValue.cppCompilerExecutable = cppCompilerExecutable;
        }
        int toolchainHash = CmakeUtils.getToolchainHash(toolchainValue);
        String toolchainHashString = UnsignedInts.toString((int)toolchainHash);
        HashMap<String, NativeToolchainValue> toolchains = new HashMap<String, NativeToolchainValue>();
        toolchains.put(toolchainHashString, toolchainValue);
        return toolchains;
    }

    private File getToolchainFile(CxxAbiModel abi) {
        if (this.variant.getModule().getNdkVersion().getMajor() >= 15) {
            return abi.getVariant().getModule().getCmakeToolchainFile();
        }
        return CmakeServerExternalNativeJsonGenerator.getPreNDKr15WrapperToolchainFile(abi);
    }

    private static File getPreNDKr15WrapperToolchainFile(CxxAbiModel abi) {
        StringBuilder tempAndroidToolchain = new StringBuilder("# This toolchain file was generated by Gradle to support NDK versions r14 and below.\n");
        tempAndroidToolchain.append(String.format("include(\"%s\")", CmakeServerExternalNativeJsonGenerator.normalizeFilePath(abi.getVariant().getModule().getCmakeToolchainFile()))).append(System.lineSeparator());
        tempAndroidToolchain.append("set(CMAKE_SYSTEM_VERSION 1)").append(System.lineSeparator());
        File toolchainFile = CmakeServerExternalNativeJsonGenerator.getTempToolchainFile(abi.getCxxBuildFolder());
        try {
            FileUtils.writeStringToFile((File)toolchainFile, (String)tempAndroidToolchain.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to write to file: %s.Please upgrade NDK to version 15 or above.", toolchainFile.getAbsolutePath()));
        }
        return toolchainFile;
    }

    private static File getTempToolchainFile(File outputFolder) {
        String tempAndroidToolchainFile = "pre-ndk-r15-wrapper-android.toolchain.cmake";
        return new File(outputFolder, tempAndroidToolchainFile);
    }

    private static String normalizeFilePath(File file) {
        if (CmakeServerExternalNativeJsonGenerator.isWindows()) {
            return file.getPath().replace("\\", "/");
        }
        return file.getPath();
    }
}

