/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.builder.compiling.ResValueGenerator;
import com.android.builder.model.ClassField;
import com.android.utils.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;

@CacheableTask
public class GenerateResValues
extends AndroidVariantTask {
    private File resOutputDir;
    private Supplier<List<Object>> items;

    @OutputDirectory
    public File getResOutputDir() {
        return this.resOutputDir;
    }

    public void setResOutputDir(File resOutputDir) {
        this.resOutputDir = resOutputDir;
    }

    @Internal
    public List<Object> getItems() {
        return this.items.get();
    }

    public void setItems(List<Object> items) {
        this.items = () -> items;
    }

    @Input
    public List<String> getItemValues() {
        List<Object> resolvedItems = this.getItems();
        ArrayList list = Lists.newArrayListWithCapacity((int)(resolvedItems.size() * 3));
        for (Object object : resolvedItems) {
            if (object instanceof String) {
                list.add((String)object);
                continue;
            }
            if (!(object instanceof ClassField)) continue;
            ClassField field = (ClassField)object;
            list.add(field.getType());
            list.add(field.getName());
            list.add(field.getValue());
        }
        return list;
    }

    @TaskAction
    void generate() throws IOException, ParserConfigurationException {
        File folder = this.getResOutputDir();
        List<Object> resolvedItems = this.getItems();
        if (resolvedItems.isEmpty()) {
            FileUtils.cleanOutputDir((File)folder);
        } else {
            ResValueGenerator generator = new ResValueGenerator(folder);
            generator.addItems(this.getItems());
            generator.generate();
        }
    }

    public static class CreationAction
    extends VariantTaskCreationAction<GenerateResValues> {
        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("generate", "ResValues");
        }

        @Override
        public Class<GenerateResValues> getType() {
            return GenerateResValues.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends GenerateResValues> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setGenerateResValuesTask(taskProvider);
        }

        @Override
        public void configure(GenerateResValues task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.items = TaskInputHelper.memoize(scope.getVariantConfiguration()::getResValues);
            task.setResOutputDir(scope.getGeneratedResOutputDir());
        }
    }
}

