/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.SyncOptions;
import com.android.build.gradle.tasks.ProcessApplicationManifest;
import com.android.build.gradle.tasks.ResourceException;
import com.android.builder.model.SourceProvider;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.resources.AssetMerger;
import com.android.ide.common.resources.AssetSet;
import com.android.ide.common.resources.DataSet;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.resources.FileValidity;
import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergedAssetWriter;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.WorkerExecutor;
import org.slf4j.Logger;

@CacheableTask
public class MergeSourceSetFolders
extends IncrementalTask {
    private final DirectoryProperty outputDir;
    private Supplier<Collection<File>> sourceFolderInputs;
    private Supplier<List<AssetSet>> assetSetSupplier;
    private ArtifactCollection libraries = null;
    private BuildableArtifact shadersOutputDir = null;
    private FileCollection copyApk = null;
    private String ignoreAssets = null;
    private SyncOptions.ErrorFormatMode errorFormatMode;
    private final FileValidity<AssetSet> fileValidity = new FileValidity();
    private final WorkerExecutorFacade workerExecutor;

    @OutputDirectory
    public DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    @Inject
    public MergeSourceSetFolders(WorkerExecutor workerExecutor, ObjectFactory objectFactory) {
        this.workerExecutor = Workers.INSTANCE.preferWorkers(this.getProject().getName(), this.getPath(), workerExecutor);
        this.outputDir = objectFactory.directoryProperty();
    }

    @Override
    @Internal
    protected boolean isIncremental() {
        return true;
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        File destinationDir = ((Directory)this.getOutputDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)destinationDir);
        List<AssetSet> assetSets = this.computeAssetSetList();
        AssetMerger merger = new AssetMerger();
        LoggerWrapper logger = new LoggerWrapper(this.getLogger());
        try (WorkerExecutorFacade workerExecutor = this.workerExecutor;){
            for (AssetSet assetSet : assetSets) {
                assetSet.loadFromFiles((ILogger)logger);
                merger.addDataSet((DataSet)assetSet);
            }
            MergedAssetWriter writer = new MergedAssetWriter(destinationDir, workerExecutor);
            merger.mergeData((MergeConsumer)writer, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false);
        }
        catch (Exception e) {
            MergingException.findAndReportMergingException((Exception)e, (MessageReceiver)new MessageReceiverImpl(this.errorFormatMode, (Logger)this.getLogger()));
            try {
                throw e;
            }
            catch (MergingException mergingException) {
                merger.cleanBlob(this.getIncrementalFolder());
                throw new ResourceException(mergingException.getMessage(), mergingException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws IOException {
        AssetMerger merger = new AssetMerger();
        try (WorkerExecutorFacade workerExecutor = this.workerExecutor;){
            if (!merger.loadFromBlob(this.getIncrementalFolder(), true)) {
                this.doFullTaskAction();
                return;
            }
            List<AssetSet> assetSets = this.computeAssetSetList();
            if (!merger.checkValidUpdate(assetSets)) {
                this.getLogger().info("Changed Asset sets: full task run!");
                this.doFullTaskAction();
                return;
            }
            LoggerWrapper logger = new LoggerWrapper(this.getLogger());
            for (Map.Entry<File, FileStatus> entry : changedInputs.entrySet()) {
                File changedFile = entry.getKey();
                if (changedFile.isDirectory()) continue;
                merger.findDataSetContaining(changedFile, this.fileValidity);
                if (this.fileValidity.getStatus() == FileValidity.FileStatus.UNKNOWN_FILE) {
                    this.doFullTaskAction();
                    return;
                }
                if (this.fileValidity.getStatus() != FileValidity.FileStatus.VALID_FILE || ((AssetSet)this.fileValidity.getDataSet()).updateWith(this.fileValidity.getSourceFile(), changedFile, entry.getValue(), (ILogger)logger)) continue;
                this.getLogger().info("Failed to process {} event! Full task run", (Object)entry.getValue());
                this.doFullTaskAction();
                return;
            }
            MergedAssetWriter writer = new MergedAssetWriter(((Directory)this.getOutputDir().get()).getAsFile(), workerExecutor);
            merger.mergeData((MergeConsumer)writer, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false);
            return;
        }
        catch (Exception e) {
            MergingException.findAndReportMergingException((Exception)e, (MessageReceiver)new MessageReceiverImpl(this.errorFormatMode, (Logger)this.getLogger()));
            try {
                throw e;
            }
            catch (MergingException mergingException) {
                merger.cleanBlob(this.getIncrementalFolder());
                throw new ResourceException(mergingException.getMessage(), mergingException);
            }
        }
        finally {
            this.fileValidity.clear();
        }
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getLibraries() {
        if (this.libraries != null) {
            return this.libraries.getArtifactFiles();
        }
        return null;
    }

    @VisibleForTesting
    public void setLibraries(ArtifactCollection libraries) {
        this.libraries = libraries;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public BuildableArtifact getShadersOutputDir() {
        return this.shadersOutputDir;
    }

    @VisibleForTesting
    void setShadersOutputDir(BuildableArtifact shadersOutputDir) {
        this.shadersOutputDir = shadersOutputDir;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getCopyApk() {
        return this.copyApk;
    }

    @VisibleForTesting
    void setCopyApk(FileCollection copyApk) {
        this.copyApk = copyApk;
    }

    @Input
    @Optional
    public String getIgnoreAssets() {
        return this.ignoreAssets;
    }

    @VisibleForTesting
    void setAssetSetSupplier(Supplier<List<AssetSet>> assetSetSupplier) {
        this.assetSetSupplier = assetSetSupplier;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Collection<File> getSourceFolderInputs() {
        return this.sourceFolderInputs.get();
    }

    @VisibleForTesting
    List<AssetSet> computeAssetSetList() {
        ArrayList assetSetList;
        ArrayList assetSets = this.assetSetSupplier.get();
        if (this.copyApk == null && this.shadersOutputDir == null && this.ignoreAssets == null && this.libraries == null) {
            assetSetList = assetSets;
        } else {
            int size = assetSets.size() + 3;
            if (this.libraries != null) {
                size += this.libraries.getArtifacts().size();
            }
            assetSetList = Lists.newArrayListWithExpectedSize((int)size);
            if (this.libraries != null) {
                Set libArtifacts = this.libraries.getArtifacts();
                for (ResolvedArtifactResult artifact : libArtifacts) {
                    AssetSet assetSet = new AssetSet(ProcessApplicationManifest.getArtifactName(artifact));
                    assetSet.addSource(artifact.getFile());
                    assetSetList.add(0, assetSet);
                }
            }
            ArrayList generatedAssetFolders = Lists.newArrayList();
            if (this.shadersOutputDir != null) {
                generatedAssetFolders.addAll(this.shadersOutputDir.getFiles());
            }
            if (this.copyApk != null) {
                generatedAssetFolders.addAll(this.copyApk.getFiles());
            }
            AssetSet mainAssetSet = (AssetSet)assetSets.get(0);
            assert (mainAssetSet.getConfigName().equals("main"));
            mainAssetSet.addSources((Collection)generatedAssetFolders);
            assetSetList.addAll(assetSets);
        }
        if (this.ignoreAssets != null) {
            for (AssetSet set : assetSetList) {
                set.setIgnoredPatterns(this.ignoreAssets);
            }
        }
        return assetSetList;
    }

    public static class MergeShaderSourceFoldersCreationAction
    extends CreationAction {
        public MergeShaderSourceFoldersCreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("merge", "Shaders");
        }

        @Override
        public void handleProvider(TaskProvider<? extends MergeSourceSetFolders> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.MERGED_SHADERS, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, (Provider<Property<Directory>>)taskProvider.map(MergeSourceSetFolders::getOutputDir), "out");
        }

        @Override
        public void configure(MergeSourceSetFolders mergeAssetsTask) {
            super.configure(mergeAssetsTask);
            BaseVariantData variantData = this.getVariantScope().getVariantData();
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            Function<SourceProvider, Collection> assetDirFunction = SourceProvider::getShadersDirectories;
            mergeAssetsTask.assetSetSupplier = () -> variantConfig.getSourceFilesAsAssetSets(assetDirFunction);
            mergeAssetsTask.sourceFolderInputs = () -> variantConfig.getSourceFiles(assetDirFunction);
        }
    }

    public static class MergeJniLibFoldersCreationAction
    extends CreationAction {
        public MergeJniLibFoldersCreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("merge", "JniLibFolders");
        }

        @Override
        public void handleProvider(TaskProvider<? extends MergeSourceSetFolders> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.MERGED_JNI_LIBS, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, (Provider<Property<Directory>>)taskProvider.map(MergeSourceSetFolders::getOutputDir), "out");
        }

        @Override
        public void configure(MergeSourceSetFolders mergeAssetsTask) {
            super.configure(mergeAssetsTask);
            BaseVariantData variantData = this.getVariantScope().getVariantData();
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            Function<SourceProvider, Collection> assetDirFunction = SourceProvider::getJniLibsDirectories;
            mergeAssetsTask.assetSetSupplier = () -> variantConfig.getSourceFilesAsAssetSets(assetDirFunction);
            mergeAssetsTask.sourceFolderInputs = () -> variantConfig.getSourceFiles(assetDirFunction);
        }
    }

    public static class LibraryAssetCreationAction
    extends MergeAssetBaseCreationAction {
        public LibraryAssetCreationAction(VariantScope scope) {
            super(scope, InternalArtifactType.LIBRARY_ASSETS, false);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("package", "Assets");
        }
    }

    public static class MergeAppAssetCreationAction
    extends MergeAssetBaseCreationAction {
        public MergeAppAssetCreationAction(VariantScope scope) {
            super(scope, InternalArtifactType.MERGED_ASSETS, true);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("merge", "Assets");
        }
    }

    public static class MergeAssetBaseCreationAction
    extends CreationAction {
        final boolean includeDependencies;
        final ArtifactType outputArtifactType;

        public MergeAssetBaseCreationAction(VariantScope scope, ArtifactType outputArtifactType, boolean includeDependencies) {
            super(scope);
            this.outputArtifactType = outputArtifactType;
            this.includeDependencies = includeDependencies;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("merge", "Assets");
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
        }

        @Override
        public void handleProvider(TaskProvider<? extends MergeSourceSetFolders> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getArtifacts().producesDir(this.outputArtifactType, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, (Provider<Property<Directory>>)taskProvider.map(MergeSourceSetFolders::getOutputDir), "out");
            this.getVariantScope().getTaskContainer().setMergeAssetsTask(taskProvider);
        }

        @Override
        public void configure(MergeSourceSetFolders task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            BaseVariantData variantData = scope.getVariantData();
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            Function<SourceProvider, Collection> assetDirFunction = SourceProvider::getAssetsDirectories;
            task.assetSetSupplier = () -> variantConfig.getSourceFilesAsAssetSets(assetDirFunction);
            task.sourceFolderInputs = () -> variantConfig.getSourceFiles(assetDirFunction);
            task.shadersOutputDir = scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.SHADER_ASSETS);
            AaptOptions options = scope.getGlobalScope().getExtension().getAaptOptions();
            if (options != null) {
                task.ignoreAssets = options.getIgnoreAssets();
            }
            if (this.includeDependencies) {
                task.libraries = scope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ASSETS);
            }
            task.dependsOn(new Object[]{scope.getTaskContainer().getAssetGenTask()});
        }
    }

    protected static abstract class CreationAction
    extends VariantTaskCreationAction<MergeSourceSetFolders> {
        protected CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public Class<MergeSourceSetFolders> getType() {
            return MergeSourceSetFolders.class;
        }

        @Override
        public void configure(MergeSourceSetFolders task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.setIncrementalFolder(scope.getIncrementalDir(this.getName()));
            task.errorFormatMode = SyncOptions.getErrorFormatMode(scope.getGlobalScope().getProjectOptions());
        }
    }
}

