/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.manifest;

import com.android.build.gradle.internal.tasks.manifest.ManifestHelperKt$WhenMappings;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestProvider;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u00ed\u0001\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00032\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"\u001a\u001a\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\n2\u0006\u0010&\u001a\u00020\u0003H\u0002\u001aS\u0010'\u001a\u00020$2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010*\u00a8\u0006+"}, d2={"mergeManifestsForApplication", "Lcom/android/manifmerger/MergingReport;", "mainManifest", "Ljava/io/File;", "manifestOverlays", "", "dependencies", "Lcom/android/manifmerger/ManifestProvider;", "navigationFiles", "featureName", "", "packageOverride", "versionCode", "", "versionName", "minSdkVersion", "targetSdkVersion", "maxSdkVersion", "outManifestLocation", "outAaptSafeManifestLocation", "outMetadataFeatureManifestLocation", "outBundleManifestLocation", "outInstantAppManifestLocation", "mergeType", "Lcom/android/manifmerger/ManifestMerger2$MergeType;", "placeHolders", "", "", "optionalFeatures", "", "Lcom/android/manifmerger/ManifestMerger2$Invoker$Feature;", "reportFile", "logger", "Lcom/android/utils/ILogger;", "(Ljava/io/File;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/android/manifmerger/ManifestMerger2$MergeType;Ljava/util/Map;Ljava/util/Collection;Ljava/io/File;Lcom/android/utils/ILogger;)Lcom/android/manifmerger/MergingReport;", "save", "", "xmlDocument", "out", "setInjectableValues", "invoker", "Lcom/android/manifmerger/ManifestMerger2$Invoker;", "(Lcom/android/manifmerger/ManifestMerger2$Invoker;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)V", "gradle"})
public final class ManifestHelperKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final MergingReport mergeManifestsForApplication(@NotNull File mainManifest, @NotNull List<? extends File> manifestOverlays, @NotNull List<? extends ManifestProvider> dependencies, @NotNull List<? extends File> navigationFiles, @Nullable String featureName, @Nullable String packageOverride, int versionCode, @Nullable String versionName, @Nullable String minSdkVersion, @Nullable String targetSdkVersion, @Nullable Integer maxSdkVersion, @NotNull String outManifestLocation, @Nullable String outAaptSafeManifestLocation, @Nullable String outMetadataFeatureManifestLocation, @Nullable String outBundleManifestLocation, @Nullable String outInstantAppManifestLocation, @NotNull ManifestMerger2.MergeType mergeType, @NotNull Map<String, ? extends Object> placeHolders, @NotNull Collection<? extends ManifestMerger2.Invoker.Feature> optionalFeatures, @Nullable File reportFile, @NotNull ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)mainManifest, (String)"mainManifest");
        Intrinsics.checkParameterIsNotNull(manifestOverlays, (String)"manifestOverlays");
        Intrinsics.checkParameterIsNotNull(dependencies, (String)"dependencies");
        Intrinsics.checkParameterIsNotNull(navigationFiles, (String)"navigationFiles");
        Intrinsics.checkParameterIsNotNull((Object)outManifestLocation, (String)"outManifestLocation");
        Intrinsics.checkParameterIsNotNull((Object)mergeType, (String)"mergeType");
        Intrinsics.checkParameterIsNotNull(placeHolders, (String)"placeHolders");
        Intrinsics.checkParameterIsNotNull(optionalFeatures, (String)"optionalFeatures");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        try {
            Collection<? extends ManifestMerger2.Invoker.Feature> $this$toTypedArray$iv;
            Collection collection = manifestOverlays;
            ManifestMerger2.Invoker invoker = ManifestMerger2.newMerger((File)mainManifest, (ILogger)logger, (ManifestMerger2.MergeType)mergeType).setPlaceHolderValues(placeHolders);
            boolean $i$f$toTypedArray = false;
            Collection<? extends ManifestMerger2.Invoker.Feature> thisCollection$iv = $this$toTypedArray$iv;
            File[] fileArray = thisCollection$iv.toArray(new File[0]);
            if (fileArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            File[] fileArray2 = fileArray;
            $this$toTypedArray$iv = optionalFeatures;
            invoker = invoker.addFlavorAndBuildTypeManifests(Arrays.copyOf(fileArray2, fileArray2.length)).addManifestProviders((Iterable)dependencies).addNavigationFiles((Iterable)navigationFiles);
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            ManifestMerger2.Invoker.Feature[] featureArray = thisCollection$iv.toArray(new ManifestMerger2.Invoker.Feature[0]);
            if (featureArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            fileArray2 = featureArray;
            ManifestMerger2.Invoker.Feature[] featureArray2 = (ManifestMerger2.Invoker.Feature[])fileArray2;
            ManifestMerger2.Invoker manifestMergerInvoker = invoker.withFeatures(Arrays.copyOf(featureArray2, featureArray2.length)).setMergeReportFile(reportFile).setFeatureName(featureName);
            if (mergeType == ManifestMerger2.MergeType.APPLICATION) {
                manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS});
            }
            if (outAaptSafeManifestLocation != null) {
                manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.MAKE_AAPT_SAFE});
            }
            ManifestMerger2.Invoker invoker2 = manifestMergerInvoker;
            Intrinsics.checkExpressionValueIsNotNull((Object)invoker2, (String)"manifestMergerInvoker");
            ManifestHelperKt.setInjectableValues(invoker2, packageOverride, versionCode, versionName, minSdkVersion, targetSdkVersion, maxSdkVersion);
            MergingReport mergingReport = manifestMergerInvoker.merge();
            Object[] objectArray = new Object[1];
            MergingReport mergingReport2 = mergingReport;
            Intrinsics.checkExpressionValueIsNotNull((Object)mergingReport2, (String)"mergingReport");
            objectArray[0] = mergingReport2.getResult();
            logger.verbose("Merging result: %1$s", objectArray);
            MergingReport.Result result = mergingReport.getResult();
            if (result == null) throw (Throwable)new RuntimeException("Unhandled result type : " + mergingReport.getResult());
            switch (ManifestHelperKt$WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
                case 1: {
                    String instantAppManifest;
                    String bundleMergedManifest;
                    String featureManifest;
                    mergingReport.log(logger);
                    String xmlDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.MERGED);
                    String annotatedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.BLAME);
                    if (annotatedDocument != null) {
                        logger.verbose(annotatedDocument, new Object[0]);
                    }
                    ManifestHelperKt.save(xmlDocument, new File(outManifestLocation));
                    logger.verbose("Merged manifest saved to " + outManifestLocation, new Object[0]);
                    if (outAaptSafeManifestLocation != null) {
                        ManifestHelperKt.save(mergingReport.getMergedDocument(MergingReport.MergedManifestKind.AAPT_SAFE), new File(outAaptSafeManifestLocation));
                    }
                    if (outMetadataFeatureManifestLocation != null && (featureManifest = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.METADATA_FEATURE)) != null) {
                        ManifestHelperKt.save(featureManifest, new File(outMetadataFeatureManifestLocation));
                    }
                    if (outBundleManifestLocation != null && (bundleMergedManifest = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.BUNDLE)) != null) {
                        ManifestHelperKt.save(bundleMergedManifest, new File(outBundleManifestLocation));
                    }
                    if (outInstantAppManifestLocation == null || (instantAppManifest = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.INSTANT_APP)) == null) return mergingReport;
                    ManifestHelperKt.save(instantAppManifest, new File(outInstantAppManifestLocation));
                    return mergingReport;
                }
                case 2: {
                    String instantAppManifest;
                    String bundleMergedManifest;
                    String featureManifest;
                    String xmlDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.MERGED);
                    String annotatedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.BLAME);
                    if (annotatedDocument != null) {
                        logger.verbose(annotatedDocument, new Object[0]);
                    }
                    ManifestHelperKt.save(xmlDocument, new File(outManifestLocation));
                    logger.verbose("Merged manifest saved to " + outManifestLocation, new Object[0]);
                    if (outAaptSafeManifestLocation != null) {
                        ManifestHelperKt.save(mergingReport.getMergedDocument(MergingReport.MergedManifestKind.AAPT_SAFE), new File(outAaptSafeManifestLocation));
                    }
                    if (outMetadataFeatureManifestLocation != null && (featureManifest = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.METADATA_FEATURE)) != null) {
                        ManifestHelperKt.save(featureManifest, new File(outMetadataFeatureManifestLocation));
                    }
                    if (outBundleManifestLocation != null && (bundleMergedManifest = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.BUNDLE)) != null) {
                        ManifestHelperKt.save(bundleMergedManifest, new File(outBundleManifestLocation));
                    }
                    if (outInstantAppManifestLocation == null || (instantAppManifest = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.INSTANT_APP)) == null) return mergingReport;
                    ManifestHelperKt.save(instantAppManifest, new File(outInstantAppManifestLocation));
                    return mergingReport;
                }
                case 3: {
                    mergingReport.log(logger);
                    throw (Throwable)new RuntimeException(mergingReport.getReportString());
                }
                default: {
                    throw (Throwable)new RuntimeException("Unhandled result type : " + mergingReport.getResult());
                }
            }
        }
        catch (ManifestMerger2.MergeFailureException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    private static final void setInjectableValues(ManifestMerger2.Invoker<?> invoker, String packageOverride, int versionCode, String versionName, String minSdkVersion, String targetSdkVersion, Integer maxSdkVersion) {
        boolean bl;
        CharSequence charSequence;
        if (packageOverride != null) {
            charSequence = packageOverride;
            bl = false;
            if (charSequence.length() > 0) {
                invoker.setOverride(ManifestSystemProperty.PACKAGE, packageOverride);
            }
        }
        if (versionCode > 0) {
            invoker.setOverride(ManifestSystemProperty.VERSION_CODE, String.valueOf(versionCode));
        }
        if (versionName != null) {
            charSequence = versionName;
            bl = false;
            if (charSequence.length() > 0) {
                invoker.setOverride(ManifestSystemProperty.VERSION_NAME, versionName);
            }
        }
        if (minSdkVersion != null) {
            charSequence = minSdkVersion;
            bl = false;
            if (charSequence.length() > 0) {
                invoker.setOverride(ManifestSystemProperty.MIN_SDK_VERSION, minSdkVersion);
            }
        }
        if (targetSdkVersion != null) {
            charSequence = targetSdkVersion;
            bl = false;
            if (charSequence.length() > 0) {
                invoker.setOverride(ManifestSystemProperty.TARGET_SDK_VERSION, targetSdkVersion);
            }
        }
        if (maxSdkVersion != null) {
            invoker.setOverride(ManifestSystemProperty.MAX_SDK_VERSION, String.valueOf(maxSdkVersion));
        }
    }

    private static final void save(String xmlDocument, File out) {
        try {
            Files.createParentDirs((File)out);
            CharSink charSink = Files.asCharSink((File)out, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]);
            String string = xmlDocument;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            charSink.write((CharSequence)string);
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }
}

