/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.builder.utils.FileCache;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

public class CleanBuildCache
extends DefaultTask {
    private FileCache buildCache;

    public void setBuildCache(FileCache buildCache) {
        this.buildCache = buildCache;
    }

    @TaskAction
    public void clean() throws IOException {
        Preconditions.checkNotNull((Object)this.buildCache, (Object)"buildCache must not be null");
        this.buildCache.delete();
    }

    public static final class CreationAction
    extends TaskCreationAction<CleanBuildCache> {
        private final GlobalScope globalScope;

        public CreationAction(GlobalScope globalScope) {
            this.globalScope = globalScope;
        }

        @Override
        public String getName() {
            return "cleanBuildCache";
        }

        @Override
        public Class<CleanBuildCache> getType() {
            return CleanBuildCache.class;
        }

        @Override
        public void configure(CleanBuildCache task) {
            Preconditions.checkNotNull((Object)this.globalScope.getBuildCache());
            task.setDescription("Deletes the build cache directory.");
            task.setGroup("build");
            task.setBuildCache(this.globalScope.getBuildCache());
        }
    }
}

