/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.logging;

import com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a%\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0002\u0010\u0006\u001a'\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\t\u001a'\u0010\n\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\t\u001a'\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\t\u00a8\u0006\f"}, d2={"checkedFormat", "", "format", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "errorln", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "infoln", "warnln", "gradle"})
public final class LoggingEnvironmentKt {
    public static final void errorln(@NotNull String format, Object ... args2) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
        ThreadLoggingEnvironment.Companion.reportFormattedErrorToCurrentLogger(LoggingEnvironmentKt.checkedFormat(format, args2));
    }

    public static final void warnln(@NotNull String format, Object ... args2) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
        ThreadLoggingEnvironment.Companion.reportFormattedWarningToCurrentLogger(LoggingEnvironmentKt.checkedFormat(format, args2));
    }

    public static final void infoln(@NotNull String format, Object ... args2) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
        ThreadLoggingEnvironment.Companion.reportFormattedInfoToCurrentLogger(LoggingEnvironmentKt.checkedFormat(format, args2));
    }

    private static final String checkedFormat(String format, Object[] args2) {
        try {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = Arrays.copyOf(args2, args2.length);
            boolean bl = false;
            String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            return string;
        }
        catch (Throwable e) {
            StringBuilder stringBuilder = new StringBuilder().append("\n            ").append(e.getMessage()).append("\n            format = ").append(format).append("\n            args[").append(args2.length).append("] = ").append(ArraysKt.joinToString$default((Object[])args2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).append("\n            stacktrace = ");
            Object[] objectArray = e.getStackTrace();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"e.stackTrace");
            String string = StringsKt.trimIndent((String)stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString());
            boolean bl = false;
            System.out.println((Object)string);
            throw e;
        }
    }

    public static final /* synthetic */ String access$checkedFormat(String format, Object[] args2) {
        return LoggingEnvironmentKt.checkedFormat(format, args2);
    }
}

