/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.packaging;

import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.tools.build.apkzlib.zfile.ApkZFileCreatorFactory;
import com.android.tools.build.apkzlib.zip.Compressor;
import com.android.tools.build.apkzlib.zip.ZFileOptions;
import com.android.tools.build.apkzlib.zip.compress.BestAndDefaultDeflateExecutorCompressor;
import com.android.tools.build.apkzlib.zip.compress.DeflateExecutionCompressor;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ApkCreatorFactories {
    private static final long BACKGROUND_THREAD_DISCARD_TIME_MS = 100L;
    private static final int MAXIMUM_COMPRESSION_THREADS = 2;

    private ApkCreatorFactories() {
    }

    public static ApkCreatorFactory fromProjectProperties(boolean keepTimestampsInApk, boolean debuggableBuild) {
        ZFileOptions options = new ZFileOptions();
        options.setNoTimestamps(!keepTimestampsInApk);
        options.setCoverEmptySpaceUsingExtraField(true);
        ThreadPoolExecutor compressionExecutor = new ThreadPoolExecutor(0, 2, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>());
        if (debuggableBuild) {
            options.setCompressor((Compressor)new DeflateExecutionCompressor((Executor)compressionExecutor, options.getTracker(), 1));
        } else {
            options.setCompressor((Compressor)new BestAndDefaultDeflateExecutorCompressor((Executor)compressionExecutor, options.getTracker(), 1.0));
            options.setAutoSortFiles(true);
        }
        return new ApkZFileCreatorFactory(options);
    }
}

