/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.ApplicationTaskManager;
import com.android.build.gradle.internal.feature.BundleAllClasses;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.profile.Recorder;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class FeatureTaskManager
extends ApplicationTaskManager {
    public FeatureTaskManager(GlobalScope globalScope, Project project2, ProjectOptions projectOptions, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, VariantFactory variantFactory, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project2, projectOptions, dataBindingBuilder, extension, variantFactory, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(VariantScope variantScope) {
        super.createTasksForVariantScope(variantScope);
        AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)variantScope.getGlobalScope().getExtension().getCompileSdkVersion());
        if (androidVersion == null || androidVersion.getApiLevel() < 26) {
            String message = "Feature modules require compileSdkVersion set to 26 or higher.";
            if (androidVersion != null) {
                message = message + " compileSdkVersion is set to " + androidVersion.getApiString();
            }
            this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException(message));
        }
        if (this.extension.getDataBinding().isEnabled() && !this.extension.getBaseFeature().booleanValue()) {
            String experimentalBinding = BooleanOption.ENABLE_EXPERIMENTAL_FEATURE_DATABINDING.getPropertyName();
            if (this.projectOptions.get(BooleanOption.ENABLE_EXPERIMENTAL_FEATURE_DATABINDING)) {
                this.globalScope.getErrorHandler().reportWarning(EvalIssueReporter.Type.GENERIC, "Data binding support for non-base features is experimental and is not supported.");
            } else {
                this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Currently, data binding does not work for non-base features. Move data binding code to the base feature module.\nSee https://issuetracker.google.com/63814741.\nTo enable data binding with non-base features, set the " + experimentalBinding + " properties to true."));
            }
        }
        this.globalScope.getErrorHandler().reportWarning(EvalIssueReporter.Type.PLUGIN_OBSOLETE, "The com.android.feature plugin is deprecated and will be removed by the end of 2019. Please switch to using dynamic-features or libraries. For more information on converting your application to using Android App Bundles, please visit https://developer.android.com/topic/google-play-instant/feature-module-migration");
    }

    @Override
    protected void postJavacCreation(VariantScope scope) {
        this.taskFactory.register(new BundleAllClasses.CreationAction(scope));
    }
}

