/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TransformInputUtil {
    public static Collection<File> getAllFiles(Iterable<TransformInput> transformInputs) {
        return TransformInputUtil.getAllFiles(transformInputs, true, true);
    }

    public static Collection<File> getDirectories(Iterable<TransformInput> transformInputs) {
        return TransformInputUtil.getAllFiles(transformInputs, true, false);
    }

    static Collection<File> getAllFiles(Iterable<TransformInput> transformInputs, boolean includeDirectoryInput, boolean includeJarInput) {
        ImmutableList.Builder inputFiles2 = ImmutableList.builder();
        for (TransformInput input : transformInputs) {
            if (includeDirectoryInput) {
                for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                    if (!directoryInput.getFile().isDirectory()) continue;
                    inputFiles2.add((Object)directoryInput.getFile());
                }
            }
            if (!includeJarInput) continue;
            for (JarInput jarInput : input.getJarInputs()) {
                if (!jarInput.getFile().isFile()) continue;
                inputFiles2.add((Object)jarInput.getFile());
            }
        }
        return inputFiles2.build();
    }

    public static Map<Status, Set<File>> getByStatus(DirectoryInput dir) {
        Map<Status, Set<File>> byStatus = dir.getChangedFiles().entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
        for (Status status : Status.values()) {
            byStatus.putIfAbsent(status, (Set<File>)ImmutableSet.of());
        }
        return byStatus;
    }
}

