/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.tasks.AnnotationProcessingTaskCreationAction;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessApplicationManifest;
import com.android.builder.internal.TestManifestGenerator;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestProvider;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskProvider;

public abstract class ProcessTestManifest
extends ManifestProcessorTask {
    private FileCollection testTargetMetadata;
    private File testManifestFile;
    private boolean onlyTestApk;
    private File tmpDir;
    private Supplier<String> testApplicationId;
    private Supplier<String> testedApplicationId;
    private Supplier<String> minSdkVersion;
    private Supplier<String> targetSdkVersion;
    private Supplier<String> instrumentationRunner;
    private Supplier<Boolean> handleProfiling;
    private Supplier<Boolean> functionalTest;
    private Supplier<Map<String, Object>> placeholdersValues;
    private ArtifactCollection manifests;
    private Supplier<String> testLabel;
    private OutputScope outputScope;

    @Inject
    public ProcessTestManifest(ObjectFactory objectFactory) {
        super(objectFactory);
    }

    public OutputScope getOutputScope() {
        return this.outputScope;
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        List<ApkData> apkDatas;
        if (this.testedApplicationId == null && this.testTargetMetadata == null) {
            throw new RuntimeException("testedApplicationId and testTargetMetadata are null");
        }
        String testedApplicationId = this.getTestedApplicationId();
        if (!this.onlyTestApk && this.testTargetMetadata != null) {
            BuildElements manifestOutputs = ExistingBuildElements.from((ArtifactType)InternalArtifactType.MERGED_MANIFESTS, this.testTargetMetadata.getSingleFile());
            java.util.Optional<BuildOutput> mainSplit = manifestOutputs.stream().filter(output2 -> output2.getApkData().getType() != VariantOutput.OutputType.SPLIT).findFirst();
            if (mainSplit.isPresent()) {
                testedApplicationId = mainSplit.get().getProperties().get("packageId");
            } else {
                throw new RuntimeException("cannot find main APK");
            }
        }
        if ((apkDatas = this.outputScope.getApkDatas()).isEmpty()) {
            throw new RuntimeException("No output defined for test module, please file a bug");
        }
        if (apkDatas.size() > 1) {
            throw new RuntimeException("Test modules only support a single split, this one defines" + Joiner.on((String)",").join(apkDatas));
        }
        ApkData mainApkData = apkDatas.get(0);
        File manifestOutputFolder = Strings.isNullOrEmpty((String)mainApkData.getDirName()) ? ((Directory)this.getManifestOutputDirectory().get()).getAsFile() : ((Directory)this.getManifestOutputDirectory().get()).file(mainApkData.getDirName()).getAsFile();
        FileUtils.mkdirs((File)manifestOutputFolder);
        File manifestOutputFile = new File(manifestOutputFolder, "AndroidManifest.xml");
        this.mergeManifestsForTestVariant(this.getTestApplicationId(), this.getMinSdkVersion(), this.getTargetSdkVersion(), testedApplicationId, this.getInstrumentationRunner(), this.getHandleProfiling(), this.getFunctionalTest(), this.getTestLabel(), this.getTestManifestFile(), this.computeProviders(), this.getPlaceholdersValues(), manifestOutputFile, this.getTmpDir());
        new BuildElements((Collection<BuildOutput>)ImmutableList.of((Object)new BuildOutput(InternalArtifactType.MERGED_MANIFESTS, mainApkData, manifestOutputFile))).save(((Directory)this.getManifestOutputDirectory().get()).getAsFile());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mergeManifestsForTestVariant(String testApplicationId, String minSdkVersion, String targetSdkVersion, String testedApplicationId, String instrumentationRunner, Boolean handleProfiling, Boolean functionalTest, String testLabel, File testManifestFile, List<? extends ManifestProvider> manifestProviders, Map<String, Object> manifestPlaceholders, File outManifest, File tmpDir) {
        Preconditions.checkNotNull((Object)testApplicationId, (Object)"testApplicationId cannot be null.");
        Preconditions.checkNotNull((Object)testedApplicationId, (Object)"testedApplicationId cannot be null.");
        Preconditions.checkNotNull((Object)instrumentationRunner, (Object)"instrumentationRunner cannot be null.");
        Preconditions.checkNotNull((Object)handleProfiling, (Object)"handleProfiling cannot be null.");
        Preconditions.checkNotNull((Object)functionalTest, (Object)"functionalTest cannot be null.");
        Preconditions.checkNotNull(manifestProviders, (Object)"manifestProviders cannot be null.");
        Preconditions.checkNotNull((Object)outManifest, (Object)"outManifestLocation cannot be null.");
        LoggerWrapper logger = new LoggerWrapper(this.getLogger());
        File tempFile1 = null;
        File tempFile2 = null;
        try {
            FileUtils.mkdirs((File)tmpDir);
            File generatedTestManifest = manifestProviders.isEmpty() && testManifestFile == null ? outManifest : (tempFile1 = File.createTempFile("manifestMerger", ".xml", tmpDir));
            logger.verbose("Generating in %1$s", new Object[]{generatedTestManifest.getAbsolutePath()});
            ProcessTestManifest.generateTestManifest(testApplicationId, minSdkVersion, targetSdkVersion.equals("-1") ? null : targetSdkVersion, testedApplicationId, instrumentationRunner, handleProfiling, functionalTest, generatedTestManifest);
            if (testManifestFile != null && testManifestFile.exists()) {
                ManifestMerger2.Invoker invoker = ManifestMerger2.newMerger((File)testManifestFile, (ILogger)logger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).setPlaceHolderValues(manifestPlaceholders).setPlaceHolderValue("instrumentationRunner", instrumentationRunner).addLibraryManifest(generatedTestManifest);
                invoker.setOverride(ManifestSystemProperty.PACKAGE, testApplicationId);
                invoker.setOverride(ManifestSystemProperty.MIN_SDK_VERSION, minSdkVersion);
                invoker.setOverride(ManifestSystemProperty.NAME, instrumentationRunner);
                invoker.setOverride(ManifestSystemProperty.TARGET_PACKAGE, testedApplicationId);
                invoker.setOverride(ManifestSystemProperty.FUNCTIONAL_TEST, functionalTest.toString());
                invoker.setOverride(ManifestSystemProperty.HANDLE_PROFILING, handleProfiling.toString());
                if (testLabel != null) {
                    invoker.setOverride(ManifestSystemProperty.LABEL, testLabel);
                }
                if (!targetSdkVersion.equals("-1")) {
                    invoker.setOverride(ManifestSystemProperty.TARGET_SDK_VERSION, targetSdkVersion);
                }
                MergingReport mergingReport = invoker.merge();
                if (manifestProviders.isEmpty()) {
                    this.handleMergingResult(mergingReport, outManifest, logger);
                } else {
                    tempFile2 = File.createTempFile("manifestMerger", ".xml", tmpDir);
                    this.handleMergingResult(mergingReport, tempFile2, logger);
                    generatedTestManifest = tempFile2;
                }
            }
            if (!manifestProviders.isEmpty()) {
                MergingReport mergingReport = ManifestMerger2.newMerger((File)generatedTestManifest, (ILogger)logger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS}).setOverride(ManifestSystemProperty.PACKAGE, testApplicationId).addManifestProviders(manifestProviders).setPlaceHolderValues(manifestPlaceholders).merge();
                this.handleMergingResult(mergingReport, outManifest, logger);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Unable to create the temporary file", e);
                catch (ManifestMerger2.MergeFailureException e2) {
                    throw new RuntimeException("Manifest merging exception", e2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (tempFile1 != null) {
                        FileUtils.delete(tempFile1);
                    }
                    if (tempFile2 == null) throw throwable;
                    FileUtils.delete(tempFile2);
                    throw throwable;
                }
                catch (IOException e3) {
                    logger.error(e3, "Unable to clean up the temporary files.", new Object[0]);
                }
                throw throwable;
            }
        }
        try {
            if (tempFile1 != null) {
                FileUtils.delete((File)tempFile1);
            }
            if (tempFile2 == null) return;
            FileUtils.delete(tempFile2);
            return;
        }
        catch (IOException e) {
            logger.error(e, "Unable to clean up the temporary files.", new Object[0]);
            return;
        }
    }

    private void handleMergingResult(MergingReport mergingReport, File outFile, ILogger logger) throws IOException {
        ProcessTestManifest.outputMergeBlameContents(mergingReport, ((RegularFile)this.getMergeBlameFile().get()).getAsFile());
        switch (mergingReport.getResult()) {
            case WARNING: {
                mergingReport.log(logger);
            }
            case SUCCESS: {
                try {
                    String annotatedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.BLAME);
                    if (annotatedDocument != null) {
                        logger.verbose(annotatedDocument, new Object[0]);
                    } else {
                        logger.verbose("No blaming records from manifest merger", new Object[0]);
                    }
                }
                catch (Exception e) {
                    logger.error((Throwable)e, "cannot print resulting xml", new Object[0]);
                }
                String finalMergedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.MERGED);
                if (finalMergedDocument == null) {
                    throw new RuntimeException("No result from manifest merger");
                }
                try {
                    Files.asCharSink((File)outFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)finalMergedDocument);
                }
                catch (IOException e) {
                    logger.error((Throwable)e, "Cannot write resulting xml", new Object[0]);
                    throw new RuntimeException(e);
                }
                logger.verbose("Merged manifest saved to " + outFile, new Object[0]);
                break;
            }
            case ERROR: {
                mergingReport.log(logger);
                throw new RuntimeException(mergingReport.getReportString());
            }
            default: {
                throw new RuntimeException("Unhandled result type : " + mergingReport.getResult());
            }
        }
    }

    private static void generateTestManifest(String testApplicationId, String minSdkVersion, String targetSdkVersion, String testedApplicationId, String instrumentationRunner, Boolean handleProfiling, Boolean functionalTest, File outManifestLocation) {
        TestManifestGenerator generator = new TestManifestGenerator(outManifestLocation, testApplicationId, minSdkVersion, targetSdkVersion, testedApplicationId, instrumentationRunner, handleProfiling, functionalTest);
        try {
            generator.generate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public File getAaptFriendlyManifestOutputFile() {
        return null;
    }

    @InputFile
    @Optional
    public File getTestManifestFile() {
        return this.testManifestFile;
    }

    public void setTestManifestFile(File testManifestFile) {
        this.testManifestFile = testManifestFile;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    @Input
    public String getTestApplicationId() {
        return this.testApplicationId.get();
    }

    @Input
    @Optional
    public String getTestedApplicationId() {
        return this.testedApplicationId.get();
    }

    @Input
    public String getMinSdkVersion() {
        return this.minSdkVersion.get();
    }

    @Input
    public String getTargetSdkVersion() {
        return this.targetSdkVersion.get();
    }

    @Input
    public String getInstrumentationRunner() {
        return this.instrumentationRunner.get();
    }

    @Input
    public Boolean getHandleProfiling() {
        return this.handleProfiling.get();
    }

    @Input
    public Boolean getFunctionalTest() {
        return this.functionalTest.get();
    }

    @Input
    @Optional
    public String getTestLabel() {
        return this.testLabel.get();
    }

    @Input
    public Map<String, Object> getPlaceholdersValues() {
        return this.placeholdersValues.get();
    }

    @InputFiles
    @Optional
    public FileCollection getTestTargetMetadata() {
        return this.testTargetMetadata;
    }

    public List<ManifestProvider> computeProviders() {
        Set artifacts = this.manifests.getArtifacts();
        ArrayList providers = Lists.newArrayListWithCapacity((int)artifacts.size());
        for (ResolvedArtifactResult artifact : artifacts) {
            providers.add(new ProcessApplicationManifest.CreationAction.ManifestProviderImpl(artifact.getFile(), ProcessApplicationManifest.getArtifactName(artifact)));
        }
        return providers;
    }

    @InputFiles
    public FileCollection getManifests() {
        return this.manifests.getArtifactFiles();
    }

    public static class CreationAction
    extends AnnotationProcessingTaskCreationAction<ProcessTestManifest> {
        private final VariantScope scope;
        private final FileCollection testTargetMetadata;

        public CreationAction(VariantScope scope, FileCollection testTargetMetadata) {
            super(scope, scope.getTaskName("process", "Manifest"), ProcessTestManifest.class);
            this.scope = scope;
            this.testTargetMetadata = testTargetMetadata;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.scope.getArtifacts().republish(InternalArtifactType.MERGED_MANIFESTS, InternalArtifactType.MANIFEST_METADATA);
        }

        @Override
        public void handleProvider(TaskProvider<? extends ProcessTestManifest> taskProvider) {
            super.handleProvider(taskProvider);
            this.scope.getTaskContainer().setProcessManifestTask(taskProvider);
            this.scope.getArtifacts().producesDir(InternalArtifactType.MERGED_MANIFESTS, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, ManifestProcessorTask::getManifestOutputDirectory, "");
            this.scope.getArtifacts().producesFile(InternalArtifactType.MANIFEST_MERGE_BLAME_FILE, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, ManifestProcessorTask::getMergeBlameFile, "manifest-merger-blame-" + this.scope.getVariantConfiguration().getBaseName() + "-report.txt");
        }

        @Override
        public void configure(ProcessTestManifest task) {
            super.configure(task);
            task.checkManifestResult = this.scope.getArtifacts().getFinalArtifactFilesIfPresent(InternalArtifactType.CHECK_MANIFEST_RESULT);
            GradleVariantConfiguration config2 = this.scope.getVariantConfiguration();
            task.setTestManifestFile(config2.getMainManifest());
            task.outputScope = this.scope.getOutputScope();
            task.setTmpDir(FileUtils.join((File)this.scope.getGlobalScope().getIntermediatesDir(), (String[])new String[]{"tmp", "manifest", this.scope.getDirName()}));
            task.minSdkVersion = TaskInputHelper.memoize(() -> config2.getMinSdkVersion().getApiString());
            task.targetSdkVersion = TaskInputHelper.memoize(() -> config2.getTargetSdkVersion().getApiString());
            task.testTargetMetadata = this.testTargetMetadata;
            task.testApplicationId = TaskInputHelper.memoize(config2::getTestApplicationId);
            task.testedApplicationId = TaskInputHelper.memoize(config2::getTestedApplicationId);
            VariantConfiguration testedConfig = config2.getTestedConfig();
            task.onlyTestApk = testedConfig != null && testedConfig.getType().isAar();
            task.instrumentationRunner = TaskInputHelper.memoize(config2::getInstrumentationRunner);
            task.handleProfiling = TaskInputHelper.memoize(config2::getHandleProfiling);
            task.functionalTest = TaskInputHelper.memoize(config2::getFunctionalTest);
            task.testLabel = TaskInputHelper.memoize(config2::getTestLabel);
            task.manifests = this.scope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST);
            task.placeholdersValues = TaskInputHelper.memoize(config2::getManifestPlaceholders);
        }
    }
}

