/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.attribution;

import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxBuildModel;
import com.android.build.gradle.internal.cxx.services.CxxCompleteModelServiceKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\b"}, d2={"appendTimestampAndBuildIdToNinjaLog", "Ljava/io/File;", "cxxBuildModel", "Lcom/android/build/gradle/internal/cxx/model/CxxBuildModel;", "cxxAbiModel", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "collectNinjaLogs", "", "gradle"})
public final class UtilsKt {
    @NotNull
    public static final File appendTimestampAndBuildIdToNinjaLog(@NotNull CxxBuildModel cxxBuildModel, @NotNull CxxAbiModel cxxAbiModel) throws IOException {
        boolean bl;
        String string;
        Comparable<StringBuilder> comparable;
        Intrinsics.checkParameterIsNotNull((Object)cxxBuildModel, (String)"cxxBuildModel");
        Intrinsics.checkParameterIsNotNull((Object)cxxAbiModel, (String)"cxxAbiModel");
        File ninjaLogFile = cxxAbiModel.getNinjaLogFile();
        StringBuilder contentToWrite = new StringBuilder();
        if (!ninjaLogFile.exists()) {
            comparable = contentToWrite;
            string = "# ninja log v5";
            bl = false;
            StringBuilder stringBuilder = comparable.append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
        }
        comparable = contentToWrite;
        string = "# " + Clock.systemUTC().millis() + ' ' + cxxBuildModel.getBuildId();
        bl = false;
        StringBuilder stringBuilder = comparable.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        comparable = ninjaLogFile;
        boolean bl2 = false;
        bl = false;
        Comparable<StringBuilder> $this$apply = comparable;
        boolean bl3 = false;
        String string2 = contentToWrite.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"contentToWrite.toString()");
        FilesKt.appendText$default((File)$this$apply, (String)string2, null, (int)2, null);
        return comparable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void collectNinjaLogs(@NotNull CxxBuildModel cxxBuildModel) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)cxxBuildModel, (String)"cxxBuildModel");
        if (CxxCompleteModelServiceKt.allAbis(cxxBuildModel).isEmpty()) {
            return;
        }
        File buildAttributionFolder = ((CxxAbiModel)CollectionsKt.first(CxxCompleteModelServiceKt.allAbis(cxxBuildModel))).getVariant().getModule().getProject().getBuildAttributionFolder();
        File zipFile = FilesKt.resolve((File)buildAttributionFolder, (String)("ninja_build_log_" + Clock.systemUTC().millis() + ".zip"));
        zipFile.getParentFile().mkdirs();
        Closeable closeable = new ZipOutputStream(new FileOutputStream(zipFile));
        boolean bl = false;
        Throwable throwable = null;
        try {
            ZipOutputStream zipOs = (ZipOutputStream)closeable;
            boolean bl2 = false;
            for (CxxAbiModel abiModel : CxxCompleteModelServiceKt.allAbis(cxxBuildModel)) {
                String abiName;
                File ninjaLogFile = abiModel.getNinjaLogFile();
                if (!ninjaLogFile.exists()) continue;
                String modulePath = StringsKt.removePrefix((String)StringsKt.replace$default((String)abiModel.getVariant().getModule().getGradleModulePathName(), (char)':', (char)'/', (boolean)false, (int)4, null), (CharSequence)"/");
                String variantName = abiModel.getVariant().getVariantName();
                Intrinsics.checkExpressionValueIsNotNull((Object)abiModel.getAbi().getTag(), (String)"abiModel.abi.tag");
                zipOs.putNextEntry(new ZipEntry(modulePath + '/' + variantName + '/' + abiName));
                File $this$useLines$iv = ninjaLogFile;
                Charset charset$iv = Charsets.UTF_8;
                boolean $i$f$useLines = false;
                Object object = $this$useLines$iv;
                int n = 8192;
                boolean bl3 = false;
                Object object2 = object;
                boolean bl4 = false;
                Object object3 = object2;
                boolean bl5 = false;
                object3 = new FileInputStream((File)object3);
                bl5 = false;
                object2 = new InputStreamReader((InputStream)object3, charset$iv);
                bl4 = false;
                object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                n = 0;
                Throwable throwable2 = null;
                try {
                    BufferedReader it$iv = (BufferedReader)object;
                    boolean bl6 = false;
                    Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                    boolean bl7 = false;
                    Sequence $this$forEach$iv = SequencesKt.dropWhile((Sequence)lines, (Function1)((Function1)new Function1<String, Boolean>(zipOs, cxxBuildModel){
                        final /* synthetic */ ZipOutputStream $zipOs$inlined;
                        final /* synthetic */ CxxBuildModel $cxxBuildModel$inlined;
                        {
                            this.$zipOs$inlined = zipOutputStream;
                            this.$cxxBuildModel$inlined = cxxBuildModel;
                            super(1);
                        }

                        public final boolean invoke(@NotNull String it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return !StringsKt.endsWith$default((String)it, (String)("" + ' ' + this.$cxxBuildModel$inlined.getBuildId()), (boolean)false, (int)2, null);
                        }
                    }));
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        byte[] byArray;
                        Charset charset;
                        String it = (String)element$iv;
                        boolean bl8 = false;
                        String string = it + '\n';
                        Intrinsics.checkExpressionValueIsNotNull((Object)StandardCharsets.UTF_8, (String)"StandardCharsets.UTF_8");
                        ZipOutputStream zipOutputStream = zipOs;
                        boolean bl9 = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2.getBytes(charset), (String)"(this as java.lang.String).getBytes(charset)");
                        zipOutputStream.write(byArray);
                    }
                    object2 = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
                zipOs.closeEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

