/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.utils.FileUtils;
import com.android.utils.PathUtils;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;

@CacheableTask
public abstract class PackageForUnitTest
extends NonIncrementalTask {
    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract DirectoryProperty getResApk();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ListProperty<Directory> getMergedAssets();

    @OutputFile
    public abstract RegularFileProperty getApkForUnitTest();

    @Override
    protected void doTaskAction() throws IOException {
        File apkForUnitTest = ((RegularFile)this.getApkForUnitTest().get()).getAsFile();
        FileUtils.copyFile((File)PackageForUnitTest.apkFrom((Provider<Directory>)this.getResApk()), (File)apkForUnitTest);
        URI uri = URI.create("jar:" + apkForUnitTest.toURI());
        try (FileSystem apkFs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
            final Path apkAssetsPath = apkFs.getPath("/assets", new String[0]);
            for (Directory mergedAsset : (List)this.getMergedAssets().get()) {
                final Path mergedAssetsPath = mergedAsset.getAsFile().toPath();
                Files.walkFileTree(mergedAssetsPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        String relativePath = PathUtils.toSystemIndependentPath((Path)mergedAssetsPath.relativize(path));
                        Path destPath = apkAssetsPath.resolve(relativePath);
                        Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
                        Files.copy(path, destPath, new CopyOption[0]);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
    }

    private static File apkFrom(Provider<Directory> compiledResourcesZip) {
        return ((BuildOutput)Iterables.getOnlyElement((Iterable)ExistingBuildElements.from((ArtifactType)InternalArtifactType.PROCESSED_RES, compiledResourcesZip))).getOutputFile();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<PackageForUnitTest> {
        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("package", "ForUnitTest");
        }

        @Override
        public Class<PackageForUnitTest> getType() {
            return PackageForUnitTest.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends PackageForUnitTest> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getArtifacts().producesFile(InternalArtifactType.APK_FOR_LOCAL_TEST, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, PackageForUnitTest::getApkForUnitTest, "apk-for-local-test.ap_");
        }

        @Override
        public void configure(PackageForUnitTest task) {
            super.configure(task);
            BuildArtifactsHolder artifacts = this.getVariantScope().getArtifacts();
            artifacts.setTaskInputToFinalProduct(InternalArtifactType.PROCESSED_RES, task.getResApk());
            artifacts.setTaskInputToFinalProducts(InternalArtifactType.MERGED_ASSETS, task.getMergedAssets());
        }
    }
}

