/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.builder.desugaring.DesugaringClassAnalyzer;
import com.android.builder.desugaring.DesugaringData;
import com.android.builder.desugaring.DesugaringGraph;
import com.android.builder.desugaring.DesugaringGraphs;
import com.android.ide.common.internal.WaitableExecutor;
import com.google.common.base.Stopwatch;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

class DesugarIncrementalTransformHelper {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(DesugarIncrementalTransformHelper.class);
    private final String projectVariant;
    private final Iterable<Path> allInputs;
    private final WaitableExecutor executor;
    private final Supplier<Set<Path>> changedPaths;
    private final Supplier<DesugaringGraph> desugaringGraph;
    private final boolean isIncremental;

    DesugarIncrementalTransformHelper(String projectVariant, boolean isIncremental, Iterable<File> allInputs, Supplier<Set<Path>> changedPaths, WaitableExecutor executor) {
        DesugaringGraph graph;
        this.projectVariant = projectVariant;
        this.isIncremental = isIncremental;
        this.allInputs = Iterables.transform(allInputs, File::toPath);
        this.executor = executor;
        this.changedPaths = Suppliers.memoize(changedPaths::get);
        if (!isIncremental) {
            DesugaringGraphs.invalidate((String)projectVariant);
            graph = null;
        } else {
            graph = DesugaringGraphs.updateVariant((String)projectVariant, () -> DesugarIncrementalTransformHelper.getIncrementalData(changedPaths, executor));
        }
        this.desugaringGraph = graph != null ? () -> graph : Suppliers.memoize(this::makeDesugaringGraph);
    }

    Set<Path> getAdditionalPaths() {
        if (!this.isIncremental) {
            return ImmutableSet.of();
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.verbose("Desugaring dependencies incrementally.", new Object[0]);
        HashSet<Path> additionalPaths = new HashSet<Path>();
        for (Path changed : this.changedPaths.get()) {
            for (Path path : this.desugaringGraph.get().getDependentPaths(changed)) {
                if (this.changedPaths.get().contains(path)) continue;
                additionalPaths.add(path);
            }
        }
        logger.verbose("Time to calculate desugaring dependencies: %d", stopwatch.elapsed(TimeUnit.MILLISECONDS));
        logger.verbose("Additional paths to desugar: %s", ((Object)additionalPaths).toString());
        return additionalPaths;
    }

    private DesugaringGraph makeDesugaringGraph() {
        if (!this.isIncremental) {
            return DesugaringGraphs.forVariant((String)this.projectVariant, DesugarIncrementalTransformHelper.getInitalGraphData(this.allInputs, this.executor));
        }
        return DesugaringGraphs.forVariant((String)this.projectVariant, () -> DesugarIncrementalTransformHelper.getInitalGraphData(this.allInputs, this.executor), () -> DesugarIncrementalTransformHelper.getIncrementalData(this.changedPaths, this.executor));
    }

    private static Collection<DesugaringData> getInitalGraphData(Iterable<Path> allInputs, WaitableExecutor executor) {
        Set data = Sets.newConcurrentHashSet();
        for (Path input : allInputs) {
            executor.execute(() -> {
                try {
                    if (Files.exists(input, new LinkOption[0])) {
                        data.addAll(DesugaringClassAnalyzer.analyze((Path)input));
                    }
                    return null;
                }
                catch (Throwable t) {
                    logger.error(t, "error processing %s", input);
                    throw t;
                }
            });
        }
        try {
            executor.waitForTasksWithQuickFail(true);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to get desugaring graph", e);
        }
        return data;
    }

    private static Set<DesugaringData> getIncrementalData(Supplier<Set<Path>> changedPaths, WaitableExecutor executor) {
        Set data = Sets.newConcurrentHashSet();
        for (Path input : changedPaths.get()) {
            if (Files.notExists(input, new LinkOption[0])) {
                data.add(DesugaringClassAnalyzer.forRemoved((Path)input));
                continue;
            }
            executor.execute(() -> {
                try {
                    data.addAll(DesugaringClassAnalyzer.analyze((Path)input));
                    return null;
                }
                catch (Throwable t) {
                    logger.error(t, "error processing %s", input);
                    throw t;
                }
            });
        }
        try {
            executor.waitForTasksWithQuickFail(true);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to get desugaring graph", e);
        }
        return data;
    }

    public Set<Path> getDependenciesPaths(Path path) {
        return this.desugaringGraph.get().getDependenciesPaths(path);
    }
}

