/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.util.RelativizableFile;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.aapt.WorkerExecutorResourceCompilationService;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.res.namespaced.Aapt2DaemonManagerService;
import com.android.build.gradle.internal.res.namespaced.Aapt2ServiceKey;
import com.android.build.gradle.internal.res.namespaced.NamespaceRemover;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.Blocks;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.SyncOptions;
import com.android.build.gradle.tasks.ResourceAwareTask;
import com.android.build.gradle.tasks.ResourceException;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.VectorDrawablesOptions;
import com.android.builder.png.VectorDrawableRenderer;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.resources.CopyToOutputDirectoryResourceCompilationService;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.resources.FileValidity;
import com.android.ide.common.resources.GeneratedResourceSet;
import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergedResourceWriter;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.NoOpResourcePreprocessor;
import com.android.ide.common.resources.ResourceCompilationService;
import com.android.ide.common.resources.ResourceMerger;
import com.android.ide.common.resources.ResourcePreprocessor;
import com.android.ide.common.resources.ResourceSet;
import com.android.ide.common.resources.SingleFileProcessor;
import com.android.ide.common.vectordrawable.ResourcesNotSupportedException;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.resources.Density;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableSet;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.bind.JAXBException;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.WorkerExecutor;
import org.slf4j.Logger;

@CacheableTask
public abstract class MergeResources
extends ResourceAwareTask {
    private File generatedPngsOutputDir;
    private boolean processResources;
    private boolean crunchPng;
    private File blameLogFolder;
    private Supplier<Collection<File>> sourceFolderInputs;
    private List<ResourceSet> processedInputs;
    private final FileValidity<ResourceSet> fileValidity = new FileValidity();
    private boolean disableVectorDrawables;
    private boolean vectorSupportLibraryIsUsed;
    private Collection<String> generatedDensities;
    private Supplier<Integer> minSdk;
    private FileCollection aapt2FromMaven;
    private SingleFileProcessor dataBindingLayoutProcessor;
    private File mergedNotCompiledResourcesOutputDirectory;
    private boolean pseudoLocalesEnabled;
    private boolean precompileRemoteResources;
    private ImmutableSet<Flag> flags;
    private final WorkerExecutorFacade workerExecutorFacade;
    private SyncOptions.ErrorFormatMode errorFormatMode;

    private static ResourceCompilationService getResourceProcessor(FileCollection aapt2FromMaven, WorkerExecutorFacade workerExecutor, SyncOptions.ErrorFormatMode errorFormatMode, ImmutableSet<Flag> flags, boolean processResources2, org.gradle.api.logging.Logger logger) {
        if (flags.contains((Object)Flag.REMOVE_RESOURCE_NAMESPACES)) {
            return NamespaceRemover.INSTANCE;
        }
        if (!processResources2) {
            return CopyToOutputDirectoryResourceCompilationService.INSTANCE;
        }
        Aapt2ServiceKey aapt2ServiceKey = Aapt2DaemonManagerService.registerAaptService(aapt2FromMaven, new LoggerWrapper(logger));
        return new WorkerExecutorResourceCompilationService(workerExecutor, aapt2ServiceKey, errorFormatMode);
    }

    @Override
    protected boolean getIncremental() {
        return true;
    }

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getDataBindingLayoutInfoOutFolder();

    @Inject
    public MergeResources(WorkerExecutor workerExecutor) {
        this.workerExecutorFacade = Workers.INSTANCE.getWorkerForAapt2(this.getProject().getName(), this.getPath(), workerExecutor);
    }

    @Override
    protected void doFullTaskAction() throws IOException, JAXBException {
        ResourcePreprocessor preprocessor = this.getPreprocessor();
        File destinationDir = ((Directory)this.getOutputDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)destinationDir);
        if (this.getDataBindingLayoutInfoOutFolder().isPresent()) {
            FileUtils.deleteDirectoryContents((File)((Directory)this.getDataBindingLayoutInfoOutFolder().get()).getAsFile());
        }
        List<ResourceSet> resourceSets = this.getConfiguredResourceSets(preprocessor);
        ResourceMerger merger = new ResourceMerger(this.minSdk.get().intValue());
        MergingLog mergingLog = null;
        if (this.blameLogFolder != null) {
            FileUtils.cleanOutputDir((File)this.blameLogFolder);
            mergingLog = new MergingLog(this.blameLogFolder);
        }
        try (ResourceCompilationService resourceCompiler = MergeResources.getResourceProcessor(this.aapt2FromMaven, this.workerExecutorFacade, this.errorFormatMode, this.flags, this.processResources, this.getLogger());){
            Blocks.recordSpan(this.getProject().getName(), this.getPath(), GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION_PHASE_1, () -> {
                for (ResourceSet resourceSet : resourceSets) {
                    resourceSet.loadFromFiles((ILogger)new LoggerWrapper(this.getLogger()));
                    merger.addDataSet(resourceSet);
                }
            });
            File publicFile = this.getPublicFile().isPresent() ? ((RegularFile)this.getPublicFile().get()).getAsFile() : null;
            MergedResourceWriter writer = new MergedResourceWriter(this.workerExecutorFacade, destinationDir, publicFile, mergingLog, preprocessor, resourceCompiler, this.getIncrementalFolder(), this.dataBindingLayoutProcessor, this.mergedNotCompiledResourcesOutputDirectory, this.pseudoLocalesEnabled, this.getCrunchPng());
            Blocks.recordSpan(this.getProject().getName(), this.getPath(), GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION_PHASE_2, () -> merger.mergeData((MergeConsumer)writer, false));
            Blocks.recordSpan(this.getProject().getName(), this.getPath(), GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION_PHASE_3, () -> {
                if (this.dataBindingLayoutProcessor != null) {
                    this.dataBindingLayoutProcessor.end();
                }
            });
            Blocks.recordSpan(this.getProject().getName(), this.getPath(), GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION_PHASE_4, () -> merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false));
        }
        catch (Exception e) {
            MergingException.findAndReportMergingException((Exception)e, (MessageReceiver)new MessageReceiverImpl(this.errorFormatMode, (Logger)this.getLogger()));
            try {
                throw e;
            }
            catch (MergingException mergingException) {
                merger.cleanBlob(this.getIncrementalFolder());
                throw new ResourceException(mergingException.getMessage(), mergingException);
            }
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, ? extends FileStatus> changedInputs) throws IOException, JAXBException {
        ResourcePreprocessor preprocessor = this.getPreprocessor();
        ResourceMerger merger = new ResourceMerger(this.minSdk.get().intValue());
        try {
            if (!merger.loadFromBlob(this.getIncrementalFolder(), true)) {
                this.doFullTaskAction();
                return;
            }
            for (Object resourceSet : merger.getDataSets()) {
                resourceSet.setPreprocessor(preprocessor);
            }
            List<ResourceSet> resourceSets = this.getConfiguredResourceSets(preprocessor);
            if (!merger.checkValidUpdate(resourceSets)) {
                this.getLogger().info("Changed Resource sets: full task run!");
                this.doFullTaskAction();
                return;
            }
            for (Map.Entry entry : changedInputs.entrySet()) {
                File changedFile = (File)entry.getKey();
                merger.findDataSetContaining(changedFile, this.fileValidity);
                if (this.fileValidity.getStatus() == FileValidity.FileStatus.UNKNOWN_FILE) {
                    this.doFullTaskAction();
                    return;
                }
                if (this.fileValidity.getStatus() != FileValidity.FileStatus.VALID_FILE || ((ResourceSet)this.fileValidity.getDataSet()).updateWith(this.fileValidity.getSourceFile(), changedFile, (FileStatus)entry.getValue(), (ILogger)new LoggerWrapper(this.getLogger()))) continue;
                this.getLogger().info(String.format("Failed to process %s event! Full task run", entry.getValue()));
                this.doFullTaskAction();
                return;
            }
            MergingLog mergingLog = this.getBlameLogFolder() != null ? new MergingLog(this.getBlameLogFolder()) : null;
            try (ResourceCompilationService resourceCompilationService = MergeResources.getResourceProcessor(this.aapt2FromMaven, this.workerExecutorFacade, this.errorFormatMode, this.flags, this.processResources, this.getLogger());){
                File publicFile = this.getPublicFile().isPresent() ? ((RegularFile)this.getPublicFile().get()).getAsFile() : null;
                MergedResourceWriter writer = new MergedResourceWriter(this.workerExecutorFacade, ((Directory)this.getOutputDir().get()).getAsFile(), publicFile, mergingLog, preprocessor, resourceCompilationService, this.getIncrementalFolder(), this.dataBindingLayoutProcessor, this.mergedNotCompiledResourcesOutputDirectory, this.pseudoLocalesEnabled, this.getCrunchPng());
                merger.mergeData((MergeConsumer)writer, false);
                if (this.dataBindingLayoutProcessor != null) {
                    this.dataBindingLayoutProcessor.end();
                }
                merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false);
            }
        }
        catch (Exception e) {
            MergingException.findAndReportMergingException((Exception)e, (MessageReceiver)new MessageReceiverImpl(this.errorFormatMode, (Logger)this.getLogger()));
            try {
                throw e;
            }
            catch (MergingException mergingException) {
                merger.cleanBlob(this.getIncrementalFolder());
                throw new ResourceException(mergingException.getMessage(), mergingException);
            }
        }
        finally {
            this.cleanup();
        }
    }

    private ResourcePreprocessor getPreprocessor() {
        if (this.disableVectorDrawables) {
            return NoOpResourcePreprocessor.INSTANCE;
        }
        Collection densities = this.getGeneratedDensities().stream().map(Density::getEnum).collect(Collectors.toList());
        return new MergeResourcesVectorDrawableRenderer(this.minSdk.get(), this.vectorSupportLibraryIsUsed, this.generatedPngsOutputDir, densities, LoggerWrapper.supplierFor(MergeResources.class));
    }

    private List<ResourceSet> getConfiguredResourceSets(ResourcePreprocessor preprocessor) {
        if (this.processedInputs == null) {
            this.processedInputs = this.getResourcesComputer().compute(this.precompileRemoteResources);
            ArrayList<GeneratedResourceSet> generatedSets = new ArrayList<GeneratedResourceSet>(this.processedInputs.size());
            for (ResourceSet resourceSet : this.processedInputs) {
                resourceSet.setPreprocessor(preprocessor);
                GeneratedResourceSet generatedSet = new GeneratedResourceSet(resourceSet);
                resourceSet.setGeneratedSet((ResourceSet)generatedSet);
                generatedSets.add(generatedSet);
            }
            for (int i2 = 0; i2 < generatedSets.size(); ++i2) {
                this.processedInputs.add(2 * i2, (ResourceSet)generatedSets.get(i2));
            }
        }
        return this.processedInputs;
    }

    private void cleanup() {
        this.fileValidity.clear();
        this.processedInputs = null;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Collection<File> getSourceFolderInputs() {
        return this.sourceFolderInputs.get();
    }

    @OutputDirectory
    public abstract DirectoryProperty getOutputDir();

    @Input
    public boolean getCrunchPng() {
        return this.crunchPng;
    }

    @Input
    public boolean getProcessResources() {
        return this.processResources;
    }

    @Optional
    @OutputFile
    public abstract RegularFileProperty getPublicFile();

    @Input
    public boolean isValidateEnabled() {
        return this.getResourcesComputer().getValidateEnabled();
    }

    @OutputDirectory
    @Optional
    public File getBlameLogFolder() {
        return this.blameLogFolder;
    }

    public void setBlameLogFolder(File blameLogFolder) {
        this.blameLogFolder = blameLogFolder;
    }

    @Optional
    @OutputDirectory
    public File getGeneratedPngsOutputDir() {
        return this.generatedPngsOutputDir;
    }

    @Input
    public Collection<String> getGeneratedDensities() {
        return this.generatedDensities;
    }

    @Input
    public int getMinSdk() {
        return this.minSdk.get();
    }

    @Input
    public boolean isVectorSupportLibraryUsed() {
        return this.vectorSupportLibraryIsUsed;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getAapt2FromMaven() {
        return this.aapt2FromMaven;
    }

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getMergedNotCompiledResourcesOutputDirectory();

    @Input
    public boolean isPseudoLocalesEnabled() {
        return this.pseudoLocalesEnabled;
    }

    @Input
    public String getFlags() {
        return this.flags.stream().map(Enum::name).sorted().collect(Collectors.joining(","));
    }

    public static enum Flag {
        REMOVE_RESOURCE_NAMESPACES,
        PROCESS_VECTOR_DRAWABLES;

    }

    public static class CreationAction
    extends VariantTaskCreationAction<MergeResources> {
        private final TaskManager.MergeType mergeType;
        private final String taskNamePrefix;
        private final File mergedNotCompiledOutputDirectory;
        private final boolean includeDependencies;
        private final boolean processResources;
        private final boolean processVectorDrawables;
        private final ImmutableSet<Flag> flags;

        public CreationAction(VariantScope variantScope, TaskManager.MergeType mergeType, String taskNamePrefix, File mergedNotCompiledOutputDirectory, boolean includeDependencies, boolean processResources2, ImmutableSet<Flag> flags) {
            super(variantScope);
            this.mergeType = mergeType;
            this.taskNamePrefix = taskNamePrefix;
            this.mergedNotCompiledOutputDirectory = mergedNotCompiledOutputDirectory;
            this.includeDependencies = includeDependencies;
            this.processResources = processResources2;
            this.processVectorDrawables = flags.contains((Object)Flag.PROCESS_VECTOR_DRAWABLES);
            this.flags = flags;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName(this.taskNamePrefix, "Resources");
        }

        @Override
        public Class<MergeResources> getType() {
            return MergeResources.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends MergeResources> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setMergeResourcesTask(taskProvider);
            this.getVariantScope().getArtifacts().producesDir(this.mergeType == TaskManager.MergeType.MERGE ? InternalArtifactType.DATA_BINDING_LAYOUT_INFO_TYPE_MERGE : InternalArtifactType.DATA_BINDING_LAYOUT_INFO_TYPE_PACKAGE, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, MergeResources::getDataBindingLayoutInfoOutFolder, "out");
        }

        @Override
        public void configure(final MergeResources task) {
            super.configure(task);
            VariantScope variantScope = this.getVariantScope();
            GlobalScope globalScope = variantScope.getGlobalScope();
            final BaseVariantData variantData = variantScope.getVariantData();
            task.minSdk = TaskInputHelper.memoize(() -> variantData.getVariantConfiguration().getMinSdkVersion().getApiLevel());
            task.aapt2FromMaven = Aapt2MavenUtils.getAapt2FromMaven(globalScope);
            task.setIncrementalFolder(variantScope.getIncrementalDir(this.getName()));
            if (this.includeDependencies) {
                task.setBlameLogFolder(variantScope.getResourceBlameLogDir());
            }
            task.processResources = this.processResources;
            task.crunchPng = variantScope.isCrunchPngs();
            VectorDrawablesOptions vectorDrawablesOptions = variantData.getVariantConfiguration().getMergedFlavor().getVectorDrawables();
            task.generatedDensities = vectorDrawablesOptions.getGeneratedDensities();
            if (task.generatedDensities == null) {
                task.generatedDensities = Collections.emptySet();
            }
            task.disableVectorDrawables = !this.processVectorDrawables || task.generatedDensities.isEmpty();
            task.vectorSupportLibraryIsUsed = Boolean.TRUE.equals(vectorDrawablesOptions.getUseSupportLibrary());
            task.getResourcesComputer().initFromVariantScope(variantScope, this.includeDependencies);
            task.sourceFolderInputs = () -> variantData.getVariantConfiguration().getSourceFiles(SourceProvider::getResDirectories);
            if (!task.disableVectorDrawables) {
                task.generatedPngsOutputDir = variantScope.getGeneratedPngsOutputDir();
            }
            boolean isDataBindingEnabled = globalScope.getExtension().getDataBinding().isEnabled();
            final boolean isViewBindingEnabled = globalScope.getProjectOptions().get(BooleanOption.ENABLE_VIEW_BINDING);
            if (isDataBindingEnabled || isViewBindingEnabled) {
                task.dataBindingLayoutProcessor = new SingleFileProcessor(){
                    private LayoutXmlProcessor processor;

                    private LayoutXmlProcessor getProcessor() {
                        if (this.processor == null) {
                            this.processor = variantData.getLayoutXmlProcessor();
                        }
                        return this.processor;
                    }

                    public boolean processSingleFile(File file, File out) throws Exception {
                        return this.getProcessor().processSingleFile(RelativizableFile.fromAbsoluteFile((File)file, null), out, isViewBindingEnabled);
                    }

                    public void processRemovedFile(File file) {
                        this.getProcessor().processRemovedFile(file);
                    }

                    public void end() throws JAXBException {
                        this.getProcessor().writeLayoutInfoFiles(((Directory)task.getDataBindingLayoutInfoOutFolder().get()).getAsFile());
                    }
                };
            }
            task.mergedNotCompiledResourcesOutputDirectory = this.mergedNotCompiledOutputDirectory;
            task.pseudoLocalesEnabled = ((CoreBuildType)variantScope.getVariantData().getVariantConfiguration().getBuildType()).isPseudoLocalesEnabled();
            task.flags = this.flags;
            task.errorFormatMode = SyncOptions.getErrorFormatMode(globalScope.getProjectOptions());
            task.precompileRemoteResources = globalScope.getProjectOptions().get(BooleanOption.PRECOMPILE_REMOTE_RESOURCES);
            task.dependsOn(new Object[]{variantScope.getTaskContainer().getResourceGenTask()});
        }
    }

    private static class MergeResourcesVectorDrawableRenderer
    extends VectorDrawableRenderer {
        public MergeResourcesVectorDrawableRenderer(int minSdk, boolean supportLibraryIsUsed, File outputDir, Collection<Density> densities, Supplier<ILogger> loggerSupplier) {
            super(minSdk, supportLibraryIsUsed, outputDir, densities, loggerSupplier);
        }

        public void generateFile(File toBeGenerated, File original) throws IOException {
            try {
                super.generateFile(toBeGenerated, original);
            }
            catch (ResourcesNotSupportedException e) {
                throw new GradleException(String.format("Can't process attribute %1$s=\"%2$s\": references to other resources are not supported by build-time PNG generation.\n%3$s\nSee http://developer.android.com/tools/help/vector-asset-studio.html for details.", e.getName(), e.getValue(), this.getPreprocessingReasonDescription(original)));
            }
        }
    }
}

