/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import java.io.File;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;

public abstract class CheckManifest
extends NonIncrementalTask {
    private File manifest;
    private Boolean isOptional;

    @Optional
    @Input
    public File getManifest() {
        return this.manifest;
    }

    @Input
    public boolean getManifestPresence() {
        return this.manifest != null && this.manifest.isFile();
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
    }

    @Input
    public Boolean getOptional() {
        return this.isOptional;
    }

    public void setOptional(Boolean optional) {
        this.isOptional = optional;
    }

    @OutputDirectory
    public abstract DirectoryProperty getFakeOutputDir();

    @Override
    protected void doTaskAction() {
        if (!this.isOptional.booleanValue() && this.manifest != null && !this.manifest.isFile()) {
            throw new IllegalArgumentException(String.format("Main Manifest missing for variant %1$s. Expected path: %2$s", this.getVariantName(), this.getManifest().getAbsolutePath()));
        }
    }

    public static class CreationAction
    extends VariantTaskCreationAction<CheckManifest> {
        private final boolean isManifestOptional;

        public CreationAction(VariantScope scope, boolean isManifestOptional) {
            super(scope);
            this.isManifestOptional = isManifestOptional;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("check", "Manifest");
        }

        @Override
        public Class<CheckManifest> getType() {
            return CheckManifest.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends CheckManifest> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setCheckManifestTask(taskProvider);
            this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.CHECK_MANIFEST_RESULT, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, CheckManifest::getFakeOutputDir, "out");
        }

        @Override
        public void configure(CheckManifest task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.setOptional(this.isManifestOptional);
            task.manifest = scope.getVariantConfiguration().getMainManifest();
        }
    }
}

