/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.FeatureExtension;
import com.android.build.gradle.api.JavaCompileOptions;
import com.android.build.gradle.api.ViewBindingOptions;
import com.android.build.gradle.internal.FeatureModelBuilder;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.LibraryTaskManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.MultiTypeTaskManager;
import com.android.build.gradle.internal.PostprocessingFeatures;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.coverage.JacocoConfigurations;
import com.android.build.gradle.internal.coverage.JacocoReportTask;
import com.android.build.gradle.internal.cxx.model.CxxModuleModel;
import com.android.build.gradle.internal.cxx.model.TryCreateCxxModuleModelKt;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.AnnotationProcessorOptions;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.dsl.DataBindingOptions;
import com.android.build.gradle.internal.dsl.DexOptions;
import com.android.build.gradle.internal.packaging.GradleKeystoreHelper;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.PublishingSpecs;
import com.android.build.gradle.internal.res.GenerateLibraryRFileTask;
import com.android.build.gradle.internal.res.LinkAndroidResForBundleTask;
import com.android.build.gradle.internal.res.LinkApplicationAndroidResourcesTask;
import com.android.build.gradle.internal.res.ParseLibraryResourcesTask;
import com.android.build.gradle.internal.res.namespaced.NamespacedResourcesTaskManager;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.ArtifactPublishingUtil;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.CodeShrinker;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidReportTask;
import com.android.build.gradle.internal.tasks.CheckDuplicateClassesTask;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.CheckProguardFiles;
import com.android.build.gradle.internal.tasks.D8MainDexListTask;
import com.android.build.gradle.internal.tasks.DependencyReportTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.DexFileDependenciesTask;
import com.android.build.gradle.internal.tasks.DexMergingAction;
import com.android.build.gradle.internal.tasks.DexMergingTask;
import com.android.build.gradle.internal.tasks.ExtractProguardFiles;
import com.android.build.gradle.internal.tasks.ExtractTryWithResourcesSupportJar;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.tasks.GenerateLibraryProguardRulesTask;
import com.android.build.gradle.internal.tasks.InstallVariantTask;
import com.android.build.gradle.internal.tasks.JacocoTask;
import com.android.build.gradle.internal.tasks.LintCompile;
import com.android.build.gradle.internal.tasks.MergeAaptProguardFilesCreationAction;
import com.android.build.gradle.internal.tasks.MergeClassesTask;
import com.android.build.gradle.internal.tasks.MergeGeneratedProguardFilesCreationAction;
import com.android.build.gradle.internal.tasks.MergeJavaResourceTask;
import com.android.build.gradle.internal.tasks.MergeNativeLibsTask;
import com.android.build.gradle.internal.tasks.PackageForUnitTest;
import com.android.build.gradle.internal.tasks.PrepareLintJar;
import com.android.build.gradle.internal.tasks.PrepareLintJarForPublish;
import com.android.build.gradle.internal.tasks.ProcessJavaResTask;
import com.android.build.gradle.internal.tasks.RecalculateStackFramesTask;
import com.android.build.gradle.internal.tasks.ShrinkResourcesTask;
import com.android.build.gradle.internal.tasks.SigningConfigWriterTask;
import com.android.build.gradle.internal.tasks.SigningReportTask;
import com.android.build.gradle.internal.tasks.SourceSetsTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.TestServerTask;
import com.android.build.gradle.internal.tasks.UninstallTask;
import com.android.build.gradle.internal.tasks.ValidateSigningTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingCompilerArguments;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportBuildInfoTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingGenBaseClassesTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingMergeBaseClassLogTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingMergeDependencyArtifactsTask;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.TaskFactory;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryImpl;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.factory.TaskProviderCallback;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitUtils;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.BundleTestDataImpl;
import com.android.build.gradle.internal.test.TestDataImpl;
import com.android.build.gradle.internal.transforms.CustomClassTransform;
import com.android.build.gradle.internal.transforms.DesugarTransform;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransform;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransformBuilder;
import com.android.build.gradle.internal.transforms.DexSplitterTransform;
import com.android.build.gradle.internal.transforms.ProGuardTransform;
import com.android.build.gradle.internal.transforms.ProguardConfigurable;
import com.android.build.gradle.internal.transforms.R8Transform;
import com.android.build.gradle.internal.transforms.ShrinkBundleResourcesTask;
import com.android.build.gradle.internal.variant.AndroidArtifactVariantData;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.options.SyncOptions;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.AndroidJavaCompile;
import com.android.build.gradle.tasks.BuildArtifactReportTask;
import com.android.build.gradle.tasks.CleanBuildCache;
import com.android.build.gradle.tasks.CompatibleScreensManifest;
import com.android.build.gradle.tasks.CopyOutputs;
import com.android.build.gradle.tasks.ExternalNativeBuildJsonTask;
import com.android.build.gradle.tasks.ExternalNativeBuildTask;
import com.android.build.gradle.tasks.ExternalNativeCleanTask;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.GenerateResValues;
import com.android.build.gradle.tasks.GenerateSplitAbiRes;
import com.android.build.gradle.tasks.GenerateTestConfig;
import com.android.build.gradle.tasks.JavaPreCompileTask;
import com.android.build.gradle.tasks.LintFixTask;
import com.android.build.gradle.tasks.LintGlobalTask;
import com.android.build.gradle.tasks.LintPerVariantTask;
import com.android.build.gradle.tasks.MainApkListPersistence;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.PackageSplitAbi;
import com.android.build.gradle.tasks.PackageSplitRes;
import com.android.build.gradle.tasks.ProcessAnnotationsTask;
import com.android.build.gradle.tasks.ProcessAnnotationsTaskCreationAction;
import com.android.build.gradle.tasks.ProcessApplicationManifest;
import com.android.build.gradle.tasks.ProcessLibraryManifest;
import com.android.build.gradle.tasks.ProcessTestManifest;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.build.gradle.tasks.ShaderCompile;
import com.android.build.gradle.tasks.factory.AndroidUnitTest;
import com.android.builder.core.DefaultDexOptions;
import com.android.builder.core.VariantType;
import com.android.builder.dexing.DexerTool;
import com.android.builder.dexing.DexingType;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.profile.Recorder;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceProvider;
import com.android.builder.testing.api.TestServer;
import com.android.builder.utils.FileCache;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public abstract class TaskManager {
    public static final String DIR_BUNDLES = "bundles";
    public static final String INSTALL_GROUP = "Install";
    public static final String BUILD_GROUP = "build";
    public static final String ANDROID_GROUP = "Android";
    public static final String FEATURE_SUFFIX = "Feature";
    public static final String MAIN_PREBUILD = "preBuild";
    public static final String UNINSTALL_ALL = "uninstallAll";
    public static final String DEVICE_CHECK = "deviceCheck";
    public static final String DEVICE_ANDROID_TEST = "deviceAndroidTest";
    public static final String CONNECTED_CHECK = "connectedCheck";
    public static final String CONNECTED_ANDROID_TEST = "connectedAndroidTest";
    public static final String ASSEMBLE_ANDROID_TEST = "assembleAndroidTest";
    public static final String LINT = "lint";
    public static final String LINT_FIX = "lintFix";
    public static final String EXTRACT_PROGUARD_FILES = "extractProguardFiles";
    protected final Project project;
    protected final ProjectOptions projectOptions;
    protected final DataBindingBuilder dataBindingBuilder;
    protected final BaseExtension extension;
    private final VariantFactory variantFactory;
    protected final ToolingModelBuilderRegistry toolingRegistry;
    protected final GlobalScope globalScope;
    protected final Recorder recorder;
    private final Logger logger;
    private final FileCache buildCache;
    protected final TaskFactory taskFactory;
    public TaskProvider<Task> createMockableJar;

    public TaskManager(GlobalScope globalScope, Project project2, ProjectOptions projectOptions, DataBindingBuilder dataBindingBuilder, BaseExtension extension, VariantFactory variantFactory, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        this.globalScope = globalScope;
        this.project = project2;
        this.projectOptions = projectOptions;
        this.dataBindingBuilder = dataBindingBuilder;
        this.extension = extension;
        this.variantFactory = variantFactory;
        this.toolingRegistry = toolingRegistry;
        this.recorder = recorder;
        this.logger = Logging.getLogger(this.getClass());
        this.buildCache = globalScope.getBuildCache();
        this.taskFactory = new TaskFactoryImpl(project2.getTasks());
    }

    public TaskFactory getTaskFactory() {
        return this.taskFactory;
    }

    public DataBindingBuilder getDataBindingBuilder() {
        return this.dataBindingBuilder;
    }

    public abstract void createTasksForVariantScope(VariantScope var1, List<VariantScope> var2);

    public void configureScopeForNdk(VariantScope scope) {
        BaseVariantData variantData = scope.getVariantData();
        File objFolder = new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/obj");
        for (Abi abi : Abi.values()) {
            scope.addNdkDebuggableLibraryFolders(abi, new File(objFolder, "local/" + abi.getTag()));
        }
    }

    public void createTasksBeforeEvaluate() {
        this.taskFactory.register(UNINSTALL_ALL, (Action<? super Task>)((Action)uninstallAllTask -> {
            uninstallAllTask.setDescription("Uninstall all applications.");
            uninstallAllTask.setGroup(INSTALL_GROUP);
        }));
        this.taskFactory.register(DEVICE_CHECK, (Action<? super Task>)((Action)deviceCheckTask -> {
            deviceCheckTask.setDescription("Runs all device checks using Device Providers and Test Servers.");
            deviceCheckTask.setGroup("verification");
        }));
        this.taskFactory.register(CONNECTED_CHECK, (Action<? super Task>)((Action)connectedCheckTask -> {
            connectedCheckTask.setDescription("Runs all device checks on currently connected devices.");
            connectedCheckTask.setGroup("verification");
        }));
        this.taskFactory.register(MAIN_PREBUILD);
        this.taskFactory.register(EXTRACT_PROGUARD_FILES, ExtractProguardFiles.class, task -> task.dependsOn(new Object[]{MAIN_PREBUILD}));
        this.taskFactory.register(new SourceSetsTask.CreationAction(this.extension));
        this.taskFactory.register(ASSEMBLE_ANDROID_TEST, (Action<? super Task>)((Action)assembleAndroidTestTask -> {
            assembleAndroidTestTask.setGroup(BUILD_GROUP);
            assembleAndroidTestTask.setDescription("Assembles all the Test applications.");
        }));
        this.taskFactory.register(new LintCompile.CreationAction(this.globalScope));
        this.createGlobalLintTask();
        this.configureCustomLintChecksConfig();
        this.globalScope.setAndroidJarConfig(TaskManager.createAndroidJarConfig(this.project));
        if (this.buildCache != null) {
            this.taskFactory.register(new CleanBuildCache.CreationAction(this.globalScope));
        }
        this.taskFactory.register("resolveConfigAttr", ConfigAttrTask.class, task -> {
            task.resolvable = true;
        });
        this.taskFactory.register("consumeConfigAttr", ConfigAttrTask.class, task -> {
            task.consumable = true;
        });
    }

    private void configureCustomLintChecksConfig() {
        this.globalScope.setLintChecks(TaskManager.createCustomLintChecksConfig(this.project));
        this.globalScope.setLintPublish(TaskManager.createCustomLintPublishConfig(this.project));
    }

    public static Configuration createCustomLintChecksConfig(Project project2) {
        Configuration lintChecks = (Configuration)project2.getConfigurations().maybeCreate("lintChecks");
        lintChecks.setVisible(false);
        lintChecks.setDescription("Configuration to apply external lint check jar");
        lintChecks.setCanBeConsumed(false);
        return lintChecks;
    }

    public static Configuration createCustomLintPublishConfig(Project project2) {
        Configuration lintChecks = (Configuration)project2.getConfigurations().maybeCreate("lintPublish");
        lintChecks.setVisible(false);
        lintChecks.setDescription("Configuration to publish external lint check jar");
        lintChecks.setCanBeConsumed(false);
        return lintChecks;
    }

    public void configureCustomLintChecks() {
        this.taskFactory.register(new PrepareLintJar.CreationAction(this.globalScope));
        this.taskFactory.register(new PrepareLintJarForPublish.CreationAction(this.globalScope));
    }

    public void createGlobalLintTask() {
        this.taskFactory.register(LINT, LintGlobalTask.class, task -> {});
        this.taskFactory.configure("check", (Action<? super Task>)((Action)it -> it.dependsOn(new Object[]{LINT})));
        this.taskFactory.register(LINT_FIX, LintFixTask.class, task -> {});
    }

    public void configureGlobalLintTask(Collection<VariantScope> variants) {
        List filteredVariants = variants.stream().filter(TaskManager::isLintVariant).collect(Collectors.toList());
        if (filteredVariants.isEmpty()) {
            return;
        }
        this.taskFactory.configure(LINT, LintGlobalTask.class, task -> new LintGlobalTask.GlobalCreationAction(this.globalScope, filteredVariants).configure((LintGlobalTask)((Object)task)));
        this.taskFactory.configure(LINT_FIX, LintFixTask.class, task -> new LintFixTask.GlobalCreationAction(this.globalScope, filteredVariants).configure((LintFixTask)((Object)task)));
        for (VariantScope scope : variants) {
            scope.getArtifacts().copy(InternalArtifactType.LINT_PUBLISH_JAR, this.globalScope.getArtifacts());
        }
    }

    public void createMockableJarTask() {
        this.project.getDependencies().add("androidApis", (Object)this.project.files(new Object[]{() -> (File)this.globalScope.getSdkComponents().getAndroidJarProvider().getOrNull()}));
        this.createMockableJar = this.project.getTasks().register("createMockableJar");
        this.createMockableJar.configure(task -> task.dependsOn(new Object[]{this.globalScope.getMockableJarArtifact()}));
    }

    public static Configuration createAndroidJarConfig(Project project2) {
        Configuration androidJarConfig = (Configuration)project2.getConfigurations().maybeCreate("androidApis");
        androidJarConfig.setDescription("Configuration providing various types of Android JAR file");
        androidJarConfig.setCanBeConsumed(false);
        return androidJarConfig;
    }

    protected void createDependencyStreams(VariantScope variantScope) {
        this.handleJacocoDependencies(variantScope);
        TransformManager transformManager = variantScope.getTransformManager();
        transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES)).build());
        if (!this.getJavaResMergingScopes(variantScope, (QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES).contains(QualifiedContent.Scope.EXTERNAL_LIBRARIES)) {
            transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-java-res").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.RESOURCES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.JAVA_RES)).build());
        }
        transformManager.addStream(OriginalStream.builder(this.project, "sub-projects-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.CLASSES)).build());
        if (!this.getJavaResMergingScopes(variantScope, (QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES).contains(QualifiedContent.Scope.SUB_PROJECTS)) {
            transformManager.addStream(OriginalStream.builder(this.project, "sub-projects-java-res").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.RESOURCES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.JAVA_RES)).build());
        }
        if (variantScope.consumesFeatureJars() || variantScope.getNeedsMainDexListForBundle()) {
            transformManager.addStream(OriginalStream.builder(this.project, "metadata-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope(InternalScope.FEATURES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.METADATA_CLASSES)).build());
        }
        transformManager.addStream(OriginalStream.builder(this.project, "provided-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROVIDED_ONLY).setFileCollection(variantScope.getProvidedOnlyClasspath()).build());
        if (variantScope.getTestedVariantData() != null) {
            BaseVariantData testedVariantData = variantScope.getTestedVariantData();
            VariantScope testedVariantScope = testedVariantData.getScope();
            PublishingSpecs.VariantSpec testedSpec = testedVariantScope.getPublishingSpec().getTestingSpec(variantScope.getVariantConfiguration().getType());
            PublishingSpecs.OutputSpec taskOutputSpec = testedSpec.getSpec(AndroidArtifacts.ArtifactType.CLASSES, AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS);
            ArtifactType testedOutputType = taskOutputSpec.getOutputType();
            variantScope.getArtifacts().copy(InternalArtifactType.TESTED_CODE_CLASSES, testedVariantScope.getArtifacts(), testedOutputType);
            transformManager.addStream(OriginalStream.builder(this.project, "tested-code-classes").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.TESTED_CODE).setFileCollection(testedVariantScope.getArtifacts().getFinalProductAsFileCollection(testedOutputType)).build());
            transformManager.addStream(OriginalStream.builder(this.project, "tested-code-deps").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.TESTED_CODE).setArtifactCollection(testedVariantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES)).build());
        }
    }

    public void createBuildArtifactReportTask(VariantScope scope) {
        this.taskFactory.register(new BuildArtifactReportTask.BuildArtifactReportCreationAction(scope));
    }

    public void createMergeApkManifestsTask(VariantScope variantScope) {
        AndroidArtifactVariantData androidArtifactVariantData = (AndroidArtifactVariantData)variantScope.getVariantData();
        Set<String> screenSizes = androidArtifactVariantData.getCompatibleScreens();
        this.taskFactory.register(new CompatibleScreensManifest.CreationAction(variantScope, screenSizes));
        TaskProvider<? extends ManifestProcessorTask> processManifestTask = this.createMergeManifestTask(variantScope);
        MutableTaskContainer taskContainer = variantScope.getTaskContainer();
        if (taskContainer.getMicroApkTask() != null) {
            TaskFactoryUtils.dependsOn(processManifestTask, taskContainer.getMicroApkTask());
        }
    }

    protected static boolean packagesCustomClassDependencies(VariantScope scope, ProjectOptions options) {
        return TaskManager.appliesCustomClassTransforms(scope, options) && !scope.getType().isFeatureSplit();
    }

    protected static boolean appliesCustomClassTransforms(VariantScope scope, ProjectOptions options) {
        VariantType type = scope.getType();
        return ((CoreBuildType)scope.getVariantConfiguration().getBuildType()).isDebuggable() && type.isApk() && !type.isForTesting() && !TaskManager.getAdvancedProfilingTransforms(options).isEmpty();
    }

    private static List<String> getAdvancedProfilingTransforms(ProjectOptions options) {
        String string = options.get(StringOption.IDE_ANDROID_CUSTOM_CLASS_TRANSFORMS);
        if (string == null) {
            return ImmutableList.of();
        }
        return Splitter.on((char)',').splitToList((CharSequence)string);
    }

    protected TaskProvider<? extends ManifestProcessorTask> createMergeManifestTask(VariantScope variantScope) {
        return this.taskFactory.register(new ProcessApplicationManifest.CreationAction(variantScope, !TaskManager.getAdvancedProfilingTransforms(this.projectOptions).isEmpty()));
    }

    public TaskProvider<? extends ManifestProcessorTask> createMergeLibManifestsTask(VariantScope scope) {
        return this.taskFactory.register(new ProcessLibraryManifest.CreationAction(scope));
    }

    protected void createProcessTestManifestTask(VariantScope scope, VariantScope testedScope) {
        Provider mergedManifest = testedScope.getArtifacts().getFinalProduct(InternalArtifactType.MERGED_MANIFESTS);
        this.taskFactory.register(new ProcessTestManifest.CreationAction(scope, (FileCollection)this.project.files(new Object[]{mergedManifest})));
    }

    public void createRenderscriptTask(VariantScope scope) {
        MutableTaskContainer taskContainer = scope.getTaskContainer();
        TaskProvider<RenderscriptCompile> rsTask = this.taskFactory.register(new RenderscriptCompile.CreationAction(scope));
        GradleVariantConfiguration config2 = scope.getVariantConfiguration();
        TaskFactoryUtils.dependsOn(taskContainer.getResourceGenTask(), rsTask);
        if (!config2.getRenderscriptNdkModeEnabled()) {
            TaskFactoryUtils.dependsOn(taskContainer.getSourceGenTask(), rsTask);
        }
    }

    public TaskProvider<MergeResources> createMergeResourcesTask(VariantScope scope, boolean processResources2, ImmutableSet<MergeResources.Flag> flags) {
        boolean unitTestRawResources = this.globalScope.getExtension().getTestOptions().getUnitTests().isIncludeAndroidResources() && !this.projectOptions.get(BooleanOption.ENABLE_UNIT_TEST_BINARY_RESOURCES);
        boolean alsoOutputNotCompiledResources = scope.getType().isApk() && !scope.getType().isForTesting() && (scope.useResourceShrinker() || unitTestRawResources);
        return this.basicCreateMergeResourcesTask(scope, MergeType.MERGE, null, true, processResources2, alsoOutputNotCompiledResources, flags, null);
    }

    public TaskProvider<MergeResources> basicCreateMergeResourcesTask(VariantScope scope, MergeType mergeType, File outputLocation, boolean includeDependencies, boolean processResources2, boolean alsoOutputNotCompiledResources, ImmutableSet<MergeResources.Flag> flags, TaskProviderCallback<MergeResources> taskProviderCallback) {
        String taskNamePrefix = mergeType.name().toLowerCase(Locale.ENGLISH);
        File mergedNotCompiledDir = alsoOutputNotCompiledResources ? new File(this.globalScope.getIntermediatesDir() + "/merged-not-compiled-resources/" + scope.getVariantConfiguration().getDirName()) : null;
        TaskProvider<MergeResources> mergeResourcesTask = this.taskFactory.register(new MergeResources.CreationAction(scope, mergeType, taskNamePrefix, mergedNotCompiledDir, includeDependencies, processResources2, flags), null, null, taskProviderCallback);
        scope.getArtifacts().producesDir(mergeType.getOutputType(), BuildArtifactsHolder.OperationType.INITIAL, mergeResourcesTask, MergeResources::getOutputDir, ((File)MoreObjects.firstNonNull((Object)outputLocation, (Object)scope.getDefaultMergeResourcesOutputDir())).getAbsolutePath(), "");
        if (alsoOutputNotCompiledResources) {
            scope.getArtifacts().producesDir(InternalArtifactType.MERGED_NOT_COMPILED_RES, BuildArtifactsHolder.OperationType.INITIAL, mergeResourcesTask, MergeResources::getMergedNotCompiledResourcesOutputDirectory, mergedNotCompiledDir.getAbsolutePath(), "");
        }
        if (this.extension.getTestOptions().getUnitTests().isIncludeAndroidResources()) {
            TaskFactoryUtils.dependsOn(scope.getTaskContainer().getCompileTask(), mergeResourcesTask);
        }
        return mergeResourcesTask;
    }

    public void createMergeAssetsTask(VariantScope scope) {
        this.taskFactory.register(new MergeSourceSetFolders.MergeAppAssetCreationAction(scope));
    }

    public void createMergeJniLibFoldersTasks(VariantScope variantScope) {
        this.taskFactory.register(new MergeSourceSetFolders.MergeJniLibFoldersCreationAction(variantScope));
        Set<QualifiedContent.ScopeType> mergeScopes = this.getJavaResMergingScopes(variantScope, ExtendedContentType.NATIVE_LIBS);
        this.taskFactory.register(new MergeNativeLibsTask.CreationAction(mergeScopes, variantScope));
    }

    public void createBuildConfigTask(VariantScope scope) {
        TaskProvider<GenerateBuildConfig> generateBuildConfigTask = this.taskFactory.register(new GenerateBuildConfig.CreationAction(scope));
        TaskFactoryUtils.dependsOn(scope.getTaskContainer().getSourceGenTask(), generateBuildConfigTask);
    }

    public void createGenerateResValuesTask(VariantScope scope) {
        TaskProvider<GenerateResValues> generateResValuesTask = this.taskFactory.register(new GenerateResValues.CreationAction(scope));
        TaskFactoryUtils.dependsOn(scope.getTaskContainer().getResourceGenTask(), generateResValuesTask);
    }

    public void createApkProcessResTask(VariantScope scope) {
        VariantType variantType = scope.getVariantData().getVariantConfiguration().getType();
        InternalArtifactType packageOutputType = variantType.isApk() && !variantType.isForTesting() ? InternalArtifactType.FEATURE_RESOURCE_PKG : null;
        this.createApkProcessResTask(scope, packageOutputType);
        if (scope.consumesFeatureJars()) {
            this.taskFactory.register(new MergeAaptProguardFilesCreationAction(scope));
        }
    }

    private void createApkProcessResTask(VariantScope scope, InternalArtifactType packageOutputType) {
        this.createProcessResTask(scope, scope.getSymbolTableFile(), packageOutputType, MergeType.MERGE, scope.getGlobalScope().getProjectBaseName());
    }

    protected boolean isLibrary() {
        return false;
    }

    public void createProcessResTask(VariantScope scope, File symbolLocation, InternalArtifactType packageOutputType, MergeType mergeType, String baseName) {
        BaseVariantData variantData = scope.getVariantData();
        variantData.calculateFilters(scope.getGlobalScope().getExtension().getSplits());
        boolean useAaptToGenerateLegacyMultidexMainDexProguardRules = scope.getNeedsMainDexList();
        if (scope.getGlobalScope().getExtension().getAaptOptions().getNamespaced()) {
            new NamespacedResourcesTaskManager(this.globalScope, this.taskFactory, scope).createNamespacedResourceTasks(packageOutputType, baseName, useAaptToGenerateLegacyMultidexMainDexProguardRules);
            ConfigurableFileCollection rFiles = this.project.files(new Object[]{scope.getArtifacts().getFinalProduct(InternalArtifactType.RUNTIME_R_CLASS_CLASSES)});
            scope.getTransformManager().addStream(OriginalStream.builder(this.project, "final-r-classes").addContentTypes((Set<QualifiedContent.ContentType>)(scope.getNeedsJavaResStreams() ? TransformManager.CONTENT_JARS : ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES))).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection((FileCollection)rFiles).build());
            scope.getArtifacts().appendToAllClasses((FileCollection)rFiles);
            return;
        }
        this.createNonNamespacedResourceTasks(scope, symbolLocation, packageOutputType, mergeType, baseName, useAaptToGenerateLegacyMultidexMainDexProguardRules);
    }

    private void createNonNamespacedResourceTasks(VariantScope scope, File symbolDirectory, InternalArtifactType packageOutputType, MergeType mergeType, String baseName, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules) {
        File symbolFile = new File(symbolDirectory, "R.txt");
        BuildArtifactsHolder artifacts = scope.getArtifacts();
        if (mergeType == MergeType.PACKAGE) {
            this.taskFactory.register(new ParseLibraryResourcesTask.CreateAction(scope));
            if (TaskManager.generatesProguardOutputFile(scope)) {
                this.taskFactory.register(new GenerateLibraryProguardRulesTask.CreationAction(scope));
            }
            this.taskFactory.register(new GenerateLibraryRFileTask.CreationAction(scope));
        } else {
            this.taskFactory.register(this.createProcessAndroidResourcesConfigAction(scope, useAaptToGenerateLegacyMultidexMainDexProguardRules, mergeType, baseName));
            if (packageOutputType != null) {
                artifacts.republish(InternalArtifactType.PROCESSED_RES, packageOutputType);
            }
            this.taskFactory.register(new LinkAndroidResForBundleTask.CreationAction(scope));
            if (!this.projectOptions.get(BooleanOption.GENERATE_R_JAVA)) {
                scope.getArtifacts().appendToAllClasses((FileCollection)this.project.files(new Object[]{artifacts.getFinalProduct(InternalArtifactType.COMPILE_AND_RUNTIME_NOT_NAMESPACED_R_CLASS_JAR)}));
            }
        }
    }

    private static boolean generatesProguardOutputFile(VariantScope variantScope) {
        return variantScope.getCodeShrinker() != null || variantScope.getType().isFeatureSplit();
    }

    protected VariantTaskCreationAction<LinkApplicationAndroidResourcesTask> createProcessAndroidResourcesConfigAction(VariantScope scope, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules, MergeType sourceArtifactType, String baseName) {
        return new LinkApplicationAndroidResourcesTask.CreationAction(scope, useAaptToGenerateLegacyMultidexMainDexProguardRules, sourceArtifactType, baseName, this.isLibrary());
    }

    public void createSplitResourcesTasks(VariantScope scope) {
        BaseVariantData variantData = scope.getVariantData();
        Preconditions.checkState((boolean)variantData.getMultiOutputPolicy().equals((Object)MultiOutputPolicy.SPLITS), (Object)"Can only create split resources tasks for pure splits.");
        TaskProvider<PackageSplitRes> task = this.taskFactory.register(new PackageSplitRes.CreationAction(scope));
    }

    public void createSplitAbiTasks(VariantScope scope) {
        BaseVariantData variantData = scope.getVariantData();
        Preconditions.checkState((boolean)variantData.getMultiOutputPolicy().equals((Object)MultiOutputPolicy.SPLITS), (Object)"split ABI tasks are only compatible with pure splits.");
        ImmutableSet<String> filters = AbiSplitOptions.getAbiFilters(this.extension.getSplits().getAbiFilters());
        if (filters.isEmpty()) {
            return;
        }
        List<ApkData> fullApkDatas = variantData.getOutputScope().getSplitsByType(VariantOutput.OutputType.FULL_SPLIT);
        if (!fullApkDatas.isEmpty()) {
            throw new RuntimeException("In release 21 and later, there cannot be full splits and pure splits, found " + Joiner.on((String)",").join(fullApkDatas) + " and abi filters " + Joiner.on((String)",").join(filters));
        }
        this.taskFactory.register(new GenerateSplitAbiRes.CreationAction(scope));
        this.taskFactory.register(new PackageSplitAbi.CreationAction(scope, TaskManager.packagesCustomClassDependencies(scope, this.projectOptions)));
    }

    public void createSplitTasks(VariantScope variantScope) {
        this.createSplitResourcesTasks(variantScope);
        this.createSplitAbiTasks(variantScope);
    }

    protected abstract Set<QualifiedContent.ScopeType> getJavaResMergingScopes(VariantScope var1, QualifiedContent.ContentType var2);

    public void createProcessJavaResTask(VariantScope variantScope) {
        this.taskFactory.register(new ProcessJavaResTask.CreationAction(variantScope));
        if (variantScope.getNeedsJavaResStreams()) {
            variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "processed-java-res").addContentType((QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection((FileCollection)variantScope.getGlobalScope().getProject().files(new Object[]{variantScope.getArtifacts().getFinalProduct(InternalArtifactType.JAVA_RES)})).build());
        }
    }

    public void createMergeJavaResTask(VariantScope variantScope) {
        TransformManager transformManager = variantScope.getTransformManager();
        Set<QualifiedContent.ScopeType> mergeScopes = this.getJavaResMergingScopes(variantScope, (QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES);
        this.taskFactory.register(new MergeJavaResourceTask.CreationAction(mergeScopes, variantScope));
        if (variantScope.getNeedsMergedJavaResStream()) {
            Provider mergedJavaResProvider = variantScope.getArtifacts().getFinalProduct(InternalArtifactType.MERGED_JAVA_RES);
            transformManager.addStream(OriginalStream.builder(this.project, "merged-java-res").addContentTypes(TransformManager.CONTENT_RESOURCES).addScopes(mergeScopes).setFileCollection(this.project.getLayout().files(new Object[]{mergedJavaResProvider})).build());
        }
    }

    public TaskProvider<AidlCompile> createAidlTask(VariantScope scope) {
        MutableTaskContainer taskContainer = scope.getTaskContainer();
        TaskProvider<AidlCompile> aidlCompileTask = this.taskFactory.register(new AidlCompile.CreationAction(scope));
        TaskFactoryUtils.dependsOn(taskContainer.getSourceGenTask(), aidlCompileTask);
        return aidlCompileTask;
    }

    public void createShaderTask(VariantScope scope) {
        TaskProvider<MergeSourceSetFolders> mergeShadersTask = this.taskFactory.register(new MergeSourceSetFolders.MergeShaderSourceFoldersCreationAction(scope));
        TaskProvider<ShaderCompile> shaderCompileTask = this.taskFactory.register(new ShaderCompile.CreationAction(scope));
        TaskFactoryUtils.dependsOn(scope.getTaskContainer().getAssetGenTask(), shaderCompileTask);
    }

    protected abstract void postJavacCreation(VariantScope var1);

    public TaskProvider<? extends JavaCompile> createJavacTask(VariantScope scope) {
        this.taskFactory.register(new JavaPreCompileTask.CreationAction(scope));
        boolean processAnnotationsTaskCreated = ProcessAnnotationsTask.taskShouldBeCreated(scope);
        if (processAnnotationsTaskCreated) {
            this.taskFactory.register(new ProcessAnnotationsTaskCreationAction(scope));
        }
        TaskProvider<AndroidJavaCompile> javacTask = this.taskFactory.register(new AndroidJavaCompile.CreationAction(scope, processAnnotationsTaskCreated));
        this.postJavacCreation(scope);
        return javacTask;
    }

    protected void addJavacClassesStream(VariantScope scope) {
        BuildArtifactsHolder artifacts = scope.getArtifacts();
        Provider javaOutputs = artifacts.getFinalProduct(InternalArtifactType.JAVAC);
        Preconditions.checkNotNull(javaOutputs);
        scope.getTransformManager().addStream(OriginalStream.builder(this.project, "javac-output").addContentTypes((Set<QualifiedContent.ContentType>)(scope.getNeedsJavaResStreams() ? TransformManager.CONTENT_JARS : ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES))).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection(this.project.getLayout().files(new Object[]{javaOutputs})).build());
        scope.getTransformManager().addStream(OriginalStream.builder(this.project, "pre-javac-generated-bytecode").addContentTypes((Set<QualifiedContent.ContentType>)(scope.getNeedsJavaResStreams() ? TransformManager.CONTENT_JARS : ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES))).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection(scope.getVariantData().getAllPreJavacGeneratedBytecode()).build());
        scope.getTransformManager().addStream(OriginalStream.builder(this.project, "post-javac-generated-bytecode").addContentTypes((Set<QualifiedContent.ContentType>)(scope.getNeedsJavaResStreams() ? TransformManager.CONTENT_JARS : ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES))).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection(scope.getVariantData().getAllPostJavacGeneratedBytecode()).build());
        if (scope.getGlobalScope().getExtension().getAaptOptions().getNamespaced() && this.projectOptions.get(BooleanOption.CONVERT_NON_NAMESPACED_DEPENDENCIES)) {
            scope.getTransformManager().addStream(OriginalStream.builder(this.project, "auto-namespaced-dependencies-classes").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setFileCollection(artifacts.getFinalProductAsFileCollection(InternalArtifactType.NAMESPACED_CLASSES_JAR)).build());
        }
    }

    protected void createCompileTask(VariantScope variantScope) {
        TaskProvider<? extends JavaCompile> javacTask = this.createJavacTask(variantScope);
        this.addJavacClassesStream(variantScope);
        TaskManager.setJavaCompilerTask(javacTask, variantScope);
        this.createPostCompilationTasks(variantScope);
    }

    public static void setJavaCompilerTask(TaskProvider<? extends JavaCompile> javaCompilerTask, VariantScope scope) {
        TaskFactoryUtils.dependsOn(scope.getTaskContainer().getCompileTask(), javaCompilerTask);
    }

    public void createGenerateMicroApkDataTask(VariantScope scope, FileCollection config2) {
        TaskProvider<GenerateApkDataTask> generateMicroApkTask = this.taskFactory.register(new GenerateApkDataTask.CreationAction(scope, config2));
        TaskFactoryUtils.dependsOn(scope.getTaskContainer().getResourceGenTask(), generateMicroApkTask);
    }

    public void createExternalNativeBuildJsonGenerators(VariantScope scope) {
        CxxModuleModel module2 = TryCreateCxxModuleModelKt.tryCreateCxxModuleModel(scope.getGlobalScope());
        if (module2 == null) {
            return;
        }
        scope.getTaskContainer().setExternalNativeJsonGenerator(TaskInputHelper.memoizeToProvider(this.project, () -> ExternalNativeJsonGenerator.create(module2, scope)));
    }

    public void createExternalNativeBuildTasks(VariantScope scope) {
        MutableTaskContainer taskContainer = scope.getTaskContainer();
        Provider<ExternalNativeJsonGenerator> generator = taskContainer.getExternalNativeJsonGenerator();
        if (generator == null) {
            return;
        }
        TaskProvider<ExternalNativeBuildJsonTask> generateTask = this.taskFactory.register(ExternalNativeBuildJsonTask.createTaskConfigAction(generator, scope));
        ProjectOptions projectOptions = this.globalScope.getProjectOptions();
        TaskProvider<ExternalNativeBuildTask> buildTask = this.taskFactory.register(new ExternalNativeBuildTask.CreationAction(generator, generateTask, scope));
        TaskFactoryUtils.dependsOn(taskContainer.getCompileTask(), buildTask);
        TaskProvider<Task> cleanTask = this.taskFactory.named("clean");
        TaskFactoryUtils.dependsOn(cleanTask, this.taskFactory.register(new ExternalNativeCleanTask.CreationAction(generator, scope)));
    }

    public void createUnitTestVariantTasks(TestVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        BuildArtifactsHolder artifacts = variantScope.getArtifacts();
        BaseVariantData testedVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)variantScope.getTestedVariantData(), (Object)"Not a unit test variant");
        VariantScope testedVariantScope = testedVariantData.getScope();
        boolean includeAndroidResources = this.extension.getTestOptions().getUnitTests().isIncludeAndroidResources();
        boolean enableBinaryResources = includeAndroidResources && this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_UNIT_TEST_BINARY_RESOURCES);
        this.createAnchorTasks(variantScope);
        this.createDependencyStreams(variantScope);
        this.createProcessJavaResTask(variantScope);
        if (includeAndroidResources) {
            if (testedVariantScope.getType().isAar()) {
                this.createProcessTestManifestTask(variantScope, testedVariantData.getScope());
                this.createGenerateResValuesTask(variantScope);
                this.createMergeAssetsTask(variantScope);
                if (enableBinaryResources) {
                    this.createMergeResourcesTask(variantScope, true, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of());
                    this.createApkProcessResTask(variantScope, InternalArtifactType.FEATURE_RESOURCE_PKG);
                    this.taskFactory.register(new PackageForUnitTest.CreationAction(variantScope));
                } else {
                    this.createMergeResourcesTask(variantScope, false, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of());
                }
            } else if (testedVariantScope.getType().isApk()) {
                if (enableBinaryResources) {
                    artifacts.copy(InternalArtifactType.PROCESSED_RES, testedVariantScope.getArtifacts());
                    artifacts.copy(InternalArtifactType.MERGED_ASSETS, testedVariantScope.getArtifacts());
                    this.taskFactory.register(new PackageForUnitTest.CreationAction(variantScope));
                } else {
                    artifacts.copy(InternalArtifactType.MERGED_RES, testedVariantScope.getArtifacts(), InternalArtifactType.MERGED_NOT_COMPILED_RES);
                }
            } else {
                throw new IllegalStateException("Tested variant " + testedVariantScope.getFullVariantName() + " in " + this.globalScope.getProject().getPath() + " must be a library or an application to have unit tests.");
            }
            TaskProvider<GenerateTestConfig> generateTestConfig = this.taskFactory.register(new GenerateTestConfig.CreationAction(variantScope));
            TaskProvider<? extends Task> compileTask = variantScope.getTaskContainer().getCompileTask();
            TaskFactoryUtils.dependsOn(compileTask, generateTestConfig);
            compileTask.configure(task -> {
                GenerateTestConfig.TestConfigInputs testConfigInputs = new GenerateTestConfig.TestConfigInputs(variantScope);
                TaskInputs taskInputs = task.getInputs();
                taskInputs.property("isUseRelativePathEnabled", (Object)testConfigInputs.isUseRelativePathEnabled());
                taskInputs.files(new Object[]{testConfigInputs.getResourceApk()}).withPropertyName("resourceApk").optional().withPathSensitivity(PathSensitivity.RELATIVE);
                taskInputs.files(new Object[]{testConfigInputs.getMergedResources()}).withPropertyName("mergedResources").optional().withPathSensitivity(PathSensitivity.RELATIVE);
                taskInputs.files(new Object[]{testConfigInputs.getMergedAssets()}).withPropertyName("mergedAssets").withPathSensitivity(PathSensitivity.RELATIVE);
                taskInputs.files(new Object[]{testConfigInputs.getMergedManifest()}).withPropertyName("mergedManifest").withPathSensitivity(PathSensitivity.RELATIVE);
                taskInputs.property("mainApkInfo", (Object)testConfigInputs.getMainApkInfo());
                taskInputs.property("packageNameOfFinalRClassProvider", testConfigInputs::getPackageNameOfFinalRClass);
            });
        }
        TaskProvider<? extends Task> compileTask = variantScope.getTaskContainer().getCompileTask();
        TaskFactoryUtils.dependsOn(compileTask, variantScope.getTaskContainer().getProcessJavaResourcesTask(), testedVariantScope.getTaskContainer().getProcessJavaResourcesTask());
        artifacts.emptyFile(InternalArtifactType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR);
        TaskProvider<? extends JavaCompile> javacTask = this.createJavacTask(variantScope);
        this.addJavacClassesStream(variantScope);
        TaskManager.setJavaCompilerTask(javacTask, variantScope);
        this.createRunUnitTestTask(variantScope);
        variantScope.getTaskContainer().getAssembleTask().configure(task -> task.setGroup(null));
    }

    protected void registerRClassTransformStream(VariantScope variantScope) {
        if (this.globalScope.getExtension().getAaptOptions().getNamespaced() || this.projectOptions.get(BooleanOption.GENERATE_R_JAVA)) {
            return;
        }
        ConfigurableFileCollection rClassJar = this.project.files(new Object[]{variantScope.getArtifacts().getFinalProduct(InternalArtifactType.COMPILE_AND_RUNTIME_NOT_NAMESPACED_R_CLASS_JAR)});
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "compile-and-runtime-light-r-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection((FileCollection)rClassJar).build());
    }

    public void createAndroidTestVariantTasks(TestVariantData variantData, List<VariantScope> variantScopesForLint) {
        VariantScope variantScope = variantData.getScope();
        this.createAnchorTasks(variantScope);
        this.createDependencyStreams(variantScope);
        this.taskFactory.register(new MainApkListPersistence.CreationAction(variantScope));
        this.createProcessTestManifestTask(variantScope, ((BaseVariantData)Preconditions.checkNotNull((Object)variantScope.getTestedVariantData())).getScope());
        this.createGenerateResValuesTask(variantScope);
        this.createRenderscriptTask(variantScope);
        this.createMergeResourcesTask(variantScope, true, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of());
        this.createShaderTask(variantScope);
        this.createMergeAssetsTask(variantScope);
        this.createBuildConfigTask(variantScope);
        this.createApkProcessResTask(variantScope);
        this.registerRClassTransformStream(variantScope);
        this.createProcessJavaResTask(variantScope);
        this.createAidlTask(variantScope);
        this.createMergeJniLibFoldersTasks(variantScope);
        this.createDataBindingTasksIfNecessary(variantScope, MergeType.MERGE);
        TaskProvider<? extends JavaCompile> javacTask = this.createJavacTask(variantScope);
        this.addJavacClassesStream(variantScope);
        TaskManager.setJavaCompilerTask(javacTask, variantScope);
        this.createPostCompilationTasks(variantScope);
        this.createValidateSigningTask(variantScope);
        this.taskFactory.register(new SigningConfigWriterTask.CreationAction(variantScope));
        this.createPackagingTask(variantScope);
        this.maybeCreateLintVitalTask((ApkVariantData)variantScope.getVariantData(), variantScopesForLint);
        this.taskFactory.configure(ASSEMBLE_ANDROID_TEST, (Action<? super Task>)((Action)assembleTest -> assembleTest.dependsOn(new Object[]{variantData.getTaskContainer().getAssembleTask().getName()})));
        this.createConnectedTestForVariant(variantScope);
    }

    static boolean isLintVariant(VariantScope variantScope) {
        VariantType variantType = variantScope.getVariantConfiguration().getType();
        return !variantType.isForTesting() && !variantType.isHybrid();
    }

    public void createLintTasks(VariantScope scope, List<VariantScope> variantScopes) {
        if (!TaskManager.isLintVariant(scope)) {
            return;
        }
        this.taskFactory.register(new LintPerVariantTask.CreationAction(scope, variantScopes));
    }

    private String getTaskPath(String taskName) {
        return this.project.getRootProject() == this.project ? ':' + taskName : this.project.getPath() + ':' + taskName;
    }

    public void maybeCreateLintVitalTask(ApkVariantData variantData, List<VariantScope> variantScopes) {
        VariantScope variantScope = variantData.getScope();
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        if (!TaskManager.isLintVariant(variantScope) || ((CoreBuildType)variantConfig.getBuildType()).isDebuggable() || !this.extension.getLintOptions().isCheckReleaseBuilds()) {
            return;
        }
        TaskProvider<LintPerVariantTask> lintReleaseCheck = this.taskFactory.register(new LintPerVariantTask.VitalCreationAction(variantScope, variantScopes), null, task -> task.dependsOn(new Object[]{variantScope.getTaskContainer().getJavacTask()}), null);
        TaskFactoryUtils.dependsOn(variantScope.getTaskContainer().getAssembleTask(), lintReleaseCheck);
        this.project.getGradle().getTaskGraph().whenReady(taskGraph -> {
            if (taskGraph.hasTask(this.getTaskPath(LINT))) {
                this.project.getTasks().getByName(lintReleaseCheck.getName()).setEnabled(false);
            }
        });
    }

    private void createRunUnitTestTask(VariantScope variantScope) {
        TaskProvider<AndroidUnitTest> runTestsTask = this.taskFactory.register(new AndroidUnitTest.CreationAction(variantScope));
        this.taskFactory.configure("test", (Action<? super Task>)((Action)test -> test.dependsOn(new Object[]{runTestsTask})));
    }

    public void createTopLevelTestTasks(boolean hasFlavors) {
        Object deviceAndroidTestTask;
        Object connectedAndroidTestTask;
        this.createMockableJarTask();
        ArrayList reportTasks = Lists.newArrayListWithExpectedSize((int)2);
        List<DeviceProvider> providers = this.extension.getDeviceProviders();
        if (hasFlavors) {
            connectedAndroidTestTask = this.taskFactory.register(new AndroidReportTask.CreationAction(this.globalScope, AndroidReportTask.CreationAction.TaskKind.CONNECTED));
            reportTasks.add(connectedAndroidTestTask.getName());
        } else {
            connectedAndroidTestTask = this.taskFactory.register(CONNECTED_ANDROID_TEST, (Action<? super Task>)((Action)connectedTask -> {
                connectedTask.setGroup("verification");
                connectedTask.setDescription("Installs and runs instrumentation tests for all flavors on connected devices.");
            }));
        }
        this.taskFactory.configure(CONNECTED_CHECK, (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{connectedAndroidTestTask.getName()})));
        if (providers.size() > 1 || hasFlavors) {
            deviceAndroidTestTask = this.taskFactory.register(new AndroidReportTask.CreationAction(this.globalScope, AndroidReportTask.CreationAction.TaskKind.DEVICE_PROVIDER));
            reportTasks.add(deviceAndroidTestTask.getName());
        } else {
            deviceAndroidTestTask = this.taskFactory.register(DEVICE_ANDROID_TEST, (Action<? super Task>)((Action)providerTask -> {
                providerTask.setGroup("verification");
                providerTask.setDescription("Installs and runs instrumentation tests using all Device Providers.");
            }));
        }
        this.taskFactory.configure(DEVICE_CHECK, (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{deviceAndroidTestTask.getName()})));
        this.taskFactory.register("test", (Action<? super Task>)((Action)unitTestTask -> {
            unitTestTask.setGroup("verification");
            unitTestTask.setDescription("Run unit tests for all variants.");
        }));
        this.taskFactory.configure("check", (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{"test"})));
        if (!reportTasks.isEmpty() && this.project.getGradle().getStartParameter().isContinueOnFailure()) {
            this.project.getGradle().getTaskGraph().whenReady(taskGraph -> {
                for (String reportTask : reportTasks) {
                    if (!taskGraph.hasTask(this.getTaskPath(reportTask))) continue;
                    this.taskFactory.configure(reportTask, (Action<? super Task>)((Action)task -> ((AndroidReportTask)task).setWillRun()));
                }
            });
        }
    }

    protected void createConnectedTestForVariant(VariantScope testVariantScope) {
        AbstractTestDataImpl testData;
        BaseVariantData baseVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)testVariantScope.getTestedVariantData());
        TestVariantData testVariantData = (TestVariantData)testVariantScope.getVariantData();
        boolean isLibrary = baseVariantData.getVariantConfiguration().getType().isAar();
        if (baseVariantData.getVariantConfiguration().getType().isDynamicFeature()) {
            testData = new BundleTestDataImpl(testVariantData, testVariantScope.getArtifacts().getFinalProduct(InternalArtifactType.APK), FeatureSplitUtils.getFeatureName(this.globalScope.getProject().getPath()), baseVariantData.getScope().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.APKS_FROM_BUNDLE));
        } else {
            ConfigurableFileCollection testedApkFileCollection = this.project.files(new Object[]{testVariantData.getTestedVariantData().getScope().getArtifacts().getFinalProduct(InternalArtifactType.APK)});
            testData = new TestDataImpl(testVariantData, testVariantScope.getArtifacts().getFinalProduct(InternalArtifactType.APK), (FileCollection)(isLibrary ? null : testedApkFileCollection));
        }
        this.configureTestData(testData);
        TaskProvider<DeviceProviderInstrumentTestTask> connectedTask = this.taskFactory.register(new DeviceProviderInstrumentTestTask.CreationAction(testVariantScope, (DeviceProvider)new ConnectedDeviceProvider(() -> (File)this.globalScope.getSdkComponents().getAdbExecutableProvider().get(), this.extension.getAdbOptions().getTimeOutInMs(), (ILogger)new LoggerWrapper(this.logger)), DeviceProviderInstrumentTestTask.CreationAction.Type.INTERNAL_CONNECTED_DEVICE_PROVIDER, testData, (FileCollection)this.project.files(new Object[0])));
        this.taskFactory.configure(CONNECTED_ANDROID_TEST, (Action<? super Task>)((Action)connectedAndroidTest -> connectedAndroidTest.dependsOn(new Object[]{connectedTask})));
        if (((CoreBuildType)baseVariantData.getVariantConfiguration().getBuildType()).isTestCoverageEnabled()) {
            Configuration jacocoAntConfiguration = JacocoConfigurations.getJacocoAntTaskConfiguration(this.project, JacocoTask.getJacocoVersion(testVariantScope));
            Iterator<DeviceProvider> reportTask = this.taskFactory.register(new JacocoReportTask.CreationAction(testVariantScope, jacocoAntConfiguration));
            TaskFactoryUtils.dependsOn(baseVariantData.getScope().getTaskContainer().getCoverageReportTask(), reportTask);
            this.taskFactory.configure(CONNECTED_ANDROID_TEST, (Action<? super Task>)((Action)connectedAndroidTest -> connectedAndroidTest.dependsOn(new Object[]{reportTask})));
        }
        List<DeviceProvider> providers = this.extension.getDeviceProviders();
        for (DeviceProvider deviceProvider : providers) {
            TaskProvider<DeviceProviderInstrumentTestTask> providerTask = this.taskFactory.register(new DeviceProviderInstrumentTestTask.CreationAction(testVariantData.getScope(), deviceProvider, DeviceProviderInstrumentTestTask.CreationAction.Type.CUSTOM_DEVICE_PROVIDER, testData, (FileCollection)this.project.files(new Object[0])));
            this.taskFactory.configure(DEVICE_ANDROID_TEST, (Action<? super Task>)((Action)deviceAndroidTest -> deviceAndroidTest.dependsOn(new Object[]{providerTask})));
        }
        List<TestServer> servers = this.extension.getTestServers();
        for (TestServer testServer : servers) {
            TaskProvider<TestServerTask> serverTask = this.taskFactory.register(new TestServerTask.TestServerTaskCreationAction(testVariantScope, testServer));
            TaskFactoryUtils.dependsOn(serverTask, testVariantScope.getTaskContainer().getAssembleTask());
            this.taskFactory.configure(DEVICE_CHECK, (Action<? super Task>)((Action)deviceAndroidTest -> deviceAndroidTest.dependsOn(new Object[]{serverTask})));
        }
    }

    public void createPostCompilationTasks(VariantScope variantScope) {
        CodeShrinker shrinker;
        boolean isTestCoverageEnabled;
        Preconditions.checkNotNull(variantScope.getTaskContainer().getJavacTask());
        BaseVariantData variantData = variantScope.getVariantData();
        GradleVariantConfiguration config2 = variantData.getVariantConfiguration();
        TransformManager transformManager = variantScope.getTransformManager();
        this.taskFactory.register(new MergeGeneratedProguardFilesCreationAction(variantScope));
        boolean bl = isTestCoverageEnabled = ((CoreBuildType)config2.getBuildType()).isTestCoverageEnabled() && !config2.getType().isForTesting();
        if (isTestCoverageEnabled) {
            this.createJacocoTask(variantScope);
        }
        this.maybeCreateDesugarTask(variantScope, config2.getMinSdkVersion(), transformManager, isTestCoverageEnabled);
        BaseExtension extension = variantScope.getGlobalScope().getExtension();
        this.createMergeJavaResTask(variantScope);
        List<Transform> customTransforms = extension.getTransforms();
        List<List<Object>> customTransformsDependencies = extension.getTransformsDependencies();
        int count = customTransforms.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Transform transform2 = customTransforms.get(i2);
            List<Object> deps = customTransformsDependencies.get(i2);
            transformManager.addTransform(this.taskFactory, variantScope, transform2, null, task -> {
                if (!deps.isEmpty()) {
                    task.dependsOn(new Object[]{deps});
                }
            }, taskProvider -> {
                if (transform2.getScopes().isEmpty()) {
                    TaskFactoryUtils.dependsOn(variantScope.getTaskContainer().getAssembleTask(), taskProvider);
                }
            });
        }
        if (variantData.getType().isFeatureSplit() || variantScope.consumesFeatureJars()) {
            this.taskFactory.register(new MergeClassesTask.CreationAction(variantScope));
        }
        if (TaskManager.appliesCustomClassTransforms(variantScope, this.projectOptions)) {
            for (String jar : TaskManager.getAdvancedProfilingTransforms(this.projectOptions)) {
                if (jar == null) continue;
                transformManager.addTransform(this.taskFactory, variantScope, new CustomClassTransform(jar, TaskManager.packagesCustomClassDependencies(variantScope, this.projectOptions)));
            }
        }
        if ((shrinker = this.maybeCreateJavaCodeShrinkerTransform(variantScope)) == CodeShrinker.R8) {
            this.maybeCreateResourcesShrinkerTasks(variantScope);
            this.maybeCreateDexSplitterTransform(variantScope);
            return;
        }
        DexingType dexingType = variantScope.getDexingType();
        if (dexingType == DexingType.LEGACY_MULTIDEX && variantScope.getVariantConfiguration().isMultiDexEnabled() && variantScope.getVariantConfiguration().getMinSdkVersionWithTargetDeviceApi().getFeatureLevel() >= 21) {
            dexingType = DexingType.NATIVE_MULTIDEX;
        }
        if (variantScope.getNeedsMainDexList()) {
            this.taskFactory.register(new D8MainDexListTask.CreationAction(variantScope, false));
        }
        if (variantScope.getNeedsMainDexListForBundle()) {
            this.taskFactory.register(new D8MainDexListTask.CreationAction(variantScope, true));
        }
        this.createDexTasks(variantScope, dexingType);
        this.maybeCreateResourcesShrinkerTasks(variantScope);
        this.maybeCreateDexSplitterTransform(variantScope);
    }

    private void maybeCreateDesugarTask(VariantScope variantScope, AndroidVersion minSdk, TransformManager transformManager, boolean isTestCoverageEnabled) {
        if (variantScope.getJava8LangSupportType() == VariantScope.Java8LangSupport.DESUGAR) {
            BaseVariantData testedVariant;
            FileCache userCache = this.getUserIntermediatesCache();
            variantScope.getTransformManager().consumeStreams((Set<? super QualifiedContent.Scope>)ImmutableSet.of((Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES), TransformManager.CONTENT_CLASS);
            this.taskFactory.register(new RecalculateStackFramesTask.CreationAction(variantScope, userCache, isTestCoverageEnabled));
            variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "fixed-stack-frames-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setFileCollection((FileCollection)this.project.files(new Object[]{variantScope.getArtifacts().getFinalProduct(InternalArtifactType.FIXED_STACK_FRAMES)}).getAsFileTree()).build());
            DesugarTransform desugarTransform = new DesugarTransform(variantScope.getBootClasspath(), userCache, minSdk.getFeatureLevel(), this.globalScope.getJavaProcessExecutor(), this.project.getLogger().isEnabled(LogLevel.INFO), this.projectOptions.get(BooleanOption.ENABLE_GRADLE_WORKERS), variantScope.getGlobalScope().getTmpFolder().toPath(), TaskManager.getProjectVariantId(variantScope), this.enableDesugarBugFixForJacoco(variantScope));
            transformManager.addTransform(this.taskFactory, variantScope, desugarTransform);
            if (minSdk.getFeatureLevel() >= 19) {
                return;
            }
            QualifiedContent.Scope scopeType = QualifiedContent.Scope.EXTERNAL_LIBRARIES;
            if (variantScope.getVariantConfiguration().getType().isTestComponent() && !(testedVariant = Objects.requireNonNull(variantScope.getTestedVariantData())).getType().isAar()) {
                scopeType = QualifiedContent.Scope.PROVIDED_ONLY;
            }
            String taskName = variantScope.getTaskName("extractTryWithResourcesSupportJar");
            TaskProvider<ExtractTryWithResourcesSupportJar> extractTryWithResources = this.taskFactory.register(new ExtractTryWithResourcesSupportJar.CreationAction(variantScope.getTryWithResourceRuntimeSupportJar(), taskName, variantScope.getFullVariantName()));
            variantScope.getTryWithResourceRuntimeSupportJar().builtBy(new Object[]{extractTryWithResources});
            transformManager.addStream(OriginalStream.builder(this.project, "runtime-deps-try-with-resources").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)scopeType).setFileCollection((FileCollection)variantScope.getTryWithResourceRuntimeSupportJar()).build());
        }
    }

    private void createDexTasks(VariantScope variantScope, DexingType dexingType) {
        DexOptions dexOptions;
        TransformManager transformManager = variantScope.getTransformManager();
        if (variantScope.getVariantData().getType().isTestComponent()) {
            dexOptions = DefaultDexOptions.copyOf((com.android.builder.core.DexOptions)this.extension.getDexOptions());
            dexOptions.setAdditionalParameters((List)ImmutableList.of());
        } else {
            dexOptions = this.extension.getDexOptions();
        }
        VariantScope.Java8LangSupport java8SLangSupport = variantScope.getJava8LangSupportType();
        boolean minified = variantScope.getCodeShrinker() != null;
        boolean supportsDesugaring = java8SLangSupport == VariantScope.Java8LangSupport.UNUSED || java8SLangSupport == VariantScope.Java8LangSupport.D8 && this.projectOptions.get(BooleanOption.ENABLE_DEXING_DESUGARING_ARTIFACT_TRANSFORM);
        boolean enableDexingArtifactTransform = this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_DEXING_ARTIFACT_TRANSFORM) && this.extension.getTransforms().isEmpty() && !minified && supportsDesugaring && !TaskManager.appliesCustomClassTransforms(variantScope, this.projectOptions);
        FileCache userLevelCache = this.getUserDexCache(minified, dexOptions.getPreDexLibraries());
        DexArchiveBuilderTransform preDexTransform = new DexArchiveBuilderTransformBuilder().setAndroidJarClasspath(this.globalScope.getFilteredBootClasspath()).setDexOptions((com.android.builder.core.DexOptions)dexOptions).setMessageReceiver(variantScope.getGlobalScope().getMessageReceiver()).setErrorFormatMode(SyncOptions.getErrorFormatMode(variantScope.getGlobalScope().getProjectOptions())).setUserLevelCache(userLevelCache).setMinSdkVersion(variantScope.getVariantConfiguration().getMinSdkVersionWithTargetDeviceApi().getFeatureLevel()).setDexer(variantScope.getDexer()).setUseGradleWorkers(this.projectOptions.get(BooleanOption.ENABLE_GRADLE_WORKERS)).setInBufferSize(this.projectOptions.get(IntegerOption.DEXING_READ_BUFFER_SIZE)).setOutBufferSize(this.projectOptions.get(IntegerOption.DEXING_WRITE_BUFFER_SIZE)).setIsDebuggable(((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable()).setJava8LangSupportType(java8SLangSupport).setProjectVariant(TaskManager.getProjectVariantId(variantScope)).setNumberOfBuckets(this.projectOptions.get(IntegerOption.DEXING_NUMBER_OF_BUCKETS)).setIncludeFeaturesInScope(variantScope.consumesFeatureJars()).setEnableDexingArtifactTransform(enableDexingArtifactTransform).createDexArchiveBuilderTransform();
        transformManager.addTransform(this.taskFactory, variantScope, preDexTransform);
        if (this.projectOptions.get(BooleanOption.ENABLE_DUPLICATE_CLASSES_CHECK)) {
            this.taskFactory.register(new CheckDuplicateClassesTask.CreationAction(variantScope));
        }
        this.createDexMergingTasks(variantScope, dexingType, enableDexingArtifactTransform);
    }

    private void createDexMergingTasks(VariantScope variantScope, DexingType dexingType, boolean dexingUsingArtifactTransforms) {
        DexMergingTask.CreationAction configAction;
        boolean separateFileDependenciesDexingTask;
        boolean bl = separateFileDependenciesDexingTask = variantScope.getJava8LangSupportType() == VariantScope.Java8LangSupport.D8 && dexingUsingArtifactTransforms;
        if (separateFileDependenciesDexingTask) {
            DexFileDependenciesTask.CreationAction desugarFileDeps = new DexFileDependenciesTask.CreationAction(variantScope);
            this.taskFactory.register(desugarFileDeps);
        }
        if (dexingType == DexingType.LEGACY_MULTIDEX) {
            configAction = new DexMergingTask.CreationAction(variantScope, DexMergingAction.MERGE_ALL, dexingType, dexingUsingArtifactTransforms, separateFileDependenciesDexingTask);
            this.taskFactory.register(configAction);
        } else if (variantScope.getCodeShrinker() != null) {
            configAction = new DexMergingTask.CreationAction(variantScope, DexMergingAction.MERGE_ALL, dexingType, dexingUsingArtifactTransforms);
            this.taskFactory.register(configAction);
        } else {
            boolean produceSeparateOutputs = dexingType == DexingType.NATIVE_MULTIDEX && ((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable();
            this.taskFactory.register(new DexMergingTask.CreationAction(variantScope, DexMergingAction.MERGE_EXTERNAL_LIBS, DexingType.NATIVE_MULTIDEX, dexingUsingArtifactTransforms, separateFileDependenciesDexingTask, produceSeparateOutputs ? InternalArtifactType.DEX : InternalArtifactType.EXTERNAL_LIBS_DEX));
            if (produceSeparateOutputs) {
                DexMergingTask.CreationAction mergeProject = new DexMergingTask.CreationAction(variantScope, DexMergingAction.MERGE_PROJECT, dexingType, dexingUsingArtifactTransforms);
                this.taskFactory.register(mergeProject);
                DexMergingTask.CreationAction mergeLibraries = new DexMergingTask.CreationAction(variantScope, DexMergingAction.MERGE_LIBRARY_PROJECTS, dexingType, dexingUsingArtifactTransforms);
                this.taskFactory.register(mergeLibraries);
            } else {
                DexMergingTask.CreationAction configAction2 = new DexMergingTask.CreationAction(variantScope, DexMergingAction.MERGE_ALL, dexingType, dexingUsingArtifactTransforms);
                this.taskFactory.register(configAction2);
            }
        }
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "final-dex").addContentTypes(ExtendedContentType.DEX).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection((FileCollection)variantScope.getGlobalScope().getProject().files(new Object[]{variantScope.getArtifacts().getFinalProducts(InternalArtifactType.DEX)})).build());
    }

    private static String getProjectVariantId(VariantScope variantScope) {
        return variantScope.getGlobalScope().getProject().getName() + ":" + variantScope.getFullVariantName();
    }

    private FileCache getUserDexCache(boolean isMinifiedEnabled, boolean preDexLibraries) {
        if (!preDexLibraries || isMinifiedEnabled) {
            return null;
        }
        return this.getUserIntermediatesCache();
    }

    private FileCache getUserIntermediatesCache() {
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_INTERMEDIATE_ARTIFACTS_CACHE)) {
            return this.globalScope.getBuildCache();
        }
        return null;
    }

    protected void handleJacocoDependencies(VariantScope variantScope) {
        boolean isTestCoverageEnabled;
        GradleVariantConfiguration config2 = variantScope.getVariantConfiguration();
        boolean bl = isTestCoverageEnabled = ((CoreBuildType)config2.getBuildType()).isTestCoverageEnabled() && (!config2.getType().isTestComponent() || config2.getTestedConfig() != null && config2.getTestedConfig().getType().isAar());
        if (isTestCoverageEnabled) {
            if (variantScope.getDexer() == DexerTool.DX) {
                this.globalScope.getErrorHandler().reportWarning(EvalIssueReporter.Type.GENERIC, String.format("Jacoco version is downgraded to %s because dx is used. This is due to -P%s=false flag. See https://issuetracker.google.com/37116789 for more details.", "0.7.4.201502262128", BooleanOption.ENABLE_D8.getPropertyName()));
            }
            String jacocoAgentRuntimeDependency = JacocoConfigurations.getAgentRuntimeDependency(JacocoTask.getJacocoVersion(variantScope));
            this.project.getDependencies().add(variantScope.getVariantDependencies().getRuntimeClasspath().getName(), (Object)jacocoAgentRuntimeDependency);
            variantScope.getVariantDependencies().getRuntimeClasspath().resolutionStrategy(r -> r.force(new Object[]{jacocoAgentRuntimeDependency}));
        }
    }

    private boolean enableDesugarBugFixForJacoco(VariantScope scope) {
        try {
            GradleVersion current = GradleVersion.parse((String)JacocoTask.getJacocoVersion(scope));
            return JacocoConfigurations.MIN_WITHOUT_BROKEN_BYTECODE.compareTo(current) > 0;
        }
        catch (Throwable ignored) {
            return true;
        }
    }

    public void createJacocoTask(VariantScope variantScope) {
        variantScope.getTransformManager().consumeStreams((Set<? super QualifiedContent.Scope>)ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT), (Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES));
        this.taskFactory.register(new JacocoTask.CreationAction(variantScope));
        ConfigurableFileCollection instumentedClasses = this.project.files(new Object[]{variantScope.getArtifacts().getFinalProduct(InternalArtifactType.JACOCO_INSTRUMENTED_CLASSES), this.project.files(new Object[]{variantScope.getArtifacts().getFinalProduct(InternalArtifactType.JACOCO_INSTRUMENTED_JARS)}).getAsFileTree()});
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "jacoco-instrumented-classes").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection((FileCollection)instumentedClasses).build());
    }

    private void createDataBindingMergeArtifactsTask(VariantScope variantScope) {
        BaseVariantData testedVariantData;
        boolean dataBindingEnabled = this.extension.getDataBinding().isEnabled();
        boolean viewBindingEnabled = this.extension.getViewBinding().isEnabled();
        if (!dataBindingEnabled && !viewBindingEnabled) {
            return;
        }
        BaseVariantData variantData = variantScope.getVariantData();
        VariantType type = variantData.getType();
        if (type.isForTesting() && !this.extension.getDataBinding().isEnabledForTests() && !(testedVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)variantScope.getTestedVariantData())).getType().isAar()) {
            return;
        }
        this.taskFactory.register(new DataBindingMergeDependencyArtifactsTask.CreationAction(variantScope));
    }

    private void createDataBindingMergeBaseClassesTask(VariantScope variantScope) {
        BaseVariantData testedVariantData;
        BaseVariantData variantData = variantScope.getVariantData();
        VariantType type = variantData.getType();
        if (type.isForTesting() && !this.extension.getDataBinding().isEnabledForTests() && !(testedVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)variantScope.getTestedVariantData())).getType().isAar()) {
            return;
        }
        this.taskFactory.register(new DataBindingMergeBaseClassLogTask.CreationAction(variantScope));
    }

    protected void createDataBindingTasksIfNecessary(VariantScope scope, MergeType mergeType) {
        BaseVariantData testedVariantData;
        boolean dataBindingEnabled = this.extension.getDataBinding().isEnabled();
        boolean viewBindingEnabled = this.extension.getViewBinding().isEnabled();
        if (!dataBindingEnabled && !viewBindingEnabled) {
            return;
        }
        this.createDataBindingMergeBaseClassesTask(scope);
        this.createDataBindingMergeArtifactsTask(scope);
        VariantType type = scope.getType();
        if (type.isForTesting() && !this.extension.getDataBinding().isEnabledForTests() && !(testedVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)scope.getTestedVariantData())).getType().isAar()) {
            return;
        }
        this.dataBindingBuilder.setDebugLogEnabled(this.getLogger().isDebugEnabled());
        this.taskFactory.register(new DataBindingGenBaseClassesTask.CreationAction(scope));
        if (dataBindingEnabled) {
            this.taskFactory.register(new DataBindingExportBuildInfoTask.CreationAction(scope));
            this.setDataBindingAnnotationProcessorParams(scope, mergeType);
        }
    }

    private void setDataBindingAnnotationProcessorParams(VariantScope scope, MergeType mergeType) {
        BaseVariantData variantData = scope.getVariantData();
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        JavaCompileOptions javaCompileOptions = variantConfiguration.getJavaCompileOptions();
        com.android.build.gradle.api.AnnotationProcessorOptions processorOptions = javaCompileOptions.getAnnotationProcessorOptions();
        if (processorOptions instanceof AnnotationProcessorOptions) {
            AnnotationProcessorOptions options = (AnnotationProcessorOptions)processorOptions;
            if (!options.getClassNames().isEmpty() && !options.getClassNames().contains("android.databinding.annotationprocessor.ProcessDataBinding")) {
                options.className("android.databinding.annotationprocessor.ProcessDataBinding");
            }
            DataBindingCompilerArguments dataBindingArgs = DataBindingCompilerArguments.createArguments(scope, this.getLogger().isDebugEnabled(), this.dataBindingBuilder.getPrintMachineReadableOutput());
            options.compilerArgumentProvider(dataBindingArgs);
        } else {
            this.getLogger().error("Cannot setup data binding for %s because java compiler options is not an instance of AnnotationProcessorOptions", (Object)processorOptions);
        }
    }

    public void createPackagingTask(VariantScope variantScope) {
        ApkVariantData variantData = (ApkVariantData)variantScope.getVariantData();
        MutableTaskContainer taskContainer = variantData.getScope().getTaskContainer();
        boolean signedApk = variantData.isSigned();
        InternalArtifactType manifestType = variantScope.getManifestArtifactType();
        boolean splitsArePossible = variantScope.getVariantData().getMultiOutputPolicy() == MultiOutputPolicy.SPLITS;
        Provider manifests = variantScope.getArtifacts().getFinalProduct(manifestType);
        File finalApkLocation = variantScope.getApkLocation();
        File outputDirectory = splitsArePossible ? variantScope.getFullApkPackagesOutputDirectory() : finalApkLocation;
        InternalArtifactType taskOutputType = splitsArePossible ? InternalArtifactType.FULL_APK : InternalArtifactType.APK;
        InternalArtifactType resourceFilesInputType = variantScope.useResourceShrinker() ? InternalArtifactType.SHRUNK_PROCESSED_RES : InternalArtifactType.PROCESSED_RES;
        Action configureResourcesAndAssetsDependencies = task -> {
            task.dependsOn(new Object[]{taskContainer.getMergeAssetsTask()});
            if (taskContainer.getProcessAndroidResTask() != null) {
                task.dependsOn(new Object[]{taskContainer.getProcessAndroidResTask()});
            }
        };
        TaskProvider<PackageApplication> packageApp = this.taskFactory.register(new PackageApplication.CreationAction(variantScope, outputDirectory, resourceFilesInputType, manifests, manifestType, variantScope.getOutputScope(), this.globalScope.getBuildCache(), taskOutputType, TaskManager.packagesCustomClassDependencies(variantScope, this.projectOptions)), null, task -> {
            task.dependsOn(new Object[]{taskContainer.getJavacTask()});
            if (taskContainer.getPackageSplitResourcesTask() != null) {
                task.dependsOn(new Object[]{taskContainer.getPackageSplitResourcesTask()});
            }
            if (taskContainer.getPackageSplitAbiTask() != null) {
                task.dependsOn(new Object[]{taskContainer.getPackageSplitAbiTask()});
            }
            configureResourcesAndAssetsDependencies.execute((Object)task);
        }, null);
        TaskFactoryUtils.dependsOn(taskContainer.getAssembleTask(), packageApp.getName());
        if (splitsArePossible) {
            TaskProvider<CopyOutputs> copyOutputsTask = this.taskFactory.register(new CopyOutputs.CreationAction(variantScope, finalApkLocation));
            TaskFactoryUtils.dependsOn(taskContainer.getAssembleTask(), copyOutputsTask);
        }
        if (signedApk) {
            this.createInstallTask(variantScope);
        }
        TaskProvider<UninstallTask> uninstallTask = this.taskFactory.register(new UninstallTask.CreationAction(variantScope));
        this.taskFactory.configure(UNINSTALL_ALL, (Action<? super Task>)((Action)uninstallAll -> uninstallAll.dependsOn(new Object[]{uninstallTask})));
    }

    protected void createInstallTask(VariantScope variantScope) {
        this.taskFactory.register(new InstallVariantTask.CreationAction(variantScope));
    }

    protected void createValidateSigningTask(VariantScope variantScope) {
        if (variantScope.getVariantConfiguration().getSigningConfig() == null) {
            return;
        }
        this.taskFactory.register(new ValidateSigningTask.CreationAction(variantScope, GradleKeystoreHelper.getDefaultDebugKeystoreLocation()));
    }

    public void createAnchorAssembleTasks(List<VariantScope> variantScopes, int flavorCount, int flavorDimensionCount, int variantTypeCount) {
        ArrayList subAssembleTasks = Lists.newArrayList();
        ArrayList subBundleTasks = Lists.newArrayList();
        if (flavorCount > 0) {
            ArrayListMultimap assembleMap = ArrayListMultimap.create();
            ArrayListMultimap bundleMap = ArrayListMultimap.create();
            for (VariantScope variantScope : variantScopes) {
                VariantType variantType = variantScope.getType();
                if (variantType.isTestComponent()) continue;
                MutableTaskContainer taskContainer = variantScope.getTaskContainer();
                GradleVariantConfiguration variantConfig = variantScope.getVariantConfiguration();
                TaskProvider<? extends Task> assembleTask = taskContainer.getAssembleTask();
                assembleMap.put((Object)((CoreBuildType)variantConfig.getBuildType()).getName(), assembleTask);
                for (CoreProductFlavor flavor : variantConfig.getProductFlavors()) {
                    assembleMap.put((Object)flavor.getName(), assembleTask);
                }
                if (flavorDimensionCount > 1) {
                    assembleMap.put((Object)variantConfig.getFlavorName(), assembleTask);
                }
                if (!variantType.isBaseModule()) continue;
                TaskProvider<? extends Task> bundleTask = taskContainer.getBundleTask();
                bundleMap.put((Object)((CoreBuildType)variantConfig.getBuildType()).getName(), bundleTask);
                for (CoreProductFlavor flavor : variantConfig.getProductFlavors()) {
                    bundleMap.put((Object)flavor.getName(), bundleTask);
                }
                if (flavorDimensionCount <= 1) continue;
                bundleMap.put((Object)variantConfig.getFlavorName(), bundleTask);
            }
            Set dimensionKeys = assembleMap.keySet();
            for (String dimensionKey : dimensionKeys) {
                String dimensionName = StringHelper.capitalize((String)dimensionKey);
                subAssembleTasks.add(this.taskFactory.register("assemble" + dimensionName, (Action<? super Task>)((Action)arg_0 -> TaskManager.lambda$createAnchorAssembleTasks$40(dimensionName, (ListMultimap)assembleMap, dimensionKey, arg_0))));
                List subBundleMap = bundleMap.get((Object)dimensionKey);
                if (subBundleMap.isEmpty()) continue;
                subBundleTasks.add(this.taskFactory.register("bundle" + dimensionName, (Action<? super Task>)((Action)task -> {
                    task.setDescription("Assembles bundles for all " + dimensionName + " variants.");
                    task.setGroup(BUILD_GROUP);
                    task.dependsOn(new Object[]{subBundleMap});
                })));
            }
        } else if (variantTypeCount > 1) {
            ArrayListMultimap assembleMap = ArrayListMultimap.create();
            ArrayListMultimap bundleMap = ArrayListMultimap.create();
            for (VariantScope variantScope : variantScopes) {
                VariantType variantType = variantScope.getType();
                if (variantType.isTestComponent()) continue;
                MutableTaskContainer taskContainer = variantScope.getTaskContainer();
                GradleVariantConfiguration variantConfig = variantScope.getVariantConfiguration();
                assembleMap.put((Object)((CoreBuildType)variantConfig.getBuildType()).getName(), taskContainer.getAssembleTask());
                if (!variantType.isBaseModule()) continue;
                TaskProvider<? extends Task> bundleTask = taskContainer.getBundleTask();
                bundleMap.put((Object)((CoreBuildType)variantConfig.getBuildType()).getName(), bundleTask);
            }
            Set dimensionKeys = assembleMap.keySet();
            Iterator iterator = dimensionKeys.iterator();
            while (iterator.hasNext()) {
                String dimensionKey = (String)iterator.next();
                String dimensionName = StringHelper.capitalize((String)dimensionKey);
                subAssembleTasks.add(this.taskFactory.register("assemble" + dimensionName, (Action<? super Task>)((Action)arg_0 -> TaskManager.lambda$createAnchorAssembleTasks$42(dimensionName, (ListMultimap)assembleMap, dimensionKey, arg_0))));
                List subBundleMap = bundleMap.get((Object)dimensionKey);
                if (subBundleMap.isEmpty()) continue;
                subBundleTasks.add(this.taskFactory.register("bundle" + dimensionName, (Action<? super Task>)((Action)task -> {
                    task.setDescription("Assembles bundles for all " + dimensionName + " variants.");
                    task.setGroup(BUILD_GROUP);
                    task.dependsOn(new Object[]{subBundleMap});
                })));
            }
        } else {
            for (VariantScope variantScope : variantScopes) {
                VariantType variantType = variantScope.getType();
                if (variantType.isTestComponent()) continue;
                MutableTaskContainer mutableTaskContainer = variantScope.getTaskContainer();
                subAssembleTasks.add(mutableTaskContainer.getAssembleTask());
                if (!variantType.isBaseModule()) continue;
                subBundleTasks.add(mutableTaskContainer.getBundleTask());
            }
        }
        if (!subAssembleTasks.isEmpty()) {
            this.taskFactory.configure("assemble", (Action<? super Task>)((Action)task -> {
                task.setDescription("Assemble main outputs for all the variants.");
                task.setGroup(BUILD_GROUP);
                task.dependsOn(new Object[]{subAssembleTasks});
            }));
        }
        if (!subBundleTasks.isEmpty()) {
            this.taskFactory.register("bundle", (Action<? super Task>)((Action)task -> {
                task.setDescription("Assemble bundles for all the variants.");
                task.setGroup(BUILD_GROUP);
                task.dependsOn(new Object[]{subBundleTasks});
            }));
        }
    }

    public void createAssembleTask(BaseVariantData variantData) {
        VariantScope scope = variantData.getScope();
        this.taskFactory.register(this.getAssembleTaskName(scope, "assemble"), null, task -> task.setDescription("Assembles main output for variant " + scope.getVariantConfiguration().getFullName()), taskProvider -> scope.getTaskContainer().setAssembleTask((TaskProvider<? extends Task>)taskProvider));
    }

    private String getAssembleTaskName(VariantScope scope, String prefix) {
        String taskName = this.variantFactory.getVariantConfigurationTypes().size() == 1 ? scope.getTaskName(prefix) : StringHelper.appendCapitalized((String)prefix, (String)scope.getVariantConfiguration().computeHybridVariantName());
        return taskName;
    }

    public void createBundleTask(BaseVariantData variantData) {
        VariantScope scope = variantData.getScope();
        this.taskFactory.register(this.getAssembleTaskName(scope, "bundle"), null, task -> {
            task.setDescription("Assembles bundle for variant " + scope.getVariantConfiguration().getFullName());
            task.dependsOn(new Object[]{scope.getArtifacts().getFinalProduct(InternalArtifactType.BUNDLE)});
        }, taskProvider -> scope.getTaskContainer().setBundleTask((TaskProvider<? extends Task>)taskProvider));
    }

    protected CodeShrinker maybeCreateJavaCodeShrinkerTransform(VariantScope variantScope) {
        CodeShrinker codeShrinker = variantScope.getCodeShrinker();
        if (codeShrinker != null) {
            return this.doCreateJavaCodeShrinkerTransform(variantScope, codeShrinker, null);
        }
        return null;
    }

    protected final CodeShrinker doCreateJavaCodeShrinkerTransform(VariantScope variantScope, CodeShrinker codeShrinker, FileCollection mappingFileCollection) {
        Optional<TaskProvider<TransformTask>> transformTask;
        CodeShrinker createdShrinker = codeShrinker;
        switch (codeShrinker) {
            case PROGUARD: {
                transformTask = this.createProguardTransform(variantScope, mappingFileCollection);
                break;
            }
            case R8: {
                if (variantScope.getVariantConfiguration().getType().isAar() && !this.projectOptions.get(BooleanOption.ENABLE_R8_LIBRARIES)) {
                    transformTask = this.createProguardTransform(variantScope, mappingFileCollection);
                    createdShrinker = CodeShrinker.PROGUARD;
                    break;
                }
                transformTask = this.createR8Transform(variantScope, mappingFileCollection, (transform2, taskName) -> {
                    if (variantScope.getNeedsMainDexListForBundle()) {
                        Provider mainDexListFile = variantScope.getArtifacts().getFinalProduct(InternalArtifactType.MAIN_DEX_LIST_FOR_BUNDLE);
                        ((R8Transform)transform2).setMainDexListOutput(mainDexListFile);
                    }
                });
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown value " + (Object)((Object)codeShrinker)));
            }
        }
        if (variantScope.getPostprocessingFeatures() != null && transformTask.isPresent()) {
            TaskProvider<CheckProguardFiles> checkFilesTask = this.taskFactory.register(new CheckProguardFiles.CreationAction(variantScope));
            TaskFactoryUtils.dependsOn(transformTask.get(), checkFilesTask);
        }
        return createdShrinker;
    }

    private Optional<TaskProvider<TransformTask>> createProguardTransform(VariantScope variantScope, FileCollection mappingFileCollection) {
        BaseVariantData testedVariantData = variantScope.getTestedVariantData();
        ProGuardTransform transform2 = new ProGuardTransform(variantScope);
        Object inputProguardMapping = testedVariantData != null && testedVariantData.getScope().getArtifacts().hasFinalProduct(InternalArtifactType.APK_MAPPING) ? this.project.files(new Object[]{testedVariantData.getScope().getArtifacts().getFinalProduct(InternalArtifactType.APK_MAPPING)}) : mappingFileCollection;
        transform2.applyTestedMapping((FileCollection)inputProguardMapping);
        return this.applyProguardRules(variantScope, (FileCollection)inputProguardMapping, testedVariantData, transform2, null);
    }

    private Optional<TaskProvider<TransformTask>> applyProguardRules(VariantScope variantScope, FileCollection inputProguardMapping, BaseVariantData testedVariantData, ProguardConfigurable transform2, ProGuardTransformCallback callback) {
        if (testedVariantData != null) {
            VariantScope testedScope = testedVariantData.getScope();
            TaskManager.applyProguardDefaultsForTest(transform2);
            Object[] objectArray = new Object[2];
            objectArray[0] = testedScope::getTestProguardFiles;
            objectArray[1] = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CONSUMER_PROGUARD_RULES);
            ConfigurableFileCollection configurationFiles = this.project.files(objectArray);
            this.maybeAddFeatureProguardRules(variantScope, configurationFiles);
            transform2.setConfigurationFiles((FileCollection)configurationFiles);
        } else if (variantScope.getType().isForTesting() && !variantScope.getType().isTestComponent()) {
            TaskManager.applyProguardDefaultsForTest(transform2);
            Object[] objectArray = new Object[2];
            objectArray[0] = variantScope::getTestProguardFiles;
            objectArray[1] = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CONSUMER_PROGUARD_RULES);
            ConfigurableFileCollection configurationFiles = this.project.files(objectArray);
            this.maybeAddFeatureProguardRules(variantScope, configurationFiles);
            transform2.setConfigurationFiles((FileCollection)configurationFiles);
        } else {
            this.applyProguardConfigForNonTest(transform2, variantScope);
        }
        Optional<TaskProvider<TransformTask>> transformTaskTaskProvider = variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, transform2, taskName -> {
            if (callback != null) {
                callback.execute(transform2, taskName);
            }
        }, t -> {
            if (inputProguardMapping != null) {
                t.dependsOn(new Object[]{inputProguardMapping});
            }
            if (testedVariantData != null) {
                t.dependsOn(new Object[]{testedVariantData.getTaskContainer().getAssembleTask()});
            }
        }, null);
        transformTaskTaskProvider.ifPresent(taskTaskProvider -> variantScope.getArtifacts().producesFile(InternalArtifactType.APK_MAPPING, BuildArtifactsHolder.OperationType.INITIAL, taskTaskProvider, TransformTask::getOutputFile, "mapping.txt"));
        return transformTaskTaskProvider;
    }

    private static void applyProguardDefaultsForTest(ProguardConfigurable transform2) {
        boolean obfuscate = transform2 instanceof ProGuardTransform;
        transform2.setActions(new PostprocessingFeatures(false, obfuscate, false));
        transform2.keep("class * {*;}");
        transform2.keep("interface * {*;}");
        transform2.keep("enum * {*;}");
        transform2.keepattributes();
    }

    private void applyProguardConfigForNonTest(ProguardConfigurable transform2, VariantScope scope) {
        GradleVariantConfiguration variantConfig = scope.getVariantConfiguration();
        PostprocessingFeatures postprocessingFeatures = scope.getPostprocessingFeatures();
        if (postprocessingFeatures != null) {
            transform2.setActions(postprocessingFeatures);
        }
        Callable<Collection> proguardConfigFiles = scope::getProguardFiles;
        InternalArtifactType aaptProguardFileType = scope.consumesFeatureJars() ? InternalArtifactType.MERGED_AAPT_PROGUARD_FILE : InternalArtifactType.AAPT_PROGUARD_FILE;
        ConfigurableFileCollection configurationFiles = this.project.files(new Object[]{proguardConfigFiles, scope.getArtifacts().getFinalProduct(aaptProguardFileType), scope.getArtifacts().getFinalProduct(InternalArtifactType.GENERATED_PROGUARD_FILE), scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CONSUMER_PROGUARD_RULES)});
        if (scope.getType().isHybrid() && scope.getType().isBaseModule()) {
            Callable<Collection> consumerProguardFiles = scope::getConsumerProguardFiles;
            configurationFiles.from(new Object[]{consumerProguardFiles});
        }
        this.maybeAddFeatureProguardRules(scope, configurationFiles);
        transform2.setConfigurationFiles((FileCollection)configurationFiles);
        if (scope.getVariantData().getType().isAar()) {
            transform2.keep("class **.R");
            transform2.keep("class **.R$*");
        }
        if (variantConfig.isTestCoverageEnabled()) {
            transform2.keep("class com.vladium.** {*;}");
            transform2.keep("class org.jacoco.** {*;}");
            transform2.keep("interface org.jacoco.** {*;}");
            transform2.dontwarn("org.jacoco.**");
        }
    }

    private void maybeAddFeatureProguardRules(VariantScope variantScope, ConfigurableFileCollection configurationFiles) {
        if (variantScope.consumesFeatureJars()) {
            configurationFiles.from(new Object[]{variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.CONSUMER_PROGUARD_RULES)});
        }
    }

    private Optional<TaskProvider<TransformTask>> createR8Transform(VariantScope variantScope, FileCollection mappingFileCollection, ProGuardTransformCallback callback) {
        BaseVariantData testedVariantData = variantScope.getTestedVariantData();
        File multiDexKeepProguard = variantScope.getVariantConfiguration().getMultiDexKeepProguard();
        ConfigurableFileCollection userMainDexListProguardRules = multiDexKeepProguard != null ? this.project.files(new Object[]{multiDexKeepProguard}) : this.project.files(new Object[0]);
        File multiDexKeepFile = variantScope.getVariantConfiguration().getMultiDexKeepFile();
        ConfigurableFileCollection userMainDexListFiles = multiDexKeepFile != null ? this.project.files(new Object[]{multiDexKeepFile}) : this.project.files(new Object[0]);
        Object inputProguardMapping = testedVariantData != null && testedVariantData.getScope().getArtifacts().hasFinalProduct(InternalArtifactType.APK_MAPPING) ? this.project.files(new Object[]{testedVariantData.getScope().getArtifacts().getFinalProduct(InternalArtifactType.APK_MAPPING)}) : (FileCollection)MoreObjects.firstNonNull((Object)mappingFileCollection, (Object)this.project.files(new Object[0]));
        R8Transform transform2 = new R8Transform(variantScope, (FileCollection)userMainDexListFiles, (FileCollection)userMainDexListProguardRules, (FileCollection)inputProguardMapping);
        return this.applyProguardRules(variantScope, (FileCollection)inputProguardMapping, testedVariantData, transform2, callback);
    }

    private void maybeCreateDexSplitterTransform(VariantScope variantScope) {
        if (!variantScope.consumesFeatureJars()) {
            return;
        }
        FileCollection featureJars = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.METADATA_CLASSES);
        Provider baseJars = variantScope.getArtifacts().getFinalProduct(InternalArtifactType.MODULE_AND_RUNTIME_DEPS_CLASSES);
        Provider mappingFileSrc = variantScope.getArtifacts().hasFinalProduct(InternalArtifactType.APK_MAPPING) ? variantScope.getArtifacts().getFinalProduct(InternalArtifactType.APK_MAPPING) : null;
        Provider mainDexList = variantScope.getArtifacts().hasFinalProduct(InternalArtifactType.MAIN_DEX_LIST_FOR_BUNDLE) ? variantScope.getArtifacts().getFinalProduct(InternalArtifactType.MAIN_DEX_LIST_FOR_BUNDLE) : null;
        DexSplitterTransform transform2 = new DexSplitterTransform(featureJars, baseJars, mappingFileSrc, mainDexList);
        Optional<TaskProvider<TransformTask>> transformTask = variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, transform2, null, null, taskProvider -> variantScope.getArtifacts().producesDir(InternalArtifactType.FEATURE_DEX, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, TransformTask::getOutputDirectory, ""));
        if (transformTask.isPresent()) {
            this.publishFeatureDex(variantScope);
            transformTask.get().configure(it -> {
                if (mainDexList != null) {
                    it.dependsOn(new Object[]{mainDexList});
                }
                it.dependsOn(new Object[]{baseJars});
            });
        } else {
            this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Internal error, could not add the DexSplitterTransform"));
        }
    }

    private void publishFeatureDex(VariantScope variantScope) {
        Collection<String> modulePaths;
        BaseExtension extension = this.globalScope.getExtension();
        if (extension instanceof BaseAppModuleExtension) {
            modulePaths = ((BaseAppModuleExtension)extension).getDynamicFeatures();
        } else if (extension instanceof FeatureExtension) {
            modulePaths = FeatureModelBuilder.getDynamicFeatures(this.globalScope);
        } else {
            return;
        }
        Configuration configuration2 = variantScope.getVariantData().getVariantDependency().getElements(AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS);
        Preconditions.checkNotNull((Object)configuration2, (Object)("Publishing to Runtime Element with no Runtime Elements configuration object. VariantType: " + variantScope.getType()));
        Provider artifact = variantScope.getArtifacts().getFinalProduct(InternalArtifactType.FEATURE_DEX);
        for (String modulePath : modulePaths) {
            Provider file = artifact.map(directory -> directory.file(TaskManager.getFeatureFileName(modulePath, null)));
            ImmutableMap attributeMap = ImmutableMap.of(AndroidArtifacts.MODULE_PATH, (Object)this.project.absoluteProjectPath(modulePath));
            ArtifactPublishingUtil.publishArtifactToConfiguration(configuration2, file, artifact, AndroidArtifacts.ArtifactType.FEATURE_DEX, (Map<Attribute<String>, String>)attributeMap);
        }
    }

    public static String getFeatureFileName(String modulePath, String fileExtension) {
        String featureName = FeatureSplitUtils.getFeatureName(modulePath);
        String sanitizedFeatureName = ":".equals(featureName) ? "" : featureName;
        return "feature-" + sanitizedFeatureName + Strings.nullToEmpty((String)fileExtension);
    }

    protected void maybeCreateResourcesShrinkerTasks(VariantScope scope) {
        if (!scope.useResourceShrinker()) {
            return;
        }
        this.taskFactory.register(new ShrinkResourcesTask.CreationAction(scope));
        this.taskFactory.register(new ShrinkBundleResourcesTask.CreationAction(scope));
    }

    public void createReportTasks(List<VariantScope> variantScopes) {
        this.taskFactory.register("androidDependencies", DependencyReportTask.class, task -> {
            task.setDescription("Displays the Android dependencies of the project.");
            task.setVariants(variantScopes);
            task.setGroup(ANDROID_GROUP);
        });
        List signingReportScopes = variantScopes.stream().filter(variantScope -> variantScope.getType().isForTesting() || variantScope.getType().isBaseModule()).collect(Collectors.toList());
        if (!signingReportScopes.isEmpty()) {
            this.taskFactory.register("signingReport", SigningReportTask.class, task -> {
                task.setDescription("Displays the signing info for the base and test modules");
                task.setVariants(signingReportScopes);
                task.setGroup(ANDROID_GROUP);
            });
        }
    }

    public void createAnchorTasks(VariantScope scope) {
        this.createVariantPreBuildTask(scope);
        BaseVariantData variantData = scope.getVariantData();
        scope.getTaskContainer().setSourceGenTask(this.taskFactory.register(scope.getTaskName("generate", "Sources"), (Action<? super Task>)((Action)task -> {
            task.dependsOn(new Object[]{"prepareLintJar"});
            task.dependsOn(new Object[]{"prepareLintJarForPublish"});
            task.dependsOn(new Object[]{variantData.getExtraGeneratedResFolders()});
        })));
        scope.getTaskContainer().setResourceGenTask(this.taskFactory.register(scope.getTaskName("generate", "Resources")));
        scope.getTaskContainer().setAssetGenTask(this.taskFactory.register(scope.getTaskName("generate", "Assets")));
        if (!variantData.getType().isForTesting() && ((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isTestCoverageEnabled()) {
            scope.getTaskContainer().setCoverageReportTask(this.taskFactory.register(scope.getTaskName("create", "CoverageReport"), (Action<? super Task>)((Action)task -> {
                task.setGroup("verification");
                task.setDescription(String.format("Creates test coverage reports for the %s variant.", variantData.getName()));
            })));
        }
        this.createCompileAnchorTask(scope);
    }

    protected void createVariantPreBuildTask(VariantScope scope) {
        this.createDefaultPreBuildTask(scope);
    }

    protected void createDefaultPreBuildTask(VariantScope scope) {
        this.taskFactory.register(new PreBuildCreationAction(scope));
    }

    private void createCompileAnchorTask(VariantScope scope) {
        scope.getTaskContainer().setCompileTask(this.taskFactory.register(scope.getTaskName("compile", "Sources"), (Action<? super Task>)((Action)task -> task.setGroup(BUILD_GROUP))));
        TaskFactoryUtils.dependsOn(scope.getTaskContainer().getAssembleTask(), scope.getTaskContainer().getCompileTask());
    }

    public void createCheckManifestTask(VariantScope scope) {
        this.taskFactory.register(this.getCheckManifestConfig(scope));
    }

    protected CheckManifest.CreationAction getCheckManifestConfig(VariantScope scope) {
        return new CheckManifest.CreationAction(scope, false);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void addBindingDependenciesIfNecessary(ViewBindingOptions viewBindingOptions, DataBindingOptions dataBindingOptions, List<VariantScope> variantScopes) {
        String version;
        ProjectOptions projectOptions = this.globalScope.getProjectOptions();
        boolean useAndroidX = projectOptions.get(BooleanOption.USE_ANDROID_X);
        boolean viewBindingEnabled = viewBindingOptions.isEnabled();
        boolean dataBindingEnabled = dataBindingOptions.isEnabled();
        if (viewBindingEnabled) {
            version = this.dataBindingBuilder.getLibraryVersion(this.dataBindingBuilder.getCompilerVersion());
            String groupAndArtifact = useAndroidX ? "androidx.databinding:viewbinding" : "com.android.databinding:viewbinding";
            this.project.getDependencies().add("api", (Object)(groupAndArtifact + ":" + version));
        }
        if (dataBindingEnabled) {
            version = (String)MoreObjects.firstNonNull((Object)dataBindingOptions.getVersion(), (Object)this.dataBindingBuilder.getCompilerVersion());
            String baseLibArtifact = useAndroidX ? "androidx.databinding:databinding-common" : "com.android.databinding:baseLibrary";
            this.project.getDependencies().add("api", (Object)(baseLibArtifact + ":" + this.dataBindingBuilder.getBaseLibraryVersion(version)));
            this.project.getDependencies().add("annotationProcessor", (Object)("androidx.databinding:databinding-compiler:" + version));
            if (dataBindingOptions.isEnabledForTests() || this instanceof LibraryTaskManager || this instanceof MultiTypeTaskManager) {
                this.project.getDependencies().add("androidTestAnnotationProcessor", (Object)("androidx.databinding:databinding-compiler:" + version));
            }
            if (dataBindingOptions.getAddDefaultAdapters()) {
                String libArtifact = useAndroidX ? "androidx.databinding:databinding-runtime" : "com.android.databinding:library";
                String adaptersArtifact = useAndroidX ? "androidx.databinding:databinding-adapters" : "com.android.databinding:adapters";
                this.project.getDependencies().add("api", (Object)(libArtifact + ":" + this.dataBindingBuilder.getLibraryVersion(version)));
                this.project.getDependencies().add("api", (Object)(adaptersArtifact + ":" + this.dataBindingBuilder.getBaseAdaptersVersion(version)));
            }
            this.project.getPluginManager().withPlugin("org.jetbrains.kotlin.kapt", appliedPlugin -> this.configureKotlinKaptTasksForDataBinding(this.project, variantScopes, version));
        }
    }

    private void configureKotlinKaptTasksForDataBinding(Project project2, List<VariantScope> variantScopes, String version) {
        DependencySet kaptDeps = project2.getConfigurations().getByName("kapt").getAllDependencies();
        kaptDeps.forEach(dependency -> {
            if (Objects.equals(dependency.getGroup() + ":" + dependency.getName(), "androidx.databinding:databinding-compiler") && !Objects.equals(dependency.getVersion(), version)) {
                String depString = dependency.getGroup() + ":" + dependency.getName() + ":" + dependency.getVersion();
                this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Data Binding annotation processor version needs to match the Android Gradle Plugin version. You can remove the kapt dependency " + depString + " and Android Gradle Plugin will inject the right version."));
            }
        });
        project2.getDependencies().add("kapt", (Object)("androidx.databinding:databinding-compiler:" + version));
        Class<?> kaptTaskClass = null;
        try {
            kaptTaskClass = Class.forName("org.jetbrains.kotlin.gradle.internal.KaptTask");
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Kotlin plugin is applied to the project " + project2.getPath() + " but we cannot find the KaptTask. Make sure you apply the kotlin-kapt plugin because it is necessary to use kotlin with data binding.");
        }
        if (kaptTaskClass == null) {
            return;
        }
        Map<String, VariantScope> kaptTaskLookup = variantScopes.stream().collect(Collectors.toMap(variantScope -> variantScope.getVariantData().getTaskName("kapt", "Kotlin"), variantScope -> variantScope));
        project2.getTasks().withType(kaptTaskClass, kaptTask -> {
            VariantScope matchingScope = (VariantScope)kaptTaskLookup.get(kaptTask.getName());
            if (matchingScope != null) {
                TaskManager.configureKaptTaskInScope(matchingScope, kaptTask);
            }
        });
    }

    private static void configureKaptTaskInScope(VariantScope scope, Task kaptTask) {
        DirectoryProperty databindingArtifact = scope.getGlobalScope().getProject().getObjects().directoryProperty();
        TaskProvider kaptTaskProvider = scope.getGlobalScope().getProject().getTasks().named(kaptTask.getName());
        scope.getArtifacts().producesDir(InternalArtifactType.DATA_BINDING_ARTIFACT, BuildArtifactsHolder.OperationType.TRANSFORM, kaptTaskProvider, task -> databindingArtifact, "out");
        kaptTask.getOutputs().dir((Object)databindingArtifact);
    }

    protected void configureTestData(AbstractTestDataImpl testData) {
        testData.setAnimationsDisabled(this.extension.getTestOptions().getAnimationsDisabled());
        testData.setExtraInstrumentationTestRunnerArgs(this.projectOptions.getExtraInstrumentationTestRunnerArgs());
    }

    private static /* synthetic */ void lambda$createAnchorAssembleTasks$42(String dimensionName, ListMultimap assembleMap, String dimensionKey, Task task) {
        task.setDescription("Assembles main outputs for all " + dimensionName + " variants.");
        task.setGroup(BUILD_GROUP);
        task.dependsOn(new Object[]{assembleMap.get((Object)dimensionKey)});
    }

    private static /* synthetic */ void lambda$createAnchorAssembleTasks$40(String dimensionName, ListMultimap assembleMap, String dimensionKey, Task task) {
        task.setDescription("Assembles main outputs for all " + dimensionName + " variants.");
        task.setGroup(BUILD_GROUP);
        task.dependsOn(new Object[]{assembleMap.get((Object)dimensionKey)});
    }

    private static class PreBuildCreationAction
    extends AbstractPreBuildCreationAction<Task> {
        public PreBuildCreationAction(VariantScope variantScope) {
            super(variantScope);
        }

        @Override
        public Class<Task> getType() {
            return Task.class;
        }
    }

    public static abstract class AbstractPreBuildCreationAction<T extends Task>
    extends TaskCreationAction<T> {
        protected final VariantScope variantScope;

        @Override
        public String getName() {
            return this.variantScope.getTaskName("pre", "Build");
        }

        public AbstractPreBuildCreationAction(VariantScope variantScope) {
            this.variantScope = variantScope;
        }

        @Override
        public void handleProvider(TaskProvider<? extends T> taskProvider) {
            super.handleProvider(taskProvider);
            this.variantScope.getTaskContainer().setPreBuildTask(taskProvider);
        }

        @Override
        public void configure(T task) {
            task.dependsOn(new Object[]{TaskManager.MAIN_PREBUILD});
            if (this.variantScope.getCodeShrinker() != null) {
                task.dependsOn(new Object[]{TaskManager.EXTRACT_PROGUARD_FILES});
            }
        }
    }

    private static interface ProGuardTransformCallback {
        public void execute(ProguardConfigurable var1, String var2);
    }

    public static enum MergeType {
        MERGE{

            @Override
            public InternalArtifactType getOutputType() {
                return InternalArtifactType.MERGED_RES;
            }
        }
        ,
        PACKAGE{

            @Override
            public InternalArtifactType getOutputType() {
                return InternalArtifactType.PACKAGED_RES;
            }
        };


        public abstract InternalArtifactType getOutputType();
    }

    public static class ConfigAttrTask
    extends DefaultTask {
        boolean consumable = false;
        boolean resolvable = false;

        @TaskAction
        public void run() {
            for (Configuration config2 : this.getProject().getConfigurations()) {
                AttributeContainer attributes2 = config2.getAttributes();
                if ((!this.consumable || !config2.isCanBeConsumed()) && (!this.resolvable || !config2.isCanBeResolved())) continue;
                System.out.println(config2.getName());
                System.out.println("\tcanBeResolved: " + config2.isCanBeResolved());
                System.out.println("\tcanBeConsumed: " + config2.isCanBeConsumed());
                for (Attribute attr : attributes2.keySet()) {
                    System.out.println("\t" + attr.getName() + ": " + attributes2.getAttribute(attr));
                }
                if (!this.consumable || !config2.isCanBeConsumed()) continue;
                for (PublishArtifact artifact : config2.getArtifacts()) {
                    System.out.println("\tArtifact: " + artifact.getName() + " (" + artifact.getFile().getName() + ")");
                }
                for (ConfigurationVariant cv : config2.getOutgoing().getVariants()) {
                    System.out.println("\tConfigurationVariant: " + cv.getName());
                    for (PublishArtifact pa : cv.getArtifacts()) {
                        System.out.println("\t\tArtifact: " + pa.getFile());
                        System.out.println("\t\tType:" + pa.getType());
                    }
                }
            }
        }
    }
}

