/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.packaging;

import com.android.build.gradle.internal.packaging.JarCreatorFactory$WhenMappings;
import com.android.build.gradle.internal.packaging.JarCreatorType;
import com.android.builder.packaging.JarMerger;
import java.nio.file.Path;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zipflinger.JarCreator;
import zipflinger.JarFlinger;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/packaging/JarCreatorFactory;", "", "()V", "make", "Lzipflinger/JarCreator;", "jarFile", "Ljava/nio/file/Path;", "type", "Lcom/android/build/gradle/internal/packaging/JarCreatorType;", "filter", "Ljava/util/function/Predicate;", "", "gradle"})
public final class JarCreatorFactory {
    public static final JarCreatorFactory INSTANCE;

    @NotNull
    public final JarCreator make(@NotNull Path jarFile, @NotNull JarCreatorType type) {
        Intrinsics.checkParameterIsNotNull((Object)jarFile, (String)"jarFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        return this.make(jarFile, null, type);
    }

    @NotNull
    public final JarCreator make(@NotNull Path jarFile, @Nullable Predicate<String> filter, @NotNull JarCreatorType type) {
        JarCreator jarCreator;
        Intrinsics.checkParameterIsNotNull((Object)jarFile, (String)"jarFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        switch (JarCreatorFactory$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                jarCreator = (JarCreator)new JarMerger(jarFile, filter);
                break;
            }
            case 2: {
                jarCreator = (JarCreator)new JarFlinger(jarFile, filter);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jarCreator;
    }

    private JarCreatorFactory() {
    }

    static {
        JarCreatorFactory jarCreatorFactory;
        INSTANCE = jarCreatorFactory = new JarCreatorFactory();
    }
}

