/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.ide.AndroidLibraryImpl;
import com.android.build.gradle.internal.ide.DependenciesImpl;
import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.ide.DependencyFailureHandlerKt;
import com.android.build.gradle.internal.ide.JavaLibraryImpl;
import com.android.build.gradle.internal.ide.dependencies.ArtifactUtils;
import com.android.build.gradle.internal.ide.dependencies.BuildMappingUtils;
import com.android.build.gradle.internal.ide.dependencies.DependencyGraphBuilder;
import com.android.build.gradle.internal.ide.dependencies.LibraryUtils;
import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesUtils;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.ide.level2.FullDependencyGraphsImpl;
import com.android.build.gradle.internal.ide.level2.GraphItemImpl;
import com.android.build.gradle.internal.ide.level2.SimpleDependencyGraphsImpl;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GraphItem;
import com.android.utils.ImmutableCollectors;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function1;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.query.ArtifactResolutionQuery;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;

class ArtifactDependencyGraph
implements DependencyGraphBuilder {
    private DependencyFailureHandler dependencyFailureHandler = new DependencyFailureHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DependencyGraphs createLevel4DependencyGraph(VariantScope variantScope, boolean withFullDependency, boolean downloadSources, ImmutableMap<String, String> buildMapping, SyncIssueHandler syncIssueHandler) {
        try {
            Set<ResolvedArtifact> runtimeArtifacts;
            Set<ResolvedArtifact> compileArtifacts = ArtifactUtils.getAllArtifacts(variantScope, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, this.dependencyFailureHandler, buildMapping);
            if (downloadSources) {
                HashSet ids = Sets.newHashSetWithExpectedSize((int)compileArtifacts.size());
                for (ResolvedArtifact artifact : compileArtifacts) {
                    ids.add(artifact.getComponentIdentifier());
                }
                ArtifactDependencyGraph.handleSources(variantScope.getGlobalScope().getProject(), ids, syncIssueHandler);
            }
            if (!withFullDependency) {
                ArtifactCollection runtimeArtifactCollection = ArtifactUtils.computeArtifactList(variantScope, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAR);
                runtimeArtifacts = runtimeArtifactCollection.getArtifacts();
                HashSet runtimeIdentifiers = Sets.newHashSetWithExpectedSize((int)runtimeArtifacts.size());
                for (ResolvedArtifactResult resolvedArtifactResult : runtimeArtifacts) {
                    runtimeIdentifiers.add(resolvedArtifactResult.getId().getComponentIdentifier());
                }
                ArrayList providedAddresses = Lists.newArrayList();
                ArrayList arrayList = Lists.newArrayListWithCapacity((int)compileArtifacts.size());
                for (ResolvedArtifact artifact : compileArtifacts) {
                    GraphItemImpl graphItem = new GraphItemImpl(artifact.computeModelAddress(), (List<GraphItem>)ImmutableList.of());
                    arrayList.add(graphItem);
                    LibraryUtils.getLibraryCache().get((Object)artifact);
                    if (runtimeIdentifiers.contains(artifact.getComponentIdentifier())) continue;
                    providedAddresses.add(graphItem.getArtifactAddress());
                }
                SimpleDependencyGraphsImpl simpleDependencyGraphsImpl = new SimpleDependencyGraphsImpl(arrayList, providedAddresses);
                return simpleDependencyGraphsImpl;
            }
            ArrayList compileItems = Lists.newArrayListWithCapacity((int)compileArtifacts.size());
            for (ResolvedArtifact artifact : compileArtifacts) {
                compileItems.add(new GraphItemImpl(artifact.computeModelAddress(), (List<GraphItem>)ImmutableList.of()));
                LibraryUtils.getLibraryCache().get((Object)artifact);
            }
            runtimeArtifacts = ArtifactUtils.getAllArtifacts(variantScope, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, this.dependencyFailureHandler, buildMapping);
            ArrayList runtimeItems = Lists.newArrayListWithCapacity((int)runtimeArtifacts.size());
            for (ResolvedArtifact resolvedArtifact : runtimeArtifacts) {
                runtimeItems.add(new GraphItemImpl(resolvedArtifact.computeModelAddress(), (List<GraphItem>)ImmutableList.of()));
                LibraryUtils.getLibraryCache().get((Object)resolvedArtifact);
            }
            ArrayList providedItems = Lists.newArrayList((Iterable)compileItems);
            providedItems.removeAll(runtimeItems);
            ImmutableList immutableList = (ImmutableList)providedItems.stream().map(GraphItem::getArtifactAddress).collect(ImmutableCollectors.toImmutableList());
            FullDependencyGraphsImpl fullDependencyGraphsImpl = new FullDependencyGraphsImpl(compileItems, runtimeItems, (List<String>)immutableList, (List<String>)ImmutableList.of());
            return fullDependencyGraphsImpl;
        }
        finally {
            this.dependencyFailureHandler.registerIssues(syncIssueHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DependenciesImpl createDependencies(VariantScope variantScope, boolean downloadSources, ImmutableMap<String, String> buildMapping, SyncIssueHandler syncIssueHandler) {
        try {
            ImmutableList.Builder projects = ImmutableList.builder();
            ImmutableList.Builder androidLibraries = ImmutableList.builder();
            ImmutableList.Builder javaLibrary = ImmutableList.builder();
            ArtifactCollection runtimeArtifactCollection = ArtifactUtils.computeArtifactList(variantScope, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAR);
            HashSet<ComponentIdentifier> runtimeIdentifiers = new HashSet<ComponentIdentifier>(runtimeArtifactCollection.getArtifacts().size());
            for (Object result : runtimeArtifactCollection.getArtifacts()) {
                runtimeIdentifiers.add(result.getId().getComponentIdentifier());
            }
            Set<ResolvedArtifact> artifacts = ArtifactUtils.getAllArtifacts(variantScope, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, this.dependencyFailureHandler, buildMapping);
            for (ResolvedArtifact resolvedArtifact : artifacts) {
                File extractedFolder;
                ComponentIdentifier id = resolvedArtifact.getComponentIdentifier();
                boolean isProvided = !runtimeIdentifiers.contains(id);
                boolean isSubproject = id instanceof ProjectComponentIdentifier;
                String projectPath = null;
                String buildId = null;
                if (isSubproject) {
                    ProjectComponentIdentifier projectId = (ProjectComponentIdentifier)id;
                    projectPath = projectId.getProjectPath();
                    buildId = BuildMappingUtils.getBuildId(projectId, buildMapping);
                }
                if (resolvedArtifact.getDependencyType() == ResolvedArtifact.DependencyType.JAVA) {
                    if (projectPath != null) {
                        projects.add((Object)new DependenciesImpl.ProjectIdentifierImpl(buildId, projectPath));
                        continue;
                    }
                    javaLibrary.add((Object)new JavaLibraryImpl(resolvedArtifact.getArtifactFile(), null, null, (List<JavaLibrary>)ImmutableList.of(), null, MavenCoordinatesUtils.getMavenCoordinates(resolvedArtifact), false, isProvided));
                    continue;
                }
                if (resolvedArtifact.isWrappedModule()) {
                    buildId = null;
                    projectPath = null;
                }
                if ((extractedFolder = resolvedArtifact.getExtractedFolder()) == null) {
                    extractedFolder = resolvedArtifact.getArtifactFile();
                }
                androidLibraries.add((Object)new AndroidLibraryImpl(MavenCoordinatesUtils.getMavenCoordinates(resolvedArtifact), buildId, projectPath, resolvedArtifact.getArtifactFile(), extractedFolder, LibraryUtils.findResStaticLibrary(variantScope, resolvedArtifact), resolvedArtifact.getVariantName(), isProvided, false, (List<AndroidLibrary>)ImmutableList.of(), (Collection<JavaLibrary>)ImmutableList.of(), (Collection)LibraryUtils.getLocalJarCache().get((Object)extractedFolder)));
            }
            if (downloadSources) {
                HashSet ids = Sets.newHashSetWithExpectedSize((int)artifacts.size());
                for (ResolvedArtifact artifact : artifacts) {
                    ids.add(artifact.getComponentIdentifier());
                }
                ArtifactDependencyGraph.handleSources(variantScope.getGlobalScope().getProject(), ids, syncIssueHandler);
            }
            Set compileIdentifiers = artifacts.stream().map(ResolvedArtifact::getComponentIdentifier).collect(Collectors.toSet());
            List<File> list = runtimeArtifactCollection.getArtifacts().stream().filter(it -> !compileIdentifiers.contains(it.getId().getComponentIdentifier())).map(ResolvedArtifactResult::getFile).collect(Collectors.toList());
            DependenciesImpl dependenciesImpl = new DependenciesImpl((List<AndroidLibrary>)androidLibraries.build(), (List<JavaLibrary>)javaLibrary.build(), (List<Dependencies.ProjectIdentifier>)projects.build(), list);
            return dependenciesImpl;
        }
        finally {
            this.dependencyFailureHandler.registerIssues(syncIssueHandler);
        }
    }

    private static void handleSources(Project project2, Set<ComponentIdentifier> artifacts, SyncIssueHandler syncIssueHandler) {
        DependencyHandler dependencies = project2.getDependencies();
        try {
            ArtifactResolutionQuery query = dependencies.createArtifactResolutionQuery();
            query.forComponents(artifacts);
            Class[] artifactTypesArray = new Class[]{SourcesArtifact.class, JavadocArtifact.class};
            query.withArtifacts(JvmLibrary.class, artifactTypesArray);
            query.execute().getResolvedComponents();
        }
        catch (Throwable t) {
            DependencyFailureHandlerKt.processDependencyThrowable(t, (Function1<? super String, String>)((Function1)s -> null), (data, messages) -> {
                ArrayList<String> multilineMsg = new ArrayList<String>(messages.size() + 1);
                multilineMsg.add(String.format("Unable to download sources/javadoc: %s", messages.get(0)));
                multilineMsg.addAll((Collection<String>)messages);
                syncIssueHandler.reportIssue(EvalIssueReporter.Type.GENERIC, EvalIssueReporter.Severity.WARNING, Joiner.on((String)"\n").join(multilineMsg));
            });
        }
    }

    ArtifactDependencyGraph() {
    }
}

