/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.IncrementalTransformInput;
import com.android.build.gradle.internal.pipeline.IntermediateFolderUtils;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.pipeline.TransformOutputProviderImpl;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;

class IntermediateStream
extends TransformStream {
    private final String taskName;
    private IntermediateFolderUtils folderUtils = null;
    private List<IntermediateStream> copies = null;

    static Builder builder(Project project2, String name, String taskName) {
        return new Builder(project2, name, taskName);
    }

    private IntermediateStream(String name, String taskName, Set<QualifiedContent.ContentType> contentTypes, Set<? super QualifiedContent.Scope> scopes, FileCollection fileCollection2) {
        super(name, contentTypes, scopes, fileCollection2);
        this.taskName = taskName;
    }

    File getRootLocation() {
        return this.getFileCollection().getSingleFile();
    }

    TransformOutputProvider asOutput() throws IOException {
        this.init(true);
        return new TransformOutputProviderImpl(this.folderUtils);
    }

    void save() throws IOException {
        this.folderUtils.save();
        this.reloadCopies();
    }

    @Override
    TransformInput asNonIncrementalInput() {
        this.init(false);
        return this.folderUtils.computeNonIncrementalInputFromFolder();
    }

    @Override
    IncrementalTransformInput asIncrementalInput() {
        this.init(false);
        return this.folderUtils.computeIncrementalInputFromFolder();
    }

    @Override
    TransformStream makeRestrictedCopy(Set<QualifiedContent.ContentType> types, Set<? super QualifiedContent.Scope> scopes) {
        IntermediateStream copy = new IntermediateStream(this.getName() + "-restricted-copy", this.taskName, types, scopes, this.getFileCollection());
        if (this.copies == null) {
            this.copies = Lists.newArrayList();
        }
        this.copies.add(copy);
        return copy;
    }

    @Override
    FileCollection getOutputFileCollection(Project project2, StreamFilter streamFilter) {
        Callable<Collection> supplier = () -> {
            if (!project2.getTasks().getByName(this.taskName).getState().getExecuted()) {
                return ImmutableList.of();
            }
            this.init(false);
            return this.folderUtils.getFiles(streamFilter);
        };
        return project2.files(new Object[]{supplier}).builtBy(new Object[]{this.getFileCollection().getBuildDependencies()});
    }

    private void init(boolean ignoreUnexpectedScopes) {
        if (this.folderUtils == null) {
            this.folderUtils = new IntermediateFolderUtils(this.getRootLocation(), this.getContentTypes(), this.getScopes(), ignoreUnexpectedScopes);
        }
    }

    private void reload() {
        if (this.folderUtils != null) {
            this.folderUtils.reload();
        }
        this.reloadCopies();
    }

    private void reloadCopies() {
        if (this.copies != null) {
            for (IntermediateStream copy : this.copies) {
                copy.reload();
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("scopes", this.getScopes()).add("contentTypes", this.getContentTypes()).add("fileCollection", (Object)this.getFileCollection()).toString();
    }

    static final class Builder {
        private final Project project;
        private final String name;
        private final String taskName;
        private Set<QualifiedContent.ContentType> contentTypes = Sets.newHashSet();
        private Set<QualifiedContent.ScopeType> scopes = Sets.newHashSet();
        private File rootLocation;

        public Builder(Project project2, String name, String taskName) {
            this.project = project2;
            this.name = name;
            this.taskName = taskName;
        }

        public IntermediateStream build() {
            Preconditions.checkNotNull((Object)this.rootLocation);
            Preconditions.checkNotNull((Object)this.taskName);
            Preconditions.checkState((!this.contentTypes.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((!this.scopes.isEmpty() ? 1 : 0) != 0);
            ConfigurableFileCollection fileCollection2 = this.project.files(new Object[]{this.rootLocation}).builtBy(new Object[]{this.taskName});
            return new IntermediateStream(this.name, this.taskName, (Set)ImmutableSet.copyOf(this.contentTypes), (Set)ImmutableSet.copyOf(this.scopes), (FileCollection)fileCollection2);
        }

        Builder addContentTypes(Set<QualifiedContent.ContentType> types) {
            this.contentTypes.addAll(types);
            return this;
        }

        Builder addContentTypes(QualifiedContent.ContentType ... types) {
            this.contentTypes.addAll(Arrays.asList(types));
            return this;
        }

        Builder addScopes(Set<? super QualifiedContent.Scope> scopes) {
            for (QualifiedContent.Scope scope : scopes) {
                this.scopes.add((QualifiedContent.ScopeType)scope);
            }
            return this;
        }

        Builder addScopes(QualifiedContent.Scope ... scopes) {
            this.scopes.addAll(Arrays.asList(scopes));
            return this;
        }

        Builder setRootLocation(File rootLocation) {
            this.rootLocation = rootLocation;
            return this;
        }
    }
}

