/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.api.artifact.ArtifactType;
import java.io.File;
import java.util.Locale;

public enum InternalArtifactType implements ArtifactType
{
    JAVAC,
    NAMESPACED_CLASSES_JAR(ArtifactType.Kind.FILE),
    TESTED_CODE_CLASSES,
    FIXED_STACK_FRAMES,
    RUNTIME_LIBRARY_CLASSES(ArtifactType.Kind.FILE),
    COMPILE_LIBRARY_CLASSES(ArtifactType.Kind.FILE),
    PROJECT_DEX_ARCHIVE,
    SUB_PROJECT_DEX_ARCHIVE,
    EXTERNAL_LIBS_DEX_ARCHIVE,
    MIXED_SCOPE_DEX_ARCHIVE,
    DEX_ARCHIVE_INPUT_JAR_HASHES,
    EXTERNAL_LIBS_DEX,
    EXTERNAL_FILE_LIB_DEX_ARCHIVES,
    DEX,
    APP_CLASSES(ArtifactType.Kind.FILE),
    DESUGAR_PROJECT_CLASSES,
    DESUGAR_SUB_PROJECT_CLASSES,
    DESUGAR_EXTERNAL_LIBS_CLASSES,
    DESUGAR_LOCAL_STATE_OUTPUT,
    JAVA_RES,
    MERGED_JAVA_RES(ArtifactType.Kind.FILE),
    LIBRARY_JAVA_RES(ArtifactType.Kind.FILE),
    FULL_JAR(ArtifactType.Kind.FILE),
    JACOCO_INSTRUMENTED_CLASSES,
    JACOCO_INSTRUMENTED_JARS,
    CODE_COVERAGE(Category.OUTPUTS),
    DEVICE_PROVIDER_CODE_COVERAGE(Category.OUTPUTS),
    MERGED_RES,
    NOT_NAMESPACED_R_CLASS_SOURCES(Category.GENERATED),
    COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR(ArtifactType.Kind.FILE),
    MERGED_NOT_COMPILED_RES,
    UNIT_TEST_CONFIG_DIRECTORY,
    PROCESSED_RES,
    PACKAGED_RES,
    SYMBOL_LIST(ArtifactType.Kind.FILE),
    SYMBOL_LIST_WITH_PACKAGE_NAME(ArtifactType.Kind.FILE),
    DEFINED_ONLY_SYMBOL_LIST,
    LOCAL_ONLY_SYMBOL_LIST(ArtifactType.Kind.FILE),
    PUBLIC_RES(ArtifactType.Kind.FILE),
    SHRUNK_PROCESSED_RES,
    DENSITY_OR_LANGUAGE_SPLIT_PROCESSED_RES,
    ABI_PROCESSED_SPLIT_RES,
    DENSITY_OR_LANGUAGE_PACKAGED_SPLIT,
    INSTANT_RUN_MAIN_APK_RESOURCES,
    INSTANT_RUN_PACKAGED_RESOURCES,
    INSTANT_RUN_SPLIT_APK_RESOURCES,
    LINKED_RES_FOR_BUNDLE(ArtifactType.Kind.FILE),
    SHRUNK_LINKED_RES_FOR_BUNDLE(ArtifactType.Kind.FILE),
    LEGACY_MULTIDEX_AAPT_DERIVED_PROGUARD_RULES(ArtifactType.Kind.FILE),
    LEGACY_MULTIDEX_MAIN_DEX_LIST(ArtifactType.Kind.FILE),
    COMPILE_AND_RUNTIME_NOT_NAMESPACED_R_CLASS_JAR(ArtifactType.Kind.FILE),
    NAVIGATION_JSON(ArtifactType.Kind.FILE),
    RES_COMPILED_FLAT_FILES,
    RES_STATIC_LIBRARY(ArtifactType.Kind.FILE),
    RES_CONVERTED_NON_NAMESPACED_REMOTE_DEPENDENCIES,
    COMPILE_ONLY_NAMESPACED_R_CLASS_JAR(ArtifactType.Kind.FILE),
    COMPILE_ONLY_NAMESPACED_DEPENDENCIES_R_JAR(ArtifactType.Kind.FILE),
    NON_NAMESPACED_CLASSES,
    RUNTIME_R_CLASS_SOURCES(Category.GENERATED),
    RUNTIME_R_CLASS_CLASSES,
    PARTIAL_R_FILES,
    LIBRARY_JNI,
    LIBRARY_AND_LOCAL_JARS_JNI,
    MERGED_JNI_LIBS,
    MERGED_SHADERS,
    NDK_LIBS,
    MERGED_NATIVE_LIBS,
    STRIPPED_NATIVE_LIBS,
    SHADER_ASSETS,
    LIBRARY_ASSETS,
    MERGED_ASSETS,
    AIDL_PARCELABLE,
    AIDL_SOURCE_OUTPUT_DIR(Category.GENERATED),
    RENDERSCRIPT_HEADERS,
    RENDERSCRIPT_SOURCE_OUTPUT_DIR(Category.GENERATED),
    RENDERSCRIPT_LIB,
    CHECK_MANIFEST_RESULT,
    COMPATIBLE_SCREEN_MANIFEST,
    MERGED_MANIFESTS,
    LIBRARY_MANIFEST(ArtifactType.Kind.FILE),
    NON_NAMESPACED_LIBRARY_MANIFEST(ArtifactType.Kind.FILE),
    NAMESPACED_MANIFESTS,
    AAPT_FRIENDLY_MERGED_MANIFESTS,
    INSTANT_APP_MANIFEST,
    MANIFEST_METADATA,
    MANIFEST_MERGE_REPORT(ArtifactType.Kind.FILE),
    MANIFEST_MERGE_BLAME_FILE(ArtifactType.Kind.FILE),
    STATIC_LIBRARY_MANIFEST(ArtifactType.Kind.FILE),
    ANNOTATION_PROCESSOR_LIST(ArtifactType.Kind.FILE),
    AP_GENERATED_SOURCES(Category.GENERATED, ArtifactType.Kind.DIRECTORY),
    CONSUMER_PROGUARD_FILE(ArtifactType.Kind.FILE),
    AAPT_PROGUARD_FILE(ArtifactType.Kind.FILE),
    MERGED_AAPT_PROGUARD_FILE(ArtifactType.Kind.FILE),
    DATA_BINDING_ARTIFACT,
    DATA_BINDING_DEPENDENCY_ARTIFACTS,
    DATA_BINDING_LAYOUT_INFO_TYPE_MERGE,
    DATA_BINDING_LAYOUT_INFO_TYPE_PACKAGE,
    DATA_BINDING_BASE_CLASS_LOGS_DEPENDENCY_ARTIFACTS,
    DATA_BINDING_BASE_CLASS_LOG_ARTIFACT,
    DATA_BINDING_BASE_CLASS_SOURCE_OUT(Category.GENERATED),
    LINT_JAR(ArtifactType.Kind.FILE),
    LINT_PUBLISH_JAR(ArtifactType.Kind.FILE),
    ANNOTATIONS_ZIP(ArtifactType.Kind.FILE),
    ANNOTATIONS_TYPEDEF_FILE(ArtifactType.Kind.FILE),
    ANNOTATIONS_PROGUARD,
    AAR_MAIN_JAR(ArtifactType.Kind.FILE),
    AAR_LIBS_DIRECTORY,
    ABI_PACKAGED_SPLIT,
    FULL_APK,
    APK,
    APK_FOR_LOCAL_TEST(ArtifactType.Kind.FILE),
    APK_MAPPING(Category.OUTPUTS, ArtifactType.Kind.FILE, "mapping"),
    AAR,
    INSTANTAPP_BUNDLE,
    SPLIT_LIST,
    APK_LIST(ArtifactType.Kind.FILE),
    MODULE_BUNDLE,
    MAIN_DEX_LIST_FOR_BUNDLE(ArtifactType.Kind.FILE),
    BUNDLE(Category.OUTPUTS, ArtifactType.Kind.FILE),
    INTERMEDIARY_BUNDLE(Category.INTERMEDIATES, ArtifactType.Kind.FILE),
    APKS_FROM_BUNDLE(ArtifactType.Kind.FILE),
    EXTRACTED_APKS,
    UNIVERSAL_APK(Category.OUTPUTS, ArtifactType.Kind.FILE),
    BUNDLE_MANIFEST,
    FEATURE_SET_METADATA(ArtifactType.Kind.FILE),
    METADATA_BASE_MODULE_DECLARATION(ArtifactType.Kind.FILE),
    METADATA_APPLICATION_ID(ArtifactType.Kind.FILE),
    FEATURE_RESOURCE_PKG,
    PACKAGED_DEPENDENCIES(ArtifactType.Kind.FILE),
    FEATURE_DATA_BINDING_BASE_FEATURE_INFO,
    FEATURE_DATA_BINDING_FEATURE_INFO,
    BASE_DEX,
    FEATURE_DEX,
    MODULE_AND_RUNTIME_DEPS_CLASSES(ArtifactType.Kind.FILE),
    SIGNING_CONFIG,
    VALIDATE_SIGNING_CONFIG,
    METADATA_FEATURE_DECLARATION,
    METADATA_FEATURE_MANIFEST,
    METADATA_INSTALLED_BASE_DECLARATION(ArtifactType.Kind.FILE),
    METADATA_LIBRARY_DEPENDENCIES_REPORT(ArtifactType.Kind.FILE),
    BUNDLE_DEPENDENCY_REPORT(ArtifactType.Kind.FILE),
    INSTANT_RUN_APP_INFO_OUTPUT_FILE,
    DUPLICATE_CLASSES_CHECK,
    GENERATED_PROGUARD_FILE(ArtifactType.Kind.FILE),
    ANALYZE_DEPENDENCIES_REPORT(ArtifactType.Kind.DIRECTORY);

    final Category category;
    final ArtifactType.Kind kind;
    final String folderName;

    public ArtifactType.Kind kind() {
        return this.kind;
    }

    private InternalArtifactType() {
        this(Category.INTERMEDIATES, ArtifactType.Kind.DIRECTORY, null);
    }

    private InternalArtifactType(Category category) {
        this(category, ArtifactType.Kind.DIRECTORY, null);
    }

    private InternalArtifactType(ArtifactType.Kind kind) {
        this(Category.INTERMEDIATES, kind, null);
    }

    private InternalArtifactType(Category category, ArtifactType.Kind kind) {
        this(category, kind, null);
    }

    private InternalArtifactType(Category category, ArtifactType.Kind kind, String folderName) {
        this.category = category;
        this.kind = kind;
        this.folderName = folderName;
    }

    public String getFolderName() {
        return this.folderName != null ? this.folderName : this.name().toLowerCase(Locale.US);
    }

    static enum Category {
        GENERATED,
        INTERMEDIATES,
        OUTPUTS;


        File getOutputDir(File parentDir) {
            return new File(parentDir, this.name().toLowerCase(Locale.US));
        }

        String getOutputPath() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

