/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.IssueReporterLoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CreateCxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CreateCxxVariantModelKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxModuleModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.process.ProcessOutputJunctionKt;
import com.android.build.gradle.internal.cxx.settings.CxxAbiModelCMakeSettingsRewriterKt;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.builder.errors.EvalIssueReporter;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ExternalNativeCleanTask
extends NonIncrementalTask {
    private EvalIssueReporter evalIssueReporter;
    private CxxVariantModel variant;
    private List<CxxAbiModel> abis;

    @Override
    protected void doTaskAction() throws ProcessException, IOException {
        try (IssueReporterLoggingEnvironment ignore = new IssueReporterLoggingEnvironment(this.evalIssueReporter);){
            LoggingEnvironmentKt.infoln("starting clean", new Object[0]);
            LoggingEnvironmentKt.infoln("finding existing JSONs", new Object[0]);
            ArrayList existingJsons = Lists.newArrayList();
            for (CxxAbiModel abi : this.abis) {
                if (CxxAbiModelKt.getJsonFile(abi).isFile()) {
                    existingJsons.add(CxxAbiModelKt.getJsonFile(abi));
                    continue;
                }
                LoggingEnvironmentKt.infoln("Json file not found so contents couldn't be cleaned %s", CxxAbiModelKt.getJsonFile(abi));
            }
            List<NativeBuildConfigValueMini> configValueList = AndroidBuildGradleJsons.getNativeBuildMiniConfigs(existingJsons, null);
            ArrayList cleanCommands = Lists.newArrayList();
            ArrayList targetNames2 = Lists.newArrayList();
            for (NativeBuildConfigValueMini config2 : configValueList) {
                cleanCommands.addAll(config2.cleanCommands);
                HashSet targets = Sets.newHashSet();
                for (NativeLibraryValueMini library : config2.libraries.values()) {
                    targets.add(String.format("%s %s", library.artifactName, library.abi));
                }
                targetNames2.add(Joiner.on((String)",").join((Iterable)targets));
            }
            LoggingEnvironmentKt.infoln("about to execute %s clean commands", cleanCommands.size());
            this.executeProcessBatch(cleanCommands, targetNames2);
            LoggingEnvironmentKt.infoln("clean complete", new Object[0]);
        }
    }

    private void executeProcessBatch(List<String> commands, List<String> targetNames2) throws ProcessException, IOException {
        for (int commandIndex = 0; commandIndex < commands.size(); ++commandIndex) {
            String command = commands.get(commandIndex);
            String target = targetNames2.get(commandIndex);
            this.getLogger().lifecycle(String.format("Clean %s", target));
            List tokens = StringHelper.tokenizeCommandLineToEscaped((String)command);
            ProcessInfoBuilder processBuilder = new ProcessInfoBuilder();
            processBuilder.setExecutable((String)tokens.get(0));
            for (int i2 = 1; i2 < tokens.size(); ++i2) {
                processBuilder.addArgs((String)tokens.get(i2));
            }
            LoggingEnvironmentKt.infoln("%s", processBuilder);
            ProcessOutputJunctionKt.createProcessOutputJunction(this.variant.getObjFolder(), "android_gradle_clean_" + commandIndex, processBuilder, this.getLogger(), new GradleProcessExecutor(this.getProject()), "").logStderrToInfo().logStdoutToInfo().execute();
        }
    }

    public static class CreationAction
    extends TaskCreationAction<ExternalNativeCleanTask> {
        private final VariantScope variantScope;
        private final CxxVariantModel variant;
        private final List<CxxAbiModel> abis = Lists.newArrayList();

        public CreationAction(CxxModuleModel module2, VariantScope scope) {
            this.variantScope = scope;
            this.variant = CreateCxxVariantModelKt.createCxxVariantModel(module2, scope.getVariantData());
            for (Abi abi : Abi.values()) {
                this.abis.add(CxxAbiModelCMakeSettingsRewriterKt.rewriteCxxAbiModelWithCMakeSettings(CreateCxxAbiModelKt.createCxxAbiModel(this.variant, abi, scope.getGlobalScope(), scope.getVariantData())));
            }
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("externalNativeBuildClean");
        }

        @Override
        public Class<ExternalNativeCleanTask> getType() {
            return ExternalNativeCleanTask.class;
        }

        @Override
        public void configure(ExternalNativeCleanTask task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            task.variant = this.variant;
            task.abis = this.abis;
            task.evalIssueReporter = this.variantScope.getGlobalScope().getErrorHandler();
        }
    }
}

