/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.packaging.IncrementalPackagerBuilder;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElementsTransformParams;
import com.android.build.gradle.internal.scope.BuildElementsTransformRunnable;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.SigningConfigUtils;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.RelativeFile;
import com.android.builder.internal.packaging.ApkCreatorType;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import javax.inject.Inject;
import kotlin.jvm.functions.Function2;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.WorkerExecutor;

public abstract class PackageSplitRes
extends NonIncrementalTask {
    private FileCollection signingConfig;
    private File incrementalDir;
    private boolean keepTimestampsInApk;
    private final WorkerExecutorFacade workers;

    @InputFiles
    public abstract DirectoryProperty getProcessedResources();

    @OutputDirectory
    public abstract DirectoryProperty getSplitResApkOutputDirectory();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getSigningConfig() {
        return this.signingConfig;
    }

    @Input
    public boolean getKeepTimestampsInApk() {
        return this.keepTimestampsInApk;
    }

    @Inject
    public PackageSplitRes(WorkerExecutor workerExecutor) {
        this.workers = Workers.INSTANCE.preferWorkers(this.getProject().getName(), this.getPath(), workerExecutor);
    }

    @Override
    protected void doTaskAction() {
        ExistingBuildElements.from((ArtifactType)InternalArtifactType.DENSITY_OR_LANGUAGE_SPLIT_PROCESSED_RES, (Provider<Directory>)this.getProcessedResources()).transform(this.workers, PackageSplitResTransformRunnable.class, (Function2<? super ApkData, ? super File, ? extends BuildElementsTransformParams>)((Function2)(apkInfo, file) -> new PackageSplitResTransformParams((ApkData)apkInfo, (File)file, this))).into(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, ((Directory)this.getSplitResApkOutputDirectory().get()).getAsFile());
    }

    public static String getOutputFileNameForSplit(ApkData apkData, String archivesBaseName, boolean isSigned) {
        String apkName = archivesBaseName + "-" + apkData.getBaseName();
        return apkName + (isSigned ? "" : "-unsigned") + ".apk";
    }

    public static class CreationAction
    extends VariantTaskCreationAction<PackageSplitRes> {
        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("package", "SplitResources");
        }

        @Override
        public Class<PackageSplitRes> getType() {
            return PackageSplitRes.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends PackageSplitRes> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setPackageSplitResourcesTask(taskProvider);
            this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, PackageSplitRes::getSplitResApkOutputDirectory, "out");
        }

        @Override
        public void configure(PackageSplitRes task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            scope.getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.PROCESSED_RES, task.getProcessedResources());
            task.signingConfig = scope.getSigningConfigFileCollection();
            task.incrementalDir = scope.getIncrementalDir(this.getName());
            task.keepTimestampsInApk = scope.getGlobalScope().getProjectOptions().get(BooleanOption.KEEP_TIMESTAMPS_IN_APK);
        }
    }

    private static class PackageSplitResTransformParams
    extends BuildElementsTransformParams {
        private final ApkData apkInfo;
        private final File input;
        private final File output;
        private final File incrementalDir;
        private final File signingConfigFile;
        private final boolean keepTimestampsInApk;

        PackageSplitResTransformParams(ApkData apkInfo, File input, PackageSplitRes task) {
            if (input == null) {
                throw new RuntimeException("Cannot find processed resources for " + apkInfo);
            }
            this.apkInfo = apkInfo;
            this.input = input;
            this.output = new File(((Directory)task.getSplitResApkOutputDirectory().get()).getAsFile(), PackageSplitRes.getOutputFileNameForSplit(apkInfo, (String)task.getProject().getProperties().get("archivesBaseName"), task.signingConfig != null));
            this.incrementalDir = task.incrementalDir;
            this.signingConfigFile = SigningConfigUtils.Companion.getOutputFile(task.getSigningConfig());
            this.keepTimestampsInApk = task.getKeepTimestampsInApk();
        }

        @Override
        public File getOutput() {
            return this.output;
        }
    }

    private static class PackageSplitResTransformRunnable
    extends BuildElementsTransformRunnable {
        @Inject
        public PackageSplitResTransformRunnable(PackageSplitResTransformParams params) {
            super(params);
        }

        @Override
        public void run() {
            PackageSplitResTransformParams params = (PackageSplitResTransformParams)this.getParams();
            File intDir = new File(params.incrementalDir, FileUtils.join((String[])new String[]{params.apkInfo.getFilterName(), "tmp"}));
            try {
                FileUtils.cleanOutputDir((File)intDir);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            try (IncrementalPackager pkg = new IncrementalPackagerBuilder(IncrementalPackagerBuilder.ApkFormat.FILE).withSigning(SigningConfigUtils.Companion.load(params.signingConfigFile)).withOutputFile(params.output).withKeepTimestampsInApk(params.keepTimestampsInApk).withIntermediateDir(intDir).withApkCreatorType(ApkCreatorType.APK_Z_FILE_CREATOR).withChangedAndroidResources((Map<RelativeFile, FileStatus>)IncrementalRelativeFileSets.fromZip((File)params.input)).build();){
                pkg.updateFiles();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

