/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.PostprocessingFeatures;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.WorkLimiter;
import com.android.build.gradle.internal.transforms.ProguardConfigurable;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.KeepClassSpecification;
import proguard.ParseException;
import proguard.ProGuard;
import proguard.classfile.util.ClassUtil;
import proguard.util.ListUtil;

public class ProGuardTransform
extends ProguardConfigurable {
    protected static final List<String> JAR_FILTER = ImmutableList.of((Object)"!META-INF/MANIFEST.MF");
    private static final int PROGUARD_CONCURRENCY_LIMIT = 4;
    @GuardedBy(value="ProGuardTransform.class")
    private static WorkLimiter proguardWorkLimiter;
    private static final Logger LOG;
    protected final Configuration configuration = new Configuration();
    private final VariantScope variantScope;
    ListMultimap<File, List<String>> fileToFilter = ArrayListMultimap.create();
    private Property<RegularFile> printMapping;
    private File testedMappingFile = null;
    private FileCollection testMappingConfiguration = null;

    public ProGuardTransform(VariantScope variantScope) {
        super(variantScope.getGlobalScope().getProject().files(new Object[0]), variantScope.getVariantData().getType(), variantScope.consumesFeatureJars());
        this.configuration.useMixedCaseClassNames = false;
        this.configuration.programJars = new ClassPath();
        this.configuration.libraryJars = new ClassPath();
        this.variantScope = variantScope;
    }

    private static String fileDescription(String fileName) {
        return "file '" + fileName + "'";
    }

    public void setOutputFile(Property<RegularFile> file) {
        this.printMapping = file;
    }

    private static synchronized WorkLimiter getWorkLimiter() {
        if (proguardWorkLimiter == null) {
            proguardWorkLimiter = new WorkLimiter(4);
        }
        return proguardWorkLimiter;
    }

    public void applyTestedMapping(FileCollection testMappingConfiguration) {
        this.testMappingConfiguration = testMappingConfiguration;
    }

    public String getName() {
        return "proguard";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_JARS;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        ArrayList files = Lists.newArrayList();
        if (this.testedMappingFile != null && this.testedMappingFile.isFile()) {
            files.add(SecondaryFile.nonIncremental((File)this.testedMappingFile));
        } else if (this.testMappingConfiguration != null) {
            files.add(SecondaryFile.nonIncremental((FileCollection)this.testMappingConfiguration));
        }
        files.add(SecondaryFile.nonIncremental((FileCollection)this.getAllConfigurationFiles()));
        return files;
    }

    public Collection<File> getSecondaryFileOutputs() {
        File printMappingFile = ((RegularFile)this.printMapping.get()).getAsFile();
        File proguardOut = printMappingFile.getParentFile();
        File printSeeds = new File(proguardOut, "seeds.txt");
        File printUsage = new File(proguardOut, "usage.txt");
        return ImmutableList.of((Object)printMappingFile, (Object)printSeeds, (Object)printUsage);
    }

    public Map<String, Object> getParameterInputs() {
        return ImmutableMap.of((Object)"shrink", (Object)this.configuration.shrink, (Object)"obfuscate", (Object)this.configuration.obfuscate, (Object)"optimize", (Object)this.configuration.optimize);
    }

    public boolean isIncremental() {
        return false;
    }

    public boolean isCacheable() {
        return true;
    }

    public void transform(TransformInvocation invocation) throws TransformException {
        try {
            if (this.printMapping == null) {
                throw new RuntimeException("printMapping not initialized");
            }
            File printMappingFile = ((RegularFile)this.printMapping.get()).getAsFile();
            ProGuardTransform.getWorkLimiter().limit(() -> {
                this.doMinification(invocation.getInputs(), invocation.getReferencedInputs(), invocation.getOutputProvider());
                if (!printMappingFile.isFile()) {
                    Files.asCharSink((File)printMappingFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"");
                }
                return null;
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void applyRuleFile(String jarName, String ruleFileName, String rules) {
        try {
            this.applyConfigurationText(rules, jarName + File.separator + ruleFileName);
        }
        catch (IOException | ParseException ex) {
            throw new UncheckedIOException("Failed to apply proguard rules for '" + ruleFileName + "' in '" + jarName, ex);
        }
    }

    private void doMinification(Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs, TransformOutputProvider output2) throws IOException {
        try {
            Preconditions.checkNotNull((Object)output2, (Object)("Missing output object for transform " + this.getName()));
            Set outputTypes = this.getOutputTypes();
            Set<? super QualifiedContent.Scope> scopes = this.getScopes();
            File outFile = output2.getContentLocation("combined_res_and_classes", outputTypes, scopes, Format.JAR);
            FileUtils.mkdirs((File)outFile.getParentFile());
            File testedMappingFile = this.computeMappingFile();
            if (testedMappingFile != null) {
                this.applyMapping(testedMappingFile);
            }
            this.addInputsToConfiguration(inputs, false);
            this.addInputsToConfiguration(referencedInputs, true);
            this.variantScope.getBootClasspath().forEach(this::libraryJar);
            this.variantScope.getGlobalScope().getFullBootClasspath().forEach(this::libraryJar);
            this.outJar(outFile);
            File printMappingFile = ((RegularFile)this.printMapping.get()).getAsFile();
            File proguardOut = printMappingFile.getParentFile();
            FileUtils.cleanOutputDir((File)proguardOut);
            for (File configFile : this.getAllConfigurationFiles()) {
                LOG.info("Applying ProGuard configuration file {}", (Object)configFile);
                this.applyConfigurationFile(configFile);
            }
            File printSeeds = new File(proguardOut, "seeds.txt");
            File printUsage = new File(proguardOut, "usage.txt");
            this.configuration.printMapping = printMappingFile;
            this.configuration.printSeeds = printSeeds;
            this.configuration.printUsage = printUsage;
            this.forceprocessing();
            this.runProguard();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    private void addInputsToConfiguration(Collection<TransformInput> inputs, boolean referencedOnly) {
        List<String> baseFilter;
        ClassPath classPath;
        if (referencedOnly) {
            classPath = this.configuration.libraryJars;
            baseFilter = JAR_FILTER;
        } else {
            classPath = this.configuration.programJars;
            baseFilter = null;
        }
        for (TransformInput transformInput : inputs) {
            for (JarInput jarInput : transformInput.getJarInputs()) {
                this.handleQualifiedContent(classPath, (QualifiedContent)jarInput, baseFilter);
            }
            for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
                this.handleQualifiedContent(classPath, (QualifiedContent)directoryInput, baseFilter);
            }
        }
    }

    private void handleQualifiedContent(ClassPath classPath, QualifiedContent content2, List<String> baseFilter) {
        ImmutableList filter = baseFilter;
        if (!content2.getContentTypes().contains(QualifiedContent.DefaultContentType.CLASSES)) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (filter != null) {
                builder.addAll(filter);
            }
            builder.add((Object)"!**.class");
            filter = builder.build();
        } else if (!content2.getContentTypes().contains(QualifiedContent.DefaultContentType.RESOURCES)) {
            filter = ImmutableList.of((Object)"**.class");
        }
        this.inputJar(classPath, content2.getFile(), (List<String>)filter);
    }

    private File computeMappingFile() {
        if (this.testedMappingFile != null && this.testedMappingFile.isFile()) {
            return this.testedMappingFile;
        }
        if (this.testMappingConfiguration != null && this.testMappingConfiguration.getSingleFile().isFile()) {
            return this.testMappingConfiguration.getSingleFile();
        }
        return null;
    }

    @Override
    public void keep(String keep) {
        ClassSpecification classSpecification;
        if (this.configuration.keep == null) {
            this.configuration.keep = Lists.newArrayList();
        }
        try {
            ConfigurationParser parser = new ConfigurationParser(new String[]{keep}, null);
            classSpecification = parser.parseClassSpecificationArguments();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        this.configuration.keep.add(new KeepClassSpecification(true, false, false, false, false, false, false, null, classSpecification));
    }

    public void runProguard() throws IOException {
        new ProGuard(this.configuration).execute();
        this.fileToFilter.clear();
    }

    @Override
    public void keepattributes() {
        this.configuration.keepAttributes = Lists.newArrayListWithExpectedSize((int)0);
    }

    @Override
    public void dontwarn(String dontwarn) {
        if (this.configuration.warn == null) {
            this.configuration.warn = Lists.newArrayList();
        }
        dontwarn = ClassUtil.internalClassName((String)dontwarn);
        this.configuration.warn.addAll(ListUtil.commaSeparatedList((String)dontwarn));
    }

    @Override
    public void setActions(PostprocessingFeatures actions) {
        this.configuration.obfuscate = actions.isObfuscate();
        this.configuration.optimize = actions.isOptimize();
        this.configuration.shrink = actions.isRemoveUnusedCode();
    }

    public void forceprocessing() {
        this.configuration.lastModified = Long.MAX_VALUE;
    }

    public void applyConfigurationFile(File file) throws IOException, ParseException {
        if (!file.isFile()) {
            return;
        }
        this.applyConfigurationText(Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read(), ProGuardTransform.fileDescription(file.getPath()), file.getParentFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyConfigurationText(String lines, String description, File baseDir) throws IOException, ParseException {
        try (ConfigurationParser parser = new ConfigurationParser(lines, description, baseDir, System.getProperties());){
            parser.parse(this.configuration);
        }
    }

    protected void applyConfigurationText(String lines, String fileName) throws IOException, ParseException {
        this.applyConfigurationText(lines, ProGuardTransform.fileDescription(fileName), null);
    }

    protected void applyMapping(File testedMappingFile) {
        this.configuration.applyMapping = testedMappingFile;
    }

    protected void outJar(File file) {
        ClassPathEntry classPathEntry = new ClassPathEntry(file, true);
        this.configuration.programJars.add(classPathEntry);
    }

    protected void libraryJar(File jarFile) {
        this.inputJar(this.configuration.libraryJars, jarFile, null);
    }

    protected void inputJar(ClassPath classPath, File file, List<String> filter) {
        if (!file.exists() || this.fileToFilter.containsEntry((Object)file, filter)) {
            return;
        }
        this.fileToFilter.put((Object)file, filter);
        ClassPathEntry classPathEntry = new ClassPathEntry(file, false);
        if (filter != null) {
            classPathEntry.setFilter(filter);
        }
        classPath.add(classPathEntry);
    }

    static {
        LOG = Logging.getLogger(ProGuardTransform.class);
    }
}

