/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.CheckManifest$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\nH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckManifest;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "fakeOutputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getFakeOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "manifestFile", "Ljava/io/File;", "manifestRequired", "", "doTaskAction", "", "isManifestRequiredButNotPresent", "CreationAction", "gradle"})
public abstract class CheckManifest
extends NonIncrementalTask {
    private boolean manifestRequired;
    private File manifestFile;

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getFakeOutputDir();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Input
    public final boolean isManifestRequiredButNotPresent() {
        if (!this.manifestRequired) return false;
        File file = this.manifestFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestFile");
        }
        if (file.isFile()) return false;
        return true;
    }

    @Override
    protected void doTaskAction() {
        if (this.isManifestRequiredButNotPresent()) {
            StringBuilder stringBuilder = new StringBuilder().append("Main manifest is missing for variant ").append(this.getVariantName()).append('.').append(" Expected path: ");
            File file = this.manifestFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"manifestFile");
            }
            String string = stringBuilder.append(file.getAbsolutePath()).toString();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public static final /* synthetic */ boolean access$getManifestRequired$p(CheckManifest $this) {
        return $this.manifestRequired;
    }

    public static final /* synthetic */ File access$getManifestFile$p(CheckManifest $this) {
        File file = $this.manifestFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestFile");
        }
        return file;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckManifest$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/CheckManifest;", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<CheckManifest> {
        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("check", "Manifest");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"check\", \"Manifest\")");
            return string;
        }

        @Override
        @NotNull
        public Class<CheckManifest> getType() {
            return CheckManifest.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends CheckManifest> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setCheckManifestTask(taskProvider);
            this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.CHECK_MANIFEST_RESULT, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, (Function1)CheckManifest$CreationAction$handleProvider$1.INSTANCE, "out");
        }

        @Override
        public void configure(@NotNull CheckManifest task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            task.manifestRequired = gradleVariantConfiguration.isMainManifestRequired();
            GradleVariantConfiguration gradleVariantConfiguration2 = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration2, (String)"variantScope.variantConfiguration");
            File file = gradleVariantConfiguration2.getMainManifestFilePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"variantScope.variantConf\u2026tion.mainManifestFilePath");
            task.manifestFile = file;
        }

        public CreationAction(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            super(scope);
        }
    }
}

