/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.manifmerger.MergingReport;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nonnull;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

public abstract class ManifestProcessorTask
extends IncrementalTask {
    @Nonnull
    private final DirectoryProperty manifestOutputDirectory;
    @Nonnull
    private final DirectoryProperty aaptFriendlyManifestOutputDirectory;
    @Nonnull
    private final DirectoryProperty instantAppManifestOutputDirectory;

    public ManifestProcessorTask(ObjectFactory objectFactory) {
        this.manifestOutputDirectory = objectFactory.directoryProperty();
        this.instantAppManifestOutputDirectory = objectFactory.directoryProperty();
        this.aaptFriendlyManifestOutputDirectory = objectFactory.directoryProperty();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    public abstract DirectoryProperty getCheckManifestResult();

    @Internal
    public abstract File getAaptFriendlyManifestOutputFile();

    @OutputDirectory
    public DirectoryProperty getManifestOutputDirectory() {
        return this.manifestOutputDirectory;
    }

    @OutputDirectory
    @Optional
    public DirectoryProperty getAaptFriendlyManifestOutputDirectory() {
        return this.aaptFriendlyManifestOutputDirectory;
    }

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getBundleManifestOutputDirectory();

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getMetadataFeatureManifestOutputDirectory();

    @OutputDirectory
    @Optional
    public DirectoryProperty getInstantAppManifestOutputDirectory() {
        return this.instantAppManifestOutputDirectory;
    }

    @OutputFile
    @Optional
    public abstract RegularFileProperty getReportFile();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getMergeBlameFile();

    protected static void outputMergeBlameContents(MergingReport mergingReport, File mergeBlameFile) throws IOException {
        if (mergeBlameFile == null) {
            return;
        }
        String output2 = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.BLAME);
        if (output2 == null) {
            return;
        }
        FileUtils.mkdirs((File)mergeBlameFile.getParentFile());
        try (BufferedWriter writer = Files.newWriter((File)mergeBlameFile, (Charset)Charsets.UTF_8);){
            writer.write(output2);
        }
    }

    protected static String serializeMap(Map<String, Object> mapToSerialize) {
        Joiner keyValueJoiner = Joiner.on((String)":");
        return Joiner.on((String)",").join((Iterable)Ordering.natural().sortedCopy(Iterables.transform(mapToSerialize.entrySet(), input -> keyValueJoiner.join(input.getKey(), input.getValue(), new Object[0]))));
    }
}

