/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.SdkHandler;
import com.android.builder.internal.compiler.RenderScriptProcessor;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.TargetInfo;
import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.utils.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013J\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\b\u0010\u001d\u001a\u0004\u0018\u00010\bJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00132\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010 \u001a\u00020#H\u0002J\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015J\b\u0010%\u001a\u0004\u0018\u00010\u0013J\b\u0010&\u001a\u0004\u0018\u00010\u0013J\b\u0010'\u001a\u0004\u0018\u00010\u0013J\b\u0010(\u001a\u0004\u0018\u00010\u0013J\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0015J\b\u0010*\u001a\u0004\u0018\u00010+J\b\u0010,\u001a\u00020\nH\u0002J\u0006\u0010-\u001a\u00020.R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/build/gradle/internal/SdkFullLoadingStrategy;", "", "sdkHandlerSupplier", "Ljava/util/function/Supplier;", "Lcom/android/build/gradle/internal/SdkHandler;", "platformTargetHashSupplier", "", "buildToolRevisionSupplier", "Lcom/android/repository/Revision;", "useAndroidX", "", "(Ljava/util/function/Supplier;Ljava/util/function/Supplier;Ljava/util/function/Supplier;Z)V", "sdkInfo", "Lcom/android/builder/sdk/SdkInfo;", "sdkInitResult", "Ljava/lang/Boolean;", "targetInfo", "Lcom/android/builder/sdk/TargetInfo;", "getAdbExecutable", "Ljava/io/File;", "getAdditionalLibraries", "", "Lcom/android/sdklib/OptionalLibrary;", "getAidlExecutable", "getAidlFramework", "getAndroidJar", "getAnnotationsJar", "getBuildToolsInfo", "Lcom/android/sdklib/BuildToolInfo;", "getBuildToolsRevision", "getCoreLambaStubs", "getFileFromBuildTool", "component", "Lcom/android/sdklib/BuildToolInfo$PathId;", "getFileFromTarget", "", "getOptionalLibraries", "getRenderScriptSupportJar", "getSplitSelectExecutable", "getSupportBlasLibFolder", "getSupportNativeLibFolder", "getTargetBootClasspath", "getTargetPlatformVersion", "Lcom/android/sdklib/AndroidVersion;", "init", "reset", "", "gradle"})
public final class SdkFullLoadingStrategy {
    private Boolean sdkInitResult;
    private SdkInfo sdkInfo;
    private TargetInfo targetInfo;
    private final Supplier<SdkHandler> sdkHandlerSupplier;
    private final Supplier<String> platformTargetHashSupplier;
    private final Supplier<Revision> buildToolRevisionSupplier;
    private final boolean useAndroidX;

    private final synchronized boolean init() {
        if (this.sdkInitResult != null) {
            Boolean bl = this.sdkInitResult;
            if (bl == null) {
                Intrinsics.throwNpe();
            }
            return bl;
        }
        String string = this.platformTargetHashSupplier.get();
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            boolean bl3 = false;
            String string2 = "Extension not initialized yet, couldn't access compileSdkVersion.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String platformHash = string;
        Revision revision = this.buildToolRevisionSupplier.get();
        bl2 = false;
        boolean bl4 = false;
        if (revision == null) {
            boolean bl5 = false;
            String string3 = "Extension not initialized yet, couldn't access buildToolsVersion.";
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        Revision buildToolRevision = revision;
        SdkHandler sdkHandler = this.sdkHandlerSupplier.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkHandler, (String)"sdkHandlerSupplier.get()");
        SdkHandler sdkHandler2 = sdkHandler;
        Pair<SdkInfo, TargetInfo> result = sdkHandler2.initTarget(platformHash, buildToolRevision);
        if (result == null) {
            this.sdkInitResult = false;
            return false;
        }
        sdkHandler2.ensurePlatformToolsIsInstalledWarnOnFailure();
        this.sdkInitResult = true;
        Object object = result.getFirst();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"result.first");
        this.sdkInfo = (SdkInfo)object;
        Object object2 = result.getSecond();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"result.second");
        this.targetInfo = (TargetInfo)object2;
        return true;
    }

    @Nullable
    public final File getAdbExecutable() {
        File file;
        if (this.init()) {
            SdkInfo sdkInfo = this.sdkInfo;
            if (sdkInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sdkInfo");
            }
            file = sdkInfo.getAdb();
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getAnnotationsJar() {
        File file;
        if (this.init()) {
            SdkInfo sdkInfo = this.sdkInfo;
            if (sdkInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sdkInfo");
            }
            file = sdkInfo.getAnnotationsJar();
        } else {
            file = null;
        }
        return file;
    }

    private final File getFileFromTarget(int component) {
        File file;
        if (this.init()) {
            TargetInfo targetInfo = this.targetInfo;
            if (targetInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
            }
            file = targetInfo.getTarget().getFile(component);
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getAidlFramework() {
        return this.getFileFromTarget(2);
    }

    @Nullable
    public final File getAndroidJar() {
        return this.getFileFromTarget(1);
    }

    @Nullable
    public final List<OptionalLibrary> getAdditionalLibraries() {
        List list;
        if (this.init()) {
            TargetInfo targetInfo = this.targetInfo;
            if (targetInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
            }
            IAndroidTarget iAndroidTarget = targetInfo.getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)iAndroidTarget, (String)"targetInfo.target");
            list = iAndroidTarget.getAdditionalLibraries();
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public final List<OptionalLibrary> getOptionalLibraries() {
        List list;
        if (this.init()) {
            TargetInfo targetInfo = this.targetInfo;
            if (targetInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
            }
            IAndroidTarget iAndroidTarget = targetInfo.getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)iAndroidTarget, (String)"targetInfo.target");
            list = iAndroidTarget.getOptionalLibraries();
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public final AndroidVersion getTargetPlatformVersion() {
        AndroidVersion androidVersion;
        if (this.init()) {
            TargetInfo targetInfo = this.targetInfo;
            if (targetInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
            }
            IAndroidTarget iAndroidTarget = targetInfo.getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)iAndroidTarget, (String)"targetInfo.target");
            androidVersion = iAndroidTarget.getVersion();
        } else {
            androidVersion = null;
        }
        return androidVersion;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<File> getTargetBootClasspath() {
        List list;
        if (this.init()) {
            void $this$mapTo$iv$iv;
            TargetInfo targetInfo = this.targetInfo;
            if (targetInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
            }
            IAndroidTarget iAndroidTarget = targetInfo.getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)iAndroidTarget, (String)"targetInfo.target");
            List list2 = iAndroidTarget.getBootClasspath();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"targetInfo.target.bootClasspath");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                File file = new File((String)it);
                collection.add(file);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public final BuildToolInfo getBuildToolsInfo() {
        BuildToolInfo buildToolInfo;
        if (this.init()) {
            TargetInfo targetInfo = this.targetInfo;
            if (targetInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
            }
            buildToolInfo = targetInfo.getBuildTools();
        } else {
            buildToolInfo = null;
        }
        return buildToolInfo;
    }

    @Nullable
    public final Revision getBuildToolsRevision() {
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        return buildToolInfo != null ? buildToolInfo.getRevision() : null;
    }

    private final File getFileFromBuildTool(BuildToolInfo.PathId component) {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            file = new File(it.getPath(component));
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getAidlExecutable() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.AIDL);
    }

    @Nullable
    public final File getCoreLambaStubs() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.CORE_LAMBDA_STUBS);
    }

    @Nullable
    public final File getSplitSelectExecutable() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.SPLIT_SELECT);
    }

    @Nullable
    public final File getRenderScriptSupportJar() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            file = RenderScriptProcessor.getSupportJar((File)it.getLocation(), (boolean)this.useAndroidX);
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getSupportNativeLibFolder() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            file = RenderScriptProcessor.getSupportNativeLibFolder((File)it.getLocation());
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getSupportBlasLibFolder() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            file = RenderScriptProcessor.getSupportBlasLibFolder((File)it.getLocation());
        } else {
            file = null;
        }
        return file;
    }

    public final synchronized void reset() {
        this.sdkInitResult = null;
        this.sdkHandlerSupplier.get().unload();
    }

    public SdkFullLoadingStrategy(@NotNull Supplier<SdkHandler> sdkHandlerSupplier2, @NotNull Supplier<String> platformTargetHashSupplier, @NotNull Supplier<Revision> buildToolRevisionSupplier, boolean useAndroidX) {
        Intrinsics.checkParameterIsNotNull(sdkHandlerSupplier2, (String)"sdkHandlerSupplier");
        Intrinsics.checkParameterIsNotNull(platformTargetHashSupplier, (String)"platformTargetHashSupplier");
        Intrinsics.checkParameterIsNotNull(buildToolRevisionSupplier, (String)"buildToolRevisionSupplier");
        this.sdkHandlerSupplier = sdkHandlerSupplier2;
        this.platformTargetHashSupplier = platformTargetHashSupplier;
        this.buildToolRevisionSupplier = buildToolRevisionSupplier;
        this.useAndroidX = useAndroidX;
    }
}

